/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.util;

import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.MonitoredDataItemListener;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpcUaBulkDataItemListener
implements MonitoredDataItemListener {
    private static final Logger LOGGER = Logger.getLogger("opcUaClient.OpcUaBulkDataItemListener");
    private final List<MonitoredDataItemListener> listeners = Collections.synchronizedList(new ArrayList());
    private final NodeId nodeId;
    private final UnsignedInteger monitoredAttribute;
    private final DataState lastDataState;

    public OpcUaBulkDataItemListener(NodeId nodeId, UnsignedInteger monitoredAttribute) {
        this.nodeId = nodeId;
        this.monitoredAttribute = monitoredAttribute;
        this.lastDataState = new DataState(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MonitoredDataItemListener listener, NodeId nodeId, UnsignedInteger monitoredAttribute) {
        if (!this.nodeId.equals((Object)nodeId) || !this.monitoredAttribute.equals((Object)monitoredAttribute)) {
            LOGGER.log(Level.WARNING, "Failed to add listener to bulk listener. Monitoring parameters do not match.");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Bulk     - NodeId: " + this.nodeId + ", monitoredAttribute: " + this.monitoredAttribute);
                LOGGER.log(Level.FINE, "Listener - NodeId: " + nodeId + ", monitoredAttribute: " + monitoredAttribute);
            }
            return;
        }
        List<MonitoredDataItemListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(listener)) {
                LOGGER.log(Level.WARNING, "Failed to add listener to bulk listener. Listener already present.");
                return;
            }
            this.listeners.add(listener);
        }
        listener.onDataChange(this.lastDataState.getMonitoredDataItem(), this.lastDataState.getOldValue(), this.lastDataState.getNewValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MonitoredDataItemListener listener, NodeId nodeId, UnsignedInteger monitoredAttribute) {
        if (!this.nodeId.equals((Object)nodeId) || !this.monitoredAttribute.equals((Object)monitoredAttribute)) {
            LOGGER.log(Level.WARNING, "Failed to remove listener from bulk listener. Monitoring parameters do not match.");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Bulk     - NodeId: " + this.nodeId + ", monitoredAttribute: " + this.monitoredAttribute);
                LOGGER.log(Level.FINE, "Listener - NodeId: " + nodeId + ", monitoredAttribute: " + monitoredAttribute);
            }
            return;
        }
        List<MonitoredDataItemListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return;
            }
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        List<MonitoredDataItemListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getListenerCount() {
        List<MonitoredDataItemListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataChange(MonitoredDataItem monitoredDataItem, DataValue dataValue, DataValue dataValue1) {
        this.lastDataState.updateState(monitoredDataItem, dataValue, dataValue1);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Updating last data state for monitoredDataItem: \n" + monitoredDataItem.toString());
        }
        List<MonitoredDataItemListener> list = this.listeners;
        synchronized (list) {
            for (MonitoredDataItemListener listener : this.listeners) {
                listener.onDataChange(monitoredDataItem, dataValue, dataValue1);
            }
        }
    }

    private static class DataState {
        private MonitoredDataItem monitoredDataItem;
        private DataValue oldValue;
        private DataValue newValue;

        public DataState(MonitoredDataItem monitoredDataItem, DataValue oldValue, DataValue newValue) {
            this.monitoredDataItem = monitoredDataItem;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public MonitoredDataItem getMonitoredDataItem() {
            return this.monitoredDataItem;
        }

        public DataValue getOldValue() {
            return this.oldValue;
        }

        public DataValue getNewValue() {
            return this.newValue;
        }

        public void updateState(MonitoredDataItem monitoredDataItem, DataValue oldValue, DataValue newValue) {
            this.monitoredDataItem = monitoredDataItem;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public boolean isNull() {
            return this.monitoredDataItem == null || this.newValue == null;
        }
    }
}

