/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.util;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.AddressSpaceException;
import com.prosysopc.ua.client.MonitoredItem;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaObject;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.stack.builtintypes.BuiltinsMap;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.Argument;
import com.prosysopc.ua.stack.core.EUInformation;
import com.prosysopc.ua.stack.core.EnumValueType;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ObjectIdentifiers;
import com.prosysopc.ua.stack.core.Range;
import com.prosysopc.ua.stack.core.ReadResponse;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.core.ReferenceDescription;
import com.prosysopc.ua.stack.core.ReferenceTypeIdentifiers;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.utils.AttributesUtil;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.AnalogItemType;
import com.tridium.ndriver.discover.BNDiscoveryJob;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.BOpcUaNetwork;
import com.tridium.opcUaClient.point.BOpcUaNodeLearnEntry;
import com.tridium.opcUaClient.util.OpcUaMonitoredDataItemUtil;
import com.tridium.opcUaCore.BUaArgument;
import com.tridium.opcUaCore.enums.BServerState;
import com.tridium.opcUaCore.util.OpcUaCoreUtil;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BEnumTrendRecord;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public final class OpcUaClientUtil {
    private static final Class<?>[] NUMERIC_CLASSES = new Class[]{Byte.class, UnsignedByte.class, Short.class, UnsignedShort.class, Integer.class, UnsignedInteger.class, Long.class, UnsignedLong.class, Float.class, Double.class};
    private static final Class<?>[] ENUM_CLASSES = new Class[]{Byte.class, UnsignedByte.class, Short.class, UnsignedShort.class, Integer.class, UnsignedInteger.class, Long.class, UnsignedLong.class};
    public static final String NC_OBJECT = "Object";
    public static final String NC_VARIABLE = "Variable";
    public static final String NC_METHOD = "Method";
    public static final String BUILT_IN_TYPES_BASE_URL = "http://opcfoundation.org/UA/";
    public static final String OPC_FOUNDATION_SECURITY_POLICY_URI = "http://opcfoundation.org/UA/SecurityPolicy#";
    public static final String OPC_FOUNDATION_SECURITY_POLICY_URI_REGEX = "http://opcfoundation\\.org/UA/SecurityPolicy#";
    public static final String OPC_FOUNDATION_TRANSPORT_URI = "http://opcfoundation.org/UA-Profile/Transport/";
    public static final String OPC_FOUNDATION_TRANSPORT_URI_REGEX = "http://opcfoundation\\.org/UA-Profile/Transport/";
    private static int discoveryCount;
    private static int progress;
    public static final Logger logger;
    public static final int NODE_CLASS = 0;
    public static final int BROWSE_NAME = 1;
    public static final int DISPLAY_NAME = 2;
    public static final int VALUE = 3;
    public static final int DATATYPE = 4;
    public static final int DESCRIPTION = 5;
    public static final int WRITE_MASK = 6;
    public static final int USER_WRITE_MASK = 7;
    public static final int ACCESS_LEVEL = 8;
    public static final int USER_ACCESS_LEVEL = 9;
    public static final int EVENT_NOTIFIER = 10;
    public static final int HISTORIZING = 11;

    private OpcUaClientUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void connect(BOpcUaDevice device) throws Exception {
        BOpcUaDevice bOpcUaDevice = device;
        synchronized (bOpcUaDevice) {
            try {
                AccessController.doPrivileged(() -> {
                    if (device.uaClient != null && device.uaClient.isConnected()) {
                        device.uaClient.disconnect();
                        device.uaClient = null;
                    }
                    device.uaClient = new UaClient(device.getServerEndpointUrl());
                    device.initialize();
                    device.configOk();
                    device.ping();
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                device.configFail(OpcUaCoreUtil.getLocalizedMessage((Exception)e.getException()));
                throw e.getException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnect(BOpcUaDevice device) throws Exception {
        BOpcUaDevice bOpcUaDevice = device;
        synchronized (bOpcUaDevice) {
            try {
                AccessController.doPrivileged(() -> {
                    if (device.uaClient != null && device.uaClient.isConnected()) {
                        device.uaClient.disconnect();
                        device.uaClient = null;
                    }
                    if (device.isCommReset()) {
                        device.setServerState(BServerState.ResettingConnection);
                    } else {
                        device.setServerState(BServerState.Unknown);
                    }
                    OpcUaMonitoredDataItemUtil.clearBulkListeners();
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
    }

    public static NodeId getUaObjectRoot(UaClient uaClient) {
        try {
            return AccessController.doPrivileged(() -> {
                AddressSpace addressSpace = uaClient.getAddressSpace();
                addressSpace.setMaxReferencesPerNode(1000);
                addressSpace.setReferenceTypeId(ReferenceTypeIdentifiers.HierarchicalReferences);
                List references = addressSpace.browse(ObjectIdentifiers.RootFolder);
                for (ReferenceDescription reference : references) {
                    String displayName = reference.getDisplayName().getText();
                    if (!"Objects".equals(displayName.trim())) continue;
                    return addressSpace.getNamespaceTable().toNodeId(reference.getNodeId());
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while getting UaObjectRoot", e);
            } else {
                logger.log(Level.SEVERE, "Exception occurred while getting UaObjectRoot: " + e);
            }
            return null;
        }
    }

    public static boolean isNodeAlreadyAdded(BOpcUaNodeLearnEntry newEntry, HashSet<String> nodeIds) {
        if (newEntry == null) {
            return false;
        }
        return nodeIds.contains(newEntry.getUaNodeId());
    }

    public static int learn(BOpcUaDevice uaDevice, BOpcUaNodeLearnEntry root, NodeId nodeId, BNDiscoveryJob job, int level, int expectedLearnCount, boolean excludeServer, boolean excludeTypesFolder) {
        block20: {
            boolean isRoot;
            boolean bl = isRoot = level == 0;
            if (isRoot) {
                discoveryCount = 0;
                if (job != null) {
                    job.setProgress(5);
                }
            }
            if (job != null && job.isCanceled()) {
                return -1;
            }
            HashSet<String> nodeIds = new HashSet<String>();
            AddressSpace addressSpace = uaDevice.uaClient.getAddressSpace();
            try {
                if (level < 2 && job != null) {
                    job.log().message(BOpcUaNetwork.lex.getText("clientPointLearn.processing", new Object[]{root.getUaNodeName()}));
                }
                String n = root.getName() == null ? "nullName" : root.getName();
                List<ReferenceDescription> references = OpcUaClientUtil.browseAddressSpace(addressSpace, nodeId);
                boolean isLeafNode = true;
                for (ReferenceDescription reference : references) {
                    if (job != null && job.isCanceled()) break;
                    NodeId nextId = addressSpace.getNamespaceTable().toNodeId(reference.getNodeId());
                    if (nextId.toString().equals(nodeId.toString() + ".Alarm")) continue;
                    if (excludeServer && nextId.equals((Object)ObjectIdentifiers.Server)) {
                        if (job == null) continue;
                        job.log().message("Excluding Server branch.");
                        continue;
                    }
                    if (excludeTypesFolder && nextId.equals((Object)ObjectIdentifiers.TypesFolder)) {
                        if (job == null) continue;
                        job.log().message("Excluding TypesFolder branch.");
                        continue;
                    }
                    BOpcUaNodeLearnEntry learnEntry = BOpcUaNodeLearnEntry.make(addressSpace, reference, nextId, uaDevice.uaClient);
                    if (OpcUaClientUtil.isNodeAlreadyAdded(learnEntry, nodeIds)) continue;
                    if (++progress > expectedLearnCount) {
                        progress = 0;
                    }
                    if (job != null) {
                        job.setProgress(progress * 100 / expectedLearnCount);
                    }
                    ++discoveryCount;
                    ++level;
                    isLeafNode = false;
                    if (learnEntry != null) {
                        String addName = learnEntry.getUaDisplayName();
                        root.add(SlotPath.escape((String)addName) + '?', (BValue)learnEntry, 2);
                        nodeIds.add(learnEntry.getUaNodeId());
                        OpcUaClientUtil.learn(uaDevice, learnEntry, nextId, job, level, expectedLearnCount, excludeServer, excludeTypesFolder);
                        uaDevice.setLastLearnedInfo(OpcUaClientUtil.toServerRootPath(learnEntry));
                    }
                    --level;
                }
                if (isLeafNode) {
                    root.initHasAddableDescendant();
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.SEVERE, "Exception occurred during OpcUaClient learn: level = " + level + ", root name = " + OpcUaClientUtil.toServerRootPath(root), e);
                } else {
                    logger.log(Level.SEVERE, "Exception occurred during OpcUaClient learn: level = " + level + ", root name = " + OpcUaClientUtil.toServerRootPath(root), e.getMessage());
                }
                if (job == null) break block20;
                job.log().message("Problem with: " + OpcUaClientUtil.toServerRootPath(root));
            }
        }
        if (job != null) {
            switch (level) {
                case 0: {
                    job.log().message(BOpcUaNetwork.lex.getText("clientPointLearn.discoverCount", new Object[]{discoveryCount}));
                    break;
                }
                case 1: {
                    if (root.getHasAddableDescendant()) break;
                    job.log().message(BOpcUaNetwork.lex.getText("clientPointLearn.pruned", new Object[]{root.getUaNodeName()}));
                }
            }
        }
        return discoveryCount;
    }

    public static UaNode getAddressSpaceNode(AddressSpace addressSpace, NodeId nodeId) {
        try {
            return AccessController.doPrivileged(() -> addressSpace.getNode(nodeId));
        }
        catch (PrivilegedActionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while getting node data " + nodeId, e);
            } else {
                logger.log(Level.SEVERE, "Exception occurred while getting node data " + nodeId + ": " + e);
            }
            return null;
        }
    }

    public static String getDisplayName(ReferenceDescription reference, DataValue[] arrayOfNodes, String fallbackNodeName) {
        String displayName;
        String string = displayName = arrayOfNodes[2].getStatusCode().isNotBad() && arrayOfNodes[2].getValue() != null && !OpcUaClientUtil.getNodeLocalizedText(arrayOfNodes[2]).isEmpty() ? OpcUaClientUtil.getNodeLocalizedText(arrayOfNodes[2]) : reference.getDisplayName().getText();
        if (displayName.isEmpty() && !fallbackNodeName.isEmpty()) {
            displayName = fallbackNodeName;
        }
        return displayName;
    }

    public static String getNodeName(ReferenceDescription reference, DataValue[] arrayOfNodes) {
        return arrayOfNodes[1].getStatusCode().isNotBad() && arrayOfNodes[1].getValue() != null && !OpcUaClientUtil.getNodeLocalizedText(arrayOfNodes[1]).isEmpty() ? OpcUaClientUtil.getNodeLocalizedText(arrayOfNodes[1]) : reference.getBrowseName().getName();
    }

    public static DataValue readNodeAttribute(UaNode node, UnsignedInteger attribute) {
        try {
            return AccessController.doPrivileged(() -> node.readAttribute(attribute));
        }
        catch (PrivilegedActionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while reading node attributes " + attribute, e);
            } else {
                logger.log(Level.SEVERE, "Exception occurred while reading node attributes " + attribute + ": " + e);
            }
            return null;
        }
    }

    public static List<ReferenceDescription> browseAddressSpace(AddressSpace addressSpace, NodeId nodeId) {
        try {
            return AccessController.doPrivileged(() -> addressSpace.browse(nodeId));
        }
        catch (PrivilegedActionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while browsing address space " + nodeId, e);
            } else {
                logger.log(Level.SEVERE, "Exception occurred while browsing address space " + nodeId + ": " + e);
            }
            return null;
        }
    }

    public static Variant[] call(UaClient uaClient, NodeId objectNodeId, NodeId methodNodeId, Variant[] methodArg) throws PrivilegedActionException {
        return AccessController.doPrivileged(() -> uaClient.call(objectNodeId, methodNodeId, methodArg));
    }

    public static String getNodeName(UaNode node, String defaultName) {
        String returnName = defaultName;
        QualifiedName browseName = node.getBrowseName();
        if (browseName != null) {
            returnName = browseName.getName();
        }
        return returnName;
    }

    public static Optional<DataValue> getNodeDataTypeNode(DataValue dataTypeDV) {
        Optional<DataValue> rtnValue = Optional.empty();
        if (dataTypeDV != null) {
            try {
                rtnValue = Optional.of(dataTypeDV);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rtnValue;
    }

    public static void addItemToSubscription(Subscription subscription, MonitoredItem item, boolean throwException) throws Exception {
        block4: {
            try {
                AccessController.doPrivileged(() -> {
                    subscription.addItem(item);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.SEVERE, "Exception occurred while adding subscription item " + item.getNodeId().toString(), e);
                } else {
                    logger.log(Level.SEVERE, "Exception occurred while adding subscription item " + item.getNodeId().toString() + ": " + e);
                }
                if (!throwException) break block4;
                throw e.getException();
            }
        }
    }

    public static void removeItemFromSubscription(Subscription subscription, MonitoredItemBase item, boolean throwException) throws Exception {
        block4: {
            try {
                AccessController.doPrivileged(() -> {
                    subscription.removeItem(item);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.SEVERE, "Exception occurred while removing subscription item " + item.getNodeId().toString(), e);
                } else {
                    logger.log(Level.SEVERE, "Exception occurred while removing subscription item " + item.getNodeId().toString() + ": " + e);
                }
                if (!throwException) break block4;
                throw e.getException();
            }
        }
    }

    public static void addSubscription(UaClient uaClient, Subscription subscription) {
        try {
            AccessController.doPrivileged(() -> {
                uaClient.addSubscription(subscription);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while adding subscription " + subscription, e);
            }
            logger.log(Level.SEVERE, "Exception occurred while adding subscription " + subscription + ": " + e);
        }
    }

    public static ReadResponse readNodes(UaClient uaClient, Double maxAge, TimestampsToReturn timestampsToReturn, ReadValueId ... valueIds) {
        try {
            return AccessController.doPrivileged(() -> uaClient.read(maxAge, timestampsToReturn, valueIds));
        }
        catch (PrivilegedActionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while reading nodes", e);
            } else {
                logger.log(Level.SEVERE, "Exception occurred while reading nodes: " + e);
            }
            return null;
        }
    }

    public static DataValue[] historyReadRaw(UaClient uaClient, NodeId nodeId, DateTime startTime, DateTime endTime, UnsignedInteger numValuesPerNode, boolean returnBounds, NumericRange indexRange, TimestampsToReturn timestampsToReturn) {
        try {
            return AccessController.doPrivileged(() -> {
                UaNode node = uaClient.getAddressSpace().getNode(nodeId);
                UaVariable variable = (UaVariable)node;
                if (!variable.getAccessLevel().contains(new OptionSpecification[]{AccessLevelType.Options.HistoryRead})) {
                    logger.log(Level.INFO, "The variable does not have history");
                    return null;
                }
                if (!variable.getUserAccessLevel().contains(new OptionSpecification[]{AccessLevelType.Options.HistoryRead})) {
                    logger.log(Level.INFO, "The variable has history, but it is not readable with this user account");
                    return null;
                }
                return uaClient.historyReadRaw(nodeId, startTime, endTime, numValuesPerNode, Boolean.valueOf(returnBounds), indexRange, timestampsToReturn);
            });
        }
        catch (PrivilegedActionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while reading raw history data", e);
            } else {
                logger.log(Level.SEVERE, "Exception occurred while reading raw history data: " + e);
            }
            return null;
        }
    }

    public static long getValueDataTypeIdentifier(Object nodeIdValue) {
        try {
            if (nodeIdValue instanceof UnsignedInteger) {
                return ((UnsignedInteger)nodeIdValue).getValue();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("getValueDataTypeIdentifier(): Unknown dataType: " + nodeIdValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    public static String readValue(UaClient client, NodeId nodeId, String defaultValue) {
        try {
            return AccessController.doPrivileged(() -> client.readValue(nodeId).getValue().toString(false));
        }
        catch (PrivilegedActionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while reading value " + nodeId, e);
            } else {
                logger.log(Level.SEVERE, "Exception occurred while reading value " + nodeId + ": " + e);
            }
            return defaultValue;
        }
    }

    public static BAbsTime dataValueToAbsTime(DataValue dv) {
        Object objValue = dv.getValue().getValue();
        if (objValue instanceof DateTime) {
            return OpcUaClientUtil.dateTimeToAbsTime((DateTime)objValue);
        }
        return BAbsTime.NULL;
    }

    public static BAbsTime dateTimeToAbsTime(DateTime dt) {
        long timeInMillis = dt.getTimeInMillis();
        return BAbsTime.make((long)timeInMillis);
    }

    public static Object getDataValueValue(DataValue dataValue) {
        Object dataValueValue = "";
        if (dataValue != null) {
            Variant variant = dataValue.getValue();
            boolean isArray = variant.isArray();
            dataValueValue = variant.getValue();
            if (dataValueValue != null) {
                if (dataValueValue instanceof LocalizedText) {
                    dataValueValue = ((LocalizedText)dataValueValue).getText();
                } else if (dataValueValue instanceof EUInformation) {
                    dataValueValue = ((EUInformation)dataValueValue).getDisplayName();
                } else if (dataValueValue instanceof Range) {
                    Double high = ((Range)dataValueValue).getHigh();
                    Double low = ((Range)dataValueValue).getLow();
                    dataValueValue = low + "," + high;
                } else if (dataValueValue instanceof LocalizedText[] || dataValueValue instanceof String[]) {
                    Object[] text = (Object[])dataValueValue;
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < text.length; ++i) {
                        if (i > 0) {
                            sb.append(',');
                        }
                        if (text[i] instanceof LocalizedText) {
                            sb.append(((LocalizedText)text[i]).getText());
                            continue;
                        }
                        sb.append(text[i]);
                    }
                    dataValueValue = sb.toString();
                } else if (dataValueValue instanceof byte[]) {
                    byte[] bytes = (byte[])dataValueValue;
                    dataValueValue = new String(bytes);
                } else if (dataValueValue instanceof EnumValueType[]) {
                    EnumValueType[] valueTypes = (EnumValueType[])dataValueValue;
                    HashMap<Integer, String> enumKeyValuesMap = new HashMap<Integer, String>();
                    for (EnumValueType valueType : valueTypes) {
                        enumKeyValuesMap.put(Math.toIntExact(valueType.getValue()), valueType.getDisplayName().toString());
                    }
                    return enumKeyValuesMap.toString();
                }
            }
        }
        return dataValueValue;
    }

    public static String dataValueValueToString(Object dataValueValue) {
        try {
            return AccessController.doPrivileged(dataValueValue::toString);
        }
        catch (PrivilegedActionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while converting value to String " + dataValueValue, e);
            } else {
                logger.log(Level.SEVERE, "Exception occurred while converting value to String " + dataValueValue + ": " + e);
            }
            return null;
        }
    }

    public static String variantToString(Variant variant, boolean includeCompositeClass) {
        try {
            return AccessController.doPrivileged(() -> variant.toString(includeCompositeClass));
        }
        catch (PrivilegedActionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while converting variant to String " + variant, e);
            } else {
                logger.log(Level.SEVERE, "Exception occurred while converting variant to String " + variant + ": " + e);
            }
            return "";
        }
    }

    public static String getNodeLocalizedText(DataValue dv) {
        String description = "";
        Object valueValue = dv.getValue().getValue();
        if (valueValue != null && !valueValue.equals("null")) {
            description = valueValue instanceof LocalizedText ? ((LocalizedText)valueValue).getText() : (valueValue instanceof QualifiedName ? ((QualifiedName)valueValue).getName() : dv.getValue().toString(false));
        }
        if (description == null) {
            description = "";
        }
        return description;
    }

    public static BTypeSpec getTypeSpec(Variant dataValue) {
        return OpcUaClientUtil.getTypeSpec(dataValue, "");
    }

    public static BTypeSpec getTypeSpec(Variant dataValue, String dataType) {
        Objects.requireNonNull(dataValue);
        Objects.requireNonNull(dataType);
        Object value = dataValue.getValue();
        return OpcUaClientUtil.getTypeSpec(value, dataType);
    }

    public static BTypeSpec getTypeSpec(Object value, String dataType) {
        if (value == null) {
            return OpcUaClientUtil.classToTypeSpec(dataType);
        }
        if (OpcUaClientUtil.isBoolean(value)) {
            return BTypeSpec.make((Type)BBoolean.TYPE);
        }
        if (OpcUaClientUtil.isEnum(value)) {
            return BTypeSpec.make((Type)BEnum.TYPE);
        }
        if (OpcUaClientUtil.isNumeric(value)) {
            return BTypeSpec.make((Type)BDouble.TYPE);
        }
        return BTypeSpec.make((Type)BString.TYPE);
    }

    public static Class<?> getValueClass(Variant dataValue) {
        return dataValue.getValue().getClass();
    }

    public static boolean isStructure(Object value) {
        return value == null ? false : value instanceof Structure;
    }

    public static boolean isBoolean(Object value) {
        return value instanceof Boolean || value instanceof Boolean[] || value.getClass().getTypeName().startsWith(Boolean.class.getTypeName());
    }

    public static boolean isNumeric(Object value) {
        return OpcUaClientUtil.isObjectNumeric(value);
    }

    public static boolean isString(Object value) {
        return value instanceof String || value instanceof String[] || value.getClass().getTypeName().startsWith(String.class.getTypeName());
    }

    public static boolean isEnum(Object value) {
        return value instanceof Enumeration || value instanceof Enumeration[] || value.getClass().getTypeName().startsWith(Enumeration.class.getTypeName());
    }

    public static void printCurrentNode(UaClient uaClient, NodeId nodeId, String indent) {
        if (uaClient != null && uaClient.isConnected()) {
            try {
                UaNode node = uaClient.getAddressSpace().getNode(nodeId);
                if (node == null) {
                    return;
                }
                if (node instanceof UaObject) {
                    UnsignedInteger[] supportedAttributes;
                    UaObject object = (UaObject)node;
                    for (UnsignedInteger supportedAttribute : supportedAttributes = object.getSupportedAttributes()) {
                        String s = AttributesUtil.toString((UnsignedInteger)supportedAttribute);
                        DataValue dataValue = object.readAttribute(supportedAttribute);
                        OpcUaClientUtil.println("[" + s + " = " + dataValue.getValue() + "]", indent + "  ");
                    }
                    UaProperty[] properties = object.getProperties();
                    if (properties != null) {
                        for (UaProperty property : properties) {
                            String propName = property.getDisplayName().getText();
                            Variant value = property.getValue().getValue();
                            OpcUaClientUtil.println("(" + propName + "=" + value + ")", indent + "  ");
                        }
                    }
                }
            }
            catch (ServiceException | AddressSpaceException e) {
                logger.severe("Exception occurred printing current node: " + e);
            }
        }
    }

    public static String getCurrentNodeAsString(UaNode node, String indent) {
        String typeStr;
        String analogInfoStr = "";
        String nodeStr = node.getDisplayName().getText();
        UaType type = null;
        if (node instanceof UaInstance) {
            type = ((UaInstance)node).getTypeDefinition();
        }
        String string = typeStr = type == null ? OpcUaClientUtil.nodeClassToStr(node.getNodeClass()) : type.getDisplayName().getText();
        if (node instanceof AnalogItemType) {
            try {
                AnalogItemType analogNode = (AnalogItemType)node;
                EUInformation units = analogNode.getEngineeringUnits();
                analogInfoStr = units == null ? "" : " Units=" + units.getDisplayName().getText();
                Range range = analogNode.getEURange();
                analogInfoStr = analogInfoStr + (range == null ? "" : String.format(" Range=(%f; %f)", range.getLow(), range.getHigh()));
            }
            catch (Exception e) {
                logger.severe("Exception occurred getting current node as String: " + e);
            }
        }
        if (node instanceof UaObject) {
            UaProperty[] properties;
            for (UaProperty property1 : properties = node.getProperties()) {
                String string2 = property1.getDisplayName() + " = " + property1.getValue();
            }
        }
        return String.format(indent + "*** Current Node: %s: %s (ID: %s)%s", nodeStr, typeStr, node.getNodeId(), analogInfoStr);
    }

    public static String eventFieldsToString(UaClient client, QualifiedName[] fieldNames, Variant[] fieldValues) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldValues.length; ++i) {
            Object fieldValue = fieldValues[i] == null ? null : fieldValues[i].getValue();
            try {
                UaNode node = null;
                if (fieldValue instanceof NodeId) {
                    node = client.getAddressSpace().getNode((NodeId)fieldValue);
                } else if (fieldValue instanceof ExpandedNodeId) {
                    node = client.getAddressSpace().getNode((ExpandedNodeId)fieldValue);
                }
                if (node != null) {
                    fieldValue = String.format("%s {%s}", node.getBrowseName(), fieldValue);
                }
            }
            catch (Exception node) {
                // empty catch block
            }
            if (i < fieldNames.length) {
                QualifiedName fieldName = fieldNames[i];
                sb.append(String.format("%s=%s;%n     ", fieldName.getName(), fieldValue));
                continue;
            }
            sb.append("Node=").append(fieldValue);
        }
        return sb.toString();
    }

    public static String eventToString(UaClient client, NodeId nodeId, QualifiedName[] fieldNames, Variant[] fieldValues) {
        return String.format("Node: %s Fields:%n     %s", nodeId, OpcUaClientUtil.eventFieldsToString(client, fieldNames, fieldValues));
    }

    public static QualifiedName[] createBrowsePath(QualifiedName qualifiedName) {
        if (!qualifiedName.getName().contains("/")) {
            return new QualifiedName[]{qualifiedName};
        }
        int namespaceIndex = qualifiedName.getNamespaceIndex();
        String[] names = qualifiedName.getName().split("/");
        QualifiedName[] result = new QualifiedName[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = new QualifiedName(namespaceIndex, names[i]);
        }
        return result;
    }

    private static String toServerRootPath(BOpcUaNodeLearnEntry learnEntry) {
        String s = learnEntry.getSlotPath().toString();
        int i = s.indexOf("/serverRoot/");
        return s.substring(i);
    }

    private static String nodeClassToStr(NodeClass nodeClass) {
        return "[" + nodeClass + "]";
    }

    private static void println(String string, String indent) {
        System.out.println(indent + string);
    }

    public static BStatusValue makeStatusValue(DataValue dataValue, BTrendRecord histRecord) {
        BStatusBoolean rtnValue;
        Variant value = dataValue.getValue();
        Object varValue = value.getValue();
        if (varValue instanceof Object[]) {
            return null;
        }
        if (histRecord instanceof BBooleanTrendRecord && varValue instanceof Boolean) {
            rtnValue = new BStatusBoolean(((Boolean)varValue).booleanValue());
        } else if (histRecord instanceof BNumericTrendRecord && OpcUaClientUtil.isObjectNumeric(varValue)) {
            double dValue = Double.parseDouble(varValue.toString());
            rtnValue = new BStatusNumeric(dValue);
        } else if (histRecord instanceof BEnumTrendRecord && OpcUaClientUtil.isObjectEnum(varValue)) {
            int iValue = Integer.parseInt(varValue.toString());
            BDynamicEnum v = BDynamicEnum.make((int)iValue);
            rtnValue = new BStatusEnum((BEnum)v);
        } else if (histRecord instanceof BStringTrendRecord && varValue instanceof String) {
            rtnValue = new BStatusString((String)varValue);
        } else if (histRecord instanceof BStringTrendRecord && varValue instanceof LocalizedText) {
            rtnValue = new BStatusString(((LocalizedText)varValue).getText());
        } else if (histRecord instanceof BStringTrendRecord && varValue instanceof QualifiedName) {
            rtnValue = new BStatusString(((QualifiedName)varValue).getName());
        } else if (histRecord instanceof BStringTrendRecord && varValue instanceof byte[]) {
            String s = new String((byte[])varValue);
            rtnValue = new BStatusString(s);
        } else if (histRecord instanceof BStringTrendRecord && varValue instanceof ByteString) {
            String s = new String(((ByteString)varValue).getValue());
            rtnValue = new BStatusString(s);
        } else {
            rtnValue = new BStatusString(varValue.toString());
        }
        return rtnValue;
    }

    public static BStatusValue makeStatusValue(DataValue dataValue, BStatusValue statusValue, int[] arrayIndex, String structurePath) {
        BStatus valueStatus;
        BStatusValue rtnValue = statusValue;
        Variant value = dataValue.getValue();
        Object varValue = value.getValue();
        Object setValue = null;
        boolean isUnwritten = dataValue.getSourceTimestamp() == null && dataValue.getServerTimestamp() == null;
        BStatus bStatus = valueStatus = isUnwritten ? BStatus.stale : BStatus.ok;
        if (OpcUaClientUtil.isStructure(varValue)) {
            String[] keySequence = structurePath.split(">");
            Structure structure = (Structure)varValue;
            for (String key : keySequence) {
                varValue = structure.get(key);
                if (!OpcUaClientUtil.isStructure(varValue)) continue;
                structure = (Structure)varValue;
            }
        }
        if (varValue instanceof Object[]) {
            switch (arrayIndex.length) {
                case 1: {
                    setValue = ((Object[])varValue)[arrayIndex[0]];
                    break;
                }
                case 2: {
                    setValue = ((Object[][])varValue)[arrayIndex[1]][arrayIndex[0]];
                    break;
                }
                case 3: {
                    setValue = ((Object[][][])varValue)[arrayIndex[2]][arrayIndex[1]][arrayIndex[0]];
                    break;
                }
                case 4: {
                    setValue = ((Object[][][][])varValue)[arrayIndex[3]][arrayIndex[2]][arrayIndex[1]][arrayIndex[0]];
                    break;
                }
                case 5: {
                    setValue = ((Object[][][][][])varValue)[arrayIndex[4]][arrayIndex[3]][arrayIndex[2]][arrayIndex[1]][arrayIndex[0]];
                    break;
                }
                default: {
                    logger.severe("Array dimension size not supported: " + arrayIndex.length);
                    break;
                }
            }
        } else {
            setValue = varValue;
        }
        if (rtnValue instanceof BStatusBoolean && setValue instanceof Boolean) {
            rtnValue = new BStatusBoolean(((Boolean)setValue).booleanValue(), valueStatus);
        } else if (rtnValue instanceof BStatusNumeric && (OpcUaClientUtil.isObjectNumeric(setValue) || OpcUaClientUtil.isObjectNumeric(varValue))) {
            rtnValue = new BStatusNumeric(Double.parseDouble(setValue.toString()), valueStatus);
        } else if (rtnValue instanceof BStatusString) {
            String s;
            if (setValue instanceof String) {
                rtnValue = new BStatusString((String)setValue, valueStatus);
            } else if (setValue instanceof LocalizedText) {
                rtnValue = new BStatusString(((LocalizedText)setValue).getText(), valueStatus);
            } else if (setValue instanceof QualifiedName) {
                rtnValue = new BStatusString(((QualifiedName)setValue).getName(), valueStatus);
            } else if (setValue instanceof byte[]) {
                s = new String((byte[])setValue, StandardCharsets.UTF_8);
                rtnValue = new BStatusString(s, valueStatus);
            } else if (setValue == null) {
                s = "-";
                rtnValue = new BStatusString(s, valueStatus);
            } else {
                rtnValue = new BStatusString(setValue.toString(), valueStatus);
            }
        } else if (rtnValue instanceof BStatusEnum && OpcUaClientUtil.isEnum(setValue)) {
            rtnValue = new BStatusEnum((BEnum)BDynamicEnum.make((int)((Enumeration)setValue).getValue()), valueStatus);
        } else if (rtnValue instanceof BStatusEnum && OpcUaClientUtil.isObjectEnum(varValue)) {
            rtnValue = new BStatusEnum((BEnum)BDynamicEnum.make((int)Integer.parseInt(setValue.toString())), valueStatus);
        }
        return rtnValue;
    }

    public static double makeDoubleValue(Object value) throws NumberFormatException {
        return Double.parseDouble(value.toString());
    }

    public static BFacets makeEnumFacets(EnumerationSpecification specification) {
        SortedSet valuesSet = specification.getAllEnumValues();
        int[] ordinals = new int[valuesSet.size()];
        String[] tags = new String[valuesSet.size()];
        int index = 0;
        for (Enumeration eachEnum : valuesSet) {
            ordinals[index] = eachEnum.getValue();
            tags[index] = (String)specification.getIntToStringMappings().get(eachEnum.getValue());
            ++index;
        }
        return BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])ordinals, (String[])tags));
    }

    public static long getDataTypeIdentifier(NodeId dataTypeNodeId) {
        long dataTypeIdentifier;
        block2: {
            dataTypeIdentifier = -1L;
            try {
                dataTypeIdentifier = Long.parseLong(dataTypeNodeId.getValue().toString());
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.log(Level.FINE, "Failed to determine data type identifier for nodeId: " + dataTypeNodeId, e);
            }
        }
        return dataTypeIdentifier;
    }

    public static StructureSpecification getStructureSpecification(UaClient uaClient, UaDataType dataType) {
        try {
            return uaClient.getTypeDictionary().getStructureSpecification(UaNodeId.fromStandard((NodeId)dataType.getNodeId()));
        }
        catch (Exception se) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Failed to determine standard structure specification for dataType - " + dataType.getBrowseName(), se);
            }
            try {
                return uaClient.getTypeDictionary().getStructureSpecification(UaNodeId.fromLocal((NodeId)dataType.getNodeId(), (NamespaceTable)uaClient.getNamespaceTable()));
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.WARNING, "Failed to determine structure specification for dataType - " + dataType.getBrowseName(), e);
                } else {
                    logger.log(Level.WARNING, "Failed to determine structure specification for dataType - " + dataType.getBrowseName() + ": " + e.getMessage());
                }
                return null;
            }
        }
    }

    public static BUaArgument makeUaArgument(Argument arg) {
        try {
            return AccessController.doPrivileged(() -> {
                NodeId dataType = arg.getDataType();
                Class argType = (Class)BuiltinsMap.ID_CLASS_MAP.getRight((Object)dataType);
                BTypeSpec typeSpec = OpcUaClientUtil.classToTypeSpec(argType.getSimpleName());
                String dimensions = OpcUaClientUtil.uIntArrayToString(arg.getArrayDimensions());
                LocalizedText description = arg.getDescription();
                String argPrompt = "no description";
                if (description != null && description.getText() != null) {
                    argPrompt = description.getText();
                }
                return new BUaArgument(typeSpec, dataType.toString(), dimensions, argPrompt);
            });
        }
        catch (PrivilegedActionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while making argument " + arg, e);
            } else {
                logger.log(Level.SEVERE, "Exception occurred while making argument " + arg + ": " + e);
            }
            return null;
        }
    }

    public static String uIntArrayToString(UnsignedInteger[] uiArray) {
        if (uiArray == null || uiArray.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (UnsignedInteger dimSize : uiArray) {
            sb.append('[').append(dimSize.longValue()).append(']');
        }
        return sb.toString();
    }

    public static BTypeSpec classToTypeSpec(String className) {
        switch (className) {
            case "Boolean": {
                return BTypeSpec.make((Type)BBoolean.TYPE);
            }
            case "Byte": 
            case "UnsignedByte": 
            case "Short": 
            case "UnsignedShort": 
            case "Integer": {
                return BTypeSpec.make((Type)BInteger.TYPE);
            }
            case "UnsignedInteger": 
            case "Long": 
            case "UnsignedLong": {
                return BTypeSpec.make((Type)BLong.TYPE);
            }
            case "Float": {
                return BTypeSpec.make((Type)BFloat.TYPE);
            }
            case "Double": {
                return BTypeSpec.make((Type)BDouble.TYPE);
            }
            case "byte[]": 
            case "ByteString": 
            case "String": 
            case "LocalizedText": {
                return BTypeSpec.make((Type)BString.TYPE);
            }
        }
        return BTypeSpec.NULL;
    }

    public static boolean isObjectNumeric(Object object) {
        if (object != null) {
            Class<?> objectClass = object.getClass();
            for (Class<?> numericClass : NUMERIC_CLASSES) {
                if (object.getClass().equals(numericClass)) {
                    return true;
                }
                if (!object.getClass().getTypeName().startsWith(numericClass.getTypeName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isObjectEnum(Object object) {
        for (Class<?> enumClass : ENUM_CLASSES) {
            if (object.getClass().equals(enumClass)) {
                return true;
            }
            if (!object.getClass().getTypeName().startsWith(enumClass.getTypeName())) continue;
            return true;
        }
        return false;
    }

    public static BAbsTime getModifiedStartTime(BAbsTime lastTimestamp, BAbsTime initialHistoryArchiveFromDate) {
        if ((BAbsTime.DEFAULT.equals((Object)lastTimestamp) || BAbsTime.DEFAULT.isAfter(lastTimestamp)) && !BAbsTime.DEFAULT.equals((Object)initialHistoryArchiveFromDate)) {
            lastTimestamp = initialHistoryArchiveFromDate;
        }
        return lastTimestamp;
    }

    static {
        logger = Logger.getLogger("opcUaClient.util");
    }
}

