/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.util;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.MonitoredDataItemListener;
import com.prosysopc.ua.client.MonitoredItem;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.tridium.opcUaClient.point.BOpcUaClientProxyExt;
import com.tridium.opcUaClient.util.OpcUaBulkDataItemListener;
import com.tridium.opcUaClient.util.OpcUaClientUtil;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class OpcUaMonitoredDataItemUtil {
    private static final ConcurrentHashMap<Integer, OpcUaBulkDataItemListener> bulkDataItemListenerHashMap = new ConcurrentHashMap();

    private OpcUaMonitoredDataItemUtil() {
    }

    public static synchronized MonitoredDataItem getOrCreateAndGetMonitoredItem(Subscription subscription, NodeId nodeId, UnsignedInteger monitoredAttribute) throws Exception {
        boolean itemExists;
        MonitoredDataItem item = (MonitoredDataItem)subscription.getItem(nodeId, monitoredAttribute);
        boolean bl = itemExists = item != null;
        if (!itemExists) {
            item = new MonitoredDataItem(nodeId, monitoredAttribute, MonitoringMode.Reporting);
        }
        if (item.getDataChangeListener() == null) {
            item.setDataChangeListener((MonitoredDataItemListener)OpcUaMonitoredDataItemUtil.getOrCreateAndGetBulkListener(item, nodeId, monitoredAttribute));
        }
        if (!itemExists) {
            try {
                OpcUaClientUtil.addItemToSubscription(subscription, (MonitoredItem)item, true);
            }
            catch (Exception e) {
                OpcUaClientUtil.removeItemFromSubscription(subscription, (MonitoredItemBase)item, false);
                throw e;
            }
        }
        return item;
    }

    public static synchronized OpcUaBulkDataItemListener getOrCreateAndGetBulkListener(MonitoredDataItem monitoredDataItem, NodeId nodeId, UnsignedInteger monitoredAttribute) throws Exception {
        if (!Objects.equals(nodeId, monitoredDataItem.getNodeId()) || !Objects.equals(monitoredAttribute, monitoredDataItem.getAttributeId())) {
            throw new IllegalArgumentException("Cannot create bulk listener. Item parameters do not match with the monitoring parameters.");
        }
        int dataItemHashCode = monitoredDataItem.hashCode();
        if (bulkDataItemListenerHashMap.get(dataItemHashCode) != null) {
            return bulkDataItemListenerHashMap.get(dataItemHashCode);
        }
        OpcUaBulkDataItemListener bulkDataItemListener = new OpcUaBulkDataItemListener(nodeId, monitoredAttribute);
        bulkDataItemListenerHashMap.put(dataItemHashCode, bulkDataItemListener);
        return bulkDataItemListener;
    }

    public static void subscribe(MonitoredDataItem item, BOpcUaClientProxyExt proxyExt, NodeId nodeId, UnsignedInteger monitoredAttribute) {
        if (item.getDataChangeListener() instanceof OpcUaBulkDataItemListener) {
            ((OpcUaBulkDataItemListener)item.getDataChangeListener()).addListener(proxyExt, nodeId, monitoredAttribute);
        } else {
            item.setDataChangeListener((MonitoredDataItemListener)proxyExt);
        }
    }

    public static void unsubscribe(Subscription subscription, MonitoredDataItem item, BOpcUaClientProxyExt proxyExt, NodeId nodeId, UnsignedInteger monitoredAttribute) throws Exception {
        if (item.getDataChangeListener() instanceof OpcUaBulkDataItemListener) {
            OpcUaBulkDataItemListener bulkDataItemListener = (OpcUaBulkDataItemListener)item.getDataChangeListener();
            bulkDataItemListener.removeListener(proxyExt, nodeId, monitoredAttribute);
            if (bulkDataItemListener.isEmpty()) {
                OpcUaMonitoredDataItemUtil.deleteItemAndListener(subscription, item);
            }
        } else {
            item.setDataChangeListener(null);
            OpcUaClientUtil.removeItemFromSubscription(subscription, (MonitoredItemBase)item, false);
        }
    }

    private static synchronized void deleteItemAndListener(Subscription subscription, MonitoredDataItem item) throws Exception {
        item.setDataChangeListener(null);
        bulkDataItemListenerHashMap.remove(item.hashCode());
        OpcUaClientUtil.removeItemFromSubscription(subscription, (MonitoredItemBase)item, false);
    }

    public static synchronized void clearBulkListeners() {
        bulkDataItemListenerHashMap.clear();
    }
}

