/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.ui;

import com.tridium.nSnmp.datatypes.BSnmpAgentBooleanDefaultValue;
import com.tridium.nSnmp.datatypes.BSnmpAgentNumericDefaultValue;
import com.tridium.nSnmp.datatypes.BSnmpAgentStringDefaultValue;
import com.tridium.nSnmp.point.agent.BSnmpAgentBooleanProxyExt;
import com.tridium.nSnmp.point.agent.BSnmpAgentEnumProxyExt;
import com.tridium.nSnmp.point.agent.BSnmpAgentNumericProxyExt;
import com.tridium.nSnmp.point.agent.BSnmpAgentPointDeviceExt;
import com.tridium.nSnmp.point.agent.BSnmpAgentPointFolder;
import com.tridium.nSnmp.point.agent.BSnmpAgentProxyExt;
import com.tridium.nSnmp.point.agent.BSnmpAgentStringProxyExt;
import java.util.ArrayList;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"nSnmp:SnmpAgentPointDeviceExt", "nSnmp:SnmpAgentPointFolder"}, requiredPermissions="r")})
public class BSnmpAgentPointManager
extends BPointManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BSnmpAgentPointManager.class);
    static Lexicon lexicon = Lexicon.make(BSnmpAgentPointManager.class);
    static Lexicon driverLex = Lexicon.make((String)"driver");
    static String lexOut = driverLex.getText("out");
    BSnmpAgentPointDeviceExt deviceExt;
    private int lastInputIndex = 0;
    private int lastOutputIndex = 0;
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colString = new MgrColumn.ToString(lexOut, 0);
    MgrColumn colOid = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpAgentProxyExt.objectIdentifier}, 0);
    MgrColumn colIndex = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpAgentProxyExt.index}, 3);
    MgrColumn colDefaultVal = new SnmpAgentDefaultCol();
    MgrColumn colAgentTable = new SnmpAgentTableCol();
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpAgentProxyExt.enabled}, 3);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpAgentProxyExt.deviceFacets}, 3);
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpAgentProxyExt.conversion}, 3);
    MgrColumn colDeviceValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    MgrColumn colExeResult = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 3);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colString, this.colOid, this.colIndex, this.colDefaultVal, this.colAgentTable, this.colEnabled, this.colDeviceFacets, this.colFacets, this.colConversion, this.colDeviceValue, this.colExeResult, this.colTuning};

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new SnmpAgentPointModel(this);
    }

    protected MgrController makeController() {
        return new SnmpAgentPointController(this);
    }

    private void initExt(BSnmpAgentProxyExt ext, BFacets deviceFacets, boolean writable) {
        if (writable) {
            this.lastOutputIndex = this.deviceExt.findNextOutputIndex(BInteger.make((int)this.lastOutputIndex)).getInt();
            ext.setIndex(this.lastOutputIndex);
        } else {
            this.lastInputIndex = this.deviceExt.findNextInputIndex(BInteger.make((int)this.lastInputIndex)).getInt();
            ext.setIndex(this.lastInputIndex);
        }
        ext.setDeviceFacets(deviceFacets);
    }

    public void doLoadValue(BObject value, Context cx) {
        if (value instanceof BSnmpAgentPointDeviceExt) {
            this.deviceExt = (BSnmpAgentPointDeviceExt)value;
        } else if (value instanceof BSnmpAgentPointFolder) {
            this.deviceExt = (BSnmpAgentPointDeviceExt)((BSnmpAgentPointFolder)value).getDeviceExt();
        }
        super.doLoadValue(value, cx);
    }

    public static class SnmpAgentTableCol
    extends MgrColumn {
        public SnmpAgentTableCol() {
            super(lexicon.getText("agentTable.columnTitle.agentTable"), 2);
        }

        public Object get(Object row) {
            BAbstractProxyExt ext;
            if (row instanceof BControlPoint && (ext = ((BControlPoint)row).getProxyExt()) instanceof BSnmpAgentProxyExt) {
                if (((BControlPoint)row).isWritablePoint()) {
                    return lexicon.getText("agentTable.strings.output");
                }
                return lexicon.getText("agentTable.strings.input");
            }
            return "";
        }
    }

    public static class SnmpAgentDefaultCol
    extends MgrColumn {
        boolean isDefault = false;

        public SnmpAgentDefaultCol() {
            super(lexicon.getText("agentTable.columnTitle.defaultValue"), 3);
        }

        public Object get(Object row) {
            if (row instanceof BControlPoint && !((BControlPoint)row).isWritablePoint()) {
                BAbstractProxyExt ext = ((BControlPoint)row).getProxyExt();
                if (ext instanceof BSnmpAgentBooleanProxyExt) {
                    return ((BSnmpAgentBooleanProxyExt)ext).getDefaultValue();
                }
                if (ext instanceof BSnmpAgentNumericProxyExt) {
                    return ((BSnmpAgentNumericProxyExt)ext).getDefaultValue();
                }
                if (ext instanceof BSnmpAgentStringProxyExt) {
                    return ((BSnmpAgentStringProxyExt)ext).getDefaultValue();
                }
                if (ext instanceof BSnmpAgentEnumProxyExt) {
                    return ((BSnmpAgentEnumProxyExt)ext).getDefaultValue();
                }
            }
            return "";
        }

        public BValue load(MgrEditRow row) {
            this.isDefault = false;
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint && !((BControlPoint)val).isWritablePoint()) {
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BSnmpAgentBooleanProxyExt) {
                    return ((BSnmpAgentBooleanProxyExt)ext).getDefaultValue().newCopy();
                }
                if (ext instanceof BSnmpAgentNumericProxyExt) {
                    return ((BSnmpAgentNumericProxyExt)ext).getDefaultValue().newCopy();
                }
                if (ext instanceof BSnmpAgentStringProxyExt) {
                    return ((BSnmpAgentStringProxyExt)ext).getDefaultValue().newCopy();
                }
                if (ext instanceof BSnmpAgentEnumProxyExt) {
                    return ((BSnmpAgentEnumProxyExt)ext).getDefaultValue().newCopy();
                }
            }
            this.isDefault = true;
            return BString.DEFAULT;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint) {
                if (((BControlPoint)val).isWritablePoint()) {
                    return;
                }
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BSnmpAgentBooleanProxyExt) {
                    ((BSnmpAgentBooleanProxyExt)ext).setDefaultValue((BSnmpAgentBooleanDefaultValue)value.newCopy());
                } else if (ext instanceof BSnmpAgentNumericProxyExt) {
                    ((BSnmpAgentNumericProxyExt)ext).setDefaultValue((BSnmpAgentNumericDefaultValue)value.newCopy());
                } else if (ext instanceof BSnmpAgentStringProxyExt) {
                    ((BSnmpAgentStringProxyExt)ext).setDefaultValue((BSnmpAgentStringDefaultValue)value.newCopy());
                } else if (ext instanceof BSnmpAgentEnumProxyExt) {
                    ((BSnmpAgentEnumProxyExt)ext).setDefaultValue((BSnmpAgentStringDefaultValue)value.newCopy());
                }
            }
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(row, value, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows == null || rows.length <= 0) {
                return null;
            }
            Type matchType = null;
            for (int i = 0; i < rows.length; ++i) {
                BComponent val = rows[i].getTarget();
                if (!(val instanceof BControlPoint)) {
                    return null;
                }
                if (((BControlPoint)val).isWritablePoint()) {
                    return null;
                }
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (matchType == null && (matchType = ext.getType()) != BSnmpAgentBooleanProxyExt.TYPE && matchType != BSnmpAgentNumericProxyExt.TYPE && matchType != BSnmpAgentStringProxyExt.TYPE && matchType != BSnmpAgentEnumProxyExt.TYPE) {
                    return null;
                }
                if (matchType == ext.getType()) continue;
                return null;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("defaultValue")};
            return SnmpAgentDefaultCol.toFieldEditor((MgrEditRow[])rows, (int)colIndex, null, (Property[])props);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            if (rows == null || rows.length <= 0) {
                return;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("defaultValue")};
            SnmpAgentDefaultCol.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])props);
        }
    }

    class SnmpAgentPointController
    extends PointController {
        SnmpAgentPointController(BSnmpAgentPointManager mgr) {
            super((BPointManager)mgr);
        }

        public CommandArtifact doNew(Context cx) throws Exception {
            BSnmpAgentPointManager.this.lastInputIndex = 0;
            BSnmpAgentPointManager.this.lastOutputIndex = 0;
            return super.doNew(cx);
        }
    }

    public class SnmpAgentPointModel
    extends PointModel {
        SnmpAgentPointModel(BSnmpAgentPointManager mgr) {
            super((BPointManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpAgentPointManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList list = new ArrayList();
            SnmpAgentPointModel.addBooleanPointTypes(list, (boolean)true);
            SnmpAgentPointModel.addNumericPointTypes(list, (boolean)true);
            SnmpAgentPointModel.addStringPointTypes(list, (boolean)true);
            SnmpAgentPointModel.addEnumPointTypes(list, (boolean)true);
            return list.toArray(new MgrTypeInfo[0]);
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BControlPoint pt = (BControlPoint)type.newInstance();
            BFacets deviceFacets = (BFacets)pt.getFacets().newCopy();
            BNullProxyExt ext = new BNullProxyExt();
            if (pt instanceof BBooleanPoint) {
                ext = new BSnmpAgentBooleanProxyExt();
                BSnmpAgentPointManager.this.initExt((BSnmpAgentProxyExt)ext, deviceFacets, pt.isWritablePoint());
            } else if (pt instanceof BNumericPoint) {
                ext = new BSnmpAgentNumericProxyExt();
                BSnmpAgentPointManager.this.initExt((BSnmpAgentProxyExt)ext, deviceFacets, pt.isWritablePoint());
            } else if (pt instanceof BStringPoint) {
                ext = new BSnmpAgentStringProxyExt();
                BSnmpAgentPointManager.this.initExt((BSnmpAgentProxyExt)ext, deviceFacets, pt.isWritablePoint());
            } else if (pt instanceof BEnumPoint) {
                ext = new BSnmpAgentEnumProxyExt();
                BSnmpAgentPointManager.this.initExt((BSnmpAgentProxyExt)ext, deviceFacets, pt.isWritablePoint());
            }
            pt.setProxyExt((BAbstractProxyExt)ext);
            return pt;
        }
    }
}

