/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.ui;

import com.tridium.nSnmp.version3.securityModel.usm.BUsmSecurityLevel;
import com.tridium.nSnmp.version3.securityModel.usmUser.BUsmUser;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicReference;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BajaException;
import javax.baja.sys.Localizable;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"nSnmp:UsmUserTable"}, requiredPermissions="r")})
public class BUsmUserManager
extends BAbstractManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BUsmUserManager.class);
    static Lexicon lex = Lexicon.make((String)"nSnmp");
    MgrColumn colName = new MgrColumn.Name(1);
    MgrColumn colIpAddress = new MgrColumn.Prop(BUsmUser.ipAddress.getDefaultDisplayName(null), BUsmUser.ipAddress, 1);
    MgrColumn colUsmSecurityLevel = new MgrColumn.Prop(BUsmUser.securityLevel.getDefaultDisplayName(null), BUsmUser.securityLevel, 1);
    MgrColumn colAuthProtocol = new MgrColumn.Prop(BUsmUser.authenticationProtocol.getDefaultDisplayName(null), BUsmUser.authenticationProtocol, 1);
    MgrColumn colAuthPassPhrase = new MgrColumn.Prop(BUsmUser.authenticationPassphrase.getDefaultDisplayName(null), BUsmUser.authenticationPassphrase, 1);
    MgrColumn colPrivacyProtocol = new MgrColumn.Prop(BUsmUser.privacyProtocol.getDefaultDisplayName(null), BUsmUser.privacyProtocol, 1);
    MgrColumn colPrivacyPassPhrase = new MgrColumn.Prop(BUsmUser.privacyPassphrase.getDefaultDisplayName(null), BUsmUser.privacyPassphrase, 1);
    MgrColumn colLocalEngineId = new MgrColumn.Prop(BUsmUser.engineID.getDefaultDisplayName(null), BUsmUser.engineID, 6);
    MgrColumn colContextName = new MgrColumn.Prop(BUsmUser.contextName.getDefaultDisplayName(null), BUsmUser.contextName, 1);
    protected MgrColumn[] cols = new MgrColumn[]{this.colName, this.colIpAddress, this.colUsmSecurityLevel, this.colAuthProtocol, this.colAuthPassPhrase, this.colPrivacyProtocol, this.colPrivacyPassPhrase, this.colLocalEngineId, this.colContextName};
    private final BPasswordStrength passwordStrength = BPasswordStrength.DEFAULT;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new SnmpUsmUserModel(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    private void validate(MgrEditRow row) throws BajaException {
        String authPass = AccessController.doPrivileged(() -> ((BPassword)((BPassword)row.getCell(this.colAuthPassPhrase))).getValue());
        String privPass = AccessController.doPrivileged(() -> ((BPassword)((BPassword)row.getCell(this.colPrivacyPassPhrase))).getValue());
        BUsmSecurityLevel usmSecurityLevel = (BUsmSecurityLevel)row.getCell(this.colUsmSecurityLevel);
        if (!usmSecurityLevel.getTag().equalsIgnoreCase("noAuthNoPriv")) {
            this.validatePassword(authPass);
        }
        if (usmSecurityLevel.getTag().equalsIgnoreCase("AuthPriv")) {
            this.validatePassword(privPass);
        }
    }

    private void validatePassword(String authPass) throws BajaException {
        AtomicReference messageRef = new AtomicReference();
        if (!this.passwordStrength.isPasswordValid(authPass.toCharArray(), messageRef::set)) {
            throw new BajaException(((Localizable)messageRef.get()).toString(null));
        }
    }

    class Edit
    extends MgrEdit {
        public Edit(BAbstractManager manager, String title) {
            super(manager, title);
        }

        public void validate(MgrEditRow row) throws Exception {
            BUsmUserManager.this.validate(row);
        }
    }

    class Controller
    extends MgrController {
        Controller(BUsmUserManager bUsmUserManager) {
            super((BAbstractManager)bUsmUserManager);
        }

        public MgrEdit makeEdit(String label) {
            return new Edit(this.getManager(), label);
        }
    }

    class SnmpUsmUserModel
    extends MgrModel {
        public SnmpUsmUserModel(BAbstractManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BUsmUserManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            MgrTypeInfo[] retVal = new MgrTypeInfo[]{MgrTypeInfo.make((Type)BUsmUser.TYPE)};
            return retVal;
        }
    }
}

