/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.print;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BFont;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Queue;
import javax.baja.util.Worker;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.standard.PrinterName;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="printer", type="String", defaultValue="<Enter Printer Name>", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"alarm:PrinterFE\"))")}), @NiagaraProperty(name="font", type="BFont", defaultValue="BFont.make(\"12pt Monospaced\")"), @NiagaraProperty(name="printFormat", type="BFormat", defaultValue="makeDefaultPrintFormat()", facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.make(true))")}), @NiagaraProperty(name="alertOnFailure", type="boolean", defaultValue="false"), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="makeDefaultAlarmSourceInfo()")})
@NiagaraAction(name="getPrinters", returnType="BVector")
public class BPrinterRecipient
extends BAlarmRecipient
implements BIAlarmSource {
    @Generated
    public static final Property printer = BPrinterRecipient.newProperty((int)0, (String)"<Enter Printer Name>", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:PrinterFE")));
    @Generated
    public static final Property font = BPrinterRecipient.newProperty((int)0, (BValue)BFont.make((String)"12pt Monospaced"), null);
    @Generated
    public static final Property printFormat = BPrinterRecipient.newProperty((int)0, (BValue)BPrinterRecipient.makeDefaultPrintFormat(), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
    @Generated
    public static final Property alertOnFailure = BPrinterRecipient.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property alarmSourceInfo = BPrinterRecipient.newProperty((int)0, (BValue)BPrinterRecipient.makeDefaultAlarmSourceInfo(), null);
    @Generated
    public static final Action getPrinters = BPrinterRecipient.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPrinterRecipient.class);
    private static final Logger log = Logger.getLogger("alarm.printer");
    private AlarmSupport support;
    private final Queue printQueue = new Queue();
    private final Worker printThread = new Worker((Worker.ITodo)this.printQueue);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"print.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));

    @Generated
    public String getPrinter() {
        return this.getString(printer);
    }

    @Generated
    public void setPrinter(String v) {
        this.setString(printer, v, null);
    }

    @Generated
    public BFont getFont() {
        return (BFont)this.get(font);
    }

    @Generated
    public void setFont(BFont v) {
        this.set(font, (BValue)v, null);
    }

    @Generated
    public BFormat getPrintFormat() {
        return (BFormat)this.get(printFormat);
    }

    @Generated
    public void setPrintFormat(BFormat v) {
        this.set(printFormat, (BValue)v, null);
    }

    @Generated
    public boolean getAlertOnFailure() {
        return this.getBoolean(alertOnFailure);
    }

    @Generated
    public void setAlertOnFailure(boolean v) {
        this.setBoolean(alertOnFailure, v, null);
    }

    @Generated
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    @Generated
    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Generated
    public BVector getPrinters() {
        return (BVector)this.invoke(getPrinters, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.support = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.printThread.start("alarm:printing");
    }

    public void stopped() throws Exception {
        this.printThread.stop();
    }

    public static BFormat makeDefaultPrintFormat() {
        StringBuilder buf = new StringBuilder();
        buf.append("Source:      %alarmData.sourceName%\n");
        buf.append("Timestamp:   %timestamp%\n");
        buf.append("State:       %sourceState% / %ackState%\n");
        buf.append("Priority:    %priority%\n");
        buf.append("Alarm Class: %alarmClass%\n");
        buf.append("Text:        %alarmData.msgText%\n");
        buf.append("\n");
        return BFormat.make((String)buf.toString());
    }

    public static BAlarmSourceInfo makeDefaultAlarmSourceInfo() {
        BAlarmSourceInfo info = new BAlarmSourceInfo();
        info.setAlarmIcon(BOrd.make((String)"module://icons/x16/print.png"));
        return info;
    }

    public BVector doGetPrinters() {
        ArrayList services = AccessController.doPrivileged(() -> {
            PrintService[] printers1 = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.AUTOSENSE, null);
            ArrayList printerList = new ArrayList();
            Collections.addAll(printerList, printers1);
            return printerList;
        });
        BVector printerNames = new BVector();
        for (int i = 0; i < services.size(); ++i) {
            printerNames.add(null, (BValue)BString.make((String)((PrintService)services.get(i)).getName()));
        }
        return printerNames;
    }

    public void handleAlarm(BAlarmRecord alarm) {
        if (alarm.getSource().equals((Object)BOrdList.make((BOrd)this.getNavOrd()))) {
            return;
        }
        this.printQueue.enqueue((Object)new PrintJob(BFormat.make((String)this.getPrintFormat().format((Object)alarm)).format((Object)alarm)));
    }

    public BBoolean ackAlarm(BAlarmRecord alert) {
        try {
            return BBoolean.make((boolean)this.support.ackAlarm(alert));
        }
        catch (Exception e) {
            return BBoolean.FALSE;
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    private class PrintJob
    implements Runnable,
    Printable {
        int[] lineNumberAtTopOfPage;
        ArrayList<String> textLines = new ArrayList();

        public PrintJob(String text) {
            int i;
            String[] textArray = text.split("\n");
            for (i = 0; i < textArray.length; ++i) {
                this.textLines.add(textArray[i]);
            }
            this.lineNumberAtTopOfPage = new int[100];
            this.lineNumberAtTopOfPage[0] = 0;
            for (i = 1; i < this.lineNumberAtTopOfPage.length; ++i) {
                this.lineNumberAtTopOfPage[i] = -1;
            }
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            int lineNumber = this.lineNumberAtTopOfPage[pageIndex];
            if (this.lineNumberAtTopOfPage[pageIndex] == -1) {
                return 1;
            }
            if (pageIndex != 0) {
                while (this.textLines.get(lineNumber).length() == 0) {
                    ++lineNumber;
                }
            }
            try {
                Font font;
                Graphics2D g2d = (Graphics2D)graphics;
                g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                if (!BPrinterRecipient.this.getFont().isNull()) {
                    BFont bFont = BPrinterRecipient.this.getFont();
                    int style = 0;
                    if (bFont.isBold()) {
                        style |= 1;
                    }
                    if (bFont.isItalic()) {
                        style |= 2;
                    }
                    font = new Font(bFont.getName(), style, (int)bFont.getSize());
                    if (bFont.isUnderline()) {
                        Hashtable<TextAttribute, Integer> map = new Hashtable<TextAttribute, Integer>();
                        map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                        font = font.deriveFont(map);
                    }
                    graphics.setFont(font);
                    g2d.setFont(font);
                } else {
                    font = g2d.getFont();
                }
                FontMetrics fontMetrics = g2d.getFontMetrics(font);
                int distanceFromTopOfPage = fontMetrics.getAscent();
                while (lineNumber < this.textLines.size() && (double)distanceFromTopOfPage < pageFormat.getImageableHeight()) {
                    String line = this.textLines.get(lineNumber);
                    if ((double)fontMetrics.charsWidth(line.toCharArray(), 0, line.length()) > pageFormat.getImageableWidth()) {
                        int length;
                        ArrayList<String> wrappedLines = new ArrayList<String>();
                        for (int start = 0; start < line.length(); start += length) {
                            length = line.length() - start;
                            while ((double)fontMetrics.charsWidth(line.toCharArray(), start, length) > pageFormat.getImageableWidth()) {
                                --length;
                            }
                            int cleanBreakLength = length;
                            if (start + cleanBreakLength < line.length()) {
                                while (line.charAt(start + cleanBreakLength - 1) != ' ' && cleanBreakLength > 1) {
                                    --cleanBreakLength;
                                }
                                if (cleanBreakLength > 1) {
                                    length = cleanBreakLength;
                                }
                            }
                            wrappedLines.add(line.substring(start, start + length));
                        }
                        this.textLines.remove(lineNumber);
                        for (int i = wrappedLines.size() - 1; i >= 0; --i) {
                            this.textLines.add(lineNumber, (String)wrappedLines.get(i));
                        }
                    }
                    g2d.drawString(line, 0, distanceFromTopOfPage);
                    distanceFromTopOfPage += fontMetrics.getAscent();
                    ++lineNumber;
                }
                if ((double)distanceFromTopOfPage >= pageFormat.getImageableHeight()) {
                    this.lineNumberAtTopOfPage[pageIndex + 1] = lineNumber;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Print failure", e);
                return 1;
            }
            return 0;
        }

        @Override
        public void run() {
            HashAttributeSet aset = new HashAttributeSet();
            aset.add(new PrinterName(BPrinterRecipient.this.getPrinter(), null));
            ArrayList printers = AccessController.doPrivileged(() -> {
                PrintService[] printers1 = PrintServiceLookup.lookupPrintServices(null, aset);
                ArrayList printerList = new ArrayList();
                Collections.addAll(printerList, printers1);
                return printerList;
            });
            if (printers.size() < 1) {
                try {
                    if (BPrinterRecipient.this.getAlertOnFailure()) {
                        BFacets facets = BPrinterRecipient.this.getAlarmSourceInfo().makeAlarmData(BSourceState.offnormal);
                        facets = BFacets.make((BFacets)facets, (String)"msgText", (BIDataValue)BString.make((String)("Printer '" + BPrinterRecipient.this.getPrinter() + "' not found.")));
                        BPrinterRecipient.this.support.newAlert(facets);
                    }
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Printer not found: " + BPrinterRecipient.this.getPrinter(), e);
                }
                return;
            }
            try {
                DocPrintJob job = AccessController.doPrivileged(() -> ((PrintService)printers.get(0)).createPrintJob());
                job.print(new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null), null);
            }
            catch (PrintException pe) {
                if (BPrinterRecipient.this.getAlertOnFailure()) {
                    BFacets facets = BPrinterRecipient.this.getAlarmSourceInfo().makeAlarmData(BSourceState.offnormal);
                    facets = BFacets.make((BFacets)facets, (String)"msgText", (BIDataValue)BString.make((String)("Unable to print to '" + BPrinterRecipient.this.getPrinter() + "'")));
                    try {
                        BPrinterRecipient.this.support.newAlert(facets);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                log.log(Level.SEVERE, "Printer failure", pe);
            }
        }
    }
}

