/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform;

import com.tridium.seriestransform.graph.BTransformGraph;
import java.util.StringJoiner;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public abstract class SchemaCheckUtil {
    private static final Lexicon lex = Lexicon.make(SchemaCheckUtil.class);
    private static final String TIMESTAMP_REQUIRED = lex.getText("fault.msg.timestampRequired");
    private static final String VALUE_REQUIRED = lex.getText("fault.msg.valueRequired");
    private static final String ADMIN_WRITE_REQUIRED = lex.getText("fault.msg.needAdminWrite");
    public static final String TIMESTAMP_FIELD = "timestamp";
    public static final String VALUE_FIELD = "value";

    public static boolean isChartable(BTransformGraph transformGraph, Context cx) {
        return SchemaCheckUtil.getCannotChartReason(transformGraph, cx) == null;
    }

    public static String getCannotChartReason(BTransformGraph transformGraph, Context cx) {
        StringJoiner reasons = new StringJoiner(",");
        reasons.setEmptyValue("");
        BSeriesSchema schema = transformGraph.getSchema();
        boolean hasValueEnumOrNumericField = false;
        for (String name : schema.getFieldNames()) {
            BTypeSpec fieldTypeSpec = schema.getFieldType(name);
            Type type = fieldTypeSpec.getResolvedType();
            if (!type.is(BEnum.TYPE) && !type.is(BINumeric.TYPE)) continue;
            hasValueEnumOrNumericField = true;
            break;
        }
        if (!hasValueEnumOrNumericField) {
            reasons.add(VALUE_REQUIRED);
        }
        if (!schema.hasField(TIMESTAMP_FIELD)) {
            reasons.add(TIMESTAMP_REQUIRED);
        } else {
            BTypeSpec fieldTypeSpec = schema.getFieldType(TIMESTAMP_FIELD);
            Type type = fieldTypeSpec.getResolvedType();
            if (!type.is(BAbsTime.TYPE)) {
                reasons.add(TIMESTAMP_REQUIRED);
            }
        }
        if (reasons.length() == 0) {
            return null;
        }
        return reasons.toString();
    }
}

