/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.functions;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.exceptions.SourceException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

@NiagaraType
public class BFindMax
extends BTransformFunction {
    @Generated
    public static final Type TYPE = Sys.loadType(BFindMax.class);
    private static final Lexicon lex = Lexicon.make(BFindMax.class);
    private static final String FUNCTION_NAME = lex.getText("functions.name.findMax");
    private static final String FUNCTION_DESC = lex.getText("functions.desc.findMax");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getFunctionDesc() {
        return FUNCTION_DESC;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public Type getReturnType() {
        return BNumber.TYPE;
    }

    @Override
    public Type[] getArgumentTypes() {
        return new Type[]{BNumber.TYPE};
    }

    @Override
    public void applyFunction(Map<String, List<? extends BComplex>> series, String[] srcProps, Property destProp, BComplex resultRecord) throws TransformException {
        BDouble maxValue = null;
        BUnit dstUnits = BFindMax.getUnits(destProp);
        for (String name : srcProps) {
            List<? extends BComplex> records = this.getSeriesRecords(series, BFindMax.getSeriesName(name));
            if (log.isLoggable(Level.FINE) && (records == null || records.isEmpty())) {
                Set<String> keySet = series.keySet();
                for (String seriesName : keySet) {
                    log.fine("BFindMax - series name: " + seriesName);
                }
            }
            if (null == records) continue;
            for (BComplex bComplex : records) {
                Property field = bComplex.getProperty(BFindMax.getFieldName(name));
                try {
                    BNumber check = BFindMax.getMaxValue((BNumber)maxValue, field, dstUnits, bComplex);
                    if (check.equals((Object)BDouble.NaN)) continue;
                    maxValue = check;
                }
                catch (SourceException e) {
                    maxValue = BDouble.NaN;
                }
            }
        }
        if (null == maxValue) {
            maxValue = BDouble.NaN;
        }
        BFindMax.setRecordValue(resultRecord, destProp, (BValue)maxValue);
    }

    private static BNumber getMaxValue(BNumber maxValue, Property field, BUnit dstUnits, BComplex record) throws SourceException {
        BValue value = record.get(field);
        BFacets facets = field.getFacets();
        if (maxValue == BDouble.NaN) {
            return maxValue;
        }
        BNumber number = BFindMax.convertToUnits((BNumber)value, (BUnit)facets.getFacet("units"), dstUnits);
        if (number == BDouble.NaN) {
            return BDouble.NaN;
        }
        if (null == maxValue || number.compareTo((Object)maxValue) > 0) {
            maxValue = number;
        }
        return maxValue;
    }
}

