/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.graph;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.seriestransform.graph.ParameterSlot;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.seriestransform.exceptions.ConfigException;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.BStatusSchema;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Version;

@NiagaraType
@NiagaraAction(name="forceSchemaCheck", flags=4)
public abstract class BNodeContainer
extends BGraphNode {
    @Generated
    public static final Action forceSchemaCheck = BNodeContainer.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNodeContainer.class);
    public static final String TRNS_LNK_PREFIX = "lnk";
    private static final String TRNS_LNK_DISPLAY_SUFFIX = "input";
    public static final Version MINIMUM_NODE_MAPPINGS = new Version("4.11");

    @Generated
    public void forceSchemaCheck() {
        this.invoke(forceSchemaCheck, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNodeContainer() {
        this.setIllegalChildTypes(new TypeInfo[0]);
    }

    public void doForceSchemaCheck() {
        BGraphNode[] children;
        for (BGraphNode node : children = (BGraphNode[])this.getChildren(BGraphNode.class)) {
            try {
                node.schemaCheck();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.schemaCheck();
    }

    public ParameterSlot[] getParameterSlots() {
        BGraphNode[] nodes;
        LinkedList slots = new LinkedList();
        for (BGraphNode node : nodes = (BGraphNode[])this.getChildren(BGraphNode.class)) {
            ParameterSlot[] parameterSlots = BNodeContainer.getParameterSlots(node);
            Collections.addAll(slots, parameterSlots);
        }
        return slots.toArray(new ParameterSlot[0]);
    }

    protected void compositeNode(BGraphNode node) {
        if (!this.isRunning() || null == node) {
            return;
        }
        if (!BNodeContainer.canCompositeNode(node)) {
            return;
        }
        for (BLink link : node.getLinks()) {
            if (!link.getSourceSlotName().equals(transformInputs.getName())) continue;
            link.activate();
            BComponent srcComp = link.getSourceComponent();
            if (srcComp == this) {
                return;
            }
            node.remove((BComplex)link);
        }
        String cmpLnkDispName = node.getDisplayName(null) + TRNS_LNK_DISPLAY_SUFFIX;
        String pName = TRNS_LNK_PREFIX + node.getName();
        if (null == this.get(pName)) {
            Property paramInputLnk = this.add(pName, (BValue)new BStatusSchema(), 4104, BFacets.NULL, null);
            BLink inputLink = new BLink(this.getHandleOrd(), pName, transformInputs.getName(), true);
            String compLinkName = TRNS_LNK_PREFIX + this.getName();
            if (null == node.get(compLinkName)) {
                node.add(compLinkName, (BValue)inputLink);
            } else {
                node.set(compLinkName, (BValue)inputLink);
            }
            inputLink.activate();
            this.setDisplayName(paramInputLnk, BFormat.make((String)cmpLnkDispName), null);
        }
    }

    protected void decompositeNode(BGraphNode node) {
        if (!this.isRunning() || null == node) {
            return;
        }
        for (BLink link : node.getLinks()) {
            try {
                String sourceSlotName;
                BComponent sourceComponent = link.getSourceComponent();
                if (null == sourceComponent || sourceComponent != this || null == this.get(sourceSlotName = link.getSourceSlotName())) continue;
                node.remove((BComplex)link);
                this.remove(sourceSlotName, null);
            }
            catch (UnresolvedException unresolvedException) {
                // empty catch block
            }
        }
    }

    private static ParameterSlot[] getParameterSlots(BGraphNode node) {
        if (node instanceof BNodeContainer) {
            BNodeContainer container = (BNodeContainer)node;
            node.lease(3);
            ParameterSlot[] parameterSlots = container.getParameterSlots();
            return parameterSlots;
        }
        BGraphNode parent = node;
        String ord = parent.getSlotPath().toString();
        LinkedList<ParameterSlot> parameters = new LinkedList<ParameterSlot>();
        for (Property p : node.getFrozenPropertiesArray()) {
            BObject instance = p.getType().getInstance();
            if (Flags.isReadonly((BComplex)node, (Slot)p) || Flags.isHidden((BComplex)node, (Slot)p) || p.getType().equals(BStatusSchema.TYPE) || p.getName().equals(BGraphNode.transformInputs.getName()) || !(instance instanceof BSimple)) continue;
            Type type = p.getType();
            ParameterSlot slot = new ParameterSlot(ord, p.getName(), type, 0x1000 | node.getFlags((Slot)p));
            parameters.add(slot);
        }
        return parameters.toArray(new ParameterSlot[0]);
    }

    private static boolean canCompositeNode(BGraphNode node) {
        node.lease();
        List schemaProps = Arrays.stream(node.getFrozenPropertiesArray()).map(Property::getType).filter(type -> type == BSeriesSchema.TYPE).collect(Collectors.toList());
        return !schemaProps.isEmpty();
    }

    public void started() throws Exception {
        String compLinkName = TRNS_LNK_PREFIX + this.getName();
        BOrd myOrd = this.getHandleOrd();
        for (Property prop : this.getDynamicPropertiesArray()) {
            BValue bValue = this.get(prop);
            if (!(bValue instanceof BGraphNode)) continue;
            BGraphNode node = (BGraphNode)bValue;
            node.lease();
            for (BLink lnk : node.getLinks()) {
                String lnkName = lnk.getName();
                if (!lnkName.startsWith(TRNS_LNK_PREFIX)) continue;
                if (!lnkName.equals(compLinkName)) {
                    node.remove((BComplex)lnk);
                    String nodeLink = TRNS_LNK_PREFIX + node.getName();
                    if (null != this.get(nodeLink)) {
                        this.remove(nodeLink);
                    }
                    this.compositeNode(node);
                    continue;
                }
                lnk.setSourceOrd(myOrd);
            }
        }
    }

    public void checkRemove(Property property, Context context) {
        BValue b = this.get(property);
        if (b instanceof BGraphNode && this.isRunning()) {
            BGraphNode node = (BGraphNode)b;
            this.decompositeNode(node);
            this.forceSchemaCheck();
        }
        super.checkRemove(property, context);
    }

    public void added(Property property, Context context) {
        BValue value = this.get(property);
        if (value instanceof BGraphNode && this.isRunning()) {
            BGraphNode node = (BGraphNode)value;
            node.lease();
            try {
                for (BLink link : node.getLinks()) {
                    BOrd sourceOrd = link.getSourceOrd();
                    BObject cmp = sourceOrd.get((BObject)this);
                    if (!(cmp instanceof BNodeContainer) || cmp == this) continue;
                    node.remove((BComplex)link);
                }
            }
            catch (UnresolvedException unresolvedException) {
                // empty catch block
            }
            this.compositeNode((BGraphNode)value);
            try {
                node.doCheckSchema();
                node.clearFault();
            }
            catch (ConfigException ce) {
                node.markFault(ce.getMessage());
            }
        }
        super.added(property, context);
    }

    public void removed(Property property, BValue oldValue, Context context) {
        BLink link;
        if (oldValue instanceof BLink && this.isRunning() && (link = (BLink)oldValue).getSourceSlotName().equals(BGraphNode.transformOutput.getName())) {
            this.forceSchemaCheck();
        }
        super.removed(property, oldValue, context);
    }

    public void changed(Property property, Context context) {
        BValue value;
        if (context != Context.decoding && (value = this.get(property)) instanceof BGraphNode) {
            this.forceSchemaCheck();
        }
    }

    public void stationStarted() throws Exception {
        BGraphNode[] nodes;
        for (BGraphNode node : nodes = (BGraphNode[])this.getChildren(BGraphNode.class)) {
            node.lease(3);
            this.compositeNode(node);
        }
        this.forceSchemaCheck();
    }

    public void runSchemaCheck() {
        BFoxSession foxSession;
        Version remoteVersion;
        BISession session = this.getSession();
        if (session instanceof BFoxSession && (remoteVersion = (foxSession = (BFoxSession)session).getConnection().getRemoteVersion()).compareTo(MINIMUM_NODE_MAPPINGS) < 0) {
            this.forceSchemaCheck();
            return;
        }
        FoxRpcUtil.doSilentRpc((BISpaceNode)this, (String)"runSchemaCheckRpc", (Object[])new Object[0]);
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.fox)}, permissions="unrestricted")
    public void runSchemaCheckRpc(Context cx) {
        this.doForceSchemaCheck();
    }
}

