/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.rollup;

import com.tridium.seriestransform.functions.BFunctionMapping;
import com.tridium.seriestransform.functions.FunctionCursor;
import com.tridium.seriestransform.rollup.BRollupInterval;
import com.tridium.seriestransform.rollup.BRollupIntervalEnum;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Level;
import javax.baja.collection.BITable;
import javax.baja.collection.Row;
import javax.baja.nre.util.IFilter;
import javax.baja.seriestransform.SeriesTransformRow;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.timezone.BTimeZone;

public class RollupCursor
extends FunctionCursor<BComplex> {
    private final BComponent record;
    protected BComplex prevRecord;
    private BAbsTime prevIntervalEndtime;
    private final String seriesName;
    private final BRollupInterval interval;
    private final Cursor<BComplex> innerCursor;
    private final List<BComplex> seriesRecords = new LinkedList<BComplex>();
    private final Map<String, List<? extends BComplex>> rollupMap = new HashMap<String, List<? extends BComplex>>();

    public RollupCursor(BSeriesSchema schema, BITable<BComplex> series, String seriesName, BRollupInterval interval, BFunctionMapping[] functions, IFilter filter) {
        super(schema.getKeyField());
        this.seriesName = seriesName;
        this.interval = interval;
        this.functions = functions;
        this.filter = filter;
        this.innerCursor = series.cursor();
        this.initTimes(series);
        this.record = RollupCursor.createTemplateRecord(schema);
    }

    @Override
    protected void initTimes(BITable<BComplex> series) {
        BRelTime definedInterval;
        super.initTimes(series);
        this.intervalDefined = false;
        if (null != this.interval && (definedInterval = this.interval.getTime()).getMillis() >= 1000L) {
            this.intervalDefined = true;
        }
        if (!this.intervalDefined) {
            throw new BajaRuntimeException("Rollup Cursor: interval not defined.");
        }
    }

    private void initInterval(BAbsTime baseSeriesStartTime) {
        this.intervalStartTime = this.makeBaselineTimestamp(baseSeriesStartTime);
        BRelTime definedInterval = this.interval.getTime();
        BRollupIntervalEnum desc = this.interval.getDesc();
        switch (desc.getOrdinal()) {
            case 0: {
                this.intervalEndTime = this.intervalStartTime.add(definedInterval);
                break;
            }
            case 1: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.makeMinutes((int)5));
                break;
            }
            case 2: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.makeMinutes((int)15));
                break;
            }
            case 3: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.makeMinutes((int)30));
                break;
            }
            case 4: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.HOUR);
                break;
            }
            case 5: {
                this.intervalEndTime = this.intervalStartTime.nextDay();
                break;
            }
            case 6: {
                this.intervalEndTime = this.intervalStartTime.nextMonth();
                break;
            }
            case 7: {
                this.intervalEndTime = this.intervalStartTime.nextYear();
            }
        }
    }

    private BAbsTime makeBaselineTimestamp(BAbsTime timestamp) {
        BRelTime definedInterval = this.interval.getTime();
        BRollupIntervalEnum desc = this.interval.getDesc();
        if (desc == BRollupIntervalEnum.yearly) {
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)BMonth.january, (int)1);
        }
        if (desc == BRollupIntervalEnum.monthly) {
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)1);
        }
        if (desc == BRollupIntervalEnum.daily || definedInterval.getDays() > 0) {
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay());
        }
        if (desc == BRollupIntervalEnum.hourly || definedInterval.getHours() > 0) {
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay(), (int)timestamp.getHour(), (int)0);
        }
        if (desc == BRollupIntervalEnum.thirtyMin) {
            int minute = RollupCursor.getBaseQuantum(timestamp.getMinute(), 30);
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay(), (int)timestamp.getHour(), (int)minute);
        }
        if (desc == BRollupIntervalEnum.fifteenMin) {
            int minute = RollupCursor.getBaseQuantum(timestamp.getMinute(), 15);
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay(), (int)timestamp.getHour(), (int)minute);
        }
        if (desc == BRollupIntervalEnum.fiveMin) {
            int minute = RollupCursor.getBaseQuantum(timestamp.getMinute(), 5);
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay(), (int)timestamp.getHour(), (int)minute);
        }
        if (definedInterval.getMinutes() > 0) {
            int minute = RollupCursor.getBaseQuantum(timestamp.getMinute(), definedInterval.getMinutes());
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay(), (int)timestamp.getHour(), (int)minute);
        }
        if (definedInterval.getSeconds() > 0) {
            int seconds = RollupCursor.getBaseQuantum(timestamp.getSecond(), definedInterval.getSeconds());
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay(), (int)timestamp.getHour(), (int)timestamp.getMinute(), (int)seconds, (int)0);
        }
        if (definedInterval.getMillis() > 0L) {
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay(), (int)timestamp.getHour(), (int)timestamp.getMinute(), (int)timestamp.getSecond(), (int)0);
        }
        return timestamp;
    }

    private static int getBaseQuantum(int quantumValue, int interval) {
        if (interval == 0 || quantumValue == 0) {
            return 0;
        }
        return quantumValue / interval * interval;
    }

    private void updateIntervalPeriod() {
        BRollupIntervalEnum desc = this.interval.getDesc();
        switch (desc.getOrdinal()) {
            case 0: {
                BRelTime definedInterval = this.interval.getTime();
                this.intervalStartTime = this.intervalStartTime.add(definedInterval);
                this.intervalEndTime = this.intervalEndTime.add(definedInterval);
                break;
            }
            case 7: {
                this.intervalStartTime = this.intervalStartTime.nextYear();
                this.intervalEndTime = this.intervalEndTime.nextYear();
                break;
            }
            case 6: {
                this.intervalStartTime = this.intervalStartTime.nextMonth();
                this.intervalEndTime = this.intervalEndTime.nextMonth();
                break;
            }
            case 5: {
                this.intervalStartTime = this.intervalStartTime.nextDay();
                this.intervalEndTime = this.intervalEndTime.nextDay();
                break;
            }
            case 4: {
                this.intervalStartTime = this.intervalStartTime.add(BRelTime.HOUR);
                this.intervalEndTime = this.intervalEndTime.add(BRelTime.HOUR);
                break;
            }
            case 3: {
                this.intervalStartTime = this.intervalStartTime.add(THIRTY_MIN);
                this.intervalEndTime = this.intervalEndTime.add(THIRTY_MIN);
                break;
            }
            case 2: {
                this.intervalStartTime = this.intervalStartTime.add(FIFTEEN_MIN);
                this.intervalEndTime = this.intervalEndTime.add(FIFTEEN_MIN);
                break;
            }
            case 1: {
                this.intervalStartTime = this.intervalStartTime.add(FIVE_MIN);
                this.intervalEndTime = this.intervalEndTime.add(FIVE_MIN);
            }
        }
    }

    public boolean advanceCursor() {
        this.seriesRecords.clear();
        String keyField = this.getKeyField();
        RollupCursor.clearRecord((BComplex)this.record);
        if (this.prevRecord != null) {
            BAbsTime timestamp = (BAbsTime)this.prevRecord.get(keyField);
            if (timestamp.isAfter(this.intervalEndTime)) {
                this.initInterval(timestamp);
            }
            if ((timestamp.isAfter(this.prevIntervalEndtime) || timestamp.equals((Object)this.prevIntervalEndtime)) && (null == this.filter || null != this.filter && this.filter.accept((Object)this.prevRecord))) {
                this.seriesRecords.add(this.prevRecord);
            }
            this.prevRecord = null;
        }
        this.getIntervalSeries(this.seriesRecords);
        if (log.isLoggable(Level.FINE)) {
            this.traceSeriesData(this.seriesRecords);
        }
        if (this.seriesRecords.isEmpty()) {
            return false;
        }
        this.rollupMap.clear();
        this.rollupMap.put(this.seriesName, this.seriesRecords);
        try {
            this.applySeriesFunction(this.rollupMap, (BComplex)this.record, false);
        }
        catch (TransformException e) {
            throw new BajaRuntimeException(e.getMessage(), e.getCause());
        }
        this.record.set(keyField, (BValue)this.intervalStartTime);
        this.prevIntervalEndtime = BAbsTime.make((long)this.intervalEndTime.getMillis(), (BTimeZone)this.intervalEndTime.getTimeZone());
        this.updateIntervalPeriod();
        return true;
    }

    public Row<BComplex> row() {
        return new SeriesTransformRow<BComponent>(this.getTable(), this.record);
    }

    protected void closeCursor() {
        this.innerCursor.close();
    }

    private void getIntervalSeries(List<BComplex> seriesRecords) {
        String keyField = this.getKeyField();
        while (this.innerCursor.next()) {
            BComplex record;
            BAbsTime timestamp;
            if (!(this.innerCursor.get() instanceof BComplex) || null == (timestamp = (BAbsTime)(record = (BComplex)((BComplex)this.innerCursor.get()).newCopy()).get(keyField))) continue;
            if (null == this.intervalStartTime || this.intervalStartTime == BAbsTime.DEFAULT) {
                this.initInterval(timestamp);
            }
            if (timestamp.equals((Object)this.intervalEndTime) || timestamp.isAfter(this.intervalEndTime)) {
                this.prevRecord = record;
                break;
            }
            if (timestamp.isBefore(this.intervalEndTime)) {
                if (null != this.filter && (null == this.filter || !this.filter.accept((Object)record))) continue;
                seriesRecords.add(record);
                continue;
            }
            this.prevRecord = null;
        }
    }

    private void traceSeriesData(List<BComplex> seriesRecords) {
        log.fine("--- Rollup Cursor ---");
        log.fine("start interval: " + this.intervalStartTime.encodeToString());
        log.fine("end interval:   " + this.intervalEndTime.encodeToString());
        log.fine("Record count:   " + seriesRecords.size());
        log.fine("Record Times:");
        StringJoiner header = new StringJoiner(",");
        StringBuilder contents = new StringBuilder();
        boolean first = true;
        Iterator<BComplex> iterator = seriesRecords.iterator();
        while (iterator.hasNext()) {
            BComplex seriesRecord;
            BComplex record = seriesRecord = iterator.next();
            SlotCursor properties = record.getProperties();
            StringJoiner joiner = new StringJoiner(",");
            while (properties.next()) {
                Property property = properties.property();
                BValue bValue = record.get(property);
                if (first) {
                    header.add(property.getName());
                }
                joiner.add(bValue.toString());
            }
            joiner.add("\n");
            contents.append(joiner.toString());
            first = false;
        }
        log.fine(header.toString());
        log.fine(contents.toString());
    }
}

