/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.scale;

import com.tridium.seriestransform.scale.BScaleFactor;
import com.tridium.seriestransform.scale.BScaleFactors;
import com.tridium.seriestransform.scale.BScaleTable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.exceptions.ConfigException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.BStatusSchema;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.status.BStatus;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperty(name="scaleFactors", type="BScaleFactors", defaultValue="new BScaleFactors()")
public class BScaleNode
extends BGraphNode {
    @Generated
    public static final Property scaleFactors = BScaleNode.newProperty((int)0, (BValue)new BScaleFactors(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BScaleNode.class);

    @Generated
    public BScaleFactors getScaleFactors() {
        return (BScaleFactors)this.get(scaleFactors);
    }

    @Generated
    public void setScaleFactors(BScaleFactors v) {
        this.set(scaleFactors, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] inputs, GraphNodeParams params, BOrd base) throws TransformException {
        Map<String, Double> scaleFactors = this.convertScaleFactorsToMap();
        LinkedList<BScaleTable> results = new LinkedList<BScaleTable>();
        for (BSeriesTransformTable table : inputs) {
            BScaleTable scaleTable = new BScaleTable(this.getName(), this.getSchema(), table, scaleFactors);
            results.add(scaleTable);
        }
        return results.toArray(new BSeriesTransformTable[0]);
    }

    protected Map<String, Double> convertScaleFactorsToMap() {
        HashMap<String, Double> factors = new HashMap<String, Double>();
        BScaleFactors propFactors = this.getScaleFactors();
        for (BScaleFactor assignment : (BScaleFactor[])propFactors.getChildren(BScaleFactor.class)) {
            String colName = assignment.getInputFieldName();
            double factor = assignment.getFactor();
            factors.put(colName, factor);
        }
        return factors;
    }

    @Override
    public BSeriesSchema doGetSchema() {
        BSeriesSchema schema = new BSeriesSchema();
        BGraphNode[] inputSources = this.getSources();
        if (inputSources.length > 0) {
            BGraphNode src = inputSources[0];
            return src.getSchema();
        }
        return schema;
    }

    @Override
    public void doCheckSchema() throws ConfigException {
        BGraphNode[] sources = this.getSources();
        BScaleFactors scaleFactorContainer = this.getScaleFactors();
        BScaleFactor[] factors = (BScaleFactor[])scaleFactorContainer.getChildren(BScaleFactor.class);
        if (sources.length == 0) {
            if (factors.length > 0) {
                String msg = lex.getText("fault.msg.schema.unmatchedfields");
                throw new ConfigException(msg);
            }
            return;
        }
        BGraphNode src = sources[0];
        BSeriesSchema srcSchema = src.getSchema();
        Set<String> fields = this.getScaleInputFields();
        String keyField = srcSchema.getKeyField();
        for (BScaleFactor factor : factors) {
            String fieldName = factor.getInputFieldName();
            if (fieldName.equals(keyField)) continue;
            if (!fields.contains(fieldName)) {
                String msg = lex.getText("fault.msg.schema.invalidField", new Object[]{fieldName});
                throw new ConfigException(msg);
            }
            BTypeSpec fieldType = srcSchema.getFieldType(fieldName);
            if (fieldType.getTypeInfo().is(BINumeric.TYPE)) continue;
            String msg = lex.getText("fault.msg.schema.invalidType", new Object[]{fieldType.toString(), fieldName, TYPE.toString()});
            throw new ConfigException(msg);
        }
    }

    public Set<String> getScaleInputFields() {
        BGraphNode[] sources;
        HashSet<String> fields = new HashSet<String>();
        for (BGraphNode src : sources = this.getSources()) {
            BSeriesSchema nodeSchema = src.getSchema();
            String[] fieldNames = nodeSchema.getFieldNames();
            Collections.addAll(fields, fieldNames);
        }
        return fields;
    }

    public BIcon getIcon() {
        String iconsrc = lex.getText("scale.icon");
        return BIcon.make((BOrd)BOrd.make((String)iconsrc));
    }

    public void changed(Property property, Context context) {
        BStatusSchema status;
        super.changed(property, context);
        if (context != Context.decoding && property.equals(transformInputs) && (status = this.getTransformInputs()).getStatus() == BStatus.ok && !status.getValue().equals("schema")) {
            this.getTransformInputs().setValue("schema");
        }
    }
}

