/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.terminal;

import com.tridium.seriestransform.terminal.BTerminalMap;
import com.tridium.seriestransform.terminal.BTerminalMapping;
import com.tridium.seriestransform.terminal.BTerminalTable;
import java.util.LinkedList;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.exceptions.ConfigException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.BStatusSchema;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="transformOutput", type="BStatusSchema", defaultValue="new BStatusSchema()", flags=14, override=true), @NiagaraProperty(name="mappings", type="BTerminalMap", defaultValue="new BTerminalMap()")})
public class BTerminalNode
extends BGraphNode {
    @Generated
    public static final Property transformOutput = BTerminalNode.newProperty((int)14, (BValue)new BStatusSchema(), null);
    @Generated
    public static final Property mappings = BTerminalNode.newProperty((int)0, (BValue)new BTerminalMap(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTerminalNode.class);

    @Generated
    public BTerminalMap getMappings() {
        return (BTerminalMap)this.get(mappings);
    }

    @Generated
    public void setMappings(BTerminalMap v) {
        this.set(mappings, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] inputs, GraphNodeParams params, BOrd base) throws TransformException {
        LinkedList<BTerminalTable> tables = new LinkedList<BTerminalTable>();
        for (BSeriesTransformTable table : inputs) {
            tables.add(new BTerminalTable(this.getName(), this.getSchema(), this, table));
        }
        return tables.toArray(new BSeriesTransformTable[0]);
    }

    @Override
    public void doCheckSchema() throws ConfigException {
        BGraphNode[] inputSources = this.getSources();
        if (inputSources.length == 0) {
            String msg = lex.getText("fault.msg.schema.nosources");
            throw new ConfigException(msg);
        }
    }

    @Override
    public BSeriesSchema doGetSchema() {
        BSeriesSchema schema;
        BGraphNode[] inputSources = this.getSources();
        if (inputSources.length > 0) {
            BGraphNode src = inputSources[0];
            BSeriesSchema srcSchema = src.getSchema();
            BSeriesSchema copy = (BSeriesSchema)srcSchema.newCopy(true);
            BTerminalMap map = this.getMappings();
            try {
                if (!map.correspondsTo(srcSchema)) {
                    map = new BTerminalMap(srcSchema);
                    this.setMappings(map);
                }
            }
            catch (PermissionException pe) {
                log.warning("Terminal mappings update failed for insufficient permissions: " + pe.getLocalizedMessage());
            }
            BTerminalMapping[] mappings = (BTerminalMapping[])map.getChildren(BTerminalMapping.class);
            if (mappings.length > 0) {
                Property[] reorder = new Property[mappings.length];
                for (int i = 0; i < mappings.length; ++i) {
                    String name = mappings[i].getElementName();
                    reorder[i] = copy.getProperty(name);
                }
                copy.reorder(reorder);
            }
            schema = copy;
        } else {
            schema = new BSeriesSchema();
        }
        return schema;
    }

    public BIcon getIcon() {
        String iconsrc = lex.getText("terminal.icon");
        return BIcon.make((BOrd)BOrd.make((String)iconsrc));
    }
}

