/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.seriestransform.graph;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.seriestransform.NGraphNodeParams;
import com.tridium.seriestransform.NQueryParameters;
import com.tridium.seriestransform.graph.BNodeContainer;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.exceptions.ConfigException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.BStatusSchema;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.seriestransform.graph.QueryParams;
import javax.baja.space.BISpaceNode;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="transformInputs", type="BStatusSchema", defaultValue="new BStatusSchema()", flags=10), @NiagaraProperty(name="transformOutput", type="BStatusSchema", defaultValue="new BStatusSchema()", flags=11), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.DEFAULT", flags=11), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3)})
@NiagaraAction(name="schemaCheck", flags=4)
@NiagaraTopic(name="schemaModified", eventType="BSeriesSchema", flags=4)
public abstract class BGraphNode
extends BComponent
implements BIStatus {
    @Generated
    public static final Property transformInputs = BGraphNode.newProperty((int)10, (BValue)new BStatusSchema(), null);
    @Generated
    public static final Property transformOutput = BGraphNode.newProperty((int)11, (BValue)new BStatusSchema(), null);
    @Generated
    public static final Property status = BGraphNode.newProperty((int)11, (BValue)BStatus.DEFAULT, null);
    @Generated
    public static final Property faultCause = BGraphNode.newProperty((int)3, (String)"", null);
    @Generated
    public static final Action schemaCheck = BGraphNode.newAction((int)4, null);
    @Generated
    public static final Topic schemaModified = BGraphNode.newTopic((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BGraphNode.class);
    public static final Logger log = Logger.getLogger("seriesTransform");
    protected static final Lexicon lex = Lexicon.make(BGraphNode.class);
    protected static final String SCHEMA_FAULT_INVALID_FIELD = "fault.msg.schema.invalidField";
    protected static final String SCHEMA_FAULT_INVALID_TYPE = "fault.msg.schema.invalidType";
    protected static final String SCHEMA_FAULT_UNMATCHED_FIELD = "fault.msg.schema.unmatchedfields";
    protected static final String SCHEMA_FAULT_NO_SOURCES = "fault.msg.schema.nosources";
    private static final String ERR_INVALID_LINK = "graphnode.link.invalidsource";
    private TypeInfo[] illegalChildTypes = Sys.getRegistry().getTypes(TYPE.getTypeInfo());

    @Generated
    public BStatusSchema getTransformInputs() {
        return (BStatusSchema)this.get(transformInputs);
    }

    @Generated
    public void setTransformInputs(BStatusSchema v) {
        this.set(transformInputs, (BValue)v, null);
    }

    @Generated
    public BStatusSchema getTransformOutput() {
        return (BStatusSchema)this.get(transformOutput);
    }

    @Generated
    public void setTransformOutput(BStatusSchema v) {
        this.set(transformOutput, (BValue)v, null);
    }

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public void schemaCheck() {
        this.invoke(schemaCheck, null, null);
    }

    @Generated
    public void fireSchemaModified(BSeriesSchema event) {
        this.fire(schemaModified, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BSeriesTransformTable[] resolve(QueryParams queryArgs, BOrd base) throws TransformException {
        return this.resolve(queryArgs, base, null);
    }

    public final BSeriesTransformTable[] resolve(QueryParams queryArgs, BOrd base, Context cx) throws TransformException {
        if (null == queryArgs) {
            queryArgs = new NQueryParameters();
        }
        BSeriesTransformTable[] resolveSources = this.resolveSources(queryArgs, base, cx);
        GraphNodeParams graphArgs = this.decodeArgs(queryArgs);
        return this.doResolve(resolveSources, graphArgs, base, cx);
    }

    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] inputTables, GraphNodeParams args, BOrd base) throws TransformException {
        return null;
    }

    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] inputTables, GraphNodeParams args, BOrd base, Context cx) throws TransformException {
        return this.doResolve(inputTables, args, base);
    }

    public abstract BSeriesSchema doGetSchema();

    public final BSeriesSchema getSchema() {
        return FoxRpcUtil.doSilentRpc((BISpaceNode)this, (String)"getSchemaRpc", (Object[])new Object[]{new BSeriesSchema()}).orElseGet(this::doGetSchema);
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.fox)}, permissions="r")
    public BSeriesSchema getSchemaRpc(Object arg, Context cx) {
        return this.doGetSchema();
    }

    public abstract void doCheckSchema() throws ConfigException;

    public final void doSchemaCheck() {
        try {
            this.doCheckSchema();
            this.clearFault();
        }
        catch (ConfigException ce) {
            this.markFault(ce.getMessage());
        }
    }

    private GraphNodeParams decodeArgs(QueryParams queryArgs) {
        SlotPath[] paths;
        String namespace = this.getSlotPath().getBody();
        NGraphNodeParams decodedArgs = new NGraphNodeParams(queryArgs);
        for (SlotPath path : paths = queryArgs.getSlotPaths()) {
            String pathArg = path.getBody();
            if (!pathArg.startsWith(namespace)) continue;
            BValue value = queryArgs.get(path);
            String slotName = pathArg.substring(namespace.length() + 1);
            decodedArgs.put(slotName, value);
        }
        return decodedArgs;
    }

    private BSeriesTransformTable[] resolveSources(QueryParams queryArgs, BOrd base, Context cx) throws TransformException {
        BLink[] links;
        LinkedList<BSeriesTransformTable> tables = new LinkedList<BSeriesTransformTable>();
        for (BLink link : links = (BLink[])this.getChildren(BLink.class)) {
            link.activate();
            String sourceSlotName = link.getSourceSlotName();
            BComponent srcComp = link.getSourceComponent();
            BValue bValue = srcComp.get(sourceSlotName);
            if (!(bValue instanceof BStatusSchema) || !(srcComp instanceof BGraphNode)) continue;
            BComponent parent = this.getParent().asComponent();
            BOrd parentOrd = parent.getSlotPathOrd();
            BOrd srcOrd = srcComp.getSlotPathOrd();
            if (srcOrd.equals((Object)parentOrd)) {
                this.resolveCompositedLinks(queryArgs, base, tables, (BNodeContainer)srcComp, cx);
                continue;
            }
            BGraphNode node = (BGraphNode)srcComp;
            BSeriesTransformTable[] resolvedTables = node.resolve(queryArgs, base, cx);
            Collections.addAll(tables, resolvedTables);
        }
        return tables.toArray(new BSeriesTransformTable[0]);
    }

    private void resolveCompositedLinks(QueryParams queryArgs, BOrd base, List<BSeriesTransformTable> tables, BNodeContainer container, Context cx) throws TransformException {
        BLink[] graphLinks;
        for (BLink graphLink : graphLinks = (BLink[])container.getChildren(BLink.class)) {
            if (!graphLink.getTargetSlotName().equals("lnk" + this.getName())) continue;
            graphLink.activate();
            BComponent graphSrcComp = graphLink.getSourceComponent();
            if (!(graphSrcComp instanceof BGraphNode)) continue;
            BGraphNode node = (BGraphNode)graphSrcComp;
            BSeriesTransformTable[] results = node.resolve(queryArgs, base, cx);
            Collections.addAll(tables, results);
        }
    }

    public final BGraphNode[] getSources() {
        BLink[] links;
        LinkedList<BGraphNode> sources = new LinkedList<BGraphNode>();
        for (BLink link : links = this.getLinks()) {
            String sourceSlotName = link.getSourceSlotName();
            if (!sourceSlotName.equals(transformOutput.getName())) continue;
            try {
                link.activate();
                BGraphNode src = (BGraphNode)link.getSourceComponent();
                sources.add(src);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sources.toArray(new BGraphNode[0]);
    }

    public final String[] getSrcFieldNames() {
        BGraphNode[] sources;
        HashSet<String> srcFields = new HashSet<String>();
        for (BGraphNode src : sources = this.getSources()) {
            String[] fieldNames;
            String srcNodeName = src.getName();
            BSeriesSchema nodeSchema = src.getSchema();
            for (String fieldName : fieldNames = nodeSchema.getFieldNames()) {
                String colName = srcNodeName + '.' + fieldName;
                srcFields.add(colName);
            }
        }
        return srcFields.toArray(new String[0]);
    }

    public final void markFault(String fault) {
        this.setStatus(BStatus.fault);
        this.setFaultCause(fault);
    }

    public final void clearFault() {
        this.setStatus(BStatus.ok);
        this.getTransformInputs().setStatus(BStatus.ok);
        this.getTransformOutput().setStatus(BStatus.ok);
        this.setFaultCause("");
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.remove("wiresheet:WebWiresheet");
        list.remove("wiresheet:WireSheet");
        return list;
    }

    public final boolean isChildLegal(BComponent child) {
        TypeInfo[] illegalChildTypes = this.getIllegalChildTypes();
        TypeInfo candidateType = child.getType().getTypeInfo();
        for (TypeInfo illegalChildType : illegalChildTypes) {
            if (candidateType != illegalChildType) continue;
            return false;
        }
        return true;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNodeContainer;
    }

    public final TypeInfo[] getIllegalChildTypes() {
        return this.illegalChildTypes;
    }

    public final void setIllegalChildTypes(TypeInfo[] types) {
        this.illegalChildTypes = types;
    }

    protected final LinkCheck doCheckLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        BValue srcProp;
        Type targetType;
        BValue bValue = this.get(targetSlot.getName());
        if (null != bValue && (targetType = bValue.getType()) == BStatusSchema.TYPE && null != (srcProp = source.get(sourceSlot.getName()))) {
            boolean valid;
            Type sourceType = srcProp.getType();
            String srcName = sourceSlot.getName();
            String targetName = targetSlot.getName();
            boolean bl = valid = targetType == BStatusSchema.TYPE && sourceType == BStatusSchema.TYPE && !srcName.equals(targetName);
            if (!valid || valid && this == source) {
                return LinkCheck.makeInvalid((String)lex.getText(ERR_INVALID_LINK));
            }
        }
        return super.doCheckLink(source, sourceSlot, targetSlot, cx);
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 3: {
                BLink lnk;
                Property property;
                if (!(a instanceof Property) || !(property = (Property)a).getType().equals(BLink.TYPE) || !this.isInputSchemaLink(lnk = (BLink)this.get(property))) break;
                this.checkForSchemaChange();
                break;
            }
            case 4: {
                BLink lnk;
                if (!(b instanceof BLink) || !this.isInputSchemaLink(lnk = (BLink)b)) break;
                this.checkForSchemaChange();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private boolean isInputSchemaLink(BLink link) {
        boolean schemaLink = false;
        String sourceSlotName = link.getSourceSlotName();
        if (sourceSlotName.equals(transformOutput.getName())) {
            schemaLink = true;
        }
        return schemaLink;
    }

    private void checkForSchemaChange() {
        for (BComplex parent = this.getParent(); null != parent; parent = parent.getParent()) {
            if (!(parent instanceof BNodeContainer)) continue;
            ((BNodeContainer)parent).runSchemaCheck();
            break;
        }
    }
}

