/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import com.tridium.snmp.object.BSnmpBooleanObjectExt;
import com.tridium.snmp.object.BSnmpEnumObjectExt;
import com.tridium.snmp.object.BSnmpNumericObjectExt;
import com.tridium.snmp.object.BSnmpObjectExt;
import com.tridium.snmp.object.BSnmpStringObjectExt;
import java.util.ArrayList;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"snmp:SnmpObjectDeviceExt"}, requiredPermissions="r")})
public class BSnmpObjectManager
extends BPointManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BSnmpObjectManager.class);
    static Lexicon lexicon = Lexicon.make(BSnmpObjectManager.class);
    static Lexicon driverLex = Lexicon.make((String)"driver");
    static String lexOut = driverLex.getText("out");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colString = new MgrColumn.ToString(lexOut, 0);
    MgrColumn colOid = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpObjectExt.objectIdentifier}, 0);
    MgrColumn colVarType = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpObjectExt.variableType}, 1);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpObjectExt.enabled}, 3);
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colDescription = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpObjectExt.description}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpObjectExt.conversion}, 3);
    MgrColumn colDeviceValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    MgrColumn colExeResult = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 3);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colString, this.colOid, this.colVarType, this.colEnabled, this.colFacets, this.colConversion, this.colDeviceValue, this.colDescription, this.colExeResult, this.colTuning};

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new SnmpObjectPointModel(this);
    }

    public class SnmpObjectPointModel
    extends PointModel {
        SnmpObjectPointModel(BSnmpObjectManager mgr) {
            super((BPointManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpObjectManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList list = new ArrayList();
            SnmpObjectPointModel.addNumericPointTypes(list, (boolean)true);
            SnmpObjectPointModel.addStringPointTypes(list, (boolean)true);
            SnmpObjectPointModel.addEnumPointTypes(list, (boolean)true);
            SnmpObjectPointModel.addBooleanPointTypes(list, (boolean)true);
            return list.toArray(new MgrTypeInfo[0]);
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BControlPoint pt = (BControlPoint)type.newInstance();
            BFacets deviceFacets = (BFacets)pt.getFacets().newCopy();
            BNullProxyExt ext = new BNullProxyExt();
            if (pt instanceof BBooleanPoint) {
                ext = new BSnmpBooleanObjectExt();
            } else if (pt instanceof BNumericPoint) {
                ext = new BSnmpNumericObjectExt();
            } else if (pt instanceof BStringPoint) {
                ext = new BSnmpStringObjectExt();
            } else if (pt instanceof BEnumPoint) {
                ext = new BSnmpEnumObjectExt();
            }
            ((BProxyExt)ext).setDeviceFacets(deviceFacets);
            pt.setProxyExt((BAbstractProxyExt)ext);
            return pt;
        }
    }
}

