/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.datatypes.BMibListEntry;
import com.tridium.snmp.datatypes.BMibListTable;
import com.tridium.snmp.enums.BSnmpAccessEnum;
import com.tridium.snmp.enums.BSnmpMipEntryTypeEnum;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.mib.OidElement;
import com.tridium.snmp.mib.OidEntry;
import com.tridium.snmp.point.BSnmpBooleanProxyExt;
import com.tridium.snmp.point.BSnmpEnumProxyExt;
import com.tridium.snmp.point.BSnmpNumericProxyExt;
import com.tridium.snmp.point.BSnmpPointDeviceExt;
import com.tridium.snmp.point.BSnmpPointFolder;
import com.tridium.snmp.point.BSnmpProxyExt;
import com.tridium.snmp.point.BSnmpStringProxyExt;
import com.tridium.snmp.table.BSnmpTable;
import com.tridium.snmp.ui.BMibPathDialog;
import com.tridium.snmp.ui.BSnmpAutoMibOptions;
import com.tridium.snmp.ui.BSnmpLocalDeviceMenuAgent;
import com.tridium.snmp.ui.BSnmpPointMgrTable;
import com.tridium.snmp.ui.MibsUtil;
import com.tridium.snmp.ui.OidUtil;
import com.tridium.snmp.ui.SnmpIcons;
import com.tridium.snmp.ui.TableUtil;
import com.tridium.snmp.util.SnmpUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.point.BPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.driver.ui.point.PointState;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;

@NiagaraType(agent={@AgentOn(types={"snmp:SnmpPointDeviceExt", "snmp:SnmpPointFolder"}, requiredPermissions="r")})
public class BSnmpPointManager
extends BPointManager
implements SnmpIcons {
    @Generated
    public static final Type TYPE = Sys.loadType(BSnmpPointManager.class);
    private Mib mib;
    static Lexicon lex = Lexicon.make(BSnmpPointManager.class);
    static String lexOut = Lexicon.make((String)"driver").getText("out");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colString = new MgrColumn.ToString(lexOut, 0);
    MgrColumn colOid = new ObjectIdCol();
    MgrColumn colVarType = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpProxyExt.variableType}, 1);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpProxyExt.enabled}, 3);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpProxyExt.deviceFacets}, 3);
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpProxyExt.conversion}, 3);
    MgrColumn colDeviceValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    MgrColumn colExeResult = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 3);
    MgrColumn colFault = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colString, this.colOid, this.colVarType, this.colEnabled, this.colDeviceFacets, this.colFacets, this.colConversion, this.colDeviceValue, this.colExeResult, this.colTuning, this.colFault};
    MgrColumn dcolName = new MgrColumn.Prop(lex.getText("table.columnTitle.name"), BMibListEntry.entryName, 0);
    MgrColumn dcolOid = new MgrColumn.Prop(lex.getText("table.columnTitle.oid"), BMibListEntry.oid, 0);
    MgrColumn dcolSyntax = new MgrColumn.Prop(lex.getText("table.columnTitle.syntax"), BMibListEntry.objectSyntax, 2);
    MgrColumn dcolType = new VarTypeCol();
    MgrColumn dcolValue = new MgrColumn.Prop(lex.getText("table.columnTitle.value"), BMibListEntry.value, 0);
    MgrColumn dcolDisplayHint = new MgrColumn.Prop(lex.getText("table.columnTitle.displayHint"), BMibListEntry.displayHint, 2);
    MgrColumn dcolAccess = new MgrColumn.Prop(lex.getText("table.columnTitle.access"), BMibListEntry.access, 2);
    MgrColumn dcolStatus = new MgrColumn.Prop(lex.getText("table.columnTitle.status"), BMibListEntry.status, 2);
    MgrColumn dcolElementType = new MgrColumn.Prop(lex.getText("table.columnTitle.elementType"), BMibListEntry.elementType, 2);
    MgrColumn dcolDesc = new MgrColumn.Prop(lex.getText("table.columnTitle.description"), BMibListEntry.desc, 0);
    MgrColumn[] dcols = new MgrColumn[]{this.dcolName, this.dcolOid, this.dcolSyntax, this.dcolType, this.dcolValue, this.dcolDisplayHint, this.dcolAccess, this.dcolStatus, this.dcolElementType, this.dcolDesc};
    BSnmpPointDeviceExt points;
    BSnmpDevice device;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new SnmpPointModel(this);
    }

    protected MgrController makeController() {
        return new SnmpPointController(this);
    }

    protected MgrLearn makeLearn() {
        return new SnmpPointLearn(this);
    }

    protected MgrState makeState() {
        return new SnmpPointState();
    }

    public void doLoadValue(BObject value, Context cx) {
        if (value instanceof BSnmpPointFolder) {
            this.points = (BSnmpPointDeviceExt)((BSnmpPointFolder)value).getDeviceExt();
        } else if (value instanceof BSnmpPointDeviceExt) {
            this.points = (BSnmpPointDeviceExt)value;
        }
        this.device = (BSnmpDevice)this.points.getDevice();
        super.doLoadValue(value, cx);
    }

    public static boolean loadMibCompiler(BAbstractManager manager, BSnmpDevice dev) throws Exception {
        return BSnmpPointManager.loadMibCompiler(manager, dev, new Mibs(), false);
    }

    private static boolean loadMibCompiler(BAbstractManager manager, BSnmpDevice dev, Mibs mibs, boolean checkWalk) throws Exception {
        mibs.mib = dev.getMib();
        if (!BSnmpPointManager.discoveryPopup(manager, mibs, checkWalk)) {
            return false;
        }
        dev.setMib(mibs.mib);
        return true;
    }

    public static Mib createMib(BAbstractManager manager, BSnmpDevice dev) {
        dev.lease();
        String mibSt = dev.getMib();
        File f = new File(mibSt);
        if (!f.exists()) {
            BDialog.error((BWidget)manager, (String)"Error", (Object)"Must have valid mib for device.");
            return null;
        }
        try {
            String[] mibDirs = BSnmpAutoMibOptions.getDefault().getMibDirectories().getArray();
            return MibsUtil.compile(mibDirs, mibSt);
        }
        catch (MibLoaderException e) {
            MibLoaderLog log = e.getLog();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(os);
            log.printTo(ps, true);
            ps.flush();
            BTextEditor te = new BTextEditor();
            te.setText(os.toString());
            log.printTo(ps, false);
            ps.flush();
            BDialog.error((BWidget)manager, (String)lex.getText("errors.createMib"), (Object)new BScrollPane((BWidget)te), (String)os.toString());
        }
        catch (Throwable e) {
            BDialog.error((BWidget)manager, (String)lex.getText("errors.createMib"), (Object)e.toString(), (Throwable)e);
        }
        return null;
    }

    private Mib getMib() {
        if (this.mib == null) {
            this.mib = BSnmpPointManager.createMib((BAbstractManager)this, this.device);
        }
        return this.mib;
    }

    private static boolean discoveryPopup(BAbstractManager manager, Mibs mibs, boolean checkWalk) throws Exception {
        BGridPane mibSelect = new BGridPane(3);
        BTextField mibTf = new BTextField(mibs.mib, 60);
        mibTf.setEditable(false);
        BButton browseBtn = new BButton((Command)new Browse((BWidget)manager.getShell(), mibTf));
        browseBtn.setButtonStyle(BButtonStyle.toolBar);
        mibSelect.add(null, (BValue)new BLabel(lex.getText("pointManager.mib")));
        mibSelect.add(null, (BValue)mibTf);
        mibSelect.add(null, (BValue)browseBtn);
        BGridPane gp = new BGridPane(1);
        gp.add(null, (BValue)mibSelect);
        ToggleCommand walkCommand = new ToggleCommand((BWidget)gp, lex.getText("pointManager.walk"));
        BRadioButton walkOnly = new BRadioButton(walkCommand, true, false);
        if (checkWalk) {
            gp.add(null, (BValue)new BBorderPane((BWidget)walkOnly, BInsets.make((double)7.0)));
        }
        BEdgePane pane = new BEdgePane();
        pane.setBottom((BWidget)new BBorderPane((BWidget)gp));
        int r = BDialog.open((BWidget)manager, (String)lex.getText("pointManager.chooseMibs"), (Object)pane, (int)3, null);
        if (r == 2) {
            return false;
        }
        mibs.mib = mibTf.getText();
        if (checkWalk) {
            mibs.walkMib = walkOnly.getSelected();
        }
        return true;
    }

    private BMibListEntry[] buildEntries(Mib mib) {
        OidElement oidBase = OidUtil.createOidEntries(mib, this.device.snmpNet());
        OidEntry[] oidEntries = oidBase.getOidEntries();
        if (oidEntries == null) {
            return new BMibListEntry[0];
        }
        HashMap<String, OidEntry> map = new HashMap<String, OidEntry>();
        Array a = new Array(BMibListEntry.class, oidEntries.length);
        for (int i = 0; i < oidEntries.length; ++i) {
            try {
                OidEntry e = oidEntries[i];
                BSnmpMipEntryTypeEnum t = e.getElementType();
                if (t.equals((Object)BSnmpMipEntryTypeEnum.trap) || t.equals((Object)BSnmpMipEntryTypeEnum.notification) || map.get(e.getOid()) != null) continue;
                map.put(e.getOid(), e);
                BMibListEntry entry = new BMibListEntry();
                entry.setOid(e.getOid());
                entry.setDisplayHint(e.getDisplayHint());
                entry.setAccess(e.getAccess());
                entry.setEntryName(e.getName());
                entry.setStatus(e.getStatus());
                entry.setObjectSyntax(e.getObjSyntax());
                entry.setElementType(e.getElementType());
                if (e.getDesc() != null) {
                    entry.setDesc(e.getDesc());
                }
                if (e.getVariableType() != null) {
                    entry.setVariableType(e.getVariableType());
                }
                if (e.enumRange != null) {
                    entry.setEnumRange(e.enumRange);
                }
                if (e.range != null) {
                    entry.setConstraint(e.getRangeFacets());
                }
                a.add((Object)entry);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (BMibListEntry[])a.trim();
    }

    static String chooseMibFiles(BWidget owner) throws Exception {
        BOrd oa;
        BSnmpAutoMibOptions opts = BSnmpAutoMibOptions.getDefault();
        BFileChooser fileChooser = BFileChooser.makeOpen((BWidget)owner);
        fileChooser.setTitle(lex.getText("pointManager.chooseMibs"));
        String lastFile = opts.getLastMibFile();
        if (lastFile.length() > 0) {
            File f = new File(lastFile);
            File dir = f.getParentFile();
            BOrd o = BOrd.make((String)("file:/" + dir.getAbsolutePath().replace('\\', '/')));
            fileChooser.setCurrentDirectory(o);
        }
        if ((oa = fileChooser.show()) == null) {
            return null;
        }
        String mibFile = SnmpUtil.ordToAbsolutePath((BOrd)oa);
        opts.setLastMibFile(mibFile);
        opts.save();
        return mibFile;
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (event.getId() == 5 && event.getSourceComponent() == this.points && BSnmpPointDeviceExt.mibWalkedEvent == event.getSlot()) {
            this.updateDiscoveryRows((BComponent)event.getValue());
        } else {
            super.handleComponentEvent(event);
        }
    }

    private void updateDiscoveryRows(BComponent config) {
        BMibListTable table = (BMibListTable)config;
        ((SnmpPointLearn)this.getLearn()).updateTable(table.getPointList());
    }

    static class VarTypeCol
    extends MgrColumn {
        public VarTypeCol() {
            super(lex.getText("table.columnTitle.type"), 2);
        }

        public Object get(Object tgt) {
            BMibListEntry mle = (BMibListEntry)tgt;
            if (mle.getAccess() == BSnmpAccessEnum.notAccessible) {
                return "";
            }
            return mle.getVariableType();
        }
    }

    static class ObjectIdCol
    extends MgrColumn {
        static Property[] props = new Property[]{BControlPoint.proxyExt, BSnmpProxyExt.objectIdentifier};

        public ObjectIdCol() {
            super(lex.getText("exportManager.objectIdentifier"), 1);
        }

        public Object get(Object tgt) {
            if (tgt instanceof BControlPoint) {
                return ((BSnmpProxyExt)((BControlPoint)tgt).getProxyExt()).getObjectIdentifier();
            }
            if (tgt instanceof BSnmpTable) {
                return ((BSnmpTable)tgt).getObjectIdentifier();
            }
            return "";
        }

        public BValue load(MgrEditRow row) throws Exception {
            return BString.make((String)((String)this.get(row.getTarget())));
        }

        public void save(MgrEditRow row, BValue value, Context cx) throws Exception {
            Object obj = row.getDiscovery();
            BMibListEntry entry = (BMibListEntry)obj;
            BComponent tgt = row.getTarget();
            if (tgt instanceof BControlPoint) {
                ((BSnmpProxyExt)((BControlPoint)tgt).getProxyExt()).setObjectIdentifier(((BString)value).toString());
                if (entry != null && entry.getDisplayHint() != null) {
                    ((BSnmpProxyExt)((BControlPoint)tgt).getProxyExt()).setDisplayHint(entry.getDisplayHint());
                }
            } else if (tgt instanceof BSnmpTable) {
                ((BSnmpTable)tgt).setObjectIdentifier(((BString)value).toString());
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            return ObjectIdCol.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])props);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            ObjectIdCol.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])props);
        }
    }

    static class Browse
    extends Command {
        BTextField txt;

        Browse(BWidget owner, BTextField t) {
            super(owner, "");
            this.txt = t;
        }

        public CommandArtifact doInvoke() {
            BOrd ord;
            BFileChooser chooser = BFileChooser.makeOpen((BWidget)this.getShell());
            String fname = this.txt.getText();
            if ((fname = fname.replace('\\', '/')).lastIndexOf(47) > 0) {
                chooser.setCurrentDirectory(SnmpUtil.absolutePathToDirOrd((String)fname));
            }
            if ((ord = chooser.show()) != null) {
                this.txt.setText(SnmpUtil.ordToAbsolutePath((BOrd)ord));
            }
            return null;
        }

        public BImage getIcon() {
            return BSnmpLocalDeviceMenuAgent.browseIcon;
        }
    }

    private static class Mibs {
        String mib;
        boolean walkMib = false;

        private Mibs() {
        }
    }

    class AddTable
    extends MgrController.MgrCommand {
        private BSnmpPointManager manager;

        AddTable(BSnmpPointManager owner) {
            super((BWidget)owner, lex, "commands.addTable");
            this.manager = owner;
        }

        public CommandArtifact doInvoke() throws Exception {
            SnmpPointLearn learn = (SnmpPointLearn)this.manager.getLearn();
            if (learn == null) {
                return null;
            }
            BComponent tgt = learn.target;
            Object[] dis = learn.getTable().getSelectedObjects();
            for (int i = 0; i < dis.length; ++i) {
                BMibListEntry entry = (BMibListEntry)dis[i];
                if (!entry.getElementType().equals((Object)BSnmpMipEntryTypeEnum.sequence)) continue;
                Mib mib = BSnmpPointManager.this.getMib();
                if (mib == null) {
                    return null;
                }
                BSnmpTable snmpTbl = TableUtil.makeSnmpTable(entry.getOid(), mib);
                tgt.add(SlotPath.escape((String)entry.getEntryName()), (BValue)snmpTbl);
            }
            return null;
        }
    }

    class ConfigAutoMibs
    extends MgrController.MgrCommand {
        private BSnmpPointManager manager;

        ConfigAutoMibs(BSnmpPointManager owner) {
            super((BWidget)owner, lex.getText("mibPathDialog.command.label"));
            this.manager = owner;
        }

        public CommandArtifact doInvoke() throws Exception {
            BMibPathDialog dlg = new BMibPathDialog((BAbstractManager)this.manager);
            dlg.open();
            return null;
        }
    }

    class SnmpPointController
    extends PointController {
        private MgrController.MgrCommand configAutoMibs;
        private MgrController.MgrCommand addTable;

        SnmpPointController(BSnmpPointManager mgr) {
            super((BPointManager)mgr);
            this.configAutoMibs = new ConfigAutoMibs(mgr);
            this.addTable = new AddTable(mgr);
            if (mgr.isLearnable()) {
                this.configAutoMibs.setFlags(1);
            }
            this.addTable.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newFolder, this.allDescendants, this.newCommand, this.edit, this.learnMode, this.discover, this.add, this.quickAdd, this.addTable, this.match, this.quickMatch, this.configAutoMibs};
        }

        public void updateCommands() {
            super.updateCommands();
            SnmpPointLearn learn = (SnmpPointLearn)this.getManager().getLearn();
            if (learn == null || learn.getTable() == null) {
                return;
            }
            Object[] sel = learn.getTable().getSelectedObjects();
            boolean enAddTab = this.learnMode.isSelected() && sel.length == 1 && sel[0] instanceof BMibListEntry && ((BMibListEntry)sel[0]).getElementType().equals((Object)BSnmpMipEntryTypeEnum.sequence);
            this.addTable.setEnabled(enAddTab);
            boolean enAdd = this.learnMode.isSelected() && sel.length > 0;
            for (int i = 0; i < sel.length; ++i) {
                if (((BMibListEntry)sel[i]).getElementType().isAccessibleValue()) continue;
                enAdd = false;
            }
            this.add.setEnabled(enAdd);
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            BComponent comp = this.getTable().getComponentAt(row);
            BWbShell shell = this.getManager().getWbShell();
            if (comp != null && comp.getType().is(BSnmpTable.TYPE) && shell != null) {
                shell.hyperlink(new HyperlinkInfo(comp.getNavOrd(), (BInputEvent)event));
                return;
            }
            super.cellDoubleClicked(table, event, row, col);
        }

        public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand command) {
            if (command == this.discover) {
                return new MgrController.IMgrCommand[]{this.configAutoMibs};
            }
            return super.getDropDownCommands(command);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            Mibs mibs = new Mibs();
            BSnmpPointManager mgr = (BSnmpPointManager)this.getManager();
            if (!BSnmpPointManager.loadMibCompiler((BAbstractManager)mgr, BSnmpPointManager.this.device, mibs, true)) {
                return null;
            }
            BSnmpPointManager.this.mib = BSnmpPointManager.createMib((BAbstractManager)mgr, BSnmpPointManager.this.device);
            if (BSnmpPointManager.this.mib != null) {
                BMibListEntry[] mibCells = BSnmpPointManager.this.buildEntries(BSnmpPointManager.this.mib);
                ((SnmpPointLearn)BSnmpPointManager.this.getLearn()).updateTable(mibCells);
                if (mibs.walkMib) {
                    BSnmpPointManager.this.getLearn().setJob(BSnmpPointManager.this.device.walkMib(new BMibListTable(mibCells)));
                }
            }
            return super.doDiscover(cx);
        }

        protected CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            MgrEdit edit = new MgrEdit(this.getManager(), this.add.getLabel());
            for (int i = 0; i < discovery.length; ++i) {
                Object dis = discovery[i];
                BMibListEntry entry = (BMibListEntry)dis;
                if (entry.hasChildren()) {
                    BMibListEntry[] entries = entry.getChildren();
                    for (int j = 0; j < entries.length; ++j) {
                        MgrTypeInfo[] types = this.getManager().getLearn().toTypes((Object)entries[j]);
                        if (types == null || types.length == 0) continue;
                        MgrEditRow row = edit.addRow((Object)entries[j], types);
                        this.getManager().getLearn().toRow((Object)entries[j], row);
                    }
                    continue;
                }
                MgrTypeInfo[] types = this.getManager().getLearn().toTypes(dis);
                if (types == null || types.length == 0) continue;
                MgrEditRow row = edit.addRow(dis, types);
                this.getManager().getLearn().toRow(dis, row);
            }
            return edit.invoke(cx);
        }
    }

    class SnmpPointState
    extends PointState {
        BMibListEntry[] lastLearn;
        BSnmpDevice dev;

        SnmpPointState() {
        }

        protected void saveForType(BAbstractManager m) {
            super.saveForType(m);
            BSnmpPointManager manager = (BSnmpPointManager)m;
            SnmpPointLearn learn = (SnmpPointLearn)manager.getLearn();
            this.lastLearn = learn.lastLearn;
            this.dev = manager.device;
        }

        protected void restoreForType(BAbstractManager m) {
            super.restoreForType(m);
            BSnmpPointManager manager = (BSnmpPointManager)m;
            SnmpPointLearn learn = (SnmpPointLearn)manager.getLearn();
            if (this.lastLearn != null && this.dev != null && this.dev.equals((Object)manager.device)) {
                learn.updateTable(this.lastLearn);
            }
        }
    }

    class SnmpPointLearn
    extends MgrLearn {
        BComponent target;
        BMibListEntry[] lastLearn;

        SnmpPointLearn(BSnmpPointManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpPointManager.this.dcols;
        }

        public boolean isDepthExpandable(int depth) {
            return true;
        }

        public boolean hasChildren(Object dis) {
            return ((BMibListEntry)dis).hasChildren();
        }

        public Object[] getChildren(Object dis) {
            return ((BMibListEntry)dis).getChildren();
        }

        public boolean isMatchable(Object dis, BComponent db) {
            if (!(db instanceof BControlPoint)) {
                return false;
            }
            BMibListEntry entry = (BMibListEntry)dis;
            BSnmpMipEntryTypeEnum elementType = entry.getElementType();
            if (!elementType.isAccessibleValue()) {
                return false;
            }
            boolean readonlyEntry = entry.getAccess().equals((Object)BSnmpAccessEnum.readOnly);
            BControlPoint pt = (BControlPoint)db;
            return !pt.isWritablePoint() || !readonlyEntry;
        }

        public BImage getIcon(Object dis) {
            BMibListEntry entry = (BMibListEntry)dis;
            if (entry.getAccess().equals((Object)BSnmpAccessEnum.notAccessible)) {
                return SnmpIcons.snmpNotAccessibleIcon;
            }
            if (entry.getElementType().equals((Object)BSnmpMipEntryTypeEnum.sequenceElement)) {
                return SnmpIcons.snmpSequenceElementIcon;
            }
            String objSyn = entry.getObjectSyntax();
            if (objSyn.equalsIgnoreCase("TruthValue")) {
                return SnmpIcons.snmpBooleanObjectIcon;
            }
            if (objSyn.equalsIgnoreCase("INTEGER") && entry.hasEnumRange()) {
                return SnmpIcons.snmpEnumObjectIcon;
            }
            if (entry.getVariableType().isNumeric()) {
                return SnmpIcons.snmpNumericObjectIcon;
            }
            return SnmpIcons.snmpStringObjectIcon;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            boolean includeWritables;
            ArrayList list = new ArrayList();
            BMibListEntry entry = (BMibListEntry)dis;
            String objSyn = entry.getObjectSyntax();
            BSnmpMipEntryTypeEnum elementType = entry.getElementType();
            if (!elementType.isAccessibleValue()) {
                return new MgrTypeInfo[0];
            }
            boolean bl = includeWritables = !entry.getAccess().equals((Object)BSnmpAccessEnum.readOnly);
            if (objSyn.equalsIgnoreCase("TruthValue")) {
                PointModel.addBooleanPointTypes(list, (boolean)includeWritables);
                PointModel.addNumericPointTypes(list, (boolean)includeWritables);
                PointModel.addStringPointTypes(list, (boolean)includeWritables);
            } else if (objSyn.equalsIgnoreCase("INTEGER") && entry.hasEnumRange()) {
                PointModel.addEnumPointTypes(list, (boolean)includeWritables);
                if (entry.getEnumRange().getOrdinals().length == 2) {
                    PointModel.addBooleanPointTypes(list, (boolean)includeWritables);
                }
                PointModel.addStringPointTypes(list, (boolean)includeWritables);
            } else if (entry.getVariableType().isNumeric()) {
                PointModel.addNumericPointTypes(list, (boolean)includeWritables);
                PointModel.addStringPointTypes(list, (boolean)includeWritables);
                PointModel.addBooleanPointTypes(list, (boolean)includeWritables);
                PointModel.addEnumPointTypes(list, (boolean)includeWritables);
            } else {
                PointModel.addStringPointTypes(list, (boolean)includeWritables);
                PointModel.addNumericPointTypes(list, (boolean)includeWritables);
                PointModel.addBooleanPointTypes(list, (boolean)includeWritables);
                PointModel.addEnumPointTypes(list, (boolean)includeWritables);
            }
            return list.toArray(new MgrTypeInfo[0]);
        }

        public void toRow(Object discovery, MgrEditRow row) throws Exception {
            BMibListEntry entry = (BMibListEntry)discovery;
            BControlPoint dbPoint = (BControlPoint)row.getTarget();
            row.setDefaultName(SlotPath.escape((String)entry.getEntryName()));
            row.setCell(BSnmpPointManager.this.colOid, (BValue)BString.make((String)entry.getOid()));
            BSnmpVariableTypeEnum typ = entry.getVariableType();
            row.setCell(BSnmpPointManager.this.colVarType, (BValue)typ);
            BFacets newFacets = dbPoint.getFacets();
            if (entry.hasEnumRange()) {
                BEnumRange er;
                int[] ords;
                boolean isBool;
                newFacets = BFacets.make((BFacets)newFacets, (BFacets)BFacets.makeEnum((BEnumRange)entry.getEnumRange()));
                String typNam = row.getType().getDisplayName();
                boolean bl = isBool = typNam.indexOf("Boolean") >= 0;
                if (isBool && entry.hasEnumRange() && (ords = (er = entry.getEnumRange()).getOrdinals()).length == 2) {
                    newFacets = BFacets.make((BFacets)newFacets, (BFacets)BFacets.makeBoolean((String)er.getTag(ords[0]), (String)er.getTag(ords[1])));
                }
            } else if (entry.getConstraint().getFacet("min") != null) {
                newFacets = BFacets.make((BFacets)newFacets, (BFacets)entry.getConstraint());
            }
            BSnmpProxyExt.adjustFacets((BFacets)newFacets, (BSnmpVariableTypeEnum)typ);
            row.setCell(BSnmpPointManager.this.colDeviceFacets, (BValue)newFacets);
            row.setCell(BSnmpPointManager.this.colFacets, (BValue)newFacets);
        }

        public boolean isExisting(Object dis, BComponent comp) {
            BMibListEntry entry = (BMibListEntry)dis;
            if (comp instanceof BControlPoint) {
                BControlPoint pt = (BControlPoint)comp;
                BSnmpProxyExt ext = (BSnmpProxyExt)pt.getProxyExt();
                return ext.getObjectIdentifier().equals(entry.getOid());
            }
            return false;
        }

        public void updateTable(BMibListEntry[] table) {
            this.lastLearn = table;
            this.updateRoots(table);
        }

        public void load(BComponent target) {
            this.target = target;
        }
    }

    class SnmpPointModel
    extends PointModel {
        SnmpPointModel(BSnmpPointManager mgr) {
            super((BPointManager)mgr);
        }

        protected BMgrTable makeTable() {
            return new BSnmpPointMgrTable((MgrModel)this);
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BControlPoint.TYPE, BPointFolder.TYPE, BSnmpTable.TYPE};
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpPointManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList list = new ArrayList();
            SnmpPointModel.addBooleanPointTypes(list, (boolean)true);
            SnmpPointModel.addNumericPointTypes(list, (boolean)true);
            SnmpPointModel.addStringPointTypes(list, (boolean)true);
            SnmpPointModel.addEnumPointTypes(list, (boolean)true);
            return list.toArray(new MgrTypeInfo[0]);
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BControlPoint pt = (BControlPoint)type.newInstance();
            BFacets deviceFacets = (BFacets)pt.getFacets().newCopy();
            BNullProxyExt ext = new BNullProxyExt();
            if (pt instanceof BBooleanPoint) {
                ext = new BSnmpBooleanProxyExt();
                ((BProxyExt)ext).setDeviceFacets(deviceFacets);
            } else if (pt instanceof BNumericPoint) {
                ext = new BSnmpNumericProxyExt();
                ((BProxyExt)ext).setDeviceFacets(deviceFacets);
            } else if (pt instanceof BEnumPoint) {
                ext = new BSnmpEnumProxyExt();
                ((BProxyExt)ext).setDeviceFacets(deviceFacets);
            } else if (pt instanceof BStringPoint) {
                ext = new BSnmpStringProxyExt();
                ((BProxyExt)ext).setDeviceFacets(deviceFacets);
            }
            pt.setProxyExt((BAbstractProxyExt)ext);
            return pt;
        }
    }
}

