/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;

public class MibsUtil {
    public static Mib compile(String[] mibDirs, String mib) throws Exception {
        MibLoader ml = new MibLoader();
        File d = new File(mib);
        ml.addDir(d.getParentFile());
        if (mibDirs != null) {
            for (int i = 0; i < mibDirs.length; ++i) {
                ml.addDir(new File(mibDirs[i]));
            }
        }
        Mib m = ml.load(d);
        return m;
    }

    public static void main(String[] args) {
        File d;
        String fileName = args[0];
        boolean verbose = false;
        if (args.length > 1 && args[1].startsWith("/v")) {
            verbose = true;
        }
        if ((d = new File(fileName)).isDirectory()) {
            MibsUtil.testDir(d, verbose);
        } else {
            MibsUtil.testFile(d, verbose);
        }
    }

    private static void testDir(File dir, boolean v) {
        FilenameFilter ff = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.endsWith("zip");
            }
        };
        System.out.println("\nprocessing " + dir.getAbsolutePath() + "\n");
        File[] fa = dir.listFiles(ff);
        for (int i = 0; i < fa.length; ++i) {
            if (fa[i].isDirectory()) {
                MibsUtil.testDir(fa[i], v);
                continue;
            }
            MibsUtil.testFile(fa[i], v);
        }
    }

    private static void testFile(File f, boolean v) {
        try {
            MibsUtil.compile(null, f.getAbsolutePath());
            if (v) {
                System.out.println("compiled " + f.getAbsolutePath());
            }
        }
        catch (MibLoaderException e) {
            System.out.println("\nException in " + f.getAbsolutePath());
            MibLoaderLog log = e.getLog();
            Iterator it = log.entries();
            while (it.hasNext()) {
                MibLoaderLog.LogEntry le = (MibLoaderLog.LogEntry)it.next();
                if (!le.isError()) continue;
                System.out.println(le.getMessage() + " " + le.getLineNumber() + ":" + le.getColumnNumber());
            }
            System.out.println();
        }
        catch (Throwable e) {
            System.out.println("Exception in " + f.getAbsolutePath());
            e.printStackTrace();
        }
    }
}

