/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import obix.Obj;

public abstract class Editor
extends JPanel {
    ArrayList<Listener> listeners = new ArrayList();
    boolean editable = true;
    boolean suppressChanged = false;

    public Editor() {
        super(new BorderLayout());
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setEditable(boolean editable) {
        if (this.editable == editable) {
            return;
        }
        this.editable = editable;
        this.doSetEditable(editable);
    }

    public final void load(Obj obj) {
        this.suppressChanged = true;
        try {
            this.doLoad(obj);
        }
        finally {
            this.suppressChanged = false;
        }
    }

    public final void save(Obj obj) throws Exception {
        this.doSave(obj);
    }

    protected abstract void doSetEditable(boolean var1);

    protected abstract void doLoad(Obj var1);

    protected abstract void doSave(Obj var1) throws Exception;

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void fireChanged() {
        if (this.suppressChanged) {
            return;
        }
        Listener[] listeners = this.listeners.toArray(new Listener[0]);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].changed(this);
        }
    }

    public void registerForChanged(AbstractButton button) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.fireChanged();
            }
        });
    }

    public void registerForChanged(JTextComponent text) {
        text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                Editor.this.fireChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Editor.this.fireChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Editor.this.fireChanged();
            }
        });
    }

    public void registerForChanged(JComboBox<?> combo) {
        this.registerForChanged((JTextComponent)combo.getEditor().getEditorComponent());
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Editor.this.fireChanged();
            }
        });
    }

    public static interface Listener {
        public void changed(Editor var1);
    }
}

