/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import obix.ui.UiSession;

public class HighlightedImageFactory
extends RGBImageFilter {
    static final HighlightedImageFactory filter = new HighlightedImageFactory();
    static final Component component = new Component(){};
    static final MediaTracker tracker = new MediaTracker(component);
    protected float[] hsb = new float[3];
    protected int[][] pixels;
    protected int width;
    protected int height;

    public static Icon convert(Icon icon) {
        if (icon instanceof ImageIcon) {
            return new ImageIcon(HighlightedImageFactory.convert(((ImageIcon)icon).getImage()));
        }
        if (icon instanceof UiSession.RemoteIcon) {
            return new ImageIcon(HighlightedImageFactory.convert(((UiSession.RemoteIcon)icon).image));
        }
        return icon;
    }

    public static synchronized Image convert(Image colorImage) {
        FilteredImageSource src = new FilteredImageSource(colorImage.getSource(), filter);
        Image dirtyImage = component.createImage(src);
        tracker.addImage(dirtyImage, 0);
        try {
            tracker.waitForID(0, 0L);
        }
        catch (InterruptedException e) {
            System.out.println("DirtyImageFactory.convert -> interrupted");
        }
        tracker.removeImage(dirtyImage, 0);
        return dirtyImage;
    }

    private HighlightedImageFactory() {
        this.canFilterIndexColorModel = false;
    }

    @Override
    public void setDimensions(int width, int height) {
        super.setDimensions(width, height);
        this.pixels = new int[width][height];
        this.width = width;
        this.height = height;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int alpha = rgb >> 24 & 0xFF;
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        float brightness = (float)(red + green + blue) / 3.0f / 255.0f;
        this.hsb[0] = 0.5f;
        this.hsb[1] = 1.0f - 1.0f / brightness;
        this.hsb[2] = brightness;
        int rgbPost = 0;
        rgbPost = alpha == 0 ? 0xFFFFFF : ((double)brightness > 0.1 ? Color.HSBtoRGB(this.hsb[0], this.hsb[1], this.hsb[2]) : -65536);
        this.pixels[x][y] = rgbPost;
        return rgbPost;
    }
}

