/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import obix.ui.HyperlinkInfo;
import obix.ui.Shell;

public class Locator
extends JComboBox<String> {
    public final Shell shell;
    boolean locked;

    public Locator(Shell shell) {
        this.shell = shell;
        this.setEditable(true);
        this.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                Locator.this.editorKeyPressed(event);
            }
        });
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                Locator.this.itemChanged(event);
            }
        });
    }

    void update(String uri) {
        this.locked = true;
        this.getEditor().setItem(uri);
        if (this.getItemCount() > 20) {
            this.removeItemAt(this.getItemCount() - 1);
        }
        this.insertItemAt(uri, 0);
        this.setSelectedIndex(0);
        this.locked = false;
    }

    void editorKeyPressed(KeyEvent event) {
        if (event.getKeyCode() == 10) {
            this.handleEnter();
            event.consume();
        }
    }

    void handleEnter() {
        String uri = "" + this.getEditor().getItem();
        this.shell.hyperlink(new HyperlinkInfo(uri));
    }

    void itemChanged(ItemEvent event) {
        if (this.locked) {
            return;
        }
        String uri = "" + this.getSelectedItem();
        if (!uri.equals(this.shell.uri())) {
            this.shell.hyperlink(uri);
        }
    }
}

