/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import obix.Uri;
import obix.ui.Commands;
import obix.ui.History;
import obix.ui.HyperlinkInfo;
import obix.ui.Locator;
import obix.ui.Pane;
import obix.ui.Tree;
import obix.ui.UiSession;
import obix.ui.Utils;
import obix.ui.View;
import obix.ui.ViewPane;

public class Shell
extends JFrame {
    public final Commands commands = new Commands(this);
    public final Locator locator = new Locator(this);
    public final History history = new History();
    public static Shell theShell;
    String uri;
    ViewPane views;
    JLabel status = new JLabel(" ");
    JSplitPane splitter = new JSplitPane(1);
    Tree tree = new Tree(this);

    public Shell() {
        super("Obix Spy");
        this.setIconImage(Utils.img("x16/obix.png"));
        this.enableEvents(64L);
        JPanel bar = new JPanel(new BorderLayout());
        bar.add((Component)this.commands.makeToolBar(), "West");
        bar.add((Component)this.locator, "Center");
        this.splitter.setDividerLocation(180);
        this.splitter.setLeftComponent(new JScrollPane(this.tree));
        this.splitter.setRightComponent(new JLabel("content"));
        this.setJMenuBar(this.commands.makeMenuBar());
        this.getContentPane().add((Component)bar, "North");
        this.getContentPane().add((Component)this.splitter, "Center");
        this.getContentPane().add((Component)new Pane(this.status, 2), "South");
        new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Shell.this.animate();
            }
        }).start();
    }

    public String uri() {
        return this.uri;
    }

    public View activeView() {
        return this.views.activeView();
    }

    public void hyperlink(String uri) {
        this.hyperlink(new HyperlinkInfo(uri));
    }

    public void hyperlink(Uri uri) {
        this.hyperlink(new HyperlinkInfo(uri.toString()));
    }

    public void hyperlink(HyperlinkInfo hinfo) {
        try {
            hinfo.hyperlink(this);
            this.uri = hinfo.uriStr;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refresh() {
        this.hyperlink(this.uri());
    }

    public void status(String msg) {
        if (msg == null || msg.length() == 0) {
            msg = " ";
        }
        this.status.setText(msg);
    }

    public void animate() {
        if (this.views != null) {
            this.views.activeView().animate();
        }
    }

    void setViewPane(ViewPane newViews) {
        ViewPane oldViews = this.views;
        if (oldViews != null) {
            this.splitter.remove(oldViews);
        }
        if (oldViews != null) {
            newViews.syncFrom(oldViews);
        }
        this.views = newViews;
        int oldPos = this.splitter.getDividerLocation();
        this.splitter.setRightComponent(newViews);
        this.splitter.setDividerLocation(oldPos);
        this.invalidate();
        this.validate();
    }

    public void savePrefs() {
        try {
            Rectangle b = this.getBounds();
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            prefs.putInt("shell.x", b.x);
            prefs.putInt("shell.y", b.y);
            prefs.putInt("shell.w", b.width);
            prefs.putInt("shell.h", b.height);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void loadPrefs() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            int x = prefs.getInt("shell.x", 50);
            int y = prefs.getInt("shell.y", 50);
            int w = prefs.getInt("shell.w", 500);
            int h = prefs.getInt("shell.h", 400);
            this.setBounds(x, y, w, h);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void sessionCreated(UiSession session) {
        this.tree.sessionCreated(session);
    }

    @Override
    public void processWindowEvent(WindowEvent event) {
        if (event.getID() == 201) {
            this.commands.exit.invoke();
        }
    }

    public static void main(String[] args) {
        String uri = args.length > 0 ? args[0] : "spy:splash";
        Utils.initDefaults();
        Shell shell = theShell = new Shell();
        shell.loadPrefs();
        shell.hyperlink(uri);
        shell.setVisible(true);
    }
}

