/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.hx.BHxWebWidget;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.schedule.BNiagaraScheduleDeviceExt;
import com.tridium.nd.sysdef.SysDefException;
import com.tridium.orion.BIMappable;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.accessDriver.BAccessInputOutputModule;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BBase2ReaderModule;
import com.tridiumx.accessDriver.BRemote2ReaderModule;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.history.BBadgeSwipeRecord;
import com.tridiumx.entsec.orionTools.BTenantFilterOptions;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.photoID.video.BPhotoIDCamera;
import com.tridiumx.entsec.photoID.video.BPhotoIDViewerComponent;
import com.tridiumx.entsec.securityUtil.BActivityMonitor;
import com.tridiumx.entsec.securityUtil.BPlatformSetup;
import com.tridiumx.entsec.securityUtil.alarm.BPopupOptions;
import com.tridiumx.entsec.securityUtil.alarm.BSecurityAlarmConsoleOptions;
import com.tridiumx.entsec.securityUtil.orion.BSecurityHistoryConsolidator;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import com.tridiumx.entsec.user.BIEntsecProfile;
import com.tridiumx.entsecHx.AutoLogoff;
import com.tridiumx.entsecHx.BHxPxWbWrapper;
import com.tridiumx.entsecHx.NavBar;
import com.tridiumx.entsecHx.SessionAlarmStatus;
import com.tridiumx.entsecHx.help.HelpCommand;
import com.tridiumx.entsecHx.orionHx.BHxDynamicTableConfig;
import com.tridiumx.entsecHx.orionToolsHx.BHxTenantFilterFE;
import com.tridiumx.entsecHx.orionToolsHx.TenantFilterCommand;
import com.tridiumx.entsecHx.securityUtilHx.HxLocalizableExceptionTranslator;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import com.tridiumx.guidedTour.GuidedTour;
import com.tridiumx.guidedTour.IGuidedTourProfile;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.driver.BDriverContainer;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.hx.BHxProfile;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.rdb.BRdbmsNetwork;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.security.BIProtected;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BServiceContainer;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;

@NiagaraType
@NiagaraSingleton
public class BHxAccessProfile
extends BHxProfile
implements BIEntsecProfile,
IGuidedTourProfile {
    @Generated
    public static final BHxAccessProfile INSTANCE = new BHxAccessProfile();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxAccessProfile.class);
    public static final BImage POWERED = BImage.make((BIcon)BIcon.make((String)"module://entsec/rc/poweredByNiagara.png"));
    public static final BImage HEADER_TRANSITION = BImage.make((BIcon)BIcon.make((String)"module://entsec/rc/HeaderTransition.png"));
    public static final BOrd HEADER_RIGHT = BOrd.make((String)"module://entsec/rc/HeaderRight.png");
    public static final TypeInfo wrapper = BTypeSpec.make((String)"entsecHx:HxPxWbWrapper").getTypeInfo();
    public static final BInsets insets = BInsets.make((double)160.0, (double)11.0, (double)11.0, (double)11.0);
    protected static final LexiconModule lex = LexiconModule.make((String)Sys.getModuleForClass(BHxAccessProfile.class).getModuleName());
    private static final TypeInfo widgetType = BHxAccessProfile.typeInfo("bajaui:Widget");
    private static final TypeInfo hxViewType = BHxAccessProfile.typeInfo("hx:HxView");
    private static final TypeInfo hxPxWbViewType = BHxAccessProfile.typeInfo("hx:HxPxWbView");
    private static final String[] IEUSERAGENTCOMMENTS = new String[]{"Trident/7.0"};
    private static final String BROWSER_PRODUCT_NAME = "Mozilla";
    private static boolean disconnected = false;
    public Command logout;
    public SmartCommand help;
    public SmartCommand newWindow;
    public TenantFilterCommand tenantFilterCommand;
    public NavBar navBar = new NavBar();
    public AutoLogoff autoLogoff = new AutoLogoff();

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxAccessProfile() {
        this.logout = new Logout(null);
        this.registerEvent((Event)this.logout);
        this.help = new HelpCommand(null);
        this.registerEvent((Event)this.help);
        this.tenantFilterCommand = new TenantFilterCommand(null);
        this.registerEvent((Event)this.tenantFilterCommand);
        this.newWindow = new NewWindow(null);
        this.registerEvent((Event)this.newWindow);
    }

    public static void fixAppletHeight(String appletParentId, int viewTitleHeight, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        SmartCommand.tryException((HxOp)op);
        out.w((Object)("var height = hx.getScreenHeight() - " + viewTitleHeight + " - entsecHx.getProfileHeight();"));
        out.w((Object)("$$('" + appletParentId + "').firstChild.style.height='0px';"));
        out.w((Object)("$$('" + appletParentId + "').parentElement.parentElement.style.height='0px';"));
        out.w((Object)("$$('" + appletParentId + "').parentElement.style.height='0px';"));
        out.w((Object)("$$('" + appletParentId + "').style.height='0px';"));
        SmartCommand.catchException((HxOp)op);
    }

    public static void hideApplet(String appletParentId, boolean hidden, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        String value = "none";
        if (!hidden) {
            value = "";
        }
        SmartCommand.tryException((HxOp)op);
        String quote = "'";
        HxUtil.getOuterQuote((HxOp)op);
        out.w((Object)("$$(" + quote + HxUtil.escapeJsStringLiteral((String)appletParentId) + quote + ").firstChild.style.display='" + HxUtil.escapeJsStringLiteral((String)value) + "';"));
        SmartCommand.catchException((HxOp)op);
    }

    public static boolean compareIEUserAgentHeader(String[] userAgentComments, boolean isUserAgentIE, String productName) {
        boolean isIE = false;
        List<String> userAgentCommentsFromOP = Arrays.asList(userAgentComments);
        List<String> userAgentsCommentForIE = Arrays.asList(IEUSERAGENTCOMMENTS);
        if (isUserAgentIE || productName.startsWith(BROWSER_PRODUCT_NAME) && userAgentCommentsFromOP.containsAll(userAgentsCommentForIE)) {
            isIE = true;
        }
        return isIE;
    }

    static TypeInfo typeInfo(String typeSpec) {
        try {
            return Sys.getRegistry().getType(typeSpec);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static void disconnect(HxOp op) throws Exception {
        disconnected = true;
        SmartCommand.tryException((HxOp)op);
        op.getHtmlWriter().w((Object)"entsecHx.timeout();");
        SmartCommand.catchException((HxOp)op);
    }

    public static void connect(HxOp op) throws Exception {
        disconnected = false;
        SmartCommand.tryException((HxOp)op);
        op.getHtmlWriter().w((Object)"entsecHx.reconnect();");
        SmartCommand.catchException((HxOp)op);
    }

    public String getAppName() {
        return "entsec";
    }

    public boolean hasView(BObject target, AgentInfo agentInfo) {
        if (agentInfo.getAgentType().toString().equals("obixDriver:ObjectToObix")) {
            return false;
        }
        if (agentInfo.getAgentType().toString().equals("schedule:HxCalendarScheduler")) {
            return false;
        }
        if (agentInfo.getAgentType().equals(wrapper)) {
            if (target instanceof BComponent) {
                SlotCursor c = ((BComponent)target).getProperties();
                while (c.next(AgentInfo.class)) {
                    if (!(c.get() instanceof BAbstractPxView)) continue;
                    BAbstractPxView pxView = (BAbstractPxView)c.get();
                    BTypeSpec media = pxView.getMedia();
                    return !media.getModuleName().equals("hx") || !media.getTypeName().equals("HxPxMedia");
                }
                return false;
            }
            return false;
        }
        if (agentInfo.getAgentType().is(widgetType)) {
            AgentList hxViews = Sys.getRegistry().getAgents(agentInfo.getAgentType());
            hxViews = hxViews.filter(AgentFilter.is((TypeInfo)hxViewType));
            for (int i = 0; i < hxViews.size(); ++i) {
                AgentInfo hxView = hxViews.get(i);
                if (hxView.getAgentType().is(hxPxWbViewType) || hxView.getAgentType().is(BHxPxWbWrapper.TYPE)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public AgentList getViews(HxOp op) {
        AgentList list = super.getViews(op);
        int videoIndex = list.indexOf("videoHx:VideoReviewView");
        int entsecAlarmIndex = list.indexOf("entsecHx:HxEntsecAlarmConsole");
        if (op.get().getType().is(BNiagaraScheduleDeviceExt.TYPE)) {
            list.toTop("entsecHx:HxDistributedScheduleView");
        }
        if (videoIndex > -1 && entsecAlarmIndex > -1 && videoIndex < entsecAlarmIndex) {
            list.swap(videoIndex, entsecAlarmIndex);
        }
        if (op.get().getType().is(BNiagaraNetwork.TYPE)) {
            list.toTop("entsecHx:HxNiagaraNetworkView");
        }
        if (op.get().getType().is(BRdbmsNetwork.TYPE)) {
            list.toTop("entsecHx:HxRdbmsNetworkView");
        }
        if (op.get().getType().is(BAccessNetwork.TYPE)) {
            list.toTop("entsecHx:HxAccessNetworkView");
        }
        BEnterpriseSecurityService enterpriseSecurityService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        if (op.get().getType().is(BSecurityHistoryConsolidator.TYPE) && enterpriseSecurityService.getMonitorSysDefSecurity().getHasNACSystem() && ((BSecurityHistoryConsolidator)op.get()).getHistoryRecordType().equals((Object)BBadgeSwipeRecord.TYPE.getTypeSpec())) {
            list.toTop("entsecHx:HxOrionHistoryView");
        }
        if (list.indexOf("entsecHx:HxPxWbWrapper") > -1) {
            int indexHxPxWrapper = list.indexOf("entsecHx:HxPxWbWrapper");
            list.toTop(indexHxPxWrapper);
        }
        list.remove("ndriver:NDeviceUxManager");
        BObject contextObject = op.get();
        boolean isNiagaraWebLauncher = op.getUserAgent() != null && op.getUserAgent().isNiagaraWebLauncher();
        String viewType = op.getViewParameter("viewType", "surveillance");
        if (viewType.equals("playback")) {
            if (isNiagaraWebLauncher) {
                list.toTop("videoHx:HxVideoPlaybackChooserView");
            } else {
                list.toTop("videoDriver:WebVideoPlayback");
            }
        }
        if (viewType.equals("surveillance")) {
            if (isNiagaraWebLauncher && list.indexOf("videoDriver:LiveVideo") == 1) {
                list.toTop("videoHx:LiveVideoViewer");
            } else if (isNiagaraWebLauncher) {
                list.toTop("videoHx:HxVideoMultistreamViewer");
            } else if (list.indexOf("videoDriver:LiveVideo") == 1) {
                list.toTop("videoDriver:WebLiveVideo");
            } else {
                list.toTop("videoDriver:WebSurveillanceViewer");
            }
        }
        if (op.get().getType().is(BPhotoIDViewerComponent.TYPE)) {
            if (isNiagaraWebLauncher) {
                list.toTop("entsecHx:HxPhotoIDsView");
            } else {
                list.toTop("entsecHx:PhotoIDsUxView");
            }
        }
        if (contextObject instanceof BConsoleRecipient && !(contextObject instanceof BActivityMonitor)) {
            if (isNiagaraWebLauncher) {
                list.toTop("entsecHx:LiveSecAlarmConsoleView");
            } else {
                list.toTop("entsecHx:HxEntsecAlarmConsole");
            }
        }
        if (contextObject instanceof BCalendarSchedule) {
            list.toTop("entsecHx:HxCalendarScheduleView");
        }
        if (contextObject instanceof BBase2ReaderModule || contextObject instanceof BAccessInputOutputModule || contextObject instanceof BRemote2ReaderModule) {
            list.toTop("entsecHx:HxAccessDeviceView");
        }
        if (contextObject instanceof BPhotoIDCamera && !isNiagaraWebLauncher) {
            list.toTop("entsecHx:PhotoIdUxCamera");
        }
        return list;
    }

    public boolean isUnsupportDevVideoDriverView(BObject o, AgentInfo agentInfo) {
        if (!agentInfo.getAgentType().getModuleName().equals("videoHx")) {
            return false;
        }
        if (agentInfo.getAgentType().getTypeName().equals("WebLiveVideo") || agentInfo.getAgentType().getTypeName().equals("WebVideoPlayback")) {
            return false;
        }
        try {
            DependencyInfo[] info = o.getType().getModule().getModuleInfo(RuntimeProfile.rt).getDependencies();
            for (int i = 0; i < info.length; ++i) {
                ModuleInfo m = info[i].getModuleInfo();
                if (!m.getModuleName().equals("devVideoDriver")) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public void updateDocument(BHxView view, HxOp op) throws Exception {
        try {
            if (!disconnected) {
                op.getHtmlWriter().w((Object)"entsecHx.reconnect();");
            }
            this.checkForVideoAlarms(op);
            super.updateDocument(view, op);
        }
        catch (Exception e) {
            throw HxLocalizableExceptionTranslator.localize(e);
        }
    }

    private synchronized void checkForVideoAlarms(HxOp op) throws Exception {
        BUser user = op.getUser();
        BSecurityAlarmConsoleOptions options = (BSecurityAlarmConsoleOptions)user.get("entsec_SecurityAlarmConsoleOptions");
        if (options.getAlarmConsolePopup().equals((Object)BPopupOptions.off)) {
            return;
        }
        BLink[] links = options.getLinks((Slot)BSecurityAlarmConsoleOptions.signalAlarmReceived);
        BConsoleRecipient recipient = (BConsoleRecipient)BOrd.make((String)"entsecnav:alarmConsole").get((BObject)BLocalHost.INSTANCE, (Context)op);
        if (links.length == 0) {
            if (recipient != null) {
                BLink link = options.linkTo((BComponent)recipient, (Slot)BConsoleRecipient.routeAlarm, (Slot)BSecurityAlarmConsoleOptions.signalAlarmReceived);
                link.setSourceOrd(recipient.getHandleOrd());
            }
        } else {
            BComponent currentRecipient = links[0].getSourceComponent();
            if (!currentRecipient.getHandleOrd().equals((Object)recipient.getHandleOrd())) {
                options.remove((BComplex)links[0]);
                BLink link = options.linkTo((BComponent)recipient, (Slot)BConsoleRecipient.routeAlarm, (Slot)BSecurityAlarmConsoleOptions.signalAlarmReceived);
                link.setSourceOrd(recipient.getHandleOrd());
            }
        }
        if (options.getAlarmReceived()) {
            this.launchConsolePopup(recipient, op);
            options.setAlarmReceived(false);
        }
    }

    private void launchConsolePopup(BConsoleRecipient recipient, HxOp op) throws Exception {
        if (recipient == null) {
            return;
        }
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"function popup(){");
        out.w((Object)"if(opener && !opener.closed){opener.focus();}");
        out.w((Object)"else{");
        out.w((Object)"var factor = 0.90;");
        out.w((Object)"var popupWidth  = parseInt(screen.width * factor);");
        out.w((Object)"var popupHeight = parseInt(screen.height * factor);");
        out.w((Object)"var leftDelta   = (screen.width - popupWidth) / 2;");
        out.w((Object)"var topDelta    = (screen.height - popupHeight) / 2;");
        out.w((Object)("var win = window.open('" + HxUtil.encodeURLForHref((String)op.toUri(BOrd.make((String)("station:|" + recipient.getSlotPath() + "|view:entsecHx:EntsecAlarmUxConsole?popup=true")))) + "','fullscreenAlarmConsole',  'resizable=yes,  location=no,  scrollbars=yes, status=no,  toolbar=no');"));
        out.w((Object)"if(win == null) { alert('Pop-ups must be enabled...'); return;}");
        out.w((Object)"win.resizeTo(popupWidth, popupHeight);");
        out.w((Object)"win.moveTo(leftDelta, topDelta);");
        out.w((Object)"win.focus();");
        out.w((Object)"opener = win;");
        out.w((Object)"}");
        out.w((Object)"}");
        out.w((Object)"popup();");
    }

    public boolean processDocument(BHxView view, HxOp op) throws Exception {
        try {
            if (super.processDocument(view, op)) {
                return true;
            }
            return this.tenantFilterCommand.process(op);
        }
        catch (Exception e) {
            throw HxLocalizableExceptionTranslator.localize(e);
        }
    }

    public void writeDocument(BHxView view, HxOp op) throws Exception {
        op.setDynamic();
        op.jQuery();
        try {
            super.writeDocument(view, op);
        }
        catch (Exception e) {
            throw HxLocalizableExceptionTranslator.localize(e);
        }
    }

    public void doBody(BHxView view, HxOp op) throws Exception {
        BObject target;
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        String brandModuleName = service.getBrandingManager().getBrandModule();
        if (RemoteUtil.isSubordinate()) {
            BOrionTypeId rowType;
            BObject o = op.get();
            Type opType = o.getType();
            boolean isTable = o instanceof BDynamicTable;
            if (isTable && !(rowType = ((BDynamicTable)o).getRowType()).equals((Object)BOrionTypeId.DEFAULT)) {
                opType = rowType.getTypeSpec().getResolvedType();
            }
            if (opType.is(BThreatLevelGroupRec.TYPE)) {
                if (isTable && !(view instanceof BHxDynamicTableConfig)) {
                    op.setReadonly(true);
                }
            } else if (opType.is(BIOrionObject.TYPE) && !opType.is(BIMappable.TYPE) && !(view instanceof BHxDynamicTableConfig)) {
                op.setReadonly(true);
            }
        }
        if (service.getInitRequired() && service.get("platformSetup") != null && !((target = op.get()) instanceof BPlatformSetup)) {
            BOrd redirect = ((BComponent)service.get("platformSetup")).getSlotPathOrd();
            op.setRedirect("/ord?station:|" + redirect);
            return;
        }
        String superUrl = null;
        try {
            superUrl = service.getSupervisorUrl();
        }
        catch (SysDefException e) {
            e.printStackTrace();
        }
        HtmlWriter out = op.getHtmlWriter();
        op.addOnload("entsecHx.init();");
        String loginLex = Lexicon.make((String)"web").getHtmlSafeText("login");
        if (!loginLex.equals("Login")) {
            String quote = HxUtil.getInnerQuote((HxOp)op);
            op.addOnload("entsecHx.loginLex=" + quote + loginLex + quote + ";");
        }
        op.addStyleSheet(BOrd.make((String)"module://entsecHx/rc/entsecHx.css"));
        op.addStyleSheet(BOrd.make((String)("module://" + brandModuleName + "/rc/entsecBrand.css")));
        op.addJavaScript(BOrd.make((String)"module://entsecHx/rc/entsecHx.js"));
        op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        boolean fullScreen = false;
        ViewQuery viewQuery = op.getViewQuery();
        if (viewQuery != null && viewQuery.getParameter("fullScreen", null) != null) {
            fullScreen = true;
        }
        if (view instanceof IFullScreen || fullScreen) {
            view.write(op);
            this.displayError(op);
            return;
        }
        out.w((Object)"<div class='entsec-header' id='entsec-header'>");
        out.w((Object)"<div class='entsec-header-logo'>");
        HxUtil.makeImageJS((BImage)BImage.make((String)("module://" + brandModuleName + "/rc/header/logo.png")), (HxOp)op);
        out.w((Object)"</div>");
        out.w((Object)"<table class='entsec-header-sysinfo' cellspacing='0' cellpadding='0'>");
        out.w((Object)"<tr><td>");
        out.w((Object)"<table width='100%' cellspacing='0' cellpadding='0'>");
        out.w((Object)"<tr><td ");
        HxTabUtil.scope((String)"profile-stationName", (HtmlWriter)out, (HxOp)op);
        if (disconnected) {
            out.attr("class", "entsec-header-stationName entsec-header-disconnected");
        } else {
            out.attr("class", "entsec-header-stationName");
        }
        out.w((Object)">");
        this.writeGuidedTour(op);
        out.safe((Object)service.getStationDisplayName((Context)op));
        String sysName = service.getSystemName((Context)op);
        if (superUrl != null && sysName.length() != 0) {
            out.w((Object)" - ");
            out.w((Object)"<a style='cursor:pointer;' href='").w((Object)HxUtil.encodeURLForHref((String)superUrl)).w((Object)"'>").safe((Object)sysName).w((Object)"</a>");
        }
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr><td class='entsec-header-alarmStatus'>");
        this.writeAlarmStatus(op);
        out.w((Object)"</td></tr>");
        out.w((Object)"</table>");
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr><td class='entsec-header-logout'>");
        out.w((Object)"<table style='float: right;' cellspacing='0' cellpadding='0'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><img src='module://").w((Object)brandModuleName).w((Object)"/rc/header/head_logout_bg_cap.png'/></td>");
        out.w((Object)"<td class='entsec-header-logout-link' ");
        out.w((Object)"onclick='").w((Object)this.help.getInvokeCode(op)).w((Object)"'");
        out.w((Object)">");
        HxUtil.makeImageJS((BImage)this.help.getIcon(op), (HxOp)op);
        out.w((Object)" ");
        out.safe((Object)this.help.getDisplayName(op));
        out.w((Object)"</td>");
        out.w((Object)"<td class='entsec-header-logout-link' ");
        out.w((Object)"onclick='").w((Object)this.logout.getInvokeCode(op)).w((Object)"'");
        out.w((Object)" title='").w((Object)lex.getHtmlSafeText("loggedInAs", (Context)op, new Object[]{op.getUser().getUsername()})).w((Object)"'");
        out.w((Object)">");
        HxUtil.makeImageJS((BImage)BImage.make((BIcon)op.getUser().getIcon()), (HxOp)op);
        out.w((Object)" ");
        out.safe((Object)lex.getHtmlSafeText("logout", (Context)op));
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
        out.w((Object)"</td></tr>");
        out.w((Object)"</table>");
        out.w((Object)"</div>");
        this.navBar.write(op);
        out.w((Object)"<div id='viewdiv' ");
        if (view instanceof BHxWebWidget || view instanceof IFullHeight) {
            out.attr(" class", "entsec-fullHeight");
        }
        out.w((Object)">");
        view.write(op);
        out.w((Object)"</div>");
        this.displayError(op);
    }

    public void writeNavMenu(HxOp op) throws Exception {
        BServiceContainer serviceContainer;
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table ");
        out.attr("class", "nav-table");
        out.w((Object)">");
        BServiceContainer c = (BServiceContainer)Sys.getService((Type)BServiceContainer.TYPE);
        BIService[] s = (BIService[])c.getChildren(BIService.class);
        for (int h = 0; h < s.length; ++h) {
            BComponent service = (BComponent)s[h];
            if (Flags.isSummary((BComplex)service.getParent(), (Slot)service.getPropertyInParent())) {
                this.writeNavEntry((BINavNode)service, op);
            }
            BComponent[] children = (BComponent[])service.getChildren(BComponent.class);
            for (int i = 0; i < children.length; ++i) {
                if (!Flags.isSummary((BComplex)service, (Slot)children[i].getPropertyInParent())) continue;
                this.writeNavEntry((BINavNode)children[i], op);
            }
        }
        BDriverContainer d = (BDriverContainer)Sys.getService((Type)BDriverContainer.TYPE);
        if (Flags.isSummary((BComplex)d.getParent(), (Slot)d.getPropertyInParent())) {
            this.writeNavEntry((BINavNode)d, op);
        }
        if (Flags.isSummary((BComplex)(serviceContainer = (BServiceContainer)Sys.getService((Type)BServiceContainer.TYPE)).getParent(), (Slot)serviceContainer.getPropertyInParent())) {
            this.writeNavEntry((BINavNode)serviceContainer, op);
        }
        s = (BIService[])d.getChildren(BIService.class);
        for (int h = 0; h < s.length; ++h) {
            BComponent service = (BComponent)s[h];
            if (!Flags.isSummary((BComplex)service.getParent(), (Slot)service.getPropertyInParent())) continue;
            this.writeNavEntry((BINavNode)service, op);
        }
        out.w((Object)"<tr>");
        out.w((Object)"<td>");
        HxUtil.makeImageJS((BImage)POWERED, (HxOp)op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
    }

    public void writeNavEntry(BINavNode navNode, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<tr ");
        out.w((Object)">");
        out.w((Object)"<td ");
        out.attr("class", "nav-cat");
        out.w((Object)(" onclick=\"window.location='ord?" + HxUtil.encodeURLForHref((String)navNode.getNavOrd().toString()))).w((Object)"'\"");
        out.w((Object)">");
        HxUtil.makeImageJS((BImage)BImage.make((BIcon)navNode.getNavIcon()), (HxOp)op);
        out.w((Object)" ").safe((Object)navNode.getNavDisplayName((Context)op));
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
    }

    private void writeAlarmStatus(HxOp op) throws Exception {
        BUser user = op.getUser();
        if (user == null) {
            return;
        }
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        SessionAlarmStatus alarmStatus = (SessionAlarmStatus)op.getRequest().getSession().getAttribute("entsecAlarmStatus");
        if (alarmStatus == null) {
            alarmStatus = new SessionAlarmStatus();
            SlotCursor c = alarmService.getProperties();
            while (c.next(BConsoleRecipient.class)) {
                BConsoleRecipient console = (BConsoleRecipient)c.get();
                if (console.getType().toString().equals("videoDriver:VideoAlarmRecipient") || !user.getPermissionsFor((BIProtected)console).hasOperatorRead()) continue;
                alarmStatus.addConsole(console, (Context)op);
            }
            op.getRequest().getSession().setAttribute("entsecAlarmStatus", (Object)alarmStatus);
        } else {
            alarmStatus.validateConsoles();
        }
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table style='float: right;' cellspacing='0' cellpadding='0'>");
        out.w((Object)"<tr>");
        int consoleCount = alarmStatus.getConsoleCount();
        if (consoleCount > 0) {
            for (int i = 0; i < consoleCount; ++i) {
                BIcon statusIcon = alarmStatus.getStatusIcon(i);
                out.w((Object)"<td>");
                out.w((Object)"<a style='cursor:pointer;' ");
                out.attr("title", alarmStatus.getConsoleOrd(i).toString());
                out.w((Object)" href='").safe((Object)alarmStatus.getConsoleOrd(i).toString()).w((Object)"'>");
                HxUtil.makeImageJS((BImage)BImage.make((BIcon)statusIcon), (String)"style='border: 0px;'", (HxOp)op);
                out.w((Object)"</a>");
                out.w((Object)"</td>");
            }
        } else {
            out.w((Object)"<td>&nbsp;</td>");
        }
        BJob job = this.getJobForStatus(op);
        if (job != null) {
            BImage jobStatus = BHxAbstractJobView.getJobStateImage(job.getJobState());
            out.w((Object)"<td>");
            out.w((Object)"<a style='cursor:pointer;' ");
            out.attr("title", job.toString((Context)op));
            out.w((Object)" href='station:|service:baja:JobService'>");
            HxUtil.makeImageJS((BImage)jobStatus, (String)"style='border: 0px;'", (HxOp)op);
            out.w((Object)"</a>");
            out.w((Object)"</td>");
        }
        out.w((Object)"<td>");
        HxTabUtil.writeImageCommand((SmartCommand)this.tenantFilterCommand, (HxOp)op);
        HxTabUtil.writeImageCommand((SmartCommand)this.newWindow, (HxOp)op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
        BSecurityAlarmConsoleOptions ac = (BSecurityAlarmConsoleOptions)user.get("entsec_SecurityAlarmConsoleOptions");
        try {
            BConsoleRecipient consoleRecipient = (BConsoleRecipient)BOrd.make((String)"entsecnav:alarmConsole").get((BObject)BLocalHost.INSTANCE, (Context)op);
            if (!ac.getAlarmReceived()) {
                return;
            }
            String[] subscribed = consoleRecipient.getSubscribedAlarmClasses();
            for (int i = 0; i < subscribed.length; ++i) {
                BAlarmClass alarmClass = alarmService.lookupAlarmClass(subscribed[i]);
                if (alarmClass.getUnackedAlarmCount() <= 0) continue;
                return;
            }
            ac.setAlarmReceived(false);
        }
        catch (Exception e) {
            BAccessControlService.LOG.log(Level.SEVERE, "Default Alarm Console for User:" + op.getUser().getUsername() + " no longer available:" + ac.getDefaultAlarmConsole(), e);
        }
    }

    public Tab getTenantFilterTab(HxOp op) {
        BTenantFilterOptions options = BTenantFilterOptions.getOptions((Context)op);
        return new Tab((BHxView)BHxTenantFilterFE.INSTANCE, op.make("tenantList", (BObject)options, null), op);
    }

    public BJob getJobForStatus(HxOp op) {
        BJobService jobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
        BJob[] jobs = jobService.getJobs();
        if (jobs.length == 0) {
            return null;
        }
        BAbsTime startTime = jobs[jobs.length - 1].getStartTime();
        if (startTime.isBefore(BAbsTime.now().subtract(BRelTime.makeHours((int)1)))) {
            return null;
        }
        return jobs[jobs.length - 1];
    }

    public void writeGuidedTour(HxOp op) throws Exception {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        if (service.getShowGuidedTour()) {
            if (service.getBrandingManager().guidedTour == null) {
                BOrd xml = service.getBrandingManager().getGuidedTourXml();
                service.getBrandingManager().guidedTour = new GuidedTour(xml, this.getRestartStepNumber());
            }
            service.getBrandingManager().guidedTour.write(op);
            if (service.getPopUpGuidedTour()) {
                service.getBrandingManager().guidedTour.popUp(op);
                service.setPopUpGuidedTour(false);
            }
        }
    }

    public void guidedTourComplete() {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        service.getBrandingManager().guidedTour = null;
        service.setShowGuidedTour(false);
        if (service.get("guidedTourStepNumber") != null) {
            // empty if block
        }
        service.remove("guidedTourStepNumber");
    }

    public int getRestartStepNumber() {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BValue step = service.get("guidedTourStepNumber");
        if (step != null && step instanceof BInteger) {
            return ((BInteger)step).getInt();
        }
        return -1;
    }

    public void updateRestartStepNumber(int stepNumber) {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BValue step = service.get("guidedTourStepNumber");
        if (step == null) {
            service.add("guidedTourStepNumber", (BValue)BInteger.make((int)stepNumber), 5);
        } else {
            service.set("guidedTourStepNumber", (BValue)BInteger.make((int)stepNumber));
        }
    }

    protected HxOp makePathBarOp(HxOp op) {
        return op.make((OrdTarget)op);
    }

    public BInsets getViewWindow() {
        return insets;
    }

    public class NewWindow
    extends SmartCommand {
        public NewWindow(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "newWindow";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"function popupNewWindow(){");
            out.w((Object)"var factor = 0.90;");
            out.w((Object)"var popupWidth  = parseInt(screen.width * factor);");
            out.w((Object)"var popupHeight = parseInt(screen.height * factor);");
            out.w((Object)"var leftDelta   = (screen.width - popupWidth) / 2;");
            out.w((Object)"var topDelta    = (screen.height - popupHeight) / 2;");
            BOrd ord = BOrd.make((BOrd)op.getOrd(), (String)"view:?fullScreen=true");
            out.w((Object)("var win = window.open('" + HxUtil.encodeURLForHref((String)op.toUri(ord)) + "','fullscreen' + new Date().getTime(),  'resizable=yes,  location=no,  scrollbars=yes, status=no,  toolbar=no', false);"));
            out.w((Object)"if(win == null) { alert('Pop-ups must be enabled...'); ");
            out.w((Object)"return;}");
            out.w((Object)"win.resizeTo(popupWidth, popupHeight);");
            out.w((Object)"win.moveTo(leftDelta, topDelta);");
            out.w((Object)"win.focus();");
            out.w((Object)"}");
            out.w((Object)"popupNewWindow();");
        }
    }

    class Logout
    extends Command {
        public Logout(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"entsecHx.logout('");
            out.w((Object)HxUtil.getCsrfTokenQueryString());
            out.w((Object)"','");
            out.w((Object)lex.getHtmlSafeText("entsec.logout.confirm.message", (Context)op));
            out.w((Object)"');");
        }
    }

    public static interface IFullHeight {
    }

    public static interface IFullScreen {
    }
}

