/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access;

import com.tridium.nd.BNiagaraStation;
import com.tridium.smartTableHx.DialogWizardCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessZone;
import com.tridiumx.entsecHx.orionToolsHx.BHxAppTableView;
import com.tridiumx.entsecHx.orionToolsHx.MappableRenameCommand;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"entsec:AccessZones"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxAccessZonesView
extends BHxAppTableView {
    @Generated
    public static final BHxAccessZonesView INSTANCE = new BHxAccessZonesView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxAccessZonesView.class);
    SmartCommand accessZoneRename = new AccessZoneRenameCommand((BHxView)this);
    SmartCommand accessZoneAdd;
    public static final String ACCESS_ZONE_INSTANCE = "accessZoneInstance";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxAccessZonesView() {
        this.registerEvent((Event)this.accessZoneRename);
        this.accessZoneAdd = new AccessZoneAddCommand((BHxView)this);
        this.registerEvent((Event)this.accessZoneAdd);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array a = new Array((Object[])super.getButtonCommands(op));
        if (!this.isAdditionAllowed()) {
            a.remove((Object)this.add);
            a.remove((Object)this.rename);
        } else {
            a.set(a.indexOf((Object)this.add), (Object)this.accessZoneAdd);
            a.set(a.indexOf((Object)this.rename), (Object)this.accessZoneRename);
        }
        return (SmartCommand[])a.trim();
    }

    public boolean isAdditionAllowed() {
        try {
            BTypeSpec typeSpec = BTypeSpec.make((String)"nacDriver", (String)"NACAccessZone");
            typeSpec.getResolvedType();
            return true;
        }
        catch (Exception exception) {
            return !BEnterpriseSecurityService.isWorkstation();
        }
    }

    public class AccessZoneAddCommand
    extends BHxAppTableView.AddCommand {
        public static final String ACCESS_ZONE_TYPE = "accessZoneType";

        public AccessZoneAddCommand(BHxView view) {
            super(view);
            this.lexModule = LexiconModule.make(((Object)((Object)this)).getClass());
        }

        @Override
        public void handle(HxOp op) throws Exception {
            if (op.getFormValue("submit") == null) {
                AddDialog addDialog = new AddDialog(this.lexModule.getText("add.addAccessZone", (Context)op), (Command)this);
                addDialog.open(op);
                return;
            }
            BAccessZone accessZone = (BAccessZone)ValueDocDecoder.unmarshal((String)SlotPath.unescape((String)op.getFormValue("add")));
            op.getRequest().getSession().setAttribute(BHxAccessZonesView.ACCESS_ZONE_INSTANCE, (Object)accessZone);
            super.handle(op);
        }

        class AccessZoneRenderer
        implements DialogWizardCommand.ChoiceRenderer {
            AccessZoneRenderer() {
            }

            public String getValue(Object o, HxOp hxOp) {
                try {
                    BAccessZone accessZone = (BAccessZone)o;
                    return SlotPath.escape((String)ValueDocEncoder.marshal((BValue)accessZone));
                }
                catch (Exception e) {
                    throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
                }
            }

            public String getDisplayName(Object o, HxOp hxOp) {
                BAccessZone accessZone = (BAccessZone)o;
                return accessZone.getFacets().gets(AccessZoneAddCommand.ACCESS_ZONE_TYPE, "");
            }

            public BImage getIcon(Object o, HxOp hxOp) {
                return null;
            }
        }

        class AddDialog
        extends Dialog {
            public AddDialog(String title, Command handler) {
                super(title, handler);
                AccessZoneAddCommand.this.lexModule = LexiconModule.make(((Object)((Object)this)).getClass());
            }

            protected void writeContent(HxOp op) throws Exception {
                BAccessZone zone;
                BTypeSpec typeSpec;
                Array choices = new Array(BAccessZone.class);
                if (!BEnterpriseSecurityService.isWorkstation()) {
                    typeSpec = BTypeSpec.make((String)"entsec", (String)"AccessZone");
                    zone = (BAccessZone)typeSpec.getInstance();
                    zone.setFacets(BFacets.make((String)AccessZoneAddCommand.ACCESS_ZONE_TYPE, (BIDataValue)BString.make((String)AccessZoneAddCommand.this.lexModule.getText("add.accessZone", (Context)op))));
                    choices.add((Object)zone);
                }
                try {
                    typeSpec = BTypeSpec.make((String)"nacDriver", (String)"NACAccessZone");
                    zone = (BAccessZone)typeSpec.getInstance();
                    zone.setFacets(BFacets.make((String)AccessZoneAddCommand.ACCESS_ZONE_TYPE, (BIDataValue)BString.make((String)AccessZoneAddCommand.this.lexModule.getText("add.nacAccessZone", (Context)op))));
                    choices.add((Object)zone);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DialogWizardCommand.writeChoices((Object[])choices.trim(), (String)AccessZoneAddCommand.this.lexModule.getText("add.chooseAccessZoneType", (Context)op), (boolean)false, (String)"add", (DialogWizardCommand.ChoiceRenderer)new AccessZoneRenderer(), (HxOp)op);
            }
        }
    }

    public class AccessZoneRenameCommand
    extends MappableRenameCommand {
        public AccessZoneRenameCommand(BHxView view) {
            super(view);
        }

        @Override
        public BComponent getComponent(HxOp op) {
            BAccessZone accessZone = (BAccessZone)super.getComponent(op);
            if (!this.isRenameAllowed(accessZone)) {
                throw new IllegalStateException("Cannot Rename Access Zone in Workstation");
            }
            BNiagaraStation[] stations = accessZone.getGrouping();
            for (int i = 0; i < stations.length; ++i) {
                stations[i].doPing();
                if (stations[i].getStatus().isOk()) continue;
                throw new IllegalStateException("Cannot Rename because Grouped station is {down}: " + stations[i].getStationName());
            }
            return accessZone;
        }

        private boolean isRenameAllowed(BAccessZone accessZone) {
            return !accessZone.getType().equals(BAccessZone.TYPE) || !BEnterpriseSecurityService.isWorkstation();
        }
    }
}

