/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.fieldeditors;

import com.tridium.smartTableHx.tab.HxTabUtil;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

@NiagaraType(agent={@AgentOn(types={"baja:Unit"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxUnitFE
extends BHxFieldEditor {
    @Generated
    public static final BHxUnitFE INSTANCE = new BHxUnitFE();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxUnitFE.class);
    private Command quantityChangedCommand = new QuantityChangedCommand((BHxView)this);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxUnitFE() {
        this.registerEvent((Event)this.quantityChangedCommand);
    }

    public void write(HxOp op) throws Exception {
        super.write(op);
        op.addJavaScript(BOrd.make((String)"module://entsecHx/rc/securityUtilHx/select.js"));
        HtmlWriter out = op.getHtmlWriter();
        HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
        out.w((Object)"<b>").safe((Object)this.getLexicon().getText("unitEditor.quantity")).w((Object)"</b>");
        HxTabUtil.nextColumn((HtmlWriter)out, (HxOp)op);
        this.writeQuantities(op);
        HxTabUtil.nextColumn((HtmlWriter)out, (HxOp)op);
        out.w((Object)"<b>").safe((Object)this.getLexicon().getText("unitEditor.unit")).w((Object)"</b>");
        HxTabUtil.nextColumn((HtmlWriter)out, (HxOp)op);
        this.writeUnits(op);
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
    }

    private void writeQuantities(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BUnit currentUnit = (BUnit)op.get();
        UnitDatabase db = UnitDatabase.getDefault();
        UnitDatabase.Quantity currentQuantity = db.getQuantity(currentUnit);
        UnitDatabase.Quantity[] quantities = db.getQuantities();
        out.w((Object)"<select ");
        out.attr("id", op.scope("quantity"));
        out.attr("name", op.scope("quantity"));
        if (!op.canWrite()) {
            out.attr("disabled", "disabled");
        }
        out.w((Object)" >");
        for (int i = 0; i < quantities.length; ++i) {
            out.w((Object)"<option ");
            out.attr("value", (Object)quantities[i]);
            if (currentQuantity.equals(quantities[i])) {
                out.attr("selected", "selected");
            }
            out.w((Object)">");
            out.w((Object)quantities[i]);
            out.w((Object)"</option>");
        }
        out.w((Object)"</select>");
        HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)HxTabUtil.FIRE_EVENT, (boolean)false, (String)op.scope("quantity"), (String)op.getPath(), (String)this.quantityChangedCommand.getId(), (HxOp)op);
    }

    private void writeUnits(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BUnit currentUnit = (BUnit)op.get();
        UnitDatabase db = UnitDatabase.getDefault();
        UnitDatabase.Quantity currentQuantity = db.getQuantity(currentUnit);
        BUnit[] units = currentQuantity.getUnits();
        out.w((Object)"<select ");
        out.attr("id", op.scope("unit"));
        out.attr("name", op.scope("unit"));
        if (!op.canWrite()) {
            out.attr("disabled", "disabled");
        }
        out.w((Object)" >");
        for (int i = 0; i < units.length; ++i) {
            out.w((Object)"<option ");
            out.attr("value", units[i].getUnitName());
            if (currentUnit.equals((Object)units[i])) {
                out.attr("selected", "selected");
            }
            out.w((Object)">");
            out.w((Object)(units[i].getUnitName() + " (" + units[i].getSymbol() + ")"));
            out.w((Object)"</option>");
        }
        out.w((Object)"</select>");
    }

    public BObject save(HxOp op) throws Exception {
        String unitName = op.getFormValue("unit");
        BUnit unit = UnitDatabase.getUnit((String)unitName);
        return unit.newCopy();
    }

    private class QuantityChangedCommand
    extends Command {
        public QuantityChangedCommand(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            super.handle(op);
            UnitDatabase db = UnitDatabase.getDefault();
            String selectedQuantity = op.getFormValue("quantity");
            UnitDatabase.Quantity[] quantities = db.getQuantities();
            UnitDatabase.Quantity quantity = null;
            for (int i = 0; i < quantities.length; ++i) {
                if (!quantities[i].toString().equals(selectedQuantity)) continue;
                quantity = quantities[i];
                break;
            }
            if (quantity == null) {
                return;
            }
            BUnit[] units = quantity.getUnits();
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var listId = '").w((Object)op.scope("unit")).w((Object)"';");
            out.w((Object)"select.clearSelect(listId);");
            for (int i = 0; i < units.length; ++i) {
                out.w((Object)"select.addToSelect(listId, '").w((Object)units[i].getUnitName()).w((Object)"', '").w((Object)(units[i].getUnitName() + " (" + units[i].getSymbol() + ")")).w((Object)"');");
            }
        }
    }
}

