/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.managers;

import com.tridium.orion.OrionSession;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.securityUtil.ui.link.BLinkTemplate;
import com.tridiumx.entsecHx.orionToolsHx.BHxOrionSummary;
import com.tridiumx.entsecHx.securityUtilHx.UpLevelCommand;
import com.tridiumx.entsecHx.securityUtilHx.link.BHxKnobFE;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDevicesView;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"accessDriver:AccessReader"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxReaderView
extends BHxManageDevicesView {
    @Generated
    public static final BHxReaderView INSTANCE = new BHxReaderView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxReaderView.class);
    protected SmartCommand upLevelCommand = new UpLevel((BHxView)this);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxReaderView() {
        this.registerEvent((Event)this.upLevelCommand);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.save, this.upLevelCommand};
    }

    @Override
    public BHxTabbedView.PropertyTab getPropertyTab(HxOp op) throws Exception {
        BHxTabbedView.PropertyTab tab = super.getPropertyTab(op);
        if (!BEnterpriseSecurityService.isThreatAvailable((Context)op)) {
            Array fields = new Array((Object[])TextUtil.split((String)tab.op.getFacets().get("fieldsProvided").toString(), (char)'|'));
            fields.remove((Object)BAccessReader.threatLevelGroup.getName());
            fields.remove((Object)BAccessReader.elevatedThreatLevel.getName());
            fields.remove((Object)BAccessReader.elevatedThreatReaderConfig.getName());
            tab.op.mergeFacets(BHxFieldSheet.getFieldsProvidedFacets((String[])((String[])fields.trim())));
        } else if (!HxUtil.isPost((HxOp)op)) {
            String scope = op.scope("properties.");
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)HxTabUtil.SHOW_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)(scope + BAccessReader.threatLevelGroup.getName() + ".value"), (String)(scope + BAccessReader.elevatedThreatLevel.getName()), (String)"", (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)HxTabUtil.SHOW_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)(scope + BAccessReader.threatLevelGroup.getName() + ".value"), (String)(scope + BAccessReader.elevatedThreatReaderConfig.getName()), (String)"", (HxOp)op);
        }
        return tab;
    }

    @Override
    public Tab[] getTabs(HxOp op) throws Exception {
        Array a = new Array((Object[])super.getTabs(op));
        try {
            a.add(0, (Object)this.getSummaryTab(op));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BAccessReader reader = (BAccessReader)op.get();
        if (reader.getParent() instanceof BPointDeviceExt) {
            try {
                BLinkTemplate intrusionZonesTemplate = new BLinkTemplate(BTypeSpec.make((String)"entsec:IntrusionZone"), (Slot)BAccessReader.accessValidated, "toggleZoneEnabled");
                Tab intrusionZones = new Tab((BHxView)BHxKnobFE.INSTANCE, "Intrusion Zones", op.make("intrusionZones", (BObject)intrusionZonesTemplate, null));
                a.add((Object)intrusionZones);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (Tab[])a.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tab getSummaryTab(HxOp op) {
        BAccessReader reader = (BAccessReader)op.get();
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        OrionSession session = null;
        try {
            session = service.createSession(null);
            BAccReaderRec rec = (BAccReaderRec)session.mappedRead((BObject)reader);
            HxOp tabOp = op.make("mapped", (BObject)rec, null);
            Tab tab = new Tab((BHxView)BHxOrionSummary.INSTANCE, Lexicon.make(((Object)((Object)this)).getClass()).getText("summary"), tabOp);
            return tab;
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public void write(HxOp op) throws Exception {
        this.fixAlarms(op);
        op.setDynamic();
        super.write(op);
    }

    public boolean process(HxOp op) throws Exception {
        op.setDynamic();
        return super.process(op);
    }

    public void fixAlarms(HxOp op) {
        try {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            boolean showPinDuress = service.getHasPinDuress();
            boolean showUnknownWiegandFormats = service.getDisplayUnknownWiegandFormats();
            BAccessReader reader = (BAccessReader)op.get();
            Property p = BAccessReader.unknownWiegandFormatAlert;
            if (showUnknownWiegandFormats && Flags.isHidden((BComplex)reader, (Slot)p)) {
                reader.setFlags((Slot)p, reader.getFlags((Slot)p) & 0xFFFFFFFB);
            } else if (!showUnknownWiegandFormats && !Flags.isHidden((BComplex)reader, (Slot)p)) {
                reader.setFlags((Slot)p, reader.getFlags((Slot)p) | 4);
            }
            p = BAccessReader.grantedButPinDuressAlert;
            if (showPinDuress && Flags.isHidden((BComplex)reader, (Slot)p)) {
                reader.setFlags((Slot)p, reader.getFlags((Slot)p) & 0xFFFFFFFB);
            } else if (!showPinDuress && !Flags.isHidden((BComplex)reader, (Slot)p)) {
                reader.setFlags((Slot)p, reader.getFlags((Slot)p) | 4);
            }
            p = BAccessReader.inactiveThreatLevelGroupAlert;
            boolean threatAvailable = BEnterpriseSecurityService.isThreatAvailable();
            if (threatAvailable && Flags.isHidden((BComplex)reader, (Slot)p)) {
                reader.setFlags((Slot)p, reader.getFlags((Slot)p) & 0xFFFFFFFB);
            } else if (!threatAvailable && !Flags.isHidden((BComplex)reader, (Slot)p)) {
                reader.setFlags((Slot)p, reader.getFlags((Slot)p) | 4);
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    public class UpLevel
    extends UpLevelCommand {
        public UpLevel(BHxView view) {
            super(view);
        }

        @Override
        public String getName(HxOp op) {
            return "moduleUpLevel";
        }

        @Override
        public String getDisplayName(HxOp op) {
            BObject o = op.get();
            if (o.asComponent().getParent() instanceof BPointDeviceExt) {
                return super.getDisplayName(op);
            }
            return o.asComponent().getParent().getType().getDisplayName((Context)op);
        }

        @Override
        public BOrd getOrd(HxOp op) {
            BObject o = op.get();
            if (o.asComponent().getParent() instanceof BPointDeviceExt) {
                return o.asComponent().getParent().asComponent().getParent().asComponent().getSlotPathOrd();
            }
            return super.getOrd(op);
        }
    }
}

