/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.orionTools.ui.BAppView;
import com.tridiumx.entsec.photoID.orion.BBadgeTemplate;
import com.tridiumx.entsec.photoID.orion.BPhotoIDTemplateRec;
import com.tridiumx.entsecHx.orionToolsHx.BHxAppView;
import com.tridiumx.entsecHx.photoID.PrintBadgeWizard;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"entsec:Badge"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxBadgeView
extends BHxAppView {
    @Generated
    public static final BHxBadgeView INSTANCE = new BHxBadgeView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxBadgeView.class);
    protected SmartCommand printBadge = new PrintBadgeWizard((BHxView)this);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxBadgeView() {
        this.registerEvent((Event)this.printBadge);
    }

    public void write(HxOp op) throws Exception {
        super.write(op);
        SmartCommand.addFormElementToPoll((String)op.scope("prop.owner.value"), (HxOp)op);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array a = new Array((Object[])super.getButtonCommands(op));
        if (BEnterpriseSecurityService.isPhotoIDAvailable((Context)op)) {
            a.add((Object)this.printBadge);
        }
        return (SmartCommand[])a.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provideBadgeTemplate(BBadge badge, HxOp op) {
        BOrionDatabase db = BHxBadgeView.getOrionDatabase(op);
        OrionSession session = null;
        try {
            session = db.createSession((Context)op);
            if (BEnterpriseSecurityService.isPhotoIDAvailable((Context)op)) {
                BRef ref = BRef.make((BTypeSpec)BPhotoIDTemplateRec.ORION_TYPE.getTypeSpec());
                BBadgeTemplate badgeTemplate = (BBadgeTemplate)session.read(BBadgeTemplate.ORION_TYPE, new PropertyValue(BBadgeTemplate.badge, (BValue)BRef.make((BIOrionObject)badge)));
                if (badgeTemplate != null) {
                    ref = BRef.make((BTypeSpec)BPhotoIDTemplateRec.ORION_TYPE.getTypeSpec(), (BSimple)badgeTemplate.getTemplate().getId());
                }
                if (badge.getProperty("template") == null) {
                    badge.add("template", (BValue)ref, 0, BFacets.make((String)"allowNull", (boolean)true), null);
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public BObject getPropertyObject(HxOp op) throws Exception {
        String encoded;
        BBadge badge = (BBadge)op.get();
        this.provideBadgeTemplate(badge, op);
        String owner = op.getViewParameter("owner", null);
        if (owner != null) {
            owner = SlotPath.unescape((String)owner);
            badge.setOwner((BRef)BRef.DEFAULT.decodeFromString(owner));
        }
        if (HxUtil.isPost((HxOp)op) && (encoded = op.getFormValue("owner.value")) != null) {
            badge.setOwner((BRef)BRef.DEFAULT.decodeFromString(encoded));
        }
        return badge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BObject save(HxOp op) throws Exception {
        this.validateExpirationDate(op);
        BBadge badge = (BBadge)super.save(op);
        if (!BEnterpriseSecurityService.isPhotoIDAvailable((Context)op)) {
            return badge;
        }
        BRef ref = (BRef)badge.get("template");
        BOrionDatabase db = BHxBadgeView.getOrionDatabase(op);
        OrionSession session = null;
        try {
            session = db.createSession((Context)op);
            BHxBadgeView.saveBadgeTemplate(badge, ref, session);
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        return badge;
    }

    private void validateExpirationDate(HxOp op) throws Exception {
        BHxTabbedView.PropertyTab propTab = this.getPropertyTab(op);
        BBadge badge = (BBadge)propTab.save();
        BAbsTime expDateTime = badge.getExpirationDate();
        if (!BAbsTime.DEFAULT.equals((Object)expDateTime) && badge.getIssueDate().isAfter(expDateTime)) {
            throw new IllegalArgumentException(Lexicon.make(((Object)((Object)this)).getClass()).get("expTimeIssue"));
        }
    }

    public static void saveBadgeTemplate(BBadge badge, BRef ref, OrionSession session) {
        BBadgeTemplate dbBadgeTemplate = (BBadgeTemplate)session.read(BBadgeTemplate.ORION_TYPE, new PropertyValue(BBadgeTemplate.badge, (BValue)BRef.make((BIOrionObject)badge)));
        BBadgeTemplate template = null;
        if (dbBadgeTemplate != null) {
            template = dbBadgeTemplate;
        } else {
            template = new BBadgeTemplate();
            template.setBadge(BRef.make((BIOrionObject)badge));
        }
        template.setTemplate(ref);
        if (ref.isBound() && dbBadgeTemplate == null) {
            session.insert((BIOrionObject)template);
        } else if (!ref.isBound() && dbBadgeTemplate != null) {
            session.delete((BIOrionObject)template);
        } else if (ref.isBound() && dbBadgeTemplate != null) {
            session.update((BIOrionObject)template);
        }
    }

    @Override
    public BHxTabbedView.PropertyTab getPropertyTab(HxOp op) throws Exception {
        BBadge badge = (BBadge)op.get();
        if (badge.getBadgeId().length() == 0) {
            Property[] props = new Property[]{BBadge.credential, BBadge.facilityCode, BBadge.wiegandFormat};
            BAppView.setWritable((BOrionObject)badge, (Property[])props);
        }
        this.disableLdapBBadgeEdit(badge, op);
        BHxTabbedView.PropertyTab propTab = super.getPropertyTab(op);
        return propTab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableLdapBBadgeEdit(BBadge bdage, HxOp op) {
        OrionSession session = null;
        try {
            session = bdage.getOrionDatabase().createSession(null);
            if (bdage.getBadgeLdapServerJoin(session) != null) {
                Flags.setAllReadonly((BComponent)bdage, (boolean)true, (Context)op);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    @Override
    public Tab[] getFieldEditors(HxOp op) {
        return new Tab[0];
    }
}

