/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.schedule;

import com.tridium.hx.fieldeditors.BHxEnumFE;
import com.tridium.hx.fieldeditors.BHxNumericFE;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.fieldeditors.BHxScheduleStatusValueFE;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.util.TimeFormat;
import com.tridiumx.entsecHx.access.schedule.BHxWeeklyScheduler;
import java.util.StringJoiner;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.TextUtil;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.util.Lexicon;

final class ViewUtil {
    private static final BFacets NO_UNITS = BFacets.make((String)"showUnits", (boolean)false);
    static final char SUBSTITUTE_QUOTE = '\ufffa';
    static final char SUBSTITUTE_DOUBLE_QUOTE = '\ufffb';
    static final char SUBSTITUTE_PIPE = '\ufffc';
    static final char SUBSTITUTE_COMMA = '\ufffd';
    static BTime[] timeColumn = new BTime[]{BTime.make((int)0, (int)0, (int)0), BTime.make((int)3, (int)0, (int)0), BTime.make((int)6, (int)0, (int)0), BTime.make((int)9, (int)0, (int)0), BTime.make((int)12, (int)0, (int)0), BTime.make((int)15, (int)0, (int)0), BTime.make((int)18, (int)0, (int)0), BTime.make((int)21, (int)0, (int)0), BTime.make((int)0, (int)0, (int)0)};

    private ViewUtil() {
    }

    static Lexicon getScheduleLexicon(HxOp op) {
        return Lexicon.make((String)"schedule", (Context)op);
    }

    static Context withoutUnits(Context cx) {
        return new BasicContext(cx, NO_UNITS);
    }

    static String getValueString(BStatusValue statusValue) {
        if (statusValue.getStatus().isNull()) {
            return "null";
        }
        if (statusValue instanceof BStatusEnum) {
            return Integer.toString(((BStatusEnum)statusValue).getValue().getOrdinal());
        }
        if (statusValue instanceof BStatusBoolean) {
            return statusValue.getValueValue().toString();
        }
        return "default";
    }

    static String getValueWithoutUnits(BValue valueValue, HxOp op) {
        if (valueValue instanceof BBoolean) {
            return Boolean.toString(((BBoolean)valueValue).getBoolean());
        }
        if (valueValue instanceof BEnum) {
            return Integer.toString(((BEnum)valueValue).getOrdinal());
        }
        return valueValue.toString(ViewUtil.withoutUnits((Context)op));
    }

    static String safeEncoding(String key) {
        key = TextUtil.replace((String)key, (String)"'", (String)"\ufffa");
        key = TextUtil.replace((String)key, (String)"\"", (String)"\ufffb");
        key = TextUtil.replace((String)key, (String)"|", (String)"\ufffc");
        key = TextUtil.replace((String)key, (String)",", (String)"\ufffd");
        key = TextUtil.replace((String)key, (String)"\\", (String)"\\\\");
        return key;
    }

    static String safeDecoding(String key) {
        key = TextUtil.replace((String)key, (String)"\ufffa", (String)"'");
        key = TextUtil.replace((String)key, (String)"\ufffb", (String)"\"");
        key = TextUtil.replace((String)key, (String)"\ufffc", (String)"|");
        key = TextUtil.replace((String)key, (String)"\ufffd", (String)",");
        return key;
    }

    static float calcTop(BTime start) {
        float top = (float)start.getHour() + (float)start.getMinute() / 60.0f;
        return top / 24.0f * 100.0f;
    }

    static float calcHeight(BTime finish, float top) {
        float height = (float)finish.getHour() + (float)finish.getMinute() / 60.0f;
        if (Float.compare(height, 0.0f) == 0) {
            height = 24.0f;
        }
        height = height / 24.0f * 100.0f;
        return height - top;
    }

    static void appendFormValue(StringBuilder formValue, BTime start, BTime finish, boolean isStatusNull, String valueWithoutUnits) {
        formValue.append(start.encodeToString()).append(',').append(finish.encodeToString()).append(',').append(isStatusNull).append(',').append(valueWithoutUnits).append('|');
    }

    static void addHeaders(HxOp op) {
        op.addStyleSheet(BOrd.make((String)"module://schedule/com/tridium/schedule/hx/schedule.css"));
        op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/save.js"));
        op.addJavaScript(BOrd.make((String)"module://schedule/com/tridium/schedule/hx/schedule.js"));
    }

    static void addOnloadReadOnly(HxOp op) {
        if (!op.canWrite()) {
            op.addOnload("schedule.setReadOnly(&quot;" + op.getPath() + "&quot;true&quot;);");
        }
    }

    static void addOnloadInit(HxOp op) {
        op.addOnload("schedule.init(&quot;" + op.getPath() + "&quot;);");
    }

    static void addOnloadNullStatus(HxOp op, Lexicon lex) {
        op.addOnload("schedule.setNullStatus(&quot;" + op.getPath() + "&quot; , &quot;" + lex.getText("day.null") + "&quot;);");
    }

    static void writeCommands(SmartCommand[] smartCommands, HxOp op, HtmlWriter out) throws Exception {
        if (op.canWrite() || op.getPath().isEmpty()) {
            BHxSmartTableView.writeCommands((SmartCommand[])smartCommands, (HxOp)op);
        } else {
            out.w((Object)"<div ").attr("style", "display: none;").w((Object)">");
            BHxSmartTableView.writeCommands((SmartCommand[])smartCommands, (HxOp)op);
            out.w((Object)"</div>");
        }
    }

    static void writeTemplateDiv(BWeeklySchedule schedule, HxOp op, HtmlWriter out) {
        BStatusValue templateStatusValue = (BStatusValue)schedule.getDefaultOutput().newCopy();
        BValue defaultValue = schedule.getDefaultOutput().getValueValue();
        if (defaultValue instanceof BBoolean) {
            defaultValue = BBoolean.make((!((BBoolean)defaultValue).getBoolean() ? 1 : 0) != 0);
            templateStatusValue.setValueValue(defaultValue);
        }
        templateStatusValue.setStatusNull(false);
        out.w((Object)"<div");
        out.w((Object)" class='schedule-HxScheduler-dayEvent");
        out.w((Object)" value-").w((Object)ViewUtil.getValueString(templateStatusValue));
        out.w((Object)"'");
        out.attr(" style", "display: none;");
        out.attr(" id", op.scope("template"));
        out.attr(" name", op.scope("template"));
        if (op.canWrite()) {
            out.attr(" onmousedown", "schedule.onselectedmousedown(this, event, '" + op.getPath() + "');");
            out.attr(" onmousemove", "schedule.onselectedmousemove(this, event, '" + op.getPath() + "');");
            out.attr(" onmouseup", "schedule.onselectedmouseup(this, event, '" + op.getPath() + "');");
            out.attr(" oncontextmenu", "smartTable.forceRightClick=true;schedule.contextMenu(this, event, '" + op.getPath() + "');smartTable.forceRightClick=false; return false;");
            out.attr(" ontouchstart", "schedule.onselectedmousedown(this, event, '" + op.getPath() + "');");
            out.attr(" ontouchmove", "schedule.onselectedmousemove(this, event, '" + op.getPath() + "');");
            out.attr(" ontouchend", "schedule.onselectedmouseup(this, event, '" + op.getPath() + "');");
        } else {
            out.attr(" onmousedown", "schedule.onreadonlyselectedmousedown(this, event, '" + op.getPath() + "');");
            out.attr(" oncontextmenu", "return smartTable.disableSelection(event);");
            out.attr(" ontouchstart", "schedule.onreadonlyselectedmousedown(this, event, '" + op.getPath() + "');");
        }
        out.attr(" value", defaultValue.toString(ViewUtil.withoutUnits((Context)op)));
        out.attr(" nullstatus", "false");
        out.w((Object)">");
        out.w((Object)defaultValue.toString((Context)op));
        out.w((Object)"</div>");
    }

    static void writeScheduleTableStart(HxOp op, HtmlWriter out) throws Exception {
        out.w((Object)"<div class='schedule-HxScheduler");
        out.w((Object)"'");
        out.attr(" id", op.scope("records"));
        out.attr(" name", op.scope("records"));
        out.w((Object)">");
        out.w((Object)"<table width='100%' cellpadding='0' cellspacing='0'");
        out.attr(" onmouseleave", "schedule.leaveTable(this, event, '" + op.getPath() + "');");
        out.attr(" onselectstart", "smartTable.disableSelection(event);");
        out.attr(" oncontextmenu", "return smartTable.disableSelection(event);");
        out.attr(" onmouseup", "schedule.onselectedmouseup(this, event, '" + op.getPath() + "');");
        out.attr(" ontouchend", "schedule.onselectedmouseup(this, event, '" + op.getPath() + "');");
        out.w((Object)">");
        out.w((Object)"<tr>");
        ViewUtil.writeTimeColumn("4%", op);
    }

    static void writeScheduleTableEnd(boolean isSpecialEventsView, HxOp op, HtmlWriter out, Lexicon lex) throws Exception {
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
        ViewUtil.writeValueFooter(isSpecialEventsView, op, out, lex);
        out.w((Object)"</div>");
    }

    static void writeTimeColumn(String size, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<td valign='top'");
        if (size != null) {
            out.attr(" style", "width:" + size + ';');
        }
        out.w((Object)">");
        out.w((Object)"<div class='schedule-HxScheduler-dayBox'>");
        out.w((Object)"<div class='schedule-HxScheduler-columnHeader'><b>&nbsp;</b></div>");
        out.w((Object)"<div class='schedule-HxScheduler-timeGrid'>");
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 3; ++j) {
                out.w((Object)"<div class='schedule-HxScheduler-daySlot schedule-HxScheduler-times");
                if (size == null) {
                    out.w((Object)" schedule-HxScheduler-timesRight");
                }
                if (i == 0 && j == 0) {
                    out.w((Object)" schedule-HxScheduler-timesTop");
                }
                if (i == 7 && j == 2) {
                    out.w((Object)" schedule-HxScheduler-timesBottom");
                }
                out.w((Object)"'>");
                if (j == 0 || i == 7 && j == 2) {
                    int index = i;
                    if (i == 7 && j == 2) {
                        index = 8;
                    }
                    out.w((Object)TextUtil.replace((String)TimeFormat.format((BTime)timeColumn[index], (Context)op), (String)" ", (String)"&nbsp;"));
                }
                out.w((Object)"</div>");
            }
        }
        out.w((Object)"</div>");
        out.w((Object)"</div>");
        out.w((Object)"</td>");
    }

    static void writeDayGridBoxStart(String day, String columnHeader, HxOp op, HtmlWriter out) {
        out.w((Object)"<div class='schedule-HxScheduler-dayBox'");
        if (op.canWrite()) {
            out.attr(" onmousemove", "schedule.ondayselectedmousemove(this, event, '" + op.getPath() + "');");
            out.attr(" onmouseup", "schedule.ondayselectedmouseup(this, event, '" + op.getPath() + "');");
            out.attr(" onmousedown", "schedule.ondayselectedmousedown(this, event, '" + op.getPath() + "');");
            out.attr(" ontouchstart", "schedule.ondayselectedmousedown(this, event, '" + op.getPath() + "');");
            out.attr(" ontouchmove", "schedule.ondayselectedmousemove(this, event, '" + op.getPath() + "');");
            out.attr(" ontouchend", "schedule.ondayselectedmouseup(this, event, '" + op.getPath() + "');");
        }
        out.attr(" oncontextmenu", "return smartTable.disableSelection(event);");
        out.attr(" day", day);
        out.w((Object)">");
        out.w((Object)"<div class='schedule-HxScheduler-columnHeader'><b>").safe((Object)columnHeader).w((Object)"</b></div>");
        out.w((Object)"<div class='schedule-HxScheduler-dayGrid");
        out.w((Object)"'");
        out.attr(" id", op.scope(day));
        if (op.canWrite()) {
            out.attr(" oncontextmenu", "smartTable.forceRightClick=true;schedule.daymousedown(this, event, '" + op.getPath() + "');smartTable.forceRightClick=false; return false;");
        }
        out.w((Object)">");
        for (int i = 0; i < 24; ++i) {
            out.w((Object)"<div class='schedule-HxScheduler-daySlot");
            if (i == 0) {
                out.w((Object)"First");
            } else if (i % 3 == 0) {
                out.w((Object)"Major");
            }
            out.w((Object)"'");
            if (op.canWrite()) {
                out.attr(" onmousedown", "schedule.onmousedown(this, event, '" + op.getPath() + "');");
                out.attr(" onmousemove", "schedule.onmousemove(this, event, '" + op.getPath() + "');");
                out.attr(" onmouseup", "schedule.onmouseup(this, event, '" + op.getPath() + "');");
                out.attr(" oncontextmenu", "smartTable.forceRightClick=true;schedule.onmousedown(this, event, '" + op.getPath() + "');smartTable.forceRightClick=false; return false;");
                out.attr(" ontouchstart", "schedule.onmousedown(this, event, '" + op.getPath() + "');");
                out.attr(" ontouchmove", "schedule.onmousemove(this, event, '" + op.getPath() + "');");
                out.attr(" ontouchend", "schedule.onmouseup(this, event, '" + op.getPath() + "');");
            }
            out.w((Object)">&nbsp;</div>");
        }
    }

    private static void writeValueFooter(boolean isSpecialEventsView, HxOp op, HtmlWriter out, Lexicon lex) throws Exception {
        out.w((Object)"<div class='schedule-HxScheduler-modBox'>");
        out.w((Object)"<table>");
        out.w((Object)"<tr><td class='schedule-HxScheduler-fieldName'>").safe((Object)lex.getText("start")).w((Object)":</td><td>");
        HxOp fieldOp = op.make("start", new OrdTarget((OrdTarget)op, (BObject)BTime.DEFAULT));
        fieldOp.mergeFacets(BFacets.make((String)"showSeconds", (boolean)false));
        if (!op.canWrite()) {
            fieldOp.setReadonly(true);
        }
        BHxFieldEditor timeEditor = BHxFieldEditor.makeFor((BObject)BTime.DEFAULT, (Context)op);
        timeEditor.write(fieldOp);
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr><td class='schedule-HxScheduler-fieldName'>").safe((Object)lex.getText("finish")).w((Object)":</td><td>");
        fieldOp = op.make("finish", new OrdTarget((OrdTarget)op, (BObject)BTime.DEFAULT));
        fieldOp.mergeFacets(BFacets.make((String)"showSeconds", (boolean)false));
        if (!op.canWrite()) {
            fieldOp.setReadonly(true);
        }
        timeEditor.write(fieldOp);
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr><td class='schedule-HxScheduler-fieldName'>").safe((Object)lex.getText("output")).w((Object)":</td><td>");
        BWeeklySchedule schedule = (BWeeklySchedule)op.get();
        BStatusValue defaultStatusValue = (BStatusValue)schedule.getDefaultOutput().newCopy();
        BValue value = schedule.getDefaultOutput().getValueValue();
        if (isSpecialEventsView && value instanceof BBoolean) {
            defaultStatusValue.setValueValue((BValue)BBoolean.make((!((BBoolean)value).getBoolean() ? 1 : 0) != 0));
        }
        HxOp valueOp = op.make("status", new OrdTarget((OrdTarget)op, (BObject)defaultStatusValue));
        if (!op.canWrite()) {
            valueOp.setReadonly(true);
        }
        valueOp.mergeFacets(op.getFacets());
        BEnumRange range = ViewUtil.checkEnumRange(schedule, value, valueOp);
        BHxScheduleStatusValueFE.INSTANCE.write(valueOp);
        out.w((Object)"</td></tr>");
        if (!isSpecialEventsView) {
            if (value instanceof BDouble) {
                HxOp numValueOp = op.make("value", new OrdTarget((OrdTarget)op, (BObject)defaultStatusValue.getValueValue()));
                numValueOp.mergeFacets(op.getFacets());
                BValue defaultValueValue = BHxNumericFE.INSTANCE.getValue(numValueOp, BHxNumericFE.Convert.display);
                defaultStatusValue.setValueValue(defaultValueValue);
            } else if (value instanceof BBoolean) {
                String s = BBoolean.toString((boolean)((BBoolean)value).getBoolean(), (Context)op);
                defaultStatusValue = (BStatusValue)BStatusValue.make((BObject)BString.make((String)s));
            }
            String defaultOutputText = Lexicon.make(BHxWeeklyScheduler.class).getText("defaultOutputStatement", new Object[]{defaultStatusValue});
            out.w((Object)"<tr><td colspan=2 class='schedule-HxScheduler-fieldName'>").safe((Object)defaultOutputText);
            out.w((Object)"</td></tr>");
        }
        out.w((Object)"</table>");
        out.w((Object)"</div>");
        op.addOnload("schedule.initBajaType(&quot;" + value.getType() + "&quot;, &quot;" + op.getPath() + "&quot;);");
        ViewUtil.addSetValueRange(schedule, value, range, op);
        ViewUtil.addEvents(op);
    }

    static BEnumRange checkEnumRange(BWeeklySchedule schedule, BValue value, HxOp valueOp) {
        BEnumRange range = null;
        if (value instanceof BEnum) {
            range = (BEnumRange)schedule.getFacets().get("range");
            if (range == null) {
                range = BEnumRange.NULL;
            } else if (range.getOrdinals().length > 0) {
                valueOp.mergeFacets(BHxEnumFE.PREFER_FROZEN_EDITOR);
            }
        }
        return range;
    }

    static void addSetValueRange(BWeeklySchedule schedule, BValue value, BEnumRange range, HxOp op) {
        if (value instanceof BBoolean) {
            String rangeStr = String.format("{%s=true, %s=false}", schedule.getFacets().get("trueText"), schedule.getFacets().get("falseText"));
            op.addOnload("schedule.setValueRange(&quot;" + rangeStr + "&quot;, &quot;" + op.getPath() + "&quot;);");
        } else if (value instanceof BEnum) {
            StringJoiner encodedRange = new StringJoiner(",", "{", "}");
            for (int ordinal : range.getOrdinals()) {
                encodedRange.add(range.getDisplayTag(ordinal, (Context)op) + '=' + ordinal);
            }
            op.addOnload("schedule.setValueRange(&quot;" + encodedRange.toString() + "&quot;, &quot;" + op.getPath() + "&quot;);");
        }
    }

    static void addEvents(HxOp op) {
        if (op.canWrite()) {
            HxTabUtil.addEvent((String)HxTabUtil.BLUR, (String)"schedule.valueBlur", (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope("status.value.value"), (String)"", (String)op.getPath(), (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)"schedule.valueChange", (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope("status.value.value"), (String)"", (String)op.getPath(), (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.KEY_UP, (String)"schedule.valueChange", (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope("status.value.value"), (String)"", (String)op.getPath(), (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)"schedule.valueChange", (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope("status.status"), (String)"", (String)op.getPath(), (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)"schedule.timeChange", (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope("start.time.hour"), (String)"start", (String)op.getPath(), (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.FOCUS, (String)"schedule.timeFocus", (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope("start.time.hour"), (String)"start", (String)op.getPath(), (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)"schedule.timeChange", (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope("start.time.twelveHour"), (String)"start", (String)op.getPath(), (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)"schedule.timeChange", (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope("start.time.min"), (String)"start", (String)op.getPath(), (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)"schedule.timeChange", (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope("start.time.ampm"), (String)"start", (String)op.getPath(), (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)"schedule.timeChange", (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope("finish.time.hour"), (String)"finish", (String)op.getPath(), (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)"schedule.timeChange", (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope("finish.time.twelveHour"), (String)"finish", (String)op.getPath(), (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)"schedule.timeChange", (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope("finish.time.min"), (String)"finish", (String)op.getPath(), (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)"schedule.timeChange", (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope("finish.time.ampm"), (String)"finish", (String)op.getPath(), (HxOp)op);
        }
    }

    public static class Delete
    extends SmartCommand {
        public Delete(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public String getName(HxOp op) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public String getEnabledInvokeCode(HxOp op) {
            String quote = HxUtil.getOuterQuote((HxOp)op);
            return "schedule.deleteSelected(" + quote + op.getPath() + quote + ");";
        }
    }

    public static class AllDay
    extends SmartCommand {
        public AllDay(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "allDay";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public String getEnabledInvokeCode(HxOp op) {
            String quote = HxUtil.getOuterQuote((HxOp)op);
            return "schedule.allDay(this, event, " + quote + op.getPath() + quote + ");";
        }
    }

    public static class PasteDay
    extends SmartCommand {
        public PasteDay(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "pasteDay";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public String getEnabledInvokeCode(HxOp op) {
            String quote = HxUtil.getOuterQuote((HxOp)op);
            return "schedule.pasteDay(this, event, " + quote + op.getPath() + quote + ");";
        }

        public String getEnablePolicyInvokeCode(HxOp op) {
            if (!op.canWrite() && !this.readonlyEnablePolicy(op)) {
                return "false";
            }
            return "schedule.hasPaste(&quot;" + op.getPath() + "&quot;);";
        }
    }

    public static class CopyDay
    extends SmartCommand {
        public CopyDay(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "copyDay";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public String getEnabledInvokeCode(HxOp op) {
            String quote = HxUtil.getOuterQuote((HxOp)op);
            return "schedule.copyDay(this, event, " + quote + op.getPath() + quote + ");";
        }
    }

    public static class ClearDay
    extends SmartCommand {
        public ClearDay(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "clearDay";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public String getEnabledInvokeCode(HxOp op) {
            String quote = HxUtil.getOuterQuote((HxOp)op);
            return "schedule.clearDay(null, event, " + quote + op.getPath() + quote + ");";
        }
    }
}

