/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx.ui;

import com.tridiumx.entsec.ldap.importconfig.BLdapImportConfig;
import com.tridiumx.ldapDriver.BLdapSearchControlScope;
import com.tridiumx.ldapDriver.BLdapServer;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.util.Lexicon;

public class LdapImportDialogPreferences
extends Dialog {
    static final Lexicon secUtilLex = Lexicon.make(LdapImportDialogPreferences.class);
    private Command handler;
    BLdapServer server;

    public LdapImportDialogPreferences(Command handler) {
        super(secUtilLex.getText("importDialog.label"), handler);
        this.handler = handler;
    }

    public void setLdapServer(BLdapServer server1) {
        this.server = server1;
    }

    public BLdapServer getLdapServer() {
        return this.server;
    }

    protected void writeContent(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        String text = TextUtil.replace((String)secUtilLex.getText("importDialog.localSettingsDescription"), (String)"\n", (String)"<br/>");
        text = TextUtil.replace((String)text, (String)"\r", (String)"");
        out.w((Object)text);
        out.w((Object)"<br/>");
        out.w((Object)"<br/>");
        BLdapServer server = this.getLdapServer();
        out.w((Object)"<table>");
        out.w((Object)"<tr><td class='smartTable-setup-label'>");
        BString userSearchBase = BString.make((String)server.getUserSearchBase());
        BHxFieldEditor userSearchBaseEditor = BHxFieldEditor.makeFor((BObject)userSearchBase, (Context)op);
        HxOp userSearchBaseFieldOp = op.make("userSearchBase", (BObject)userSearchBase, null);
        out.safe((Object)secUtilLex.getText("userSearchBase"));
        out.w((Object)"</td><td>");
        userSearchBaseEditor.write(userSearchBaseFieldOp);
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr><td class='smartTable-setup-label'>");
        BString userSearchFilter = BString.make((String)server.getUserSearchFilter());
        BHxFieldEditor userSearchFilterEditor = BHxFieldEditor.makeFor((BObject)userSearchFilter, (Context)op);
        HxOp userSearchFilterFieldOp = op.make("userSearchFilter", (BObject)userSearchFilter, null);
        out.safe((Object)secUtilLex.getText("userSearchFilter"));
        out.w((Object)"</td><td>");
        userSearchFilterEditor.write(userSearchFilterFieldOp);
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr><td class='smartTable-setup-label'>");
        BLdapSearchControlScope searchScope = (BLdapSearchControlScope)server.get(BLdapServer.searchScope);
        HxOp fieldOp1 = op.make("searchScope", (BObject)searchScope, server.getSlotFacets((Slot)BLdapServer.searchScope));
        BHxFieldEditor searchScopeEditor = BHxFieldEditor.makeFor((BObject)searchScope, (Context)op);
        out.safe((Object)secUtilLex.getText("searchScope"));
        out.w((Object)"</td><td>");
        searchScopeEditor.write(fieldOp1);
        out.w((Object)"</td></tr>");
        BLdapImportConfig importConfig = (BLdapImportConfig)server.getMixIn(BLdapImportConfig.TYPE);
        out.w((Object)"<tr><td class='smartTable-setup-label'>");
        BString groupAttr = BString.make((String)importConfig.getGroupAttribute());
        BHxFieldEditor groupAttributeEditor = BHxFieldEditor.makeFor((BObject)groupAttr, (Context)op);
        HxOp groupAttributeFieldOp = op.make("groupAttribute", (BObject)groupAttr, null);
        out.safe((Object)secUtilLex.getText("groupAttribute"));
        out.w((Object)"</td><td>");
        groupAttributeEditor.write(groupAttributeFieldOp);
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr><td class='smartTable-setup-label'>");
        BBoolean inactiveUsers = BBoolean.make((boolean)importConfig.getAllowNewInactiveUsers());
        BHxFieldEditor inActiveUsersEditor = BHxFieldEditor.makeFor((BObject)inactiveUsers, (Context)op);
        HxOp inActiveUsersFieldOp = op.make("allowNewInactiveUsers", (BObject)inactiveUsers, null);
        out.safe((Object)secUtilLex.getText("allowNewInactiveUsers"));
        out.w((Object)"</td><td>");
        inActiveUsersEditor.write(inActiveUsersFieldOp);
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr><td class='smartTable-setup-label'>");
        BString statusAttribute = BString.make((String)importConfig.getStatusAttribute());
        BHxFieldEditor statusAttributeEditor = BHxFieldEditor.makeFor((BObject)statusAttribute, (Context)op);
        HxOp statusAttributeFieldOp = op.make("statusAttribute", (BObject)statusAttribute, null);
        out.safe((Object)secUtilLex.getText("statusAttribute"));
        out.w((Object)"</td><td>");
        statusAttributeEditor.write(statusAttributeFieldOp);
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr><td class='smartTable-setup-label'>");
        BString activeStatusValues = BString.make((String)importConfig.getActiveStatusValues());
        BHxFieldEditor activeStatusValuesEditor = BHxFieldEditor.makeFor((BObject)activeStatusValues, (Context)op);
        HxOp activeStatusValuesFieldOp = op.make("activeStatusValues", (BObject)activeStatusValues, null);
        out.safe((Object)secUtilLex.getText("activeStatusValues"));
        out.w((Object)"</td><td>");
        activeStatusValuesEditor.write(activeStatusValuesFieldOp);
        out.w((Object)"</td></tr>");
        out.w((Object)"</table>");
    }
}

