/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx.ui.searchbase;

import com.tridiumx.entsec.ldap.util.ExportPersonsDataUtility;
import java.util.ArrayList;
import java.util.List;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="contextName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="depthIndexId", type="String", defaultValue="", flags=1), @NiagaraProperty(name="ldapServerName", type="String", defaultValue="", flags=1)})
public class BLdapSearchBaseContext
extends BComponent {
    @Generated
    public static final Property contextName = BLdapSearchBaseContext.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property depthIndexId = BLdapSearchBaseContext.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property ldapServerName = BLdapSearchBaseContext.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLdapSearchBaseContext.class);
    private List<BLdapSearchBaseContext> children = new ArrayList<BLdapSearchBaseContext>();
    private BLdapSearchBaseContext parentContext;

    @Generated
    public String getContextName() {
        return this.getString(contextName);
    }

    @Generated
    public void setContextName(String v) {
        this.setString(contextName, v, null);
    }

    @Generated
    public String getDepthIndexId() {
        return this.getString(depthIndexId);
    }

    @Generated
    public void setDepthIndexId(String v) {
        this.setString(depthIndexId, v, null);
    }

    @Generated
    public String getLdapServerName() {
        return this.getString(ldapServerName);
    }

    @Generated
    public void setLdapServerName(String v) {
        this.setString(ldapServerName, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public List<BLdapSearchBaseContext> getChildren() {
        return this.children;
    }

    public void setChildren(List<BLdapSearchBaseContext> children) {
        this.children = children;
    }

    public BLdapSearchBaseContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(BLdapSearchBaseContext parentContext) {
        this.parentContext = parentContext;
    }

    public BLdapSearchBaseContext() {
    }

    public BLdapSearchBaseContext(String contextName) {
        this.setContextName(contextName);
    }

    public static BLdapSearchBaseContext getInstance(String contextName) {
        return new BLdapSearchBaseContext(contextName);
    }

    public void setDepthIndexId(int depthIndexId) {
        if (this.parentContext != null) {
            this.setDepthIndexId(this.getParentContext().getDepthIndexId().concat(".").concat(String.valueOf(depthIndexId)));
        } else {
            this.setDepthIndexId(String.valueOf(depthIndexId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BLdapSearchBaseContext> fetchChildren() {
        if (this.children == null || this.children.size() == 0) {
            DirContext ldapContext = null;
            try {
                ldapContext = ExportPersonsDataUtility.getSelectedLdapServer((String)this.getLdapServerName()).connect();
            }
            catch (NamingException e) {
                throw new BajaRuntimeException(this.getLexicon().getText("ldap.server.connecion.failed"));
            }
            try {
                NamingEnumeration<NameClassPair> answer = ldapContext.list(this.getContextNameWithParentName());
                int index = 0;
                while (answer.hasMoreElements()) {
                    NameClassPair nameclass = answer.next();
                    BLdapSearchBaseContext child = new BLdapSearchBaseContext(nameclass.getName());
                    child.setParentContext(this);
                    child.setLdapServerName(this.getLdapServerName());
                    child.setDepthIndexId(++index);
                    this.children.add(child);
                }
            }
            catch (NamingException e) {
            }
            finally {
                try {
                    ldapContext.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.children;
    }

    public String getContextNameWithParentName() {
        StringBuilder fullContextName = new StringBuilder();
        if (this.getParentContext() != null) {
            fullContextName.append(this.getContextName()).append(",").append(this.getParentContext().getContextNameWithParentName());
        } else {
            fullContextName.append(this.getContextName());
        }
        return fullContextName.toString();
    }

    public void printTree() {
        System.out.println(depthIndexId + " - " + this.getContextNameWithParentName());
        List<BLdapSearchBaseContext> nextNodes = this.fetchChildren();
        for (BLdapSearchBaseContext searchBaseContext : nextNodes) {
            searchBaseContext.printTree();
        }
    }
}

