/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.nrio.device.handlers.command;

import com.tridium.hx.ErrorDialog;
import com.tridiumx.entsecHx.factory.handlers.CommandHandler;
import com.tridiumx.entsecHx.nrio.util.NrioUtil;
import javax.baja.hx.BHxView;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;

public class RenameIoPointCommandHandler
extends CommandHandler {
    private ErrorDialog invalidNameError = new ErrorDialog("Rename Error", (Throwable)new Exception("Invalid name specified"));
    private ErrorDialog missingNameError = new ErrorDialog("Rename Error", (Throwable)new Exception("New name is an empty string"));
    private ErrorDialog sameNameError = new ErrorDialog("Rename Cancelled", (Throwable)new Exception("New name matches old name"));

    public RenameIoPointCommandHandler(BHxView view) {
        super(view);
    }

    @Override
    public void handle(HxOp op) {
        if (NrioUtil.make(op).isDatabaseEmpty()) {
            return;
        }
        String newName = op.getFormValue("newName");
        BComponent target = BOrd.make((String)op.getFormValue("targetOrd")).get().asComponent();
        BComponent parent = target.getParent().asComponent();
        if (newName != null && !newName.equals("")) {
            String escapedName = SlotPath.escape((String)newName);
            if (SlotPath.isValidName((String)escapedName)) {
                if (!escapedName.equals(SlotPath.escape((String)target.getDisplayName((Context)op)))) {
                    try {
                        parent.rename(target.getPropertyInParent(), escapedName);
                        this.refresh(op);
                    }
                    catch (Exception ex) {
                        this.refresh(op);
                    }
                } else {
                    this.displayError((Dialog)this.sameNameError, op);
                }
            } else {
                this.displayError((Dialog)this.invalidNameError, op);
            }
        } else {
            this.displayError((Dialog)this.missingNameError, op);
        }
    }

    private void displayError(Dialog dialog, HxOp op) {
        try {
            dialog.open(op.make((OrdTarget)op));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

