/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.nrio.device.handlers.content;

import com.tridium.nrio.enums.BNrioIoTypeEnum;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsecHx.factory.handlers.ContentHandler;
import com.tridiumx.entsecHx.nrio.util.INrioLexicon;
import com.tridiumx.entsecHx.nrio.util.INrioPointCategories;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.util.TextUtil;

public class ConfigureIoPointContentHandler
extends ContentHandler
implements INrioPointCategories,
INrioLexicon {
    @Override
    public void writeContent(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        if (op.getFormValue("learnPoint") == null) {
            out.w((Object)"<b>No points are currently available for configuration</b>");
            return;
        }
        out.w((Object)("<b>" + configureIoPointStepComment + "</b><br /><br />"));
        this.writeControlPointDetails(op);
        BHxSmartTableView.writeFormValue((String)"learnPoint", (String)op.getFormValue("learnPoint"), (HxOp)op);
        String ioCategory = op.getFormValue("ioCategory");
        int selectedIndex = 0;
        if (ioCategory.equals("temperatureInput")) {
            selectedIndex = 1;
        } else if (ioCategory.equals("resistiveInput")) {
            selectedIndex = 2;
        } else if (ioCategory.equals("digitalInput")) {
            selectedIndex = 3;
        } else if (ioCategory.equals("highSpeedCounter")) {
            selectedIndex = 4;
        }
        op.addOnload("document.getElementById('ioType').selectedIndex=" + selectedIndex);
    }

    private void writeControlPointDetails(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        String[] tokens = this.parse(op.getFormValue("learnPoint"));
        if (tokens.length == 0) {
            return;
        }
        String name = tokens[0];
        String type = tokens[1];
        HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
        out.w((Object)"<td>");
        out.w((Object)"Name");
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        out.w((Object)"<input type='text' name='").w((Object)op.scope("ioName")).w((Object)"' value='").w((Object)name).w((Object)"' />");
        out.w((Object)"</td>");
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
        out.w((Object)"<td>");
        out.w((Object)"IO Type");
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        out.w((Object)"<select ");
        out.attr("id", op.scope("ioType"));
        out.attr("name", op.scope("ioType"));
        out.w((Object)">");
        this.writeOptions(BNrioIoTypeEnum.make((String)type), op);
        out.w((Object)"</select>");
        out.w((Object)"</td>");
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
    }

    private void writeOptions(BNrioIoTypeEnum type, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        switch (type.getOrdinal()) {
            case 4: {
                for (int i = 0; i < uiArray.length; ++i) {
                    out.w((Object)"<option ");
                    out.attr("value", uiArray[i]);
                    out.w((Object)">").w((Object)TextUtil.toFriendly((String)uiArray[i])).w((Object)"</option>");
                }
                break;
            }
            case 2: {
                for (int i = 0; i < roArray.length; ++i) {
                    out.w((Object)"<option ");
                    out.attr("value", roArray[i]);
                    out.w((Object)">").w((Object)TextUtil.toFriendly((String)roArray[i])).w((Object)"</option>");
                }
                break;
            }
            case 5: {
                for (int i = 0; i < aoArray.length; ++i) {
                    out.w((Object)"<option ");
                    out.attr("value", aoArray[i]);
                    out.w((Object)">").w((Object)TextUtil.toFriendly((String)aoArray[i])).w((Object)"</option>");
                }
                break;
            }
        }
    }

    private String[] parse(String formValue) {
        if (formValue == null) {
            return new String[0];
        }
        return TextUtil.split((String)formValue, (char)':');
    }
}

