/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx;

import com.tridium.orion.BIMappable;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.priv.util.CountingUtil;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsec.orionTools.BIBackgroundAssociation;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsecHx.orionHx.BHxDynamicTableView;
import com.tridiumx.entsecHx.orionToolsHx.HxRemoteUtil;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class Delete
extends SmartCommand {
    protected ConfirmDialog dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this);

    public Delete(BHxView view) {
        super(view, smartTableHxLexModule);
    }

    public String getName(HxOp op) {
        return "delete";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.anySelection;
    }

    public boolean readonlyEnablePolicy(HxOp op) {
        if (!op.canWrite()) {
            return false;
        }
        BDynamicTable dt = (BDynamicTable)op.get();
        if (!dt.getPermissions((Context)op).hasAdminWrite()) {
            return false;
        }
        Type rowType = dt.getRowType().getTypeSpec().getResolvedType();
        return rowType.is(BIMappable.TYPE);
    }

    public Object[] getSubjects(HxOp op) {
        return ((BHxDynamicTableView)this.getView()).getSubjects(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HxOp op) throws Exception {
        BDynamicTable dt = (BDynamicTable)op.get();
        OrionSession session = null;
        try {
            session = dt.getOrionDatabase().createSession((Context)op);
            Object[] subjects = this.getSubjects(op);
            if (!this.dlg.isSubmit(op)) {
                String references;
                Type type = dt.getRowType().getTypeSpec().getResolvedType();
                String message = this.lexModule.getText("confirmDelete", (Context)op, new Object[]{type.getDisplayName((Context)op)});
                if (subjects.length > 1) {
                    Lexicon subjectLex = Lexicon.make((Class)type.getTypeClass());
                    String displayName = subjectLex.get(type.getTypeName() + ".displayName.plural", type.getDisplayName(null) + "s");
                    message = this.lexModule.getText("confirmDeletes", (Context)op, new Object[]{"" + subjects.length, displayName});
                }
                if ((references = this.makeReferences(subjects, session, op)) != null && references.length() > 0) {
                    message = message + "\n\n" + references;
                }
                this.dlg.open(message, op);
                return;
            }
            for (int i = 0; i < subjects.length; ++i) {
                BOrionObject o = (BOrionObject)subjects[i];
                if (o instanceof BIOrdMappable) {
                    BComponent mapped;
                    BIOrdMappable mappable = (BIOrdMappable)o;
                    BOrd ord = mappable.getMappedOrd();
                    String stationName = mappable.getStationName();
                    if (stationName.equals(Sys.getStation().getStationName())) {
                        if (ord != BOrd.DEFAULT) {
                            mapped = null;
                            try {
                                mapped = (BComponent)ord.get();
                            }
                            catch (Exception e) {
                                session.delete((BIOrionObject)o);
                                continue;
                            }
                            if (Flags.isReadonly((BComplex)mapped.getParent(), (Slot)mapped.getPropertyInParent())) {
                                throw new BajaRuntimeException("You cannot delete readonly " + HxTabUtil.getPluralDisplayName((Type)mapped.getType(), (Context)op) + ". " + mapped.toDisplayPathString((Context)op) + " is readonly.");
                            }
                            mapped.getParent().asComponent().remove(mapped.getPropertyInParent(), (Context)op);
                        }
                    } else if (RemoteUtil.isStationConfigured((String)stationName)) {
                        if (!RemoteUtil.isStationValid((String)stationName)) {
                            throw new BajaRuntimeException("You cannot delete a component while a configured station is down: " + stationName);
                        }
                        mapped = HxRemoteUtil.getRemoteComponent(ord, stationName, op);
                        if (RemoteUtil.isSubordinate() && mapped != null) {
                            throw new BajaRuntimeException("On a subordinate, you cannot delete a component still residing on another station: " + stationName);
                        }
                        if (mapped != null) {
                            mapped.lease();
                            if (Flags.isReadonly((BComplex)mapped.getParent(), (Slot)mapped.getPropertyInParent())) {
                                throw new BajaRuntimeException("You cannot delete readonly " + HxTabUtil.getPluralDisplayName((Type)mapped.getType(), (Context)op) + ". " + mapped.toDisplayPathString((Context)op) + " is readonly.");
                            }
                            BComponent parent = (BComponent)mapped.getParent();
                            parent.remove(mapped.getPropertyInParent(), (Context)op);
                        }
                    }
                }
                session.delete((BIOrionObject)o);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        BHxDynamicTableView.INSTANCE.reloadTable(op);
    }

    public String makeReferences(Object[] subjects, OrionSession session, HxOp op) throws Exception {
        BOrionObject o = (BOrionObject)subjects[0];
        StringBuffer b = new StringBuffer();
        BOrionDatabase db = o.getOrionDatabase();
        OrionType oOrionType = o.getOrionType();
        BTypeDependency[] refTypes = db.getDependentTypes(oOrionType);
        Property[] directProps = o.getPropertiesArray();
        for (int i = 0; i < directProps.length; ++i) {
            String confirmDeleteEntry;
            if (!directProps[i].getType().is(BRef.TYPE)) continue;
            BRef propertyRef = (BRef)directProps[i].getDefaultValue();
            Lexicon lex = Lexicon.make((Class)oOrionType.getTypeClass());
            if (lex.get(confirmDeleteEntry = "confirmDelete." + oOrionType.getTypeName() + ".to." + propertyRef.getTargetTypeSpec().getTypeName()) == null) continue;
            int count = 0;
            for (int k = 0; k < subjects.length; ++k) {
                BRef ref = (BRef)((BOrionObject)subjects[k]).get(directProps[i]);
                if (!ref.isBound()) continue;
                ++count;
            }
            if (count <= 0) continue;
            String typeDisplayName = null;
            if (count > 1) {
                typeDisplayName = lex.get(oOrionType.getTypeName() + ".to." + propertyRef.getTargetTypeSpec().getTypeName());
                if (typeDisplayName == null) {
                    typeDisplayName = lex.get(propertyRef.getTargetTypeSpec().getTypeName() + ".displayName.plural", propertyRef.getTargetTypeSpec().getResolvedType().getDisplayName(null) + "s");
                }
            } else {
                typeDisplayName = propertyRef.getTargetTypeSpec().getResolvedType().getDisplayName((Context)op);
            }
            String text = lex.getText(confirmDeleteEntry, new Object[]{"" + count, typeDisplayName});
            b.append(text + "\n");
        }
        if (refTypes.length == 0) {
            return b.toString();
        }
        int columns = refTypes.length;
        for (int i = 0; i < columns; ++i) {
            String confirmDeleteEntry;
            String displayName = "";
            BOrionTypeId fromId = refTypes[i].getFromTypeId();
            OrionType orionType = db.getType(fromId);
            if (orionType.is(BIBackgroundAssociation.TYPE)) continue;
            if (orionType.isAssociation()) {
                Property fromProp = orionType.getProperty(refTypes[i].getFromProperty());
                Property[] props = orionType.getProperties();
                for (int j = 0; j < props.length; ++j) {
                    String confirmDeleteEntry2;
                    Lexicon lex;
                    OrionType refOrionType;
                    if (props[j].equals(fromProp) || !props[j].getType().is(BRef.TYPE) || (refOrionType = db.getType(((BRef)props[j].getDefaultValue()).getTargetOrionTypeId())).is(BIBackgroundAssociation.TYPE) || (lex = Lexicon.make((Class)refOrionType.getTypeClass())).get(confirmDeleteEntry2 = "confirmDelete." + oOrionType.getTypeName() + ".to." + orionType.getTypeName() + ".to." + refOrionType.getTypeName()) == null) continue;
                    int count = 0;
                    for (int k = 0; k < subjects.length; ++k) {
                        BRef ref = BRef.make((BIOrionObject)((BIOrionObject)subjects[k]));
                        count += CountingUtil.getCount((OrionType)orionType, (Property)orionType.getProperty(refTypes[i].getFromProperty()), (BSimple)ref, (OrionSession)session);
                    }
                    if (count <= 0) continue;
                    String typeDisplayName = null;
                    if (count > 1) {
                        typeDisplayName = lex.get(oOrionType.getTypeName() + ".to." + orionType.getTypeName() + ".to." + refOrionType.getTypeName());
                        if (typeDisplayName == null) {
                            typeDisplayName = lex.get(refOrionType.getTypeName() + ".displayName.plural", refOrionType.getDisplayName(null) + "s");
                        }
                    } else {
                        typeDisplayName = refOrionType.getDisplayName((Context)op);
                    }
                    String text = lex.getText(confirmDeleteEntry2, new Object[]{"" + count, typeDisplayName});
                    b.append(text + "\n");
                }
                continue;
            }
            Lexicon lex = Lexicon.make((Class)orionType.getTypeClass());
            if (lex.get(confirmDeleteEntry = "confirmDelete." + oOrionType.getTypeName() + ".to." + orionType.getTypeName()) == null) continue;
            Property refProp = orionType.getProperty(refTypes[i].getFromProperty());
            int count = 0;
            for (int k = 0; k < subjects.length; ++k) {
                BRef ref = BRef.make((BIOrionObject)((BIOrionObject)subjects[k]));
                count += CountingUtil.getCount((OrionType)orionType, (Property)refProp, (BSimple)ref, (OrionSession)session);
            }
            if (count <= 0) continue;
            String typeDisplayName = null;
            if (count > 1) {
                typeDisplayName = lex.get(oOrionType.getTypeName() + ".to." + orionType.getTypeName());
                if (typeDisplayName == null) {
                    typeDisplayName = lex.get(orionType.getTypeName() + ".displayName.plural", orionType.getDisplayName(null) + "s");
                }
            } else {
                typeDisplayName = orionType.getDisplayName((Context)op);
            }
            String text = lex.getText(confirmDeleteEntry, new Object[]{"" + count, typeDisplayName});
            b.append(text + "\n");
        }
        return b.toString();
    }
}

