/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx;

import com.tridium.orion.BIMappable;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.RenameCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsecHx.orionHx.BHxDynamicTableView;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class MappableRenameCommand
extends RenameCommand {
    public MappableRenameCommand(BHxView view) {
        super(view, smartTableHxLexModule);
    }

    public String getName(HxOp op) {
        return "rename";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.singleSelection;
    }

    public boolean readonlyEnablePolicy(HxOp op) {
        if (!op.canWrite()) {
            return false;
        }
        BDynamicTable dt = (BDynamicTable)op.get();
        if (!dt.getPermissions((Context)op).hasAdminWrite()) {
            return false;
        }
        Type rowType = dt.getRowType().getTypeSpec().getResolvedType();
        return rowType.is(BIMappable.TYPE);
    }

    public BComponent getComponent(HxOp op) {
        BOrionObject o = (BOrionObject)((BHxDynamicTableView)this.getView()).getSubject(op);
        if (o instanceof BIOrdMappable) {
            BIOrdMappable mappable = (BIOrdMappable)o;
            BOrd ord = mappable.getMappedOrd();
            String stationName = mappable.getStationName();
            if (stationName.equals(Sys.getStation().getStationName())) {
                BComponent mapped = (BComponent)ord.get();
                if (Flags.isReadonly((BComplex)mapped.getParent(), (Slot)mapped.getPropertyInParent())) {
                    throw new BajaRuntimeException("You cannot rename a readonly " + HxTabUtil.getPluralDisplayName((Type)mapped.getType(), (Context)op) + ". " + mapped.toDisplayPathString((Context)op) + " is readonly.");
                }
                return mapped;
            }
            throw new BajaRuntimeException("You cannot rename " + ord + ". It is not located locally, go to " + mappable.getStationName() + " to rename it.");
        }
        throw new BajaRuntimeException("You cannot rename orion objects that not mappables.");
    }

    public void completeRename(BComponent renamed, HxOp op) throws Exception {
        ((BHxSmartTableView)this.getView()).reloadTable(op);
    }
}

