/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.hx.ErrorDialog;
import com.tridium.hx.progress.HxProgressJobDialog;
import com.tridium.hx.util.HxUtils;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.alarm.BNiagaraAlarmDeviceExt;
import com.tridium.nd.sysdef.BNiagaraSysDefDeviceExt;
import com.tridium.nd.user.BNiagaraUserDeviceExt;
import com.tridium.nd.user.BUserSyncStrategy;
import com.tridium.orion.OrionType;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.ntp.BNtpPlatformService;
import com.tridium.platform.ntp.BNtpServerVector;
import com.tridium.platform.posix.BNtpModePosix;
import com.tridium.platform.qnx.BNtpPlatformServiceQnx;
import com.tridium.platform.qnx.BNtpServerQnx;
import com.tridium.platform.win32.BNtpServerWin32;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.fieldeditors.BHxSmartDefaultFE;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.orionTools.replicate.BNiagaraReplicationDeviceExt;
import com.tridiumx.entsec.orionTools.replicate.BReplicationService;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BForceSysJoinManager;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BRetrieveImportStatusJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BSysJoinJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BTypeImportStatus;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinType;
import com.tridiumx.entsecHx.securityUtilHx.UpLevelCommand;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.table.Table;
import javax.baja.hx.table.TableModel;
import javax.baja.hx.table.TableRenderer;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nd.BStationRole;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.bajax.timesync.BTimeSyncClient;
import javax.bajax.timesync.BTimeSyncService;

@NiagaraType(agent={@AgentOn(types={"entsec:NiagaraReplicationDeviceExt"})})
@NiagaraSingleton
public class BSysJoinManager
extends BHxView
implements HxProgressJobDialog.IHxProgressDialogParent {
    static final Lexicon lex = Lexicon.make(BSysJoinManager.class);
    @Generated
    public static final BSysJoinManager INSTANCE = new BSysJoinManager();
    @Generated
    public static final Type TYPE = Sys.loadType(BSysJoinManager.class);
    private Version localVersion = Version.ZERO;
    private Version remoteVersion = Version.ZERO;
    public SmartCommand commitCommand;
    public SmartCommand restartConfiguration;
    public SmartCommand upLevelCommand;
    public SmartCommand retrieveImportStatus;
    public SmartCommand synchronizeTime;
    public HxProgressJobDialog.ProgressEvent progressEvent = HxProgressJobDialog.makeProgress((String)lex.getText("join.joining"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
    public HxProgressJobDialog.ProgressEvent retrieveProgressEvent;
    public ProgressCommand progressCommand;
    public RetrieveProgressCommand retrieveProgressCommand;
    private static final String MANIFEST_KEY = "sysJoinManifest";

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BSysJoinManager() {
        this.registerEvent((Event)this.progressEvent);
        this.retrieveProgressEvent = HxProgressJobDialog.makeProgress((String)lex.getText("join.retrievingProgress"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.retrieveProgressEvent);
        this.progressCommand = new ProgressCommand(this);
        this.registerEvent((Event)this.progressCommand);
        this.retrieveProgressCommand = new RetrieveProgressCommand(this);
        this.registerEvent((Event)this.retrieveProgressCommand);
        this.progressEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.progressCommand);
        this.retrieveProgressEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.retrieveProgressCommand);
        this.commitCommand = new CommitCommand(this);
        this.registerEvent((Event)this.commitCommand);
        if (!this.isForcedJoin()) {
            this.restartConfiguration = new RestartConfiguration(this);
            this.registerEvent((Event)this.restartConfiguration);
            this.retrieveImportStatus = new RetrieveImportStatus(this);
            this.registerEvent((Event)this.retrieveImportStatus);
        }
        this.upLevelCommand = new UpLevelCommand.DoubleUpLevelCommand(this);
        this.registerEvent((Event)this.upLevelCommand);
        this.synchronizeTime = new SynchronizeTime(this);
        this.registerEvent((Event)this.synchronizeTime);
    }

    public void write(HxOp op) throws Exception {
        op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
        op.addStyleSheet(BOrd.make((String)"module://entsecHx/rc/orionToolsHx/SysJoinManager.css"));
        op.setDynamic();
        BNiagaraReplicationDeviceExt ext = (BNiagaraReplicationDeviceExt)op.get();
        BNiagaraStation ns = (BNiagaraStation)ext.getDevice();
        String stationName = ns.getDisplayName((Context)op);
        Lexicon lex = op.getLexicon(this.getType().getModule().getModuleName());
        String title = lex.getText("join.title", new Object[]{stationName});
        HtmlWriter out = op.getHtmlWriter();
        try {
            SysJoinManifest.getForSession(ns, op);
        }
        catch (Exception e) {
            HxTabUtil.writeHeader((String)title, (SmartCommand[])new SmartCommand[]{this.upLevelCommand}, (HxOp)op);
            new ErrorDialog(lex.getText("join.errStationConnection"), (Command)this.commitCommand, (Throwable)e, lex.getText("join.errStationConnection")).writeContent(false, op);
            return;
        }
        BNiagaraSysDefDeviceExt[] exts = (BNiagaraSysDefDeviceExt[])ns.getChildren(BNiagaraSysDefDeviceExt.class);
        if (exts.length != 1 || exts[0].getRoleManager().getActualRole() != BStationRole.subordinate) {
            HxTabUtil.writeHeader((String)title, (SmartCommand[])new SmartCommand[]{this.upLevelCommand}, (HxOp)op);
            new ErrorDialog(lex.getText("join.errStationRole"), (Command)this.commitCommand, (Throwable)new Exception(lex.getText("join.errStationRole"))).writeContent(false, op);
            return;
        }
        if (this.isForcedJoin()) {
            HxTabUtil.writeHeader((String)title, (SmartCommand[])new SmartCommand[]{this.commitCommand, this.upLevelCommand}, (HxOp)op);
        } else {
            HxTabUtil.writeHeader((String)title, (SmartCommand[])new SmartCommand[]{this.commitCommand, this.retrieveImportStatus, this.restartConfiguration, this.upLevelCommand}, (HxOp)op);
        }
        out.w((Object)"<div class='sys-join-instructions'>");
        out.safe((Object)lex.getText("join.instructions.step1", new Object[]{"" + BSysJoinManager.getAllowableTimeDifference(op)}));
        out.w((Object)"</div>");
        this.writeSystemTimes(out, lex, ns, op);
        out.w((Object)"<div class='sys-join-instructions'>");
        out.safe((Object)lex.getText("join.instructions.step2"));
        out.w((Object)"</div>");
        this.writeScheduleLink(out, lex, ns);
        if (!this.isForcedJoin()) {
            out.w((Object)"<div class='sys-join-instructions'>");
            out.safe((Object)lex.getText("join.instructions.step3"));
            out.w((Object)"</div>");
            ReplicateTableModel tableModel = new ReplicateTableModel(op);
            Table table = new Table((TableModel)tableModel);
            table.setRenderer((TableRenderer)new ReplicateTableRenderer());
            table.write(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSystemTimes(HtmlWriter out, Lexicon lex, BNiagaraStation ns, HxOp op) throws Exception {
        HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
        BAbsTime now = Clock.time();
        HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((String)lex.getText("supervisorTime"), (HtmlWriter)out, (HxOp)op);
        BHxSmartDefaultFE.INSTANCE.write(op.make("timeA", (BObject)now, null));
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((String)lex.getText("subordinateTime"), (HtmlWriter)out, (HxOp)op);
        SysJoinManifest manifest = SysJoinManifest.getForSession(op);
        try (SubordinateConnection jaceConn = manifest.makeSubordinateConnection();){
            BSystemPlatformService service = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)jaceConn.getProxy());
            service.lease();
            BTimeZone timeZone = service.getTimeZone();
            BAbsTime remoteTime = BAbsTime.make((BAbsTime)service.getSystemTime(), (BTimeZone)timeZone);
            BHxSmartDefaultFE.INSTANCE.write(op.make("timeB", (BObject)remoteTime, null));
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startRow((String)lex.getText("timeDifference"), (HtmlWriter)out, (HxOp)op);
            BString s = BString.make((String)now.delta(remoteTime).toString((Context)BFacets.make((String)"showMilliseconds", (boolean)false)));
            boolean red = false;
            if (now.delta(remoteTime).abs().compareTo((Object)BRelTime.makeMinutes((int)1)) < 0) {
                s = BString.make((String)"< 1min");
            } else if (now.delta(remoteTime).abs().compareTo((Object)BSysJoinManager.getAllowableTimeDifference(op)) > 0) {
                red = true;
            }
            if (red) {
                out.w((Object)"<span style='color: red'>");
            }
            BHxSmartDefaultFE.INSTANCE.write(op.make("timeC", (BObject)s, null));
            if (red) {
                out.w((Object)"</span>");
            }
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
            HxTabUtil.nextColumn((HtmlWriter)out, (HxOp)op);
            HxTabUtil.writeCommand((SmartCommand)this.synchronizeTime, (boolean)true, (HxOp)op);
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
        }
    }

    private void writeScheduleLink(HtmlWriter out, Lexicon lex, BNiagaraStation ns) throws Exception {
        BComponent sched = (BComponent)ns.get("schedules");
        BOrd ord = BOrd.make((String)("station:|" + sched.getSlotPathOrd()));
        out.w((Object)("<a href='" + HxUtil.encodeURLForHref((String)ord.toString()) + "' "));
        out.w((Object)"<span class='sys-join-schedules'>");
        out.safe((Object)lex.getText("HxDistributedScheduleView.displayName"));
        out.w((Object)"</span>");
        out.w((Object)"</a>");
    }

    public void update(HxOp op) throws Exception {
        super.update(op);
        String name = op.scope("job");
        String ordStr = op.getFormValue(name);
        if (ordStr != null) {
            HxUtils.forceUpdate((BRelTime)BRelTime.make((long)750L), (HxOp)op);
        }
        this.progressEvent.getDialog().updateContent(op);
        this.retrieveProgressEvent.getDialog().updateContent(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processJaceJoinSystem(HxOp op) {
        try {
            SysJoinManifest manifest = SysJoinManifest.getForSession(op);
            try (SubordinateConnection jaceConn = manifest.makeSubordinateConnection();){
                String supervisorStationName = Sys.getStation().getStationName();
                BNiagaraNetwork remoteNetwork = (BNiagaraNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get((BObject)jaceConn.getProxy());
                BNiagaraStation remoteStation = RemoteUtil.findStation((BComponent)remoteNetwork, (String)supervisorStationName);
                this.configureRemoteTimeServer(manifest, jaceConn, remoteStation, op);
                this.configureRemoteUserSync(manifest, jaceConn, remoteStation, op);
                this.configureAlarmClass(manifest, jaceConn, remoteStation, op);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configureRemoteTimeServer(SysJoinManifest manifest, SubordinateConnection jaceConn, BNiagaraStation remoteStation, HxOp op) {
        BNtpPlatformService win32PlatformService = (BNtpPlatformService)Sys.getService((Type)BNtpPlatformService.TYPE);
        if (win32PlatformService.getEnabled()) {
            BNtpServerVector win32ServerVector = win32PlatformService.getTimeServers();
            BNtpServerWin32[] qnxServers = (BNtpServerWin32[])win32ServerVector.getChildren(BNtpServerWin32.class);
            if (qnxServers.length > 0) {
                this.setUpRemoteTimeServer(manifest, jaceConn, remoteStation, op);
            }
        } else {
            this.setUpRemoteTimeSync(manifest, jaceConn, remoteStation, op);
        }
    }

    public void setUpRemoteTimeSync(SysJoinManifest manifest, SubordinateConnection jaceConn, BNiagaraStation remoteStation, HxOp op) {
        try {
            BTimeSyncService timeSyncService = (BTimeSyncService)Sys.getService((Type)BTimeSyncService.TYPE);
            timeSyncService.setServerEnabled(true);
            remoteStation.lease();
            BOrd addressOrd = remoteStation.getAddress();
            BTimeSyncService remoteTimeSyncService = (BTimeSyncService)BOrd.make((String)"service:timesync:TimeSyncService").get((BObject)jaceConn.getProxy());
            remoteTimeSyncService.lease(1);
            remoteTimeSyncService.setEnabled(true);
            String supervisorAddress = addressOrd.parse()[0].getBody();
            BTimeSyncClient remoteTimeSyncClient = null;
            BTimeSyncClient[] timeSyncClients = (BTimeSyncClient[])remoteTimeSyncService.getChildren(BTimeSyncClient.class);
            if (timeSyncClients.length > 0) {
                remoteTimeSyncClient = timeSyncClients[0];
                remoteTimeSyncClient.lease();
                remoteTimeSyncClient.setServerName(supervisorAddress);
                remoteTimeSyncClient.setServerPort(timeSyncService.getServerPort());
                if (timeSyncClients.length > 1) {
                    for (int i = 1; i < timeSyncClients.length; ++i) {
                        timeSyncClients[i].lease();
                        remoteTimeSyncService.remove(timeSyncClients[i].getName());
                    }
                }
            } else {
                remoteTimeSyncClient = new BTimeSyncClient();
                remoteTimeSyncClient.setServerName(supervisorAddress);
                remoteTimeSyncClient.setServerPort(timeSyncService.getServerPort());
                remoteTimeSyncService.add("TimeSyncClient?", (BValue)remoteTimeSyncClient);
            }
            remoteTimeSyncService.getComponentSpace().sync();
            Thread.sleep(100L);
            remoteTimeSyncService.forceSync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpRemoteTimeServer(SysJoinManifest manifest, SubordinateConnection jaceConn, BNiagaraStation remoteStation, HxOp op) {
        try {
            BNtpPlatformServiceQnx remotePlatformService = (BNtpPlatformServiceQnx)BOrd.make((String)"service:platform:NtpPlatformService").get((BObject)jaceConn.getProxy());
            remotePlatformService.lease(1);
            remotePlatformService.setEnabled(true);
            remoteStation.lease();
            BOrd addressOrd = remoteStation.getAddress();
            String supervisorAddress = addressOrd.parse()[0].getBody();
            BNtpServerQnx remoteTimeServer = null;
            BNtpServerVector vector = remotePlatformService.getTimeServers();
            BNtpServerQnx[] qnxServers = (BNtpServerQnx[])vector.getChildren(BNtpServerQnx.class);
            if (qnxServers.length > 0) {
                remoteTimeServer = qnxServers[0];
                remoteTimeServer.lease();
                remoteTimeServer.setAddress(supervisorAddress);
                remoteTimeServer.setPeerMode(BNtpModePosix.server);
                remoteTimeServer.setUseBurst(true);
                remoteTimeServer.setServerPreferred(true);
                remoteTimeServer.setMinPollInterval(6);
                remoteTimeServer.setMaxPollInterval(10);
                if (qnxServers.length > 1) {
                    for (int i = 1; i < qnxServers.length; ++i) {
                        remotePlatformService.getTimeServers().remove((BComplex)qnxServers[i]);
                    }
                }
            } else {
                remotePlatformService.setSyncAtBoot(true);
                remotePlatformService.setLocalBackup(true);
                remoteTimeServer = new BNtpServerQnx();
                remoteTimeServer.setAddress(supervisorAddress);
                remoteTimeServer.setPeerMode(BNtpModePosix.server);
                remoteTimeServer.setUseBurst(true);
                remoteTimeServer.setServerPreferred(true);
                remoteTimeServer.setMinPollInterval(6);
                remoteTimeServer.setMaxPollInterval(10);
                remotePlatformService.add("NTPServer1", (BValue)remoteTimeServer);
            }
            String[] serverStrings = new String[]{remoteTimeServer.getServerString()};
            remotePlatformService.getTimeServers().sync(serverStrings);
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configureRemoteUserSync(SysJoinManifest manifest, SubordinateConnection jaceConn, BNiagaraStation remoteStation, HxOp op) {
        try {
            BNiagaraReplicationDeviceExt ext = (BNiagaraReplicationDeviceExt)op.get();
            BNiagaraStation localStation = (BNiagaraStation)ext.getDevice();
            BNiagaraUserDeviceExt localUsers = localStation.getUsers();
            localUsers.setSyncInEnabled(false);
            localUsers.setSyncOutEnabled(true);
            remoteStation.lease();
            BNiagaraUserDeviceExt remoteUsers = remoteStation.getUsers();
            remoteUsers.lease();
            remoteUsers.setSyncOutEnabled(false);
            remoteUsers.setSyncInEnabled(true);
            remoteUsers.setSyncStrategy(BUserSyncStrategy.useDefaultPrototype);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configureAlarmClass(SysJoinManifest manifest, SubordinateConnection jaceConn, BNiagaraStation remoteStation, HxOp op) {
        try {
            BNiagaraReplicationDeviceExt ext = (BNiagaraReplicationDeviceExt)op.get();
            BNiagaraStation localStation = (BNiagaraStation)ext.getDevice();
            BNiagaraAlarmDeviceExt localAlarmExt = localStation.getAlarms();
            localAlarmExt.setAlarmClass("%alarmClass%");
            remoteStation.lease();
            BNiagaraAlarmDeviceExt remoteAlarmExt = remoteStation.getAlarms();
            remoteAlarmExt.lease();
            remoteAlarmExt.setAlarmClass("%alarmClass%");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized boolean validateSoftwareVersion(HxOp op) throws Exception {
        SysJoinManifest manifest = SysJoinManifest.getForSession(op);
        SubordinateConnection conn = manifest.makeSubordinateConnection();
        BAccessControlService localService = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        BAccessControlService remoteService = (BAccessControlService)BOrd.make((String)"service:entsec:AccessControlService").get((BObject)conn.getProxy());
        remoteService.lease();
        this.localVersion = new Version(localService.getSoftwareVersion());
        this.remoteVersion = new Version(remoteService.getSoftwareVersion());
        conn.close();
        return this.localVersion.equals((Object)this.remoteVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void synchronizeTime(ConfirmDialog dlg, HxOp op) throws Exception {
        SysJoinManifest manifest = SysJoinManifest.getForSession(op);
        try (SubordinateConnection jaceConn = manifest.makeSubordinateConnection();){
            BSystemPlatformService remoteService = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)jaceConn.getProxy());
            remoteService.lease();
            BSystemPlatformService localService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            if (dlg != null && !dlg.isSubmit(op)) {
                String message = lex.getText("join.synchronizeTime.warning");
                if (!localService.getTimeZone().equals((Object)remoteService.getTimeZone())) {
                    message = lex.getText("join.synchronizeTime.warningTimeZone");
                }
                dlg.open(message, op);
                return;
            }
            BAbsTime superTime = Clock.time();
            remoteService.setSystemTime(superTime);
            remoteService.savePlatformServiceProperties();
            if (dlg != null) {
                dlg.getHandler().refresh(op);
            }
        }
    }

    public BJob submitJob(HxProgressJobDialog dialog, HxOp op) {
        if (dialog.getHandler() == this.progressEvent) {
            SysJoinManifest manifest = SysJoinManifest.getForSession(op);
            BSysJoinJob job = new BSysJoinJob(manifest, op, this.isForcedJoin());
            BOrd jobOrd = job.submit((Context)op);
            return (BJob)BOrd.make((String)("station:|" + jobOrd)).get();
        }
        SysJoinManifest.removeFromSession(op);
        SysJoinManifest manifest = SysJoinManifest.getForSession(op);
        BRetrieveImportStatusJob job = new BRetrieveImportStatusJob(manifest, op);
        BOrd jobOrd = job.submit((Context)op);
        return (BJob)BOrd.make((String)("station:|" + jobOrd)).get();
    }

    public static BRelTime getAllowableTimeDifference(HxOp op) {
        BReplicationService service = (BReplicationService)Sys.getService((Type)BReplicationService.TYPE);
        return service.getTimeSyncOverlap();
    }

    protected boolean isForcedJoin() {
        return false;
    }

    private class ReplicateTableModel
    extends TableModel {
        OrionType[] types;
        SysJoinManifest manifest;
        Lexicon lexicon;

        public ReplicateTableModel(HxOp op) {
            this.manifest = SysJoinManifest.getForSession(op);
            this.lexicon = op.getLexicon("entsecHx");
            this.types = SysJoinType.getDisplayedTypes();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col, HxOp op) {
            Lexicon lex = op.getLexicon(BSysJoinManager.this.getType().getModule().getModuleName());
            switch (col) {
                case 0: {
                    return lex.getText("join.recordType");
                }
                case 1: {
                    return lex.getText("join.importStatus");
                }
            }
            return "Error-" + col;
        }

        public int getRowCount(int group) {
            return this.types.length;
        }

        public Object getValueAt(int group, int row, int col, HxOp op) {
            switch (col) {
                case 0: {
                    return this.types[row];
                }
                case 1: {
                    SysJoinType forType = this.manifest.lookupConfigForType(this.types[row]);
                    return forType == null ? BTypeImportStatus.notConfigured.toString() : forType.getImportDescription();
                }
            }
            return "Error: row=" + row + ", col=" + col;
        }

        public BImage getRowIcon(int group, int row) {
            return BImage.make((BIcon)this.types[row].getInstance().getIcon());
        }
    }

    private class ReplicateTableRenderer
    extends TableRenderer {
        private ReplicateTableRenderer() {
        }

        public void writeCellValue(Object value, int group, int row, int col, HxOp op) throws Exception {
            if (col == 0) {
                Lexicon lex = op.getLexicon(BSysJoinManager.this.getType().getModule().getModuleName());
                BOrd ord = BOrd.make((String)("station:|" + ((BComponent)op.get()).getSlotPathOrd()));
                OrionType orionType = (OrionType)value;
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"<a style='text-decoration: none;' ");
                out.w((Object)"href='").w((Object)HxUtil.encodeURLForHref((String)ord.toString())).w((Object)"|view:entsecHx:DataImportManager?");
                out.w((Object)"dataType=").w((Object)orionType).w((Object)"'>");
                out.w((Object)"<span class='sys-join-objectTypeImage'>");
                HxUtil.makeImageJS((BImage)this.getModel().getRowIcon(group, row), (HxOp)op);
                out.w((Object)"</span>");
                out.w((Object)"&nbsp; <span class='sys-join-objectType'>");
                out.safe((Object)lex.getText(SysJoinType.getLexiconText(orionType)));
                out.w((Object)"</span>");
                out.w((Object)"</a>");
            } else {
                super.writeCellValue(value, group, row, col, op);
            }
        }
    }

    public class ProgressCommand
    extends Command
    implements HxProgressJobDialog.IJobCompleteHandler {
        public ProgressCommand(BHxView view) {
            super(view);
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BHxAbstractJobView.openErrorDialog(job, this, op);
                SysJoinManifest.removeFromSession(op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                BHxAbstractJobView.openSuccessDialog(job, this, BOrd.make((String)("station:|service:" + BNiagaraNetwork.TYPE.getTypeSpec())), op);
                SysJoinManifest.removeFromSession(op);
            }
        }

        public void handle(HxOp op) throws Exception {
            BSysJoinManager.this.progressEvent.handle(op);
        }
    }

    public class RetrieveProgressCommand
    extends Command
    implements HxProgressJobDialog.IJobCompleteHandler {
        public RetrieveProgressCommand(BHxView view) {
            super(view);
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BHxAbstractJobView.openErrorDialog(job, this, op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                this.refresh(op);
            }
        }

        public void handle(HxOp op) throws Exception {
            BSysJoinManager.this.retrieveProgressEvent.handle(op);
        }
    }

    public class SynchronizeTime
    extends SmartCommand {
        private ConfirmDialog dlg;

        public SynchronizeTime(BHxView view) {
            super(view);
            this.dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "synchronizeTime";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            BSysJoinManager.this.synchronizeTime(this.dlg, op);
        }
    }

    public class RestartConfiguration
    extends SmartCommand {
        private ConfirmDialog dlg;

        public RestartConfiguration(BHxView view) {
            super(view);
            this.dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "join.restartConfiguration";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            SysJoinManifest.removeFromSession(op);
            this.refresh(op);
        }
    }

    public class RetrieveImportStatus
    extends SmartCommand {
        public RetrieveImportStatus(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "join.retrieveImportStatus";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            BSysJoinManager.this.retrieveProgressCommand.handle(op);
        }
    }

    public class CommitCommand
    extends SmartCommand {
        public CommitCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            if (this.getView() instanceof BForceSysJoinManager) {
                return "forceJoin.commit";
            }
            return "join.commit";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean startsEnabled(HxOp op) {
            if (!super.startsEnabled(op)) {
                return false;
            }
            if (BSysJoinManager.this.isForcedJoin()) {
                return true;
            }
            SysJoinManifest manifest = SysJoinManifest.getForSession(op);
            try (SubordinateConnection jaceConn = manifest.makeSubordinateConnection();){
                BAbsTime time = Clock.time();
                BSystemPlatformService service = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)jaceConn.getProxy());
                service.lease();
                BAbsTime remoteTime = service.getSystemTime();
                if (time.delta(remoteTime).abs().compareTo((Object)BSysJoinManager.getAllowableTimeDifference(op)) > 0) {
                    boolean bl = false;
                    return bl;
                }
            }
            for (int i = 0; i < SysJoinType.getDisplayedTypes().length; ++i) {
                SysJoinType sj = manifest.lookupConfigForType(SysJoinType.getDisplayedTypes()[i]);
                if (sj == null) {
                    return false;
                }
                if (!sj.getImportStatus().equals((Object)BTypeImportStatus.configured)) {
                    return false;
                }
                if (!sj.hasErrors()) continue;
                return false;
            }
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BSysJoinManager.this.processJaceJoinSystem(op);
            BSysJoinManager.this.progressCommand.handle(op);
        }
    }
}

