/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BObjectImportStatus;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BSysJoinJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.JoinAction;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinType;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeSimple;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;

public class SysJoinTypeAccessRight
extends SysJoinTypeSimple {
    private static final String ID = "accessRightId";
    private static final String NAME = "accessRightName";
    private static final String TENANT = "tenant";
    private static final String NIAGARA_INT = "niagaraIntegrationID";
    private static final String SCHEDULE = "schedule";
    private static final String THREAT_LEVEL_GROUP = BAccessRight.threatLevelGroup.getName();

    public SysJoinTypeAccessRight() {
        super(SysJoinType.ACCESSRIGHT_TYPE, ID, NAME);
    }

    @Override
    protected void match(OrionSession supSession, SubordinateConnection jaceConn, SysJoinManifest manifest) {
        for (int i = 0; i < this.actions.length; ++i) {
            BIOrionObject supRec = null;
            BIOrionObject jaceRec = this.actions[i].getJaceObject();
            BSimple jaceKey = this.getKey(jaceRec);
            this.setActionByJaceId(jaceKey, this.actions[i]);
            BValue jaceMatch = jaceRec.get(this.matchField);
            supRec = supSession.read(this.getOrionType(), new PropertyValue(this.getOrionType().getProperty(this.matchField), jaceMatch));
            if (supRec != null) {
                this.actions[i].setStatus(BObjectImportStatus.matchedObject);
                this.actions[i].setMatch(supRec);
                continue;
            }
            supRec = supSession.read(this.getOrionType(), jaceKey);
            if (supRec != null) {
                this.actions[i].setStatus(BObjectImportStatus.matchedObject);
                this.actions[i].setMatch(supRec);
                this.actions[i].setWarningDescription(SysJoinTypeAccessRight.getLexiconText("join.matchByUuid"));
                continue;
            }
            this.actions[i].setStatus(BObjectImportStatus.newObject);
            BRef ref = (BRef)jaceRec.get(SCHEDULE);
            if (!ref.isBound() || supSession.read(BScheduleRec.ORION_TYPE, ref.getId()) != null) continue;
            this.actions[i].setWarningDescription("Schedule is missing on supervisor");
        }
    }

    @Override
    public void join(OrionSession supSession, SubordinateConnection jaceConn, BSysJoinJob job, SysJoinManifest manifest) {
        SysJoinType joinTenant = manifest.getConfigForType(jaceConn, SysJoinType.TENANT_TYPE, manifest);
        SysJoinType joinNiagaraInt = manifest.getConfigForType(jaceConn, SysJoinType.NIAGARA_INT_TYPE, manifest);
        SysJoinType joinThreatLevelGroup = manifest.getConfigForType(jaceConn, SysJoinType.THREATLEVELGROUP_TYPE, manifest);
        for (int i = 0; i < this.actions.length; ++i) {
            JoinAction action = this.actions[i];
            BIOrionObject jaceObj = action.getJaceObject();
            if (!action.getStatus().equals((Object)BObjectImportStatus.newObject)) continue;
            BOrionObject clonedObj = (BOrionObject)this.copyObject(jaceObj);
            SysJoinType.adjustRef(clonedObj, TENANT, joinTenant);
            SysJoinType.adjustRef(clonedObj, NIAGARA_INT, joinNiagaraInt);
            SysJoinType.adjustRef(clonedObj, THREAT_LEVEL_GROUP, joinThreatLevelGroup);
            BRef ref = (BRef)clonedObj.get(SCHEDULE);
            if (ref.isBound() && supSession.read(BScheduleRec.ORION_TYPE, ref.getId()) == null) {
                job.log().message("WARNING: Access Right '" + clonedObj.get(NAME) + "' is now missing a Schedule.");
                clonedObj.set(SCHEDULE, (BValue)BRef.NULL);
            }
            supSession.insert((BIOrionObject)clonedObj);
        }
    }

    private String showRef(BIOrionObject iobj, String refName) {
        BOrionObject obj = (BOrionObject)iobj;
        BRef ref = (BRef)obj.get(refName);
        String bound = ref.isBound() ? ref.getId().toString() : "UNBOUND";
        return "ref(" + refName + "," + bound + ")";
    }
}

