/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneGroup;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BSysJoinJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.JoinAction;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinType;
import java.util.HashSet;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class SysJoinTypeIntrusionZoneGroup
extends SysJoinType {
    private static final String INTRUSION_ZONE = BIntrusionZoneGroup.intrusionZone.getName();

    public SysJoinTypeIntrusionZoneGroup() {
        super(INTRUSIONZONEGROUP_TYPE);
    }

    @Override
    protected void match(OrionSession supSession, SubordinateConnection jaceConn, SysJoinManifest manifest) {
    }

    @Override
    public void join(OrionSession supSession, SubordinateConnection jaceConn, BSysJoinJob job, SysJoinManifest manifest) {
        SysJoinType joinIntrusionZone = manifest.getConfigForType(jaceConn, INTRUSIONZONE_TYPE, manifest);
        BSqlQuery query = BSqlQuery.make((OrionType)BIntrusionZoneGroup.ORION_TYPE);
        ExpressionBuilder b = new ExpressionBuilder();
        BSqlField field = new BSqlField(BIntrusionZoneGroup.ORION_TYPE, BIntrusionZoneGroup.stationName);
        b.or(Predicates.eq((BExpression)field.newExprCopy(), (BSimple)BString.make((String)jaceConn.getStation().getName())));
        query.where(b.getExpression());
        OrionCursor c = supSession.select((BQuery)query);
        HashSet<BSimple> hashSet = new HashSet<BSimple>();
        while (c.next()) {
            BIntrusionZoneGroup group = (BIntrusionZoneGroup)c.get();
            hashSet.add(group.getIntrusionZone().getId());
        }
        for (int i = 0; i < this.actions.length; ++i) {
            JoinAction action = this.actions[i];
            BIOrionObject jaceObj = action.getJaceObject();
            BOrionObject clonedObj = (BOrionObject)this.copyObject(jaceObj);
            SysJoinType.adjustRef(clonedObj, INTRUSION_ZONE, joinIntrusionZone);
            if (!supSession.exists((BIOrionObject)clonedObj)) {
                supSession.insert((BIOrionObject)clonedObj);
            }
            BIntrusionZoneGroup groupRec = (BIntrusionZoneGroup)clonedObj;
            hashSet.remove(groupRec.getIntrusionZone().getId());
        }
        Object[] removes = hashSet.toArray();
        if (removes.length == 0) {
            return;
        }
        job.log().message("There are " + removes.length + " Intrusion Zone Records(s) that no longer exist on subordinate that will be cleaned");
        for (int i = 0; i < removes.length; ++i) {
            BIntrusionZoneGroup group = new BIntrusionZoneGroup();
            group.setStationName(jaceConn.getStation().getName());
            group.setIntrusionZone(BRef.make((BTypeSpec)BIntrusionZoneGroup.ORION_TYPE.getTypeSpec(), (BSimple)((BUuid)removes[i])));
            supSession.delete((BIOrionObject)group);
        }
    }

    @Override
    public BSimple getKey(BIOrionObject obj) {
        return (BSimple)obj.get(INTRUSION_ZONE);
    }
}

