/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BObjectImportStatus;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BSysJoinJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.JoinAction;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinType;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeBadge;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.util.BUuid;

public class SysJoinTypePerson
extends SysJoinType {
    private static final String PERSON_ID = "personId";
    private static final String TENANT = "tenant";

    public SysJoinTypePerson() {
        super(PERSON_TYPE);
    }

    @Override
    protected void match(OrionSession supSession, SubordinateConnection jaceConn, SysJoinManifest manifest) {
        SysJoinTypeBadge joinBadge = (SysJoinTypeBadge)manifest.getConfigForType(jaceConn, BADGE_TYPE, manifest);
        block4: for (int i = 0; i < this.actions.length; ++i) {
            JoinAction action = this.actions[i];
            BIOrionObject jaceRec = action.getJaceObject();
            BUuid jacePerson = (BUuid)this.getKey(jaceRec);
            this.setActionByJaceId((BSimple)jacePerson, action);
            action.setStatus(BObjectImportStatus.deleteObject);
            Object[] jaceBadges = joinBadge.getJaceBadges(jacePerson);
            if (jaceBadges == null) continue;
            Array supPersons = new Array(BUuid.class);
            Array supBadges = new Array(BBadge.class);
            for (int j = 0; j < jaceBadges.length; ++j) {
                BUuid uuid;
                BBadge supBadge = (BBadge)supSession.read(BBadge.ORION_TYPE, new PropertyValue(BBadge.badgeId, (BValue)BString.make((String)jaceBadges[j])));
                if (supBadge == null) continue;
                supBadges.add((Object)supBadge);
                if (!supBadge.getOwner().isBound() || supPersons.contains((Object)(uuid = (BUuid)supBadge.getOwner().getId()))) continue;
                supPersons.add((Object)uuid);
            }
            switch (supPersons.size()) {
                case 0: {
                    BPerson supPerson = (BPerson)supSession.read(this.getOrionType(), new PropertyValue[]{new PropertyValue(BPerson.personId, (BValue)jacePerson)});
                    boolean exists = supPerson != null;
                    int jaceBadgesLength = jaceBadges.length;
                    int supBadgesLength = supBadges.size();
                    if (exists && (supBadgesLength > 0 || jaceBadgesLength > 0)) {
                        action.setStatus(BObjectImportStatus.error);
                        action.setErrorDescription(SysJoinTypePerson.getLexiconText("join.errBadgeMismatch2", new Object[]{this.toDisplayString(supBadges.trim()), this.toDisplayString(jaceBadges)}));
                        continue block4;
                    }
                    if (exists && supBadgesLength == 0 && jaceBadgesLength == 0) {
                        this.setMatch(jaceRec, (BIOrionObject)supPerson, supSession, action);
                        if (action.getStatus() == BObjectImportStatus.error) continue block4;
                        action.setWarningDescription(SysJoinTypePerson.getLexiconText("join.warning.noBadgeAssigned"));
                        continue block4;
                    }
                    BPerson jacePersonRec = (BPerson)jaceRec;
                    BSqlQuery query = BSqlQuery.make((OrionType)BPerson.ORION_TYPE);
                    ExpressionBuilder b = new ExpressionBuilder();
                    b.and(Predicates.eq((BExpression)Funcs.lower((BExpression)new BSqlField(BPerson.ORION_TYPE, BPerson.lastName)), (BSimple)BString.make((String)TextUtil.toLowerCase((String)jacePersonRec.getLastName()))));
                    b.and(Predicates.eq((BExpression)Funcs.lower((BExpression)new BSqlField(BPerson.ORION_TYPE, BPerson.firstName)), (BSimple)BString.make((String)TextUtil.toLowerCase((String)jacePersonRec.getFirstName()))));
                    b.and(Predicates.eq((BExpression)Funcs.lower((BExpression)new BSqlField(BPerson.ORION_TYPE, BPerson.middleInitial)), (BSimple)BString.make((String)TextUtil.toLowerCase((String)jacePersonRec.getMiddleInitial()))));
                    query.where(b.getExpression());
                    OrionCursor c = supSession.select((BQuery)query);
                    action.setStatus(BObjectImportStatus.newObject);
                    if (c.next()) {
                        action.setWarningDescription(SysJoinTypePerson.getLexiconText("join.warning.matchingNameButNoBadges"));
                        action.setMatch(c.get());
                    }
                    action.setStatus(BObjectImportStatus.newObject);
                    continue block4;
                }
                case 1: {
                    BPerson supPerson = (BPerson)supSession.read(this.getOrionType(), new PropertyValue[]{new PropertyValue(BPerson.personId, (BValue)supPersons.get(0))});
                    this.setMatch(jaceRec, (BIOrionObject)supPerson, supSession, action);
                    continue block4;
                }
                default: {
                    action.setStatus(BObjectImportStatus.error);
                    action.setErrorDescription(SysJoinTypePerson.getLexiconText("join.errBadgeMismatch1", new Object[]{this.toDisplayString(joinBadge.getJaceBadges(jacePerson))}));
                }
            }
        }
    }

    public void setMatch(BIOrionObject jaceRec, BIOrionObject supRecord, OrionSession supSession, JoinAction action) {
        if (!supRecord.toDisplayString(null).toLowerCase().equals(jaceRec.toDisplayString(null).toLowerCase())) {
            action.setStatus(BObjectImportStatus.error);
            action.setErrorDescription(SysJoinTypePerson.getLexiconText("join.error.namesNeedToMatch"));
        } else {
            action.setStatus(BObjectImportStatus.matchedObject);
        }
        action.setMatch(supRecord);
    }

    public String toDisplayString(Object[] list) {
        StringBuffer b = new StringBuffer();
        if (list.length == 0) {
            return "none";
        }
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                b.append("; ");
            }
            b.append(list[i].toString());
        }
        return b.toString();
    }

    @Override
    public void join(OrionSession supSession, SubordinateConnection jaceConn, BSysJoinJob job, SysJoinManifest manifest) {
        SysJoinType joinTenant = manifest.getConfigForType(jaceConn, TENANT_TYPE, manifest);
        BatchStatement supInsert = supSession.batchInsert(PERSON_TYPE);
        supInsert.setChunkSize(CHUNK_SIZE);
        for (int i = 0; i < this.actions.length; ++i) {
            JoinAction action = this.actions[i];
            if (!action.getStatus().equals((Object)BObjectImportStatus.newObject)) continue;
            BIOrionObject jaceObj = action.getJaceObject();
            BOrionObject clonedObj = (BOrionObject)this.copyObject(jaceObj);
            SysJoinType.adjustRef(clonedObj, TENANT, joinTenant);
            supInsert.add((BIOrionObject)clonedObj);
            if (supInsert.size() <= EXECUTE_SIZE) continue;
            supInsert.execute();
        }
        supInsert.execute();
    }

    @Override
    public BSimple getKey(BIOrionObject obj) {
        return (BSimple)((BOrionObject)obj).get(PERSON_ID);
    }
}

