/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.photoID;

import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.DialogWizardCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsec.photoID.BIPhotoIDClientDevice;
import com.tridiumx.entsec.photoID.BPhotoIDDevice;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsecHx.photoID.BHxPhotoIDWakeUpView;
import com.tridiumx.entsecHx.photoID.BHxPortraitFE;
import com.tridiumx.entsecHx.photoID.CropWizard;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class CaptureWizard
extends DialogWizardCommand {
    protected SmartCommand finishCapture;

    public CaptureWizard(BHxView view) {
        super(view);
        this.finishCapture = new FinishCapture(view);
        view.registerEvent((Event)this.finishCapture);
    }

    public DialogWizardCommand.Step[] makeSteps() {
        return new DialogWizardCommand.Step[]{new DeviceStep("deviceStep", (Command)this), new CaptureWaitingStep("captureWaitingStep", (Command)this), new CaptureWaitingStep("recaptureWaitingStep", (Command)this), new CropStep("cropStep", (Command)this), new DoneStep("doneStep", (Command)this)};
    }

    public String getFirstStepName(HxOp op) {
        BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
        if (((BPhotoIDDevice[])network.getChildren(BPhotoIDDevice.class)).length != 1) {
            return "deviceStep";
        }
        return "captureWaitingStep";
    }

    public String getName(HxOp op) {
        return "captureWizard";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    public class FinishCapture
    extends SmartCommand {
        public FinishCapture(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "finishCapture";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
            BPhotoIDDevice device = null;
            if (((BPhotoIDDevice[])network.getChildren(BPhotoIDDevice.class)).length == 1) {
                device = ((BPhotoIDDevice[])network.getChildren(BPhotoIDDevice.class))[0];
            } else if (op.getFormValue("device") != null) {
                device = (BPhotoIDDevice)network.get(op.getFormValue("device"));
            }
            if (device == null) {
                return;
            }
            BOrd ord = null;
            try {
                ord = device.doCaptureImage();
                Auditor auditor = Sys.getAuditor();
                if (auditor != null) {
                    auditor.audit(new AuditEvent("Invoked", device.toPathString(), BPhotoIDDevice.captureImage.getName(), "", "", op.getUser().getUsername()));
                }
            }
            catch (Exception e) {
                SmartCommand.tryException((HxOp)op);
                out.w((Object)"hx.closeDialog(null, null, null);");
                SmartCommand.catchException((HxOp)op);
                new ErrorDialog(e.getMessage(), (Command)this, (Throwable)e).open(op);
                return;
            }
            if (ord == null || ord.equals((Object)BOrd.DEFAULT)) {
                SmartCommand.tryException((HxOp)op);
                out.w((Object)"hx.closeDialog(null, null, null);");
                SmartCommand.catchException((HxOp)op);
                return;
            }
            BImage image = BImage.make((BOrd)ord);
            SmartCommand.tryException((HxOp)op);
            SmartCommand.disable((String)op.scope("submit"), (boolean)false, (HxOp)op);
            CropWizard.updateImageWithMaxHeight(image, op.scope("waitingImage"), op);
            SmartCommand.setFormValue((String)op.scope("capturedImage"), (Object)ord, (HxOp)op);
            SmartCommand.show((String)op.scope("waitingDiv"), (HxOp)op);
            SmartCommand.hide((String)op.scope("waitingText"), (HxOp)op);
            SmartCommand.resizeCurrentDialog((HxOp)op);
            SmartCommand.catchException((HxOp)op);
        }
    }

    public class DoneStep
    extends DialogWizardCommand.Step {
        public DoneStep(String name, Command handler) {
            super((DialogWizardCommand)CaptureWizard.this, name, handler);
        }

        public String handle(HxOp op) throws Exception {
            return null;
        }

        public boolean requiresOpen(HxOp op) {
            return false;
        }
    }

    public class CropStep
    extends DialogWizardCommand.Step {
        public CropStep(String name, Command handler) {
            super((DialogWizardCommand)CaptureWizard.this, name, handler);
        }

        public String handle(HxOp op) throws Exception {
            op.getHtmlWriter().w((Object)SmartCommand.getInvokeCode((Command)BHxPortraitFE.INSTANCE.cropWizard, (String)HxUtil.getInnerQuote((HxOp)op), (HxOp)op));
            return null;
        }

        public boolean requiresOpen(HxOp op) {
            return false;
        }
    }

    public class CaptureWaitingStep
    extends DialogWizardCommand.Step {
        public CaptureWaitingStep(String name, Command handler) {
            super((DialogWizardCommand)CaptureWizard.this, name, handler);
        }

        public String handle(HxOp op) throws Exception {
            String ord = op.getFormValue("capturedImage");
            if (ord == null) {
                ord = BHxPortraitFE.blank.toString();
            }
            BHxPortraitFE.setMainImage(ord, op);
            return null;
        }

        protected void writeContent(HxOp op) throws Exception {
            BAbsTime now = BAbsTime.now();
            String fileOrd = "^portraits/portrait" + now.getMillis() + ".png";
            HtmlWriter out = op.getHtmlWriter();
            SmartCommand.persistFormValue((String)"device", (HxOp)op);
            BHxSmartTableView.writeFormValue((String)"fileOrd", (String)fileOrd, (HxOp)op);
            op.getRequest().getSession().setAttribute("fileOrd", (Object)fileOrd);
            out.w((Object)"<div ");
            HxTabUtil.scope((String)"waitingText", (HtmlWriter)out, (HxOp)op);
            out.w((Object)">");
            out.safe((Object)CaptureWizard.this.lexModule.getText("waitingPhotoCapture", (Context)op));
            out.w((Object)"</div>");
            out.w((Object)"<div ");
            HxTabUtil.scope((String)"waitingImage", (HtmlWriter)out, (HxOp)op);
            out.w((Object)">");
            HxUtil.makeImageJS((BImage)BHxPortraitFE.blank, (HxOp)op);
            out.w((Object)"</div>");
            op.addOnload(SmartCommand.disableInvokeCode((String)op.scope("submit"), (String)HxUtil.getInnerQuote((HxOp)op), (boolean)true, (HxOp)op));
            op.addOnload(SmartCommand.getInvokeCode((Command)CaptureWizard.this.finishCapture, (String)HxUtil.getInnerQuote((HxOp)op), (HxOp)op));
            BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
            BPhotoIDDevice device = null;
            device = ((BPhotoIDDevice[])network.getChildren(BPhotoIDDevice.class)).length == 1 ? ((BPhotoIDDevice[])network.getChildren(BPhotoIDDevice.class))[0] : (BPhotoIDDevice)network.get(op.getFormValue("device"));
            if (device instanceof BIPhotoIDClientDevice) {
                BHxPhotoIDWakeUpView.wakeUp((BIPhotoIDClientDevice)device, op);
            }
            out.w((Object)"<div ");
            out.attr("style", "display:none;");
            HxTabUtil.scope((String)"waitingDiv", (HtmlWriter)out, (HxOp)op);
            out.w((Object)">");
            Array choices = new Array(DialogWizardCommand.Step.class);
            choices.add((Object)CaptureWizard.this.getStep("cropStep", op));
            choices.add((Object)CaptureWizard.this.getStep("recaptureWaitingStep", op));
            choices.add((Object)CaptureWizard.this.getStep("doneStep", op));
            DialogWizardCommand.writeChoices((Object[])choices.trim(), (String)CaptureWizard.this.lexModule.getText("nextStep", (Context)op), (boolean)false, (String)"nextStep", null, (HxOp)op);
            out.w((Object)"</div>");
        }
    }

    public class DeviceStep
    extends DialogWizardCommand.Step {
        public DeviceStep(String name, Command handler) {
            super((DialogWizardCommand)CaptureWizard.this, name, handler);
        }

        public String handle(HxOp op) throws Exception {
            BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
            BPhotoIDDevice device = (BPhotoIDDevice)network.get(op.getFormValue("device"));
            return "captureWaitingStep";
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            Array choices = new Array(BPhotoIDDevice.class);
            choices.addAll((Object[])BHxPortraitFE.INSTANCE.getPhotoIDDevices(op));
            SmartCommand.persistFormValue((String)op.scope("imageRatio"), (HxOp)op);
            if (choices.size() > 0) {
                DialogWizardCommand.writeChoices((Object[])choices.trim(), null, (boolean)false, (String)"device", null, (HxOp)op);
            } else {
                DialogWizardCommand.writeChoices((Object[])choices.trim(), (String)CaptureWizard.this.lexModule.getText("noPhotoIDDevicesAvailable", (Context)op), (boolean)false, (String)"device", null, (HxOp)op);
                op.addOnload(SmartCommand.disableInvokeCode((String)op.scope("submit"), (String)HxUtil.getInnerQuote((HxOp)op), (boolean)true, (HxOp)op));
            }
        }
    }
}

