/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.photoID;

import com.tridium.hx.ErrorDialog;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.DialogWizardCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.orionTools.BRefList;
import com.tridiumx.entsec.photoID.BIPhotoIDClientDevice;
import com.tridiumx.entsec.photoID.BPhotoIDDevice;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.photoID.BPhotoIDPrintInfo;
import com.tridiumx.entsec.photoID.BPhotoIDTemplate;
import com.tridiumx.entsec.photoID.asureID.BAsureIDClientDevice;
import com.tridiumx.entsec.photoID.asureID.WakeupClientListener;
import com.tridiumx.entsecHx.orionHx.BHxDynamicTableView;
import com.tridiumx.entsecHx.photoID.BHxPhotoIDWakeUpView;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BLong;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

public class PrintBadgeWizard
extends DialogWizardCommand {
    private static final int MAX_REQUESTS = 100;
    private static Map<Long, Boolean> lockStatusMap = Collections.synchronizedMap(new LinkedHashMap<Long, Boolean>(100){

        @Override
        public boolean removeEldestEntry(Map.Entry<Long, Boolean> eldest) {
            return this.size() > 100;
        }
    });
    private static final Logger log = Logger.getLogger("entsec.PrintBadgeWizard");
    SmartCommand finishPrint;

    public PrintBadgeWizard(BHxView view) {
        super(view, LexiconModule.make((String)Sys.getModuleForClass(PrintBadgeWizard.class).getModuleName()));
        this.finishPrint = new FinishPrint(view);
        view.registerEvent((Event)this.finishPrint);
    }

    public DialogWizardCommand.Step[] makeSteps() {
        return new DialogWizardCommand.Step[]{new ChooseBadgeStep("badgeStep", (Command)this), new PrintStep("printStep", (Command)this)};
    }

    public String getFirstStepName(HxOp op) {
        if (op.get() instanceof BPerson) {
            return "badgeStep";
        }
        return "printStep";
    }

    public String getName(HxOp op) {
        return "printBadgeWizard";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    public boolean isVisible(HxOp op) {
        BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
        return network.getPermissions((Context)op).hasAdminInvoke();
    }

    public Type getTypeForSubject(HxOp op) {
        if (op.get() instanceof BIOrionObject) {
            return ((BIOrionObject)op.get()).getOrionType();
        }
        if (op.get() instanceof BDynamicTable) {
            return ((BDynamicTable)op.get()).getRowType().getTypeSpec().getResolvedType();
        }
        throw new BajaRuntimeException("Unknown Orion Type for " + op.get().getType());
    }

    public BPhotoIDPrintInfo getPhotoIDPrintInfo(HxOp op) {
        BDynamicTable table;
        Type type;
        BPhotoIDPrintInfo info = new BPhotoIDPrintInfo();
        if (op.getFormValue("badge") != null) {
            BBadge badge = (BBadge)BOrd.make((String)op.getFormValue("badge")).get();
            info.setBadges(BRefList.make((BIOrionObject)badge));
        } else if (op.get() instanceof BBadge) {
            info.setBadges(BRefList.make((BIOrionObject)((BBadge)op.get())));
        } else if (op.get() instanceof BDynamicTable && (type = (table = (BDynamicTable)op.get()).getRowType().getTypeSpec().getResolvedType()) == BBadge.TYPE) {
            Array subjects = new Array(BIOrionObject.class);
            subjects.addAll((Object[])((BIOrionObject[])((BHxDynamicTableView)this.getView()).getSubjects(op)));
            info.setBadges(BRefList.make((OrionType)BBadge.ORION_TYPE, (BIOrionObject[])((BIOrionObject[])subjects.trim())));
        }
        return info;
    }

    public static boolean getLockStatus(Long timeInMillis) {
        Boolean lockApplied = lockStatusMap.remove(timeInMillis);
        return lockApplied == null ? false : lockApplied;
    }

    public class FinishPrint
    extends SmartCommand {
        public FinishPrint(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "finishPrint";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            try {
                BPhotoIDPrintInfo info = PrintBadgeWizard.this.getPhotoIDPrintInfo(op);
                BPhotoIDTemplate template = info.getTemplate();
                if (template == null) {
                    throw new IllegalStateException("No Template Assigned");
                }
                BPhotoIDDevice device = (BPhotoIDDevice)template.getParent().getParent();
                device.doPrint(info);
            }
            catch (Exception e) {
                SmartCommand.tryException((HxOp)op);
                out.w((Object)"hx.closeDialog(null, null, null);");
                SmartCommand.catchException((HxOp)op);
                new ErrorDialog("Error", (Command)this, (Throwable)e).open(op);
                return;
            }
            SmartCommand.tryException((HxOp)op);
            out.w((Object)"hx.closeDialog(null, null, null);");
            SmartCommand.catchException((HxOp)op);
        }
    }

    public static class OrionPrintBadgeWizard
    extends PrintBadgeWizard {
        public OrionPrintBadgeWizard(BHxView view) {
            super(view);
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }
    }

    public static class OrionChoiceRenderer
    implements DialogWizardCommand.ChoiceRenderer {
        public String getValue(Object o, HxOp op) {
            return ((BIOrionObject)o).getHandle().toString();
        }

        public String getDisplayName(Object o, HxOp op) {
            return ((BIOrionObject)o).toDisplayString((Context)op);
        }

        public BImage getIcon(Object o, HxOp op) {
            return null;
        }
    }

    public class PrintStep
    extends DialogWizardCommand.Step
    implements WakeupClientListener {
        private Long wakeUpTimeInMillis;

        public PrintStep(String name, Command handler) {
            super((DialogWizardCommand)PrintBadgeWizard.this, name, handler);
            this.wakeUpTimeInMillis = BLong.DEFAULT.getLong();
        }

        public String handle(HxOp op) throws Exception {
            return null;
        }

        public boolean requiresOpen(HxOp op) throws Exception {
            return true;
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            SmartCommand.persistFormValue((String)"badge", (HxOp)op);
            out.w((Object)"<div ");
            HxTabUtil.scope((String)"waitingText", (HtmlWriter)out, (HxOp)op);
            out.w((Object)">");
            out.safe((Object)PrintBadgeWizard.this.lexModule.getText("waitingPrint", (Context)op));
            out.w((Object)"</div>");
            BPhotoIDPrintInfo info = PrintBadgeWizard.this.getPhotoIDPrintInfo(op);
            BPhotoIDTemplate template = info.getTemplate();
            if (template == null) {
                throw new IllegalStateException("No Template Assigned");
            }
            BPhotoIDDevice device = (BPhotoIDDevice)template.getParent().getParent();
            if (device instanceof BAsureIDClientDevice) {
                this.wakeUpTimeInMillis = System.currentTimeMillis();
                BHxPhotoIDWakeUpView.wakeUp((BIPhotoIDClientDevice)device, this.wakeUpTimeInMillis, op);
                device.registerWakeupListener((WakeupClientListener)this);
            }
            BHxSmartTableView.writeFormValue((String)"deviceSlotPath", (String)device.getSlotPath().toString(), (HxOp)op);
            op.addOnload(SmartCommand.getInvokeCode((Command)PrintBadgeWizard.this.finishPrint, (String)HxUtil.getInnerQuote((HxOp)op), (HxOp)op));
        }

        public Command[] getCommands() {
            return new Command[]{new Dialog.Cancel((Dialog)this)};
        }

        public void setLockApplied(boolean lockApplied) {
            lockStatusMap.put(this.wakeUpTimeInMillis, lockApplied);
            if (lockApplied) {
                log.log(Level.FINE, "isLockApplied set to true");
            }
        }
    }

    public class ChooseBadgeStep
    extends DialogWizardCommand.Step {
        public ChooseBadgeStep(String name, Command handler) {
            super((DialogWizardCommand)PrintBadgeWizard.this, name, handler);
        }

        public String handle(HxOp op) throws Exception {
            return "printStep";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            Array choices = new Array(BIOrionObject.class);
            BPerson person = (BPerson)op.get();
            OrionSession session = null;
            try {
                session = person.getOrionDatabase().createSession((Context)op);
                choices.addAll((Object[])person.getBadges(session).toArray());
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
            if (choices.size() > 0) {
                DialogWizardCommand.writeChoices((Object[])choices.trim(), null, (boolean)false, (String)"badge", (DialogWizardCommand.ChoiceRenderer)new OrionChoiceRenderer(), (HxOp)op);
            } else {
                DialogWizardCommand.writeChoices((Object[])choices.trim(), (String)PrintBadgeWizard.this.lexModule.getText("noBadgesFound", (Context)op), (boolean)false, (String)"badge", null, (HxOp)op);
                op.addOnload(SmartCommand.disableInvokeCode((String)op.scope("submit"), (String)HxUtil.getInnerQuote((HxOp)op), (boolean)true, (HxOp)op));
            }
        }
    }
}

