/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx;

import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.query.BBqlEngine;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.HxOptionsManager;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsec.nav.BEntsecNav;
import com.tridiumx.entsec.securityUtil.BActivityMonitor;
import com.tridiumx.entsec.securityUtil.BActivityQuery;
import com.tridiumx.entsec.securityUtil.BActivityRecord;
import com.tridiumx.entsec.securityUtil.BActivityRecordType;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.ui.query.BQueryTableOptions;
import com.tridiumx.entsec.securityUtil.ui.query.BWbQueryConfig;
import com.tridiumx.entsecHx.EntsecReportCommand;
import com.tridiumx.entsecHx.securityUtilHx.BHxActivityConfigurationView;
import com.tridiumx.entsecHx.securityUtilHx.orion.BHxLocalHistoryTableView;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import com.tridiumx.entsecHx.securityUtilHx.query.ColumnsCommand;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BOptions;
import javax.baja.util.BTypeSpec;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"entsec:ActivityMonitor", "entsec:ActivityQuery"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxActivityMonitorView
extends BHxQueryTableView {
    @Generated
    public static final BHxActivityMonitorView INSTANCE = new BHxActivityMonitorView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxActivityMonitorView.class);
    private static BImage auditImg = BImage.make((BIcon)BIcon.std((String)"history.png"));
    private static BImage attendanceImg = BImage.make((String)"module://entsec/rc/access/people.png");
    private static BImage accessImg = BImage.make((String)"module://entsec/rc/access/cards.png");
    private static BImage intrusionImg = BImage.make((String)"module://entsec/rc/intrusion/intrusion.png");
    private static BImage logImg = BImage.make((BIcon)BIcon.std((String)"history.png"));
    private static BImage yellowAlarmImg = BImage.make((String)"module://icons/x16/alarm.png");
    private static BImage redAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmRed.png");
    private static BImage greenAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmGreen.png");
    private static BImage orangeAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmOrange.png");
    private static BImage whiteAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmWhite.png");
    SmartCommand summaryCommand = new BHxLocalHistoryTableView.HistorySummaryCommand((BHxView)this);
    SmartCommand activityReportCommand;
    SmartCommand configCommand;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxActivityMonitorView() {
        this.registerEvent((Event)this.summaryCommand);
        this.columnsCommand = new ActivityColumnsCommand((BHxView)this);
        this.registerEvent((Event)this.columnsCommand);
        this.configCommand = new ConfigureCommand((BHxView)this);
        this.registerEvent((Event)this.configCommand);
        this.activityReportCommand = new ActivityReportCommand((BHxView)this);
        this.registerEvent((Event)this.activityReportCommand);
    }

    static BActivityMonitor getActivityMonitor(HxOp op) {
        BObject obj = op.get();
        if (obj instanceof BActivityMonitor) {
            return (BActivityMonitor)obj;
        }
        if (obj instanceof BActivityQuery) {
            return (BActivityMonitor)((BActivityQuery)obj).getParent();
        }
        return null;
    }

    public static BTypeSpec getRowType(HxOp op) {
        return BActivityRecord.TYPE.getTypeSpec();
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        if (BHxActivityMonitorView.getActivityMonitor(op).getPermissions((Context)op).hasAdminWrite()) {
            return new SmartCommand[]{this.summaryCommand, this.columnsCommand, this.filterCommand, this.refreshCommand, this.configCommand, this.activityReportCommand, this.exportCommand};
        }
        return new SmartCommand[]{this.summaryCommand, this.columnsCommand, this.filterCommand, this.refreshCommand, this.activityReportCommand, this.exportCommand};
    }

    public int getMaxResultSize(Context cx) {
        return BActivityMonitor.MAX_RESULT_SIZE;
    }

    public int getMaxPageSize(Context cx) {
        return BActivityMonitor.MAX_RESULT_SIZE;
    }

    public boolean supportsAutoRefresh(HxOp op) {
        return true;
    }

    public boolean defaultAutoRefresh(HxOp op) {
        return true;
    }

    @Override
    protected BITable<? extends BIObject> getCollection(BOrd baseOrd, BQuery query, HxOp op) {
        BProjection projection = query.getProjection();
        BProjectionColumn[] columns = projection.getProjectionColumns();
        boolean timestampFound = false;
        for (int i = 0; i < columns.length; ++i) {
            BTypeSpec typeSpec = (BTypeSpec)columns[i].get("typeSpec");
            if (!typeSpec.equals((Object)BAbsTime.TYPE.getTypeSpec())) continue;
            timestampFound = true;
        }
        if (!timestampFound) {
            throw new IllegalStateException("The Timestamp column is required for properly filtering the Activity Monitor.");
        }
        BBqlEngine engine = new BBqlEngine(baseOrd);
        return engine.compile(query).execute((Context)op);
    }

    @Override
    public BObject getBase(HxOp op) {
        BActivityMonitor monitor = BHxActivityMonitorView.getActivityMonitor(op);
        BActivityQuery query = monitor.getQuery();
        return query;
    }

    @Override
    public BQuery getQuery(HxOp op) {
        BActivityMonitor monitor = BHxActivityMonitorView.getActivityMonitor(op);
        BActivityQuery query = monitor.getQuery();
        query = QueryUtil.getWorkingCopy((BQuery)query, (BObject)this.getBase(op), (Context)op);
        return query;
    }

    @Override
    public BImage getRowIcon(TableCursor<? extends BIObject> cursor, HxOp op) {
        try {
            BActivityRecord rec = (BActivityRecord)cursor.get();
            BActivityRecordType recEnum = rec.getRecordType();
            switch (recEnum.getOrdinal()) {
                case 0: {
                    return accessImg;
                }
                case 4: {
                    return attendanceImg;
                }
                case 5: {
                    return auditImg;
                }
                case 6: {
                    return intrusionImg;
                }
                case 7: {
                    return logImg;
                }
                case 3: {
                    return orangeAlarmImg;
                }
                case 2: {
                    return redAlarmImg;
                }
                case 1: {
                    return yellowAlarmImg;
                }
                case 9: {
                    return greenAlarmImg;
                }
                case 8: {
                    return whiteAlarmImg;
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getRowKey(Type rowType, TableCursor<? extends BIObject> cursor, HxOp op) {
        try {
            BActivityRecord rec = (BActivityRecord)cursor.get();
            return rec.getEncodedSourceRecord();
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.getRowKey(rowType, cursor, op);
        }
    }

    class DetailsDialog
    extends Dialog {
        BObject rec;

        public DetailsDialog(String title, Command handler) {
            super(title, handler);
        }

        public void open(HxOp op, BObject rec) throws Exception {
            this.rec = rec;
            super.open(op);
        }

        protected void writeContent(HxOp op) throws Exception {
            String[] fieldNames = null;
            String[] fieldEditors = null;
            if (this.rec instanceof BAlarmRecord) {
                fieldNames = new String[]{"timestamp", "uuid", "sourceState", "ackState", "ackRequired", "source", "alarmClass", "priority", "normalTime", "ackTime", "user", "alarmData", "alarmTransition", "lastUpdate"};
                fieldEditors = new String[]{"smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "entsecHx:AlarmDataFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE"};
            } else if (this.rec instanceof BComplex) {
                Property[] props = ((BComplex)this.rec).getPropertiesArray();
                int len = props != null ? props.length : 0;
                Array names = new Array(String.class);
                Array editors = new Array(String.class);
                for (int i = 0; i < len; ++i) {
                    if (Flags.isHidden((BComplex)((BComplex)this.rec), (Slot)props[i])) continue;
                    names.add((Object)props[i].getName());
                    editors.add((Object)"smartTableHx:HxSmartDefaultFE");
                }
                fieldNames = (String[])names.trim();
                fieldEditors = (String[])editors.trim();
            }
            BFacets facets = BFacets.make((BFacets)BHxFieldSheet.getFieldsProvidedFacets(fieldNames), (BFacets)BHxFieldSheet.getFieldEditorsProvidedFacets(fieldEditors));
            HxOp subOp = op.make("activityRecord", this.rec, facets);
            BHxFieldSheet.INSTANCE.write(subOp);
        }

        public Command[] getCommands() {
            return new Command[]{this.makeSubmitCommand()};
        }
    }

    class DetailsCommand
    extends SmartCommand {
        DetailsDialog dialog;

        public DetailsCommand(BHxView view) {
            super(view);
            this.lexModule = LexiconModule.make(BHxActivityMonitorView.class);
            this.dialog = new DetailsDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "recordDetails";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean isDefaultAction() {
            return true;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            if (this.dialog.isSubmit(op)) {
                return;
            }
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            if (selectionList == null || selectionList.length < 1) {
                return;
            }
            BObject rec = BActivityRecord.decodeSourceRecord((String)selectionList[0]);
            if (rec != null) {
                this.dialog.open(op, rec);
                return;
            }
        }
    }

    public static class ConfigureCommand
    extends SmartCommand {
        public ConfigureCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "configureActivity";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BOrd ord = BOrd.make((String)("station:|" + BHxActivityMonitorView.getActivityMonitor(op).getSlotPathOrd() + "|view:" + BHxActivityConfigurationView.TYPE));
            this.redirect(op, op.toUri(ord));
        }
    }

    class ActivityReportCommand
    extends EntsecReportCommand {
        public ActivityReportCommand(BHxView view) {
            super(view);
        }

        @Override
        public BComponent getNewReport(HxOp op) {
            Type type;
            int i;
            BActivityMonitor activityMonitor = (BActivityMonitor)op.get();
            BActivityMonitor activityMonitorCopy = (BActivityMonitor)activityMonitor.newCopy();
            BActivityQuery query = activityMonitor.getQuery();
            BQuery copy = QueryUtil.getWorkingCopy((BQuery)query, (BObject)BHxActivityMonitorView.this.getBase(op), (Context)op);
            Property[] props = copy.getDynamicPropertiesArray();
            for (i = 0; i < props.length; ++i) {
                type = props[i].getType();
                if (!type.is(BQuery.TYPE) && !type.is(BEntsecNav.TYPE) && !type.is(BLink.TYPE)) continue;
                copy.remove(props[i].getName());
            }
            props = activityMonitorCopy.getDynamicPropertiesArray();
            for (i = 0; i < props.length; ++i) {
                type = props[i].getType();
                if (!type.is(BActivityMonitor.TYPE) && !type.is(BEntsecNav.TYPE) && !type.is(BLink.TYPE)) continue;
                activityMonitorCopy.remove(props[i].getName());
            }
            HxOptionsManager manager = new HxOptionsManager((BObject)copy, op);
            BQueryTableOptions options = (BQueryTableOptions)manager.load(BQueryTableOptions.TYPE);
            BQueryTableOptions newOptions = new BQueryTableOptions();
            BFilterSet set = options.getFilterSet((BQuery)query);
            if (set != null) {
                newOptions.setFilterSet((BQuery)query, (BFilterSet)set.newCopy());
            }
            activityMonitorCopy.setQuery((BActivityQuery)copy);
            activityMonitorCopy.setFlags((Slot)BActivityMonitor.query, activityMonitorCopy.getFlags((Slot)BActivityMonitor.query) | Integer.MIN_VALUE);
            manager.saveMounted((BOptions)newOptions);
            return activityMonitorCopy;
        }
    }

    class ActivityColumnsCommand
    extends ColumnsCommand {
        public ActivityColumnsCommand(BHxView view) {
            super(view);
        }

        @Override
        public void handle(HxOp op) throws Exception {
            if (op.get() instanceof BActivityMonitor && op.getPath().length() == 0) {
                StringBuffer sb = new StringBuffer();
                sb.append(op.getOrd().toString());
                sb.append("|slot:").append(BActivityMonitor.query.getName());
                sb.append("|view:").append(BWbQueryConfig.TYPE.toString());
                this.redirect(op, op.toUri(BOrd.make((String)sb.toString())));
            } else {
                super.handle(op);
            }
        }
    }
}

