/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsecHx.orionToolsHx.HxRemoteUtil;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nd.SysDefSession;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;
import javax.baja.web.BWebService;
import javax.servlet.http.HttpServletRequest;

public abstract class RedirectCommand
extends SmartCommand {
    private RedirectDialog dialog = new RedirectDialog((Command)this, false);
    private HttpsTunnelDialog httpsDialog = new HttpsTunnelDialog((Command)this);
    static Lexicon lex = Lexicon.make(RedirectCommand.class);

    public RedirectCommand(BHxView view) {
        this(view, smartTableHxLexModule);
    }

    public RedirectCommand(BHxView view, LexiconModule lexModule) {
        super(view, lexModule);
    }

    public String getName(HxOp op) {
        return "hyperlink";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.singleSelection;
    }

    public boolean isDefaultAction() {
        return false;
    }

    public abstract String getPath(HxOp var1);

    public abstract String getStationName(HxOp var1);

    public abstract String getHostName(HxOp var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HxOp op) throws Exception {
        int defaultPort;
        String stationName = this.getStationName(op);
        if (stationName == null || stationName.equals(Sys.getStation().getStationName())) {
            this.redirect(op, this.getPath(op));
            return;
        }
        Boolean tunnelRedirects = (Boolean)op.getRequest().getSession().getAttribute("tunnelRedirects");
        BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        Object niagaraStation = null;
        if (!this.dialog.isSubmit(op)) {
            this.dialog.tunnel = false;
            this.dialog.open(op);
            return;
        }
        HttpServletRequest req = op.getRequest();
        boolean useHttps = req.isSecure();
        BNiagaraStation remStation = (BNiagaraStation)network.getNiagaraStation(stationName);
        String scheme = "http";
        boolean useFoxs = remStation.getClientConnection().getUseFoxs();
        if (useFoxs) {
            useHttps = true;
            scheme = "https";
        } else {
            useHttps = false;
            scheme = "http";
        }
        int port = defaultPort = useHttps ? 443 : 80;
        SysDefSession session = null;
        try {
            session = network.createSysDefSession((Context)op);
            BProviderStation station = (BProviderStation)session.getStation(stationName);
            if (station != null) {
                port = useHttps ? station.getHttpsPort() : station.getHttpPort();
            } else {
                BWebService remoteWebService = (BWebService)HxRemoteUtil.getRemoteComponent(BOrd.make((String)"service:web:WebService"), stationName, op);
                if (remoteWebService != null) {
                    remoteWebService.lease();
                    port = useHttps ? 443 : 80;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append(scheme);
        sb.append("://");
        sb.append(this.getHostName(op));
        if (port != defaultPort) {
            sb.append(":").append(Integer.toString(port));
        }
        sb.append(this.getPath(op));
        this.redirect(op, sb.toString());
    }

    static class HttpsTunnelDialog
    extends Dialog {
        String msg;

        public HttpsTunnelDialog(Command handler) {
            super(lex.getText("httpsTunnel.title"), handler);
        }

        public Command[] getCommands() {
            return new Command[]{this.makeSubmitCommand("confirmOk"), this.makeCancelCommand()};
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<table>");
            out.w((Object)"<tr><td>");
            String text = TextUtil.replace((String)this.msg, (String)"\n", (String)"<br/>");
            text = TextUtil.replace((String)text, (String)"\r", (String)"");
            out.w((Object)"<b>").w((Object)text).w((Object)"&nbsp;</b>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
        }
    }

    static class RedirectDialog
    extends Dialog {
        boolean tunnel;

        public RedirectDialog(Command handler, boolean tunnel) {
            super(lex.getText("hyperlink.label"), handler);
            this.tunnel = tunnel;
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            String text = TextUtil.replace((String)lex.getText("redirect.dialogMessage"), (String)"\n", (String)"<br/>");
            text = TextUtil.replace((String)text, (String)"\r", (String)"");
            out.w((Object)"<br/>");
            out.w((Object)text);
            out.w((Object)"<br/>");
            out.w((Object)"<br/>");
            out.w((Object)"<table><tr><td>");
            out.w((Object)"<input type='radio'");
            out.w((Object)" ").attr("name", op.scope("redirectMethod"));
            out.w((Object)" ").attr("id", op.scope("redirectMethod"));
            if (!this.tunnel) {
                out.w((Object)" checked ");
            }
            out.w((Object)" value='direct' ").w((Object)"/><b>");
            out.safe((Object)lex.getText("redirect.direct"));
            out.w((Object)"</b></td></tr><tr><td>");
            out.w((Object)"<input type='radio'");
            out.w((Object)" ").attr("name", op.scope("redirectMethod"));
            out.w((Object)" ").attr("id", op.scope("redirectMethod"));
            if (this.tunnel) {
                out.w((Object)" checked ");
            }
            out.w((Object)" value='tunnel' ").w((Object)"/><b>");
            out.safe((Object)lex.getText("redirect.tunnel"));
            out.w((Object)"</b></td></tr></table>");
            out.w((Object)"<br/>");
            out.w((Object)"<br/>");
            out.w((Object)"<input type='checkbox'");
            out.w((Object)" ").attr("name", op.scope("rememberTunnelSelection"));
            out.w((Object)" ").attr("id", op.scope("rememberTunnelSelection"));
            out.w((Object)"/>");
            out.safe((Object)lex.getText("redirect.rememberSelection"));
        }
    }
}

