/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsecHx.securityUtilHx.alarm.BHxAlarmExtManager;
import com.tridiumx.entsecHx.securityUtilHx.fieldeditors.AlarmInstructionsDialog;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class EditInstructions
extends SmartCommand {
    AlarmInstructionsDialog dlg;

    public EditInstructions(BHxView view) {
        super(view);
        this.dlg = new AlarmInstructionsDialog(this.getDisplayName(null), (Command)this, view);
    }

    public String getName(HxOp op) {
        return "editInstructions";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.anySelection;
    }

    public void handle(HxOp op) throws Exception {
        if (!this.dlg.isSubmit(op)) {
            BComponent ext;
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            String rowId = selectionList[0];
            int idx = rowId.indexOf(59);
            String stationName = SlotPath.unescape((String)rowId.substring(0, idx));
            String slotPath = rowId.substring(idx + 1, rowId.length());
            BOrd ord = BOrd.make((String)("station:|" + slotPath));
            if (stationName.equals(Sys.getStation().getStationName())) {
                ext = (BComponent)ord.get();
            } else {
                BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
                BFoxSession foxSession = RemoteUtil.getFoxSession((BNiagaraStation)station);
                ext = RemoteUtil.getRemoteComponent((BFoxSession)foxSession, (String)ord.toString());
            }
            ext.lease();
            Property p = ext.getProperty("alarmInstructions");
            BAlarmInstructions inst = (BAlarmInstructions)ext.get(p);
            try {
                this.dlg.open(op, inst);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        BAlarmInstructions inst = this.dlg.save(op);
        this.save(inst, op);
        BHxAlarmExtManager.INSTANCE.reloadTable(op);
    }

    public BObject save(BAlarmInstructions inst, HxOp op) throws Exception {
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        BComponent[] exts = new BComponent[selectionList.length];
        for (int i = 0; i < selectionList.length; ++i) {
            String rowId = selectionList[i];
            int idx = rowId.indexOf(59);
            String stationName = SlotPath.unescape((String)rowId.substring(0, idx));
            String slotPath = rowId.substring(idx + 1, rowId.length());
            BOrd ord = BOrd.make((String)("station:|" + slotPath));
            if (stationName.equals(Sys.getStation().getStationName())) {
                exts[i] = (BComponent)ord.get();
            } else {
                BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
                BFoxSession foxSession = RemoteUtil.getFoxSession((BNiagaraStation)station);
                exts[i] = RemoteUtil.getRemoteComponent((BFoxSession)foxSession, (String)ord.toString());
            }
            exts[i].lease();
            exts[i].set(exts[i].getProperty("alarmInstructions"), (BValue)inst, (Context)op);
        }
        return inst;
    }

    public boolean process(HxOp op) throws Exception {
        if (this.dlg.process(op)) {
            return true;
        }
        if (!this.matchesScope(op)) {
            return false;
        }
        return super.process(op);
    }
}

