/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsecHx.securityUtilHx.alarm.BHxAlarmExtManager;
import com.tridiumx.entsecHx.securityUtilHx.alarm.VideoCommand;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class TableVideoCommand
extends VideoCommand {
    public TableVideoCommand(BHxView view) {
        super(view);
    }

    @Override
    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.singleSelection;
    }

    @Override
    public void handle(HxOp op) throws Exception {
        if (!this.dlg.isSubmit(op)) {
            this.dlg.open(op);
            return;
        }
        this.save(op, true);
        BHxAlarmExtManager.INSTANCE.reloadTable(op);
    }

    @Override
    public BComponent[] getAlarmSourceExts(HxOp op) {
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        BComponent[] exts = new BComponent[selectionList.length];
        for (int i = 0; i < selectionList.length; ++i) {
            String rowId = selectionList[i];
            int idx = rowId.indexOf(59);
            String stationName = SlotPath.unescape((String)rowId.substring(0, idx));
            String slotPath = rowId.substring(idx + 1, rowId.length());
            BOrd ord = BOrd.make((String)("station:|" + slotPath));
            if (stationName.equals(Sys.getStation().getStationName())) {
                exts[i] = (BComponent)ord.get();
                continue;
            }
            BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
            BFoxSession foxSession = RemoteUtil.getFoxSession((BNiagaraStation)station);
            exts[i] = RemoteUtil.getRemoteComponent((BFoxSession)foxSession, (String)ord.toString());
        }
        return exts;
    }
}

