/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.discover.nd;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BRoleManager;
import com.tridium.sys.NreLib;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.replicate.BNiagaraReplicationDeviceExt;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDefSecurity;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BAddStationsJob;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BHxNiagaraNetworkView;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.nd.BStationRole;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BClientCredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.PermissionException;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BRemoteConfigJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BRemoteConfigJob.class);
    public boolean sslApprovalNeeded = false;
    public String remoteStation = null;
    public String certStationName = null;
    static Lexicon lex = Lexicon.make(BRemoteConfigJob.class);
    BNiagaraNetwork network;
    String stationName;
    boolean stationEnabled;
    String stationUser;
    BPassword stationPassword;
    BClientCredentials stationUserCred;
    boolean useFoxs;
    int foxPort;
    BStationRole stationRole;
    boolean editedCredentials;
    Context context;
    BNiagaraStation[] deleteStations = null;
    String interest;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRemoteConfigJob(BNiagaraNetwork network, String stationName, boolean stationEnabled, BClientCredentials stationUserCred, boolean useFoxs, int foxPort, BStationRole stationRole, boolean editedCredentials, Context context) {
        this.network = network;
        this.stationName = stationName;
        this.stationEnabled = stationEnabled;
        this.stationUserCred = stationUserCred;
        this.useFoxs = useFoxs;
        this.foxPort = foxPort;
        this.stationRole = stationRole;
        this.editedCredentials = editedCredentials;
        this.context = context;
        this.interest = "SecurityRemoteConfig" + System.identityHashCode((Object)this);
    }

    public BRemoteConfigJob(BNiagaraStation[] deleteStations, Context context) {
        this.deleteStations = deleteStations;
        if (deleteStations == null) {
            this.deleteStations = new BNiagaraStation[0];
        }
        this.interest = "SecurityRemoteConfig" + System.identityHashCode((Object)this);
        this.context = context;
    }

    public BRemoteConfigJob() {
    }

    public boolean isCertApprovalNeeded() {
        return this.sslApprovalNeeded;
    }

    public String getRemoteStation() {
        return this.remoteStation;
    }

    public String getCertStationName() {
        return this.certStationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run(Context cx) throws Exception {
        block73: {
            block64: {
                block65: {
                    block62: {
                        block63: {
                            block60: {
                                block61: {
                                    if (this.deleteStations != null) {
                                        len = this.deleteStations.length;
                                        joinedStations = new Array(String.class);
                                        for (i = 0; i < this.deleteStations.length; ++i) {
                                            ext = (BNiagaraReplicationDeviceExt)this.deleteStations[i].getMixIn(BNiagaraReplicationDeviceExt.TYPE);
                                            if (ext == null || !ext.getJoined()) continue;
                                            joinedStations.add((Object)this.deleteStations[i].getStationName());
                                        }
                                        this.log().start("Deleting " + len + " stations");
                                        try {
                                            if (len > 0) {
                                                counter = new BAddStationsJob.Counter(len);
                                                workers = new DeleteStationWork[len];
                                                this.network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                                                for (i = 0; i < len; ++i) {
                                                    workers[i] = new DeleteStationWork(this, this.deleteStations[i], counter, this.context);
                                                    this.network.getWorkers().process((Object)workers[i]);
                                                }
                                                i = counter;
                                                synchronized (i) {
                                                    while (counter.count > 0) {
                                                        counter.wait(60000L);
                                                    }
                                                }
                                                this.network.getSysDefProvider().purge();
                                                for (i = 0; i < len; ++i) {
                                                    if (workers[i].e == null) continue;
                                                    throw workers[i].e;
                                                }
                                            }
                                            this.progress(100);
                                            return;
                                        }
                                        finally {
                                            try {
                                                this.network.getSysDefProvider().purge();
                                            }
                                            catch (Exception e) {
                                                this.log().failed("cannot purge SysDef", (Throwable)e);
                                            }
                                            if (joinedStations.size() > 0) {
                                                service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                                                service.doCleanupOrphanedMappables((BJob)this, (String[])joinedStations.trim());
                                            }
                                            for (i = 0; i < len; ++i) {
                                                if (this.deleteStations[i].getParent() == null) continue;
                                                name = this.deleteStations[i].getName();
                                                ((BComponent)this.deleteStations[i].getParent()).remove(this.deleteStations[i].getPropertyInParent(), cx);
                                                this.log().success("Removed local NiagaraStation for '" + name + "'");
                                            }
                                        }
                                    }
                                    this.log().start("Remote Station '" + this.stationName + "' configuration");
                                    this.progress(1);
                                    if (this.network == null) {
                                        throw new BajaRuntimeException(BRemoteConfigJob.lex.getText("stationView.error.noNetwork"));
                                    }
                                    this.remoteStation = this.stationName;
                                    station = (BNiagaraStation)this.network.getNiagaraStation(this.stationName);
                                    remoteSession = null;
                                    ex = null;
                                    displayStationName = this.stationName;
                                    host = (BIpHost)station.getRemoteHost();
                                    credentials = (BUsernameAndPassword)station.getClientConnection().getCredentialStore().getCredentials();
                                    credentialStore = station.getClientConnection().getCredentialStore();
                                    remoteSession = BFoxSession.make((String)this.stationName, (BHost)host, (int)station.getFoxPort(), (boolean)station.getClientConnection().getUseFoxs());
                                    remoteSession.getConnection().setCredentials((BIUserCredentials)credentials);
                                    remoteSession.getConnection().setPort(station.getFoxPort());
                                    remoteSession.getConnection().setUseFoxs(station.getClientConnection().getUseFoxs());
                                    remoteSession.getConnection().setCheckBrandCompatibility(false);
                                    remoteSession.getConnection().setAuthenticationClient((AuthenticationClient)remoteSession.getConnection());
                                    remoteSession.engageNoRetry(this.interest, 0L);
                                    if (this.isAlive()) break block60;
                                    if (remoteSession == null) break block61;
                                    remoteSession.disengage(this.interest);
                                }
                                if (!this.isAlive()) {
                                    throw new Exception("Job Canceled");
                                }
                                return;
                            }
                            remoteNetwork = (BNiagaraNetwork)remoteSession.getService(BNiagaraNetwork.TYPE);
                            myStationName = Sys.getStation().getStationName();
                            remoteStation = BRemoteConfigJob.findStation((BComponent)remoteNetwork, myStationName, remoteSession.getConnection().session().isLegacyConnection());
                            remoteStation.lease(5, 120000L);
                            remoteStation.setEnabled(this.stationEnabled);
                            remoteStation.getClientConnection().lease(5, 120000L);
                            stationUserPassword = (BUsernameAndPassword)this.stationUserCred.getCredentials();
                            remoteStationUserPassword = (BUsernameAndPassword)remoteStation.getClientConnection().getCredentialStore().getCredentials();
                            forceDisconnect = remoteStation.getClientConnection().getUsername().equals(stationUserPassword.getUsername()) == false;
                            remoteStation.getClientConnection().setCredentials(this.stationUserCred.getCredentials());
                            remoteStation.getClientConnection().setPort(this.foxPort);
                            remoteStation.getClientConnection().setUseFoxs(this.useFoxs);
                            if (!this.stationEnabled) ** GOTO lbl236
                            if (this.editedCredentials) {
                                remoteStation.getClientConnection().manualDisconnect();
                            }
                            if (this.isAlive()) break block62;
                            if (remoteSession == null) break block63;
                            remoteSession.disengage(this.interest);
                        }
                        if (!this.isAlive()) {
                            throw new Exception("Job Canceled");
                        }
                        return;
                    }
                    remoteSession = BFoxSession.make((String)this.stationName, (BHost)host, (int)station.getFoxPort(), (boolean)station.getClientConnection().getUseFoxs());
                    remoteSession.getConnection().setCredentials((BIUserCredentials)credentials);
                    remoteSession.getConnection().setPort(station.getFoxPort());
                    remoteSession.getConnection().setUseFoxs(station.getClientConnection().getUseFoxs());
                    remoteSession.getConnection().setCheckBrandCompatibility(false);
                    remoteSession.getConnection().setAuthenticationClient((AuthenticationClient)station.getClientConnection());
                    remoteSession.engageNoRetry(this.interest, 0L);
                    if (this.isAlive()) break block64;
                    if (remoteSession == null) break block65;
                    remoteSession.disengage(this.interest);
                }
                if (!this.isAlive()) {
                    throw new Exception("Job Canceled");
                }
                return;
            }
            try {
                this.progress(5);
                remoteNetwork = (BNiagaraNetwork)remoteSession.getService(BNiagaraNetwork.TYPE);
                remoteStation = BRemoteConfigJob.findStation((BComponent)remoteNetwork, myStationName, remoteSession.getConnection().session().isLegacyConnection());
                remoteStation.lease(5, 120000L);
                if (remoteStation.getClientConnection().getState().equals("Connecting...")) {
                    this.log().message("Waiting for previous connection attempt to complete...");
                }
                this.progress(7);
                while (remoteStation.getClientConnection().getState().equals("Connecting...")) {
                    Thread.sleep(1000L);
                    remoteStation.lease(5, 120000L);
                }
                this.progress(10);
                displayStationName = remoteStation.getStationName();
                if (this.editedCredentials) {
                    remoteStation.getClientConnection().manualConnect();
                    this.log().success("Reverse Connection Success using address: " + remoteStation.getAddress());
                } else {
                    this.log().success("Reverse Connection is disabled: " + remoteStation.getAddress());
                }
                ** GOTO lbl236
                {
                    catch (Exception e) {
                        block71: {
                            block72: {
                                block69: {
                                    block70: {
                                        block67: {
                                            block68: {
                                                this.progress(20);
                                                this.log().failed("Cannot complete reverse connection to address:" + remoteStation.getAddress(), (Throwable)e);
                                                oldAddress = remoteStation.getAddress();
                                                isIpV6 = false;
                                                try {
                                                    isIpV6 = host.getInetAddress() instanceof Inet6Address;
                                                }
                                                catch (Exception exp) {
                                                    this.displayFailureMessage(exp, "stationView.error.HostName", this.stationName);
                                                }
                                                catch (Throwable exp) {
                                                    // empty catch block
                                                }
                                                attemptedAddress = null;
                                                remoteSession = BFoxSession.make((String)this.stationName, (BHost)host, (int)station.getFoxPort(), (boolean)station.getClientConnection().getUseFoxs());
                                                remoteSession.getConnection().setCredentials((BIUserCredentials)credentials);
                                                remoteSession.getConnection().setPort(station.getFoxPort());
                                                remoteSession.getConnection().setUseFoxs(station.getClientConnection().getUseFoxs());
                                                remoteSession.getConnection().setCheckBrandCompatibility(false);
                                                remoteSession.engageNoRetry(this.interest, 0L);
                                                if (this.isAlive()) break block67;
                                                if (remoteSession == null) break block68;
                                                remoteSession.disengage(this.interest);
                                            }
                                            if (!this.isAlive()) {
                                                throw new Exception("Job Canceled");
                                            }
                                            return;
                                        }
                                        try {
                                            remoteNetwork = (BNiagaraNetwork)remoteSession.getService(BNiagaraNetwork.TYPE);
                                            remoteStation = BRemoteConfigJob.findStation((BComponent)remoteNetwork, myStationName, remoteSession.getConnection().session().isLegacyConnection());
                                            remoteStation.lease(5, 120000L);
                                            attemptedAddress = BOrd.make((String)("ip:" + NreLib.getLocalHost((boolean)isIpV6).getHostAddress()));
                                            this.progress(30);
                                            remoteStation.setAddress(attemptedAddress);
                                            this.progress(40);
                                        }
                                        catch (Exception x) {
                                            this.progress(50);
                                            this.displayFailureMessage(x, "stationView.error.IPAddress", this.stationName);
                                        }
                                        displayStationName = this.stationName;
                                        remoteSession = BFoxSession.make((String)this.stationName, (BHost)host, (int)station.getFoxPort(), (boolean)station.getClientConnection().getUseFoxs());
                                        remoteSession.getConnection().setCredentials((BIUserCredentials)credentials);
                                        remoteSession.getConnection().setPort(station.getFoxPort());
                                        remoteSession.getConnection().setUseFoxs(station.getClientConnection().getUseFoxs());
                                        remoteSession.getConnection().setCheckBrandCompatibility(false);
                                        remoteSession.engageNoRetry(this.interest, 0L);
                                        if (this.isAlive()) break block69;
                                        if (remoteSession == null) break block70;
                                        remoteSession.disengage(this.interest);
                                    }
                                    if (!this.isAlive()) {
                                        throw new Exception("Job Canceled");
                                    }
                                    return;
                                }
                                remoteNetwork = (BNiagaraNetwork)remoteSession.getService(BNiagaraNetwork.TYPE);
                                remoteStation = BRemoteConfigJob.findStation((BComponent)remoteNetwork, myStationName, remoteSession.getConnection().session().isLegacyConnection());
                                remoteStation.lease(5, 120000L);
                                this.progress(60);
                                if (remoteStation.getClientConnection().getState().equals("Connecting...")) {
                                    this.log().message("Waiting for previous connection attempt to complete...");
                                }
                                while (remoteStation.getClientConnection().getState().equals("Connecting...")) {
                                    Thread.sleep(1000L);
                                    remoteStation.lease(5, 120000L);
                                }
                                this.progress(70);
                                displayStationName = remoteStation.getStationName();
                                if (this.editedCredentials) {
                                    remoteStation.getClientConnection().manualConnect();
                                    this.log().success("Reverse Connection Success using address: " + remoteStation.getAddress());
                                } else {
                                    this.log().success("Reverse Connection is disabled: " + remoteStation.getAddress());
                                }
                                if (this.isAlive()) break block71;
                                if (remoteSession == null) break block72;
                                remoteSession.disengage(this.interest);
                            }
                            if (!this.isAlive()) {
                                throw new Exception("Job Canceled");
                            }
                            return;
                        }
                        try {
                            block74: {
                                break block74;
                                {
                                    catch (Exception ex2) {
                                        this.progress(80);
                                        remoteStation.lease(5, 120000L);
                                        this.log().failed("Cannot complete reverse connection to address: " + attemptedAddress + ", reverting to oldAddress", (Throwable)ex2);
                                        remoteStation.setAddress(oldAddress);
                                        throw ex2;
                                    }
                                }
                            }
                            if ((roleEx = BRemoteConfigJob.checkRoleAssignment(remoteSession, this.stationRole, this.stationName, station)) == null) {
                                station.getSysDef().getRoleManager().set(BRoleManager.desiredRole, (BValue)this.stationRole, this.context);
                                station.getSysDef().getRoleManager().doExecute();
                            } else {
                                ex = roleEx;
                                if (ex != null) {
                                    throw ex;
                                }
                            }
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                            this.displayFailureMessage(ee, "stationView.error.remoteConnectFailure", displayStationName);
                        }
                        catch (Throwable var20_42) {
                            throw var20_42;
                        }
                    }
                }
            }
            finally {
                if (remoteSession != null) {
                    remoteSession.disengage(this.interest);
                }
                if (this.isAlive()) break block73;
                throw new Exception("Job Canceled");
            }
        }
    }

    public Exception displayFailureMessage(Exception ex, String failureMsg, String stationName) throws Exception {
        if (ex instanceof FoxAuthenticationException || ex instanceof AuthenticationException) {
            this.log().failed(lex.getText("stationView.error.authentication", new Object[]{stationName}));
            throw new FoxAuthenticationException("Authentication failed", null);
        }
        if (ex instanceof ConnectException) {
            this.log().failed(lex.getText("stationView.error.port", new Object[]{stationName}));
            throw new ConnectException("Fox Port Connection failed");
        }
        if (ex instanceof UnknownHostException) {
            this.log().failed(lex.getText("stationView.error.HostName", new Object[]{stationName}));
            throw new UnknownHostException("UnknownHostException: Invalid HostName.");
        }
        if (ex instanceof IOException) {
            if (ex.getClass().getName().equals("javax.net.ssl.SSLHandshakeException") || ex.getClass().getName().equals("javax.net.ssl.SSLException")) {
                this.sslApprovalNeeded = true;
                this.certStationName = stationName;
                this.log().failed(lex.getText("stationView.error.certificate", new Object[]{stationName}));
                throw new IOException("SSLHandshakeException: Failed certificate validation");
            }
            if (ex.getMessage().equals("Expected 'f', got '0x15'")) {
                this.log().failed(lex.getText("stationView.error.foxs", new Object[]{stationName}));
                throw new IOException("Exception: fox/foxs connection failed");
            }
            this.log().failed(lex.getText(failureMsg));
            throw new IOException();
        }
        if (ex instanceof ActionInvokeException) {
            Throwable tExcep = ex.getCause();
            if (tExcep != null) {
                if (tExcep.getMessage().indexOf("SSLHandshakeException") > -1 || tExcep.getMessage().indexOf("SSLException") > -1) {
                    this.sslApprovalNeeded = true;
                    this.certStationName = stationName;
                    this.log().failed(lex.getText("stationView.error.certificate", new Object[]{stationName}));
                    throw new IOException("SSLHandshakeException: Failed certificate validation ");
                }
                if (tExcep.getMessage().indexOf("FoxAuthenticationException") > -1) {
                    this.log().failed(lex.getText("stationView.error.authentication", new Object[]{stationName}));
                    throw new FoxAuthenticationException("Authentication failed", null);
                }
                if (tExcep.getMessage().indexOf("Expected 'f', got '0x15'") > -1) {
                    this.log().failed(lex.getText("stationView.error.foxs", new Object[]{stationName}));
                    throw new IOException("Exception: fox/foxs connection failed.. ");
                }
                if (tExcep.getMessage().indexOf("java.net.ConnectException") > -1) {
                    this.log().failed(lex.getText("stationView.error.port", new Object[]{stationName}));
                    throw new IOException("Exception: Invalid Port ");
                }
                this.log().failed(lex.getText("stationView.error.remoteConnectFailure", new Object[]{stationName}), (Throwable)ex);
                throw new IOException("Failure during remote configuration of station > " + stationName + " : " + tExcep.getMessage());
            }
            this.log().failed("Failure during remote configuration of station " + stationName, (Throwable)ex);
            throw ex;
        }
        this.log().failed("Failure during remote configuration of station " + stationName, (Throwable)ex);
        throw new BajaRuntimeException("Failed");
    }

    static BNiagaraStation findStation(BComponent comp, String name, boolean isLegacyconnection) {
        if (!isLegacyconnection) {
            comp.lease(5, 120000L);
        } else {
            comp.lease();
        }
        BValue slot = comp.get(name);
        if (slot instanceof BNiagaraStation) {
            return (BNiagaraStation)slot;
        }
        BComponent[] children = comp.getChildComponents();
        for (int i = 0; i < children.length; ++i) {
            BNiagaraStation station = BRemoteConfigJob.findStation(children[i], name, isLegacyconnection);
            if (station == null) continue;
            return station;
        }
        return null;
    }

    static Exception checkRoleAssignment(BFoxSession remoteSession, BStationRole stationRole, String stationName, BNiagaraStation station) {
        BajaRuntimeException e = null;
        switch (stationRole.getOrdinal()) {
            case 1: {
                if (BHxNiagaraNetworkView.isSubordinate()) {
                    e = new BajaRuntimeException(lex.getText("stationView.misConfig.subToSub"));
                    break;
                }
                if (BRemoteConfigJob.isSupervisor(remoteSession)) {
                    e = new BajaRuntimeException(lex.getText("stationView.misConfig.subIsSup", new Object[]{stationName}));
                    break;
                }
                if (BRemoteConfigJob.hasDifferentSupervisor(remoteSession)) {
                    e = new BajaRuntimeException(lex.getText("stationView.misConfig.subHasSup", new Object[]{stationName}));
                    break;
                }
                if (BMonitorSysDefSecurity.isPlatformValidSupervisor()) break;
                e = new BajaRuntimeException(lex.getText("stationView.misConfig.platNotSup", new Object[]{Sys.getStation().getStationName()}));
                break;
            }
            case 2: {
                if (BHxNiagaraNetworkView.isSupervisor()) {
                    e = new BajaRuntimeException(lex.getText("stationView.misConfig.supToSup"));
                    break;
                }
                if (BRemoteConfigJob.isSubordinate(remoteSession)) {
                    e = new BajaRuntimeException(lex.getText("stationView.misConfig.supIsSub", new Object[]{stationName}));
                    break;
                }
                if (BRemoteConfigJob.hasDifferentSupervisor(stationName)) {
                    e = new BajaRuntimeException(lex.getText("stationView.misConfig.duplicateSup"));
                    break;
                }
                if (station.getHostModel().equals("Workstation")) break;
                e = new BajaRuntimeException(lex.getText("stationView.misConfig.platNotSup", new Object[]{stationName}));
                break;
            }
        }
        return e;
    }

    static boolean isSupervisor(BFoxSession foxSession) {
        try {
            BEnterpriseSecurityService remoteEntsecService = (BEnterpriseSecurityService)foxSession.getService(BEnterpriseSecurityService.TYPE);
            remoteEntsecService.lease(5, 120000L);
            BMonitorSysDefSecurity remoteSysDef = remoteEntsecService.getMonitorSysDefSecurity();
            remoteSysDef.lease(0, 120000L);
            return remoteSysDef.getHasSecuritySubordinate();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static boolean isSubordinate(BFoxSession foxSession) {
        try {
            BEnterpriseSecurityService remoteEntsecService = (BEnterpriseSecurityService)foxSession.getService(BEnterpriseSecurityService.TYPE);
            remoteEntsecService.lease(0, 120000L);
            BMonitorSysDefSecurity remoteSysDef = remoteEntsecService.getMonitorSysDefSecurity();
            remoteSysDef.lease(0, 120000L);
            return remoteSysDef.getHasSecuritySupervisor();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static boolean hasDifferentSupervisor(BFoxSession foxSession) {
        try {
            BEnterpriseSecurityService remoteEntsecService = (BEnterpriseSecurityService)foxSession.getService(BEnterpriseSecurityService.TYPE);
            remoteEntsecService.lease(0, 120000L);
            BMonitorSysDefSecurity remoteSysDef = remoteEntsecService.getMonitorSysDefSecurity();
            remoteSysDef.lease(0, 120000L);
            return remoteSysDef.getHasSecuritySupervisor() && !remoteSysDef.isSecuritySupervisor(Sys.getStation().getStationName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static boolean hasDifferentSupervisor(String stationName) {
        try {
            BEnterpriseSecurityService entsecService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            BMonitorSysDefSecurity monitorSysDef = entsecService.getMonitorSysDefSecurity();
            return monitorSysDef.getHasSecuritySupervisor() && !monitorSysDef.isSecuritySupervisor(stationName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static class DeleteStationWork
    implements Runnable {
        BRemoteConfigJob job;
        BAddStationsJob.Counter counter;
        BNiagaraStation deleteStation;
        Context cx;
        Exception e = null;

        DeleteStationWork(BRemoteConfigJob job, BNiagaraStation deleteStation, BAddStationsJob.Counter counter, Context cx) {
            this.job = job;
            this.deleteStation = deleteStation;
            this.counter = counter;
            this.cx = cx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String stationName = null;
            try {
                stationName = this.deleteStation.getStationName();
                Object permissions = this.deleteStation.getParentComponent().getPermissions(this.cx);
                if (!permissions.hasAdminWrite()) {
                    throw new PermissionException("Missing admin write permission.  Cannot delete station " + stationName);
                }
                BFoxSession remoteSession = null;
                try {
                    this.job.log().message("Attempting to disable reverse station side connection: '" + stationName + "'...");
                    this.deleteStation.getSysDef().getRoleManager().setDesiredRole(BStationRole.peer);
                    this.deleteStation.getSysDef().getRoleManager().doExecute();
                    BIpHost host = (BIpHost)this.deleteStation.getRemoteHost();
                    BUsernameAndPassword credentials = (BUsernameAndPassword)this.deleteStation.getClientConnection().getCredentialStore().getCredentials();
                    remoteSession = BFoxSession.make((String)stationName, (BHost)host, (int)this.deleteStation.getFoxPort(), (boolean)this.deleteStation.getClientConnection().getUseFoxs());
                    remoteSession.getConnection().setCredentials((BIUserCredentials)credentials);
                    remoteSession.getConnection().setPort(this.deleteStation.getFoxPort());
                    remoteSession.getConnection().setUseFoxs(this.deleteStation.getClientConnection().getUseFoxs());
                    remoteSession.getConnection().setCheckBrandCompatibility(false);
                    remoteSession.engageNoRetry(this.job.interest, 0L);
                    BNiagaraNetwork remoteNetwork = (BNiagaraNetwork)remoteSession.getService(BNiagaraNetwork.TYPE);
                    BNiagaraStation remoteStation = BRemoteConfigJob.findStation((BComponent)remoteNetwork, Sys.getStation().getStationName(), remoteSession.getConnection().session().isLegacyConnection());
                    remoteStation.lease(5, 120000L);
                    remoteStation.getClientConnection().setCredentials((BIUserCredentials)new BUsernameAndPassword("", BPassword.make((String)"")));
                    remoteStation.setEnabled(false);
                    remoteNetwork.getSysDefProvider().purge();
                    this.job.log().success("Reverse station connection is now disabled: '" + stationName + "'...");
                }
                catch (Exception ex) {
                    this.job.log().failed("Failure during reverse side disabling of '" + stationName + "'", (Throwable)ex);
                    this.e = ex;
                }
                finally {
                    if (remoteSession != null) {
                        remoteSession.disengage(this.job.interest);
                    }
                    if (this.deleteStation.getParent() != null) {
                        ((BComponent)this.deleteStation.getParent()).remove(this.deleteStation.getPropertyInParent(), this.cx);
                        if (this.e == null) {
                            this.job.log().success("Removed local NiagaraStation for '" + stationName + "'");
                        } else {
                            this.job.log().message("Removed local NiagaraStation for '" + stationName + "' even though reverse side could not be reached.");
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.e = ex;
            }
            finally {
                BAddStationsJob.Counter counter = this.counter;
                synchronized (counter) {
                    --this.counter.count;
                    if (this.counter.count < 1) {
                        this.counter.notifyAll();
                    } else {
                        this.job.progress((int)((float)(this.counter.length - this.counter.count) / (float)this.counter.length * 100.0f));
                    }
                }
            }
        }
    }
}

