/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.discover.nd;

import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.BSystemPlatformService;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.securityUtil.BSafeSimpleJob;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BAddStationsJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
public class BSyncTimeJob
extends BSafeSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BSyncTimeJob.class);
    static Lexicon lex = Lexicon.make(BSyncTimeJob.class);
    private BNiagaraStation[] stations;
    private BAddStationsJob.Counter counter;
    private static final int WAIT_DURATION = 2000;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSyncTimeJob() {
    }

    public BSyncTimeJob(BNiagaraStation[] stations) {
        this.stations = stations;
        this.counter = new BAddStationsJob.Counter(stations.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        this.log().start("Starting remote time sync on " + this.stations.length + (this.stations.length == 1 ? " station" : " stations"));
        SyncTimeWork[] workers = new SyncTimeWork[this.stations.length];
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = new SyncTimeWork(this, this.stations[i], this.counter, cx);
            this.stations[i].postAsync((Runnable)workers[i]);
        }
        BAddStationsJob.Counter i = this.counter;
        synchronized (i) {
            while (this.counter.count > 0) {
                try {
                    this.counter.wait(20000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
        for (int i2 = 0; i2 < workers.length; ++i2) {
            if (workers[i2].e == null) continue;
            throw workers[i2].e;
        }
        this.progress(100);
        this.log().endSuccess();
    }

    private static class SyncTimeWork
    implements Runnable {
        private BSyncTimeJob job;
        private BNiagaraStation station;
        private BAddStationsJob.Counter counter;
        private Context cx;
        Exception e = null;

        public SyncTimeWork(BSyncTimeJob job, BNiagaraStation station, BAddStationsJob.Counter counter, Context cx) {
            this.job = job;
            this.station = station;
            this.counter = counter;
            this.cx = cx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block22: {
                String stationName = this.station.getStationName();
                try {
                    if (this.station.isDown() || this.station.isFault() || this.station.isDisabled()) {
                        this.job.log().message("Skipping time sync on " + stationName + ". The station is " + this.station.getStatus());
                        break block22;
                    }
                    Object foxSession = RemoteUtil.getFoxSession((BNiagaraStation)this.station);
                    String interest = TYPE + ".SyncTimeWork." + BUuid.make().toString();
                    try {
                        foxSession.engageNoRetry(interest);
                        BSystemPlatformService platformService = (BSystemPlatformService)foxSession.getService(BSystemPlatformService.TYPE);
                        platformService.poll();
                        platformService.lease();
                        platformService.getComponentSpace().sync();
                        BAbsTime oldRemoteTime = platformService.getSystemTime();
                        this.job.log().message("Current system time on " + stationName + " before time sync is " + oldRemoteTime);
                        platformService.setSystemTime(Clock.time());
                        platformService.savePlatformServiceProperties();
                        Thread.sleep(2000L);
                        platformService.poll();
                        platformService.lease();
                        platformService.getComponentSpace().sync();
                        BAbsTime newRemoteTime = platformService.getSystemTime();
                        this.job.log().message("Current system time on " + stationName + " after time sync is " + newRemoteTime);
                        BRelTime delta = oldRemoteTime.delta(newRemoteTime);
                        if (delta.getMillis() != 0L) {
                            this.job.log().message("A clock adjustment of " + delta + " was made on station " + stationName);
                        } else {
                            this.job.log().message("No time sync required on station " + stationName);
                        }
                        this.job.log().message("Time sync complete on station " + stationName);
                    }
                    finally {
                        foxSession.disengage(interest);
                    }
                }
                catch (Exception ex) {
                    this.job.log().failed("Failed to sync time on " + stationName, (Throwable)ex);
                    this.e = new BajaRuntimeException((Throwable)ex);
                }
                finally {
                    BAddStationsJob.Counter counter = this.counter;
                    synchronized (counter) {
                        --this.counter.count;
                        if (this.counter.count < 1) {
                            this.counter.notifyAll();
                        } else {
                            this.job.progress((int)((float)(this.counter.length - this.counter.count) / (float)this.counter.length * 100.0f));
                        }
                    }
                }
            }
        }
    }
}

