/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.driver;

import com.tridium.hx.fieldeditors.BHxDefaultFE;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.orion.BIOrionApp;
import com.tridium.orion.OrionSession;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.DialogWizardCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridium.sys.Nre;
import com.tridium.videoDriver.BIVideoNetwork;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmRecipient;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.BEntsecUserPermissionsInfo;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsecHx.BHxAccessProfile;
import com.tridiumx.entsecHx.ldapHx.LdapUtil;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import com.tridiumx.entsecHx.securityUtilHx.manager.ManageDevicesCommand;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import com.tridiumx.ldapDriver.BLdapNetwork;
import com.tridiumx.smartKey.BSmartKeyNetwork;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BDriverContainer;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.registry.TypeInfo;
import javax.baja.serial.BISerialService;
import javax.baja.serial.PortNotFoundException;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"driver:DriverContainer"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxDriverManagerView
extends BHxAbstractManagerView {
    public static Lexicon lex = Lexicon.make(BHxDriverManagerView.class);
    @Generated
    public static final BHxDriverManagerView INSTANCE = new BHxDriverManagerView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxDriverManagerView.class);
    SmartCommand manageDriverDevices = new ManageDriverDevicesCommand((BHxView)this);
    SmartCommand restartCommand;
    SmartCommand enableDisableNetworks;
    SmartCommand driverDeleteCommand;
    SmartCommand deleteRestartCommand;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxDriverManagerView() {
        this.registerEvent((Event)this.manageDriverDevices);
        this.restartCommand = new SaveRestartCommand((BHxView)this);
        this.registerEvent((Event)this.restartCommand);
        this.deleteRestartCommand = new DeleteRestartCommand((BHxView)this);
        this.registerEvent((Event)this.deleteRestartCommand);
        this.enableDisableNetworks = new EnableDisableNetworksCommand((BHxView)this);
        this.registerEvent((Event)this.enableDisableNetworks);
        this.driverDeleteCommand = new DriverDeleteCommand((BHxView)this);
        this.registerEvent((Event)this.driverDeleteCommand);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.manageDriverDevices, this.driverDeleteCommand, this.enableDisableNetworks, this.filterCommand, this.hyperlinkCommand, this.reportCommand, this.exportCommand};
    }

    @Override
    public String getPageTitle(HxOp op) {
        return lex.getText("remoteDrivers");
    }

    @Override
    public BHxAbstractDiscoverView getDiscoverView(HxOp op) {
        return null;
    }

    @Override
    public BTypeSpec getDeviceTypeSpec(HxOp op) {
        return BDeviceNetwork.TYPE.getTypeSpec();
    }

    @Override
    public BTypeSpec getLearnRowTypeSpec(HxOp op) {
        return BDeviceNetwork.TYPE.getTypeSpec();
    }

    @Override
    public BJob submitDiscoveryJob(HxOp op) {
        return null;
    }

    @Override
    public BQuery getQuery(HxOp op) {
        BComponent component = (BComponent)op.get();
        BQuery query = QueryUtil.makeQuery((BTypeSpec)this.getDeviceTypeSpec(op));
        query.select(new BProjection());
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "displayName", lex.getText("name")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BStatus.TYPE.getTypeSpec(), "status", lex.getText("status")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "enabled", lex.getText("enabled")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "faultCause", lex.getText("faultCause")));
        QueryUtil.addHiddenColumns((BQuery)query);
        query.add("base", (BValue)component.getAbsoluteOrd());
        query = QueryUtil.getWorkingCopy((BQuery)query, (Context)op);
        return query;
    }

    @Override
    public BQuery getDiscoverQuery(HxOp op) {
        return null;
    }

    @Override
    public Tab getLearnTab(HxOp op) {
        return new Tab((BHxView)BHxDefaultFE.INSTANCE, op.make("null", (BObject)BString.DEFAULT, null));
    }

    @Override
    public BImage getRowIcon(TableCursor<? extends BIObject> cursor, HxOp op) {
        BITable table = cursor.getTable();
        BDeviceNetwork dn = (BDeviceNetwork)BOrd.make((String)cursor.cell(table.getColumns().get(table.getColumns().size() - 1)).toString()).get(op.get());
        return BImage.make((BIcon)dn.getIcon());
    }

    @Override
    public boolean hasPermissionsFor(TableCursor<? extends BIObject> cursor, HxOp op) {
        BComponent c = (BComponent)cursor.get();
        String[] types = ManageDevicesCommand.getDevices(BDriverContainer.TYPE.getTypeSpec());
        for (int i = 0; i < types.length; ++i) {
            BTypeSpec typeSpec = BTypeSpec.make((String)types[i]);
            TypeInfo typeInfo = typeSpec.getTypeInfo();
            if (!c.getType().is(typeInfo)) continue;
            return super.hasPermissionsFor(cursor, op);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void driverCheckRemove(String propertyName, HxOp op) {
        BComplex c = (BComplex)op.get();
        BValue value = c.get(propertyName);
        if (value instanceof BPhotoIDNetwork) {
            BPhotoIDNetwork photoIDNetwork = (BPhotoIDNetwork)value;
            OrionSession orionSession = null;
            try {
                orionSession = photoIDNetwork.createSession((Context)op);
                photoIDNetwork.unregisterApp(orionSession, (Context)op);
            }
            finally {
                if (orionSession != null) {
                    orionSession.close();
                    orionSession = null;
                }
            }
        } else if (value instanceof BLdapNetwork) {
            LdapUtil.deleteLdapNetwork();
        }
    }

    public void driverDeleted(Property[] props, HxOp op) throws Exception {
        boolean refresh = true;
        for (int i = 0; i < props.length; ++i) {
            Type resolvedType = props[i].getType().getTypeSpec().getResolvedType();
            if (!resolvedType.is(BIOrionApp.TYPE)) continue;
            this.reloadTable(op);
            op.getHtmlWriter().w((Object)SmartCommand.getInvokeCode((Command)this.deleteRestartCommand, (String)HxUtil.getInnerQuote((HxOp)op), (HxOp)op));
            refresh = false;
        }
        if (refresh) {
            this.reloadTable(op);
        }
    }

    public static class DeleteRestartCommand
    extends SaveRestartCommand {
        public DeleteRestartCommand(BHxView view) {
            super(view);
        }

        @Override
        public String getConfirmationMessage() {
            return this.lexModule.getText("HxDriverManagerView.restartDeleteQuestion", null);
        }
    }

    public static class SaveRestartCommand
    extends SmartCommand {
        private ConfirmDialog dialog;

        public SaveRestartCommand(BHxView view) {
            super(view);
            Lexicon lex = HxTabUtil.getLexicon(BHxDriverManagerView.class);
            this.dialog = new ConfirmDialog(lex.getText("HxDriverManagerView.restartStation"), (Command)this, this.getConfirmationMessage());
        }

        public String getConfirmationMessage() {
            return this.lexModule.getText("HxDriverManagerView.restartQuestion", null);
        }

        public String getName(HxOp op) {
            return "saveRestartStation";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(op);
                return;
            }
            BSystemPlatformService service = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            service.restartStation();
            HtmlWriter out = op.getHtmlWriter();
            if (op.getProfile().getType().is(BHxAccessProfile.TYPE)) {
                BHxAccessProfile.disconnect(op);
            }
        }

        public boolean isAvailable(HxOp op) {
            try {
                BSystemPlatformService service = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
                return LocalSessionUtil.localDaemonIsAvailable();
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public class DriverDeleteCommand
    extends BHxAbstractManagerView.Delete {
        public DriverDeleteCommand(BHxView view) {
            super(BHxDriverManagerView.this, view);
        }

        @Override
        public void checkRemove(String propertyName, HxOp op) {
            super.checkRemove(propertyName, op);
            BHxDriverManagerView.this.driverCheckRemove(propertyName, op);
        }

        @Override
        public void deleted(Property[] props, HxOp op) throws Exception {
            BHxDriverManagerView.this.driverDeleted(props, op);
        }
    }

    private class EnableDisableNetworksDialog
    extends Dialog {
        public EnableDisableNetworksDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            super.writeContent(op);
            BDeviceNetwork[] enabledNetworks = this.getNetworks(op, true);
            BDeviceNetwork[] disabledNetworks = this.getNetworks(op, false);
            this.writeNetworksToEnable(disabledNetworks, op);
            this.writeNetworksToDisable(enabledNetworks, op);
        }

        private BDeviceNetwork[] getNetworks(HxOp op, boolean enabled) {
            Array networkArray = new Array(BDeviceNetwork.class);
            Object[] networks = BHxQueryTableView.getSubjects(op);
            for (int i = 0; i < networks.length; ++i) {
                BDeviceNetwork network = (BDeviceNetwork)networks[i];
                if (network.getEnabled() != enabled) continue;
                networkArray.add((Object)network);
            }
            return (BDeviceNetwork[])networkArray.trim();
        }

        private void writeNetworksToEnable(BDeviceNetwork[] disabledNetworks, HxOp op) throws Exception {
            if (disabledNetworks.length == 0) {
                return;
            }
            HtmlWriter out = op.getHtmlWriter();
            HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
            out.w((Object)"<b>").safe((Object)BHxDriverManagerView.this.getLexicon().getText("enableNetworksMessage")).w((Object)"</b>");
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            for (int i = 0; i < disabledNetworks.length; ++i) {
                BDeviceNetwork network = disabledNetworks[i];
                HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
                out.w((Object)"<input type='checkbox' ");
                out.attr("name", op.scope("enableCheckbox" + i));
                out.attr("value", (Object)network.getSlotPathOrd());
                out.w((Object)" />");
                out.w((Object)"&nbsp;");
                out.safe((Object)network.getDisplayName((Context)op));
                HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            }
            HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
            out.w((Object)"<br />");
        }

        private void writeNetworksToDisable(BDeviceNetwork[] enabledNetworks, HxOp op) throws Exception {
            if (enabledNetworks.length == 0) {
                return;
            }
            HtmlWriter out = op.getHtmlWriter();
            HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
            out.w((Object)"<b>").safe((Object)BHxDriverManagerView.this.getLexicon().getText("disableNetworksMessage")).w((Object)"</b>");
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            for (int i = 0; i < enabledNetworks.length; ++i) {
                BDeviceNetwork network = enabledNetworks[i];
                HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
                out.w((Object)"<input type='checkbox' ");
                out.attr("name", op.scope("disableCheckbox" + i));
                out.attr("value", (Object)network.getSlotPathOrd());
                out.w((Object)" />");
                out.w((Object)"&nbsp;");
                out.safe((Object)network.getDisplayName((Context)op));
                HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            }
            HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
        }
    }

    public class EnableDisableNetworksCommand
    extends SmartCommand {
        private Dialog dlg;

        public EnableDisableNetworksCommand(BHxView view) {
            super(view);
            this.dlg = new EnableDisableNetworksDialog(Lexicon.make((String)"entsecHx").getText("enableDisableNetworksCommand.label"), (Command)this);
        }

        public String getName(HxOp op) {
            return "enableDisableNetworksCommand";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            super.handle(op);
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            String[] keys = op.getFormKeys();
            for (int i = 0; i < keys.length; ++i) {
                BDeviceNetwork network;
                BOrd networkOrd;
                String key = keys[i];
                if (key.startsWith("enableCheckbox")) {
                    networkOrd = BOrd.make((String)op.getFormValue(key));
                    network = (BDeviceNetwork)networkOrd.get((BObject)Sys.getStation());
                    network.setEnabled(true);
                    continue;
                }
                if (!key.startsWith("disableCheckbox")) continue;
                networkOrd = BOrd.make((String)op.getFormValue(key));
                network = (BDeviceNetwork)networkOrd.get((BObject)Sys.getStation());
                network.setEnabled(false);
            }
            this.refresh(op);
        }
    }

    public class ManageDriverDevicesCommand
    extends ManageDevicesCommand {
        public ManageDriverDevicesCommand(BHxView view) {
            super(view);
        }

        @Override
        public DialogWizardCommand.ChoiceRenderer getAddChoiceRenderer() {
            return new DialogWizardCommand.ChoiceRenderer(){

                public String getValue(Object o, HxOp op) {
                    return o.toString();
                }

                public String getDisplayName(Object o, HxOp op) {
                    Type type = (Type)o;
                    if (type.is(BIVideoNetwork.TYPE)) {
                        return type.getDisplayName((Context)op) + " (" + type.getModule().getModuleName() + ")";
                    }
                    return type.getDisplayName((Context)op);
                }

                public BImage getIcon(Object o, HxOp op) {
                    return null;
                }
            };
        }

        @Override
        public void added(BValue added, HxOp op) throws Exception {
            BEnterpriseSecurityService service;
            Type resolvedType = added.getType().getTypeSpec().getResolvedType();
            if (resolvedType.is(BIVideoNetwork.TYPE)) {
                this.checkVideoNetworkAdded(added, op);
            }
            if ((service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE)).getRequireDefaultUserPermissions()) {
                service.restoreDefaultUserPermissions(BEntsecUserPermissionsInfo.makeAutoLoad());
            }
            if (added instanceof BIOrionApp) {
                BHxDriverManagerView.this.reloadTable(op);
                op.getHtmlWriter().w((Object)SmartCommand.getInvokeCode((Command)BHxDriverManagerView.this.restartCommand, (String)HxUtil.getInnerQuote((HxOp)op), (HxOp)op));
            } else {
                this.refresh(op);
            }
        }

        @Override
        public void deleted(Property[] props, HxOp op) throws Exception {
            BHxDriverManagerView.this.driverDeleted(props, op);
        }

        @Override
        public void checkAdd(BValue value, HxOp op) {
            Type resolvedType = value.getType().getTypeSpec().getResolvedType();
            if (resolvedType.is(BAccessNetwork.TYPE)) {
                this.checkAccessNetworkAdd(value, op);
            } else if (resolvedType.is(BNrioNetwork.TYPE)) {
                this.checkNrioNetworkAdd(value, op);
            } else if (resolvedType.is(BIVideoNetwork.TYPE)) {
                this.checkVideoNetworkAdd(value, op);
            } else if (resolvedType.is(BTypeSpec.make((String)"obixDriver:ObixNetwork").getType())) {
                this.checkObixNetworkAdd(value, op);
            } else if (resolvedType.is(BSmartKeyNetwork.TYPE)) {
                this.checkSmartKeyNetworkAdd(value, op);
            }
            if (!BEnterpriseSecurityService.isWorkstation() && resolvedType.is(BPhotoIDNetwork.TYPE)) {
                throw new IllegalStateException("Photo ID Network is not available on non-Workstation");
            }
            if (!BEnterpriseSecurityService.isWorkstation() && resolvedType.is(BLdapNetwork.TYPE)) {
                throw new IllegalStateException("Ldap Network is not available on non-Workstation");
            }
            BObject o = resolvedType.getInstance();
            Feature feature = null;
            if (o instanceof BDeviceNetwork) {
                feature = ((BDeviceNetwork)o).getLicenseFeature();
            } else if (o instanceof BAbstractService) {
                feature = ((BAbstractService)o).getLicenseFeature();
            }
            if (feature != null) {
                feature.check();
            }
            BComponent c = this.getContainer(op);
            Property[] props = c.getPropertiesArray();
            if (value.getType().getTypeSpec().equals((Object)BTypeSpec.make((String)"naxisVideo:AxisVideoNetwork"))) {
                int existingAxisVideoNetwork = 0;
                for (int i = 0; i < props.length; ++i) {
                    if (!props[i].getType().getTypeSpec().equals((Object)BTypeSpec.make((String)"naxisVideo:AxisVideoNetwork"))) continue;
                    ++existingAxisVideoNetwork;
                }
                if (existingAxisVideoNetwork > 1) {
                    throw new IllegalStateException("Only 2 " + value.getType().getDisplayName((Context)op) + " allowed.");
                }
            } else {
                for (int i = 0; i < props.length; ++i) {
                    if (!props[i].getType().equals(resolvedType)) continue;
                    throw new IllegalStateException("Only 1 " + value.getType().getDisplayName((Context)op) + " allowed.");
                }
            }
            if (value.getType().getTypeSpec().equals((Object)BTypeSpec.make((String)"accessDriver:AccessNetwork")) && RemoteUtil.isSupervisor()) {
                throw new IllegalStateException("Access Network cannot be added on the supervisor");
            }
        }

        @Override
        public void checkRemove(String propertyName, HxOp op) {
            BHxDriverManagerView.this.driverCheckRemove(propertyName, op);
        }

        private void checkAccessNetworkAdd(BValue value, HxOp op) {
            if (!this.comPortsAvailable()) {
                throw new IllegalStateException("All available COM ports are occupied");
            }
            if (RemoteUtil.isSupervisor()) {
                throw new IllegalStateException("Access Network cannot be added to the supervisor");
            }
        }

        private void checkSmartKeyNetworkAdd(BValue value, HxOp op) {
            if (Nre.getHostModel().equals("Workstation")) {
                throw new IllegalStateException("SmartKey Network cannot be added to the supervisor");
            }
        }

        private void checkNrioNetworkAdd(BValue value, HxOp op) {
            if (Nre.getHostModel().equals("Workstation")) {
                throw new IllegalStateException("Nrio Network cannot be added to the supervisor");
            }
            if (Nre.getHostModel().equals("NPM2")) {
                throw new IllegalStateException("Nrio Network cannot be added to NPM2 model");
            }
        }

        private String[] getAvailableComPorts() {
            BISerialService serialPortService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            Array availablePorts = new Array(String.class);
            String[] portNames = serialPortService.getPortNames();
            for (int i = 0; i < portNames.length; ++i) {
                String portName = portNames[i];
                if (portName.equals("COM1")) continue;
                try {
                    String portOwner = serialPortService.getCurrentOwner(portName);
                    if (!portOwner.equals("none")) continue;
                    availablePorts.add((Object)portName);
                    continue;
                }
                catch (PortNotFoundException e) {
                    e.printStackTrace();
                }
            }
            return (String[])availablePorts.trim();
        }

        private boolean comPortsAvailable() {
            return this.getAvailableComPorts().length > 0;
        }

        private void checkVideoNetworkAdded(BValue value, HxOp op) {
            if (!this.videoAlarmRecipientPresent()) {
                BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                alarmService.add("videoRecipient", (BValue)new BVideoAlarmRecipient());
            }
        }

        private boolean videoAlarmRecipientPresent() {
            BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            Object[] videoRecipients = alarmService.getChildren(BVideoAlarmRecipient.class);
            return videoRecipients.length > 0;
        }

        private void checkVideoNetworkAdd(BValue value, HxOp op) {
            try {
                Sys.loadModule((String)"videoDriver");
            }
            catch (Exception e) {
                throw new IllegalStateException("module \"videoDriver\" is not available");
            }
            try {
                Sys.getLicenseManager().checkFeature("tridium", "videoDriver");
            }
            catch (Exception e) {
                throw new IllegalStateException("Feature \"videoDriver\" is not licensed");
            }
            this.checkVideoNetwork(value, op);
        }

        private void checkVideoNetwork(BValue value, HxOp op) {
            BDeviceNetwork videoNetwork = (BDeviceNetwork)value;
            Feature licenseFeature = videoNetwork.getLicenseFeature();
            if (licenseFeature != null) {
                try {
                    licenseFeature.check();
                }
                catch (FeatureNotLicensedException ex) {
                    throw new IllegalStateException("License missing feature \"" + licenseFeature + "\"");
                }
            }
            String videoModule = value.getType().getTypeSpec().getModuleName();
            try {
                Sys.loadModule((String)videoModule);
            }
            catch (Exception e) {
                throw new IllegalStateException("Module \"" + videoModule + "\" not found");
            }
        }

        private void checkObixNetworkAdd(BValue value, HxOp op) {
            try {
                Sys.getLicenseManager().checkFeature("tridium", "obixDriver");
            }
            catch (Exception e) {
                throw new IllegalStateException("License missing feature \"obixDriver\"");
            }
            try {
                Sys.loadModule((String)"obix");
            }
            catch (Exception e) {
                throw new IllegalStateException("Module \"obix\" not found");
            }
            try {
                Sys.loadModule((String)"obixDriver");
            }
            catch (Exception e) {
                throw new IllegalStateException("Module \"obixDriver\" not found");
            }
        }
    }
}

