/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.query;

import com.tridium.query.BProjCol;
import com.tridium.query.expression.BFunction;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.DynamicDialog;
import com.tridium.smartTableHx.HxOptionsManager;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridiumx.entsec.filter.PrefilteringUtil;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.ui.query.BQueryTableOptions;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableConfig;
import java.util.ListIterator;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.BSingleExtent;
import javax.baja.sys.BComplex;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BOptions;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
@NiagaraSingleton
public class BHxQueryColumnTable
extends BHxSmartTableView {
    public static final Lexicon lex = Lexicon.make(BHxQueryColumnTable.class);
    @Generated
    public static final BHxQueryColumnTable INSTANCE = new BHxQueryColumnTable();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxQueryColumnTable.class);
    protected SmartCommand tableCommand = new TableCommand((BHxView)this);
    protected SmartCommand delete;
    protected SmartCommand edit;
    protected SmartCommand save;
    protected SmartCommand moveUp;
    protected SmartCommand moveDown;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxQueryColumnTable() {
        this.registerEvent((Event)this.tableCommand);
        this.delete = new Delete((BHxView)this);
        this.registerEvent((Event)this.delete);
        this.edit = new Edit((BHxView)this);
        this.registerEvent((Event)this.edit);
        this.save = new Save((BHxView)this);
        this.registerEvent((Event)this.save);
        this.moveUp = new MoveUp((BHxView)this);
        this.registerEvent((Event)this.moveUp);
        this.moveDown = new MoveDown((BHxView)this);
        this.registerEvent((Event)this.moveDown);
    }

    public String getPageTitle(HxOp op) throws Exception {
        BQuery query = (BQuery)op.get();
        return lex.getText("columnsFor", new Object[]{query.getDisplayName((Context)op)});
    }

    public void write(HxOp op) throws Exception {
        super.write(op);
    }

    public void writeTableHeader(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("name"));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("displayName"));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("fromType"));
        out.w((Object)"</th>");
    }

    public TableContents writeContents(HxOp op) throws Exception {
        TableContents contents = new TableContents(op.scope("records"));
        BQuery query = (BQuery)op.getRequest().getSession().getAttribute("working");
        BProjectionColumn[] columns = query.getProjection().getProjectionColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (Flags.isHidden((BComplex)query.getProjection(), (Slot)columns[i].getPropertyInParent())) continue;
            TableContents.Tr tr = new TableContents.Tr();
            tr.id = "" + columns[i].getName();
            tr.td.add(new TableContents.Td(SlotPath.unescape((String)columns[i].getName())));
            tr.td.add(new TableContents.Td(columns[i].getAlias()));
            tr.td.add(new TableContents.Td("" + columns[i].get("typeSpec")));
            contents.tr.add(tr);
        }
        return contents;
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.save, this.edit, this.delete, this.moveUp, this.moveDown, this.tableCommand, this.exportCommand};
    }

    public static class Edit
    extends SmartCommand {
        private EditDialog dlg = new EditDialog((Command)this, this.getDisplayName(null));

        public Edit(BHxView view) {
            super(view);
        }

        public boolean isDefaultAction() {
            return true;
        }

        public String getName(HxOp op) {
            return "edit";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                String functionName;
                BQuery query = (BQuery)op.getRequest().getSession().getAttribute("working");
                String[] propNames = Edit.getSelectionList((HxOp)op);
                BProjCol column = (BProjCol)query.getProjection().get(propNames[0]);
                HtmlWriter out = op.getHtmlWriter();
                BExpression expression = column.getColumnExpression();
                if (expression.getType().is(BFunction.TYPE) && (functionName = ((BFunction)expression).getFunctionName()).equals("entsec:ConsolidatedColumnsProvider.getStationName")) {
                    out.w((Object)"alert('Editing the \\'stationName\\' column is not permitted');");
                    return;
                }
                this.dlg.open(op);
                return;
            }
            SaveCommand.setModified((HxOp)op);
            BQuery query = (BQuery)op.getRequest().getSession().getAttribute("working");
            String[] propNames = Edit.getSelectionList((HxOp)op);
            BString currentName = null;
            BProjCol column = (BProjCol)query.getProjection().get(propNames[0]);
            HtmlWriter out = op.getHtmlWriter();
            currentName = BString.make((String)column.getAlias());
            BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)currentName, (Context)op);
            String newName = editor.save(op.make("displayName", (BObject)currentName, null)).toString();
            if (!newName.equals(currentName.toString())) {
                if (!this.stringValidated(newName)) {
                    out.w((Object)"alert('Illegal characters(s) in display name');");
                    return;
                }
                if (!this.columnNameValidated(newName)) {
                    out.w((Object)"alert('\\'stationName\\' is a reserved name. Please choose a different display name.');");
                    return;
                }
                column.setAlias(newName);
                out.w((Object)"var elem = $('").w((Object)column.getName()).w((Object)"');");
                out.w((Object)"elem.firstChild.nextSibling.textContent='");
                out.w((Object)HxUtil.escapeJsStringLiteral((String)column.getAlias()));
                out.w((Object)"';");
                BHxQueryTableConfig.setSaveToOptions(true, op);
            }
        }

        private boolean stringValidated(String string) {
            return string.indexOf(39) == -1 && string.indexOf("\"") == -1 && string.indexOf("\\") == -1;
        }

        private boolean columnNameValidated(String newName) {
            return !SlotPath.escape((String)TextUtil.fromFriendly((String)newName)).equalsIgnoreCase("stationName");
        }

        private class EditDialog
        extends Dialog {
            EditDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                BQuery query = (BQuery)op.getRequest().getSession().getAttribute("working");
                String[] propNames = SmartCommand.getSelectionList((HxOp)op);
                String displayName = "";
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"<table>");
                out.w((Object)"<tr><td ");
                out.attr("class", "smartTable-setup-label");
                out.w((Object)">");
                out.safe((Object)Edit.this.lexModule.getText("displayName", (Context)op));
                out.w((Object)"</td><td>");
                String propName = propNames[0];
                BProjCol column = (BProjCol)query.getProjection().get(propName);
                BString value = BString.make((String)column.getAlias());
                BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)value, (Context)op);
                editor.write(op.make("displayName", (BObject)value, null));
                out.w((Object)"</td></tr>");
                out.w((Object)"</table>");
            }
        }
    }

    public class SaveDialog
    extends DynamicDialog {
        SaveDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            Lexicon lex = Lexicon.make((String)Sys.getModuleForClass(BHxQueryColumnTable.class).getModuleName());
            HtmlWriter out = op.getHtmlWriter();
            out.safe((Object)lex.getText("saveColumnsForAllUsersQuestion"));
        }

        public Command[] getCommands() {
            return new Command[]{this.makeSubmitCommand("yes", LexiconText.make((BModule)Sys.getModuleForClass(BHxQueryColumnTable.class), (String)"yes")), this.makeSubmitCommand("no", LexiconText.make((BModule)Sys.getModuleForClass(BHxQueryColumnTable.class), (String)"no"))};
        }
    }

    public class Save
    extends SaveCommand {
        private SaveDialog dlg;

        public Save(BHxView view) {
            super(view);
            this.dlg = new SaveDialog(this.getDisplayName(null), (Command)this);
        }

        public void onHandle(HxOp op) throws Exception {
            this.saveTable(op);
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void saveTable(HxOp op) throws Exception {
            BQuery result = (BQuery)op.get();
            BQuery working = (BQuery)op.getRequest().getSession().getAttribute("working");
            BTypeSpec typeSpec = QueryUtil.getRowType((BQuery)working);
            BSingleExtent extent = (BSingleExtent)result.getExtent();
            extent.setBaseExtent(typeSpec);
            BQuery copy = QueryUtil.makeQueryReset((BQuery)working);
            BProjection projection = copy.getProjection();
            boolean prefiltering = PrefilteringUtil.getPrefiltering((BQuery)working);
            PrefilteringUtil.setPrefiltering((BQuery)copy, (boolean)prefiltering);
            Array toRemove = new Array(Property.class, 16);
            SlotCursor c = projection.getProperties();
            while (c.next(BProjCol.class)) {
                toRemove.add((Object)c.property());
            }
            ListIterator x = toRemove.iterator();
            while (x.hasNext()) {
                projection.remove((Property)x.next());
            }
            BProjCol[] cols = (BProjCol[])working.getProjection().getChildren(BProjCol.class);
            BProjectionColumn[] columns = projection.getProjectionColumns();
            for (int i = 0; i < cols.length; ++i) {
                int flags = projection.getFlags((Slot)cols[i].getPropertyInParent());
                String escape = SlotPath.escape((String)TextUtil.fromFriendly((String)cols[i].getAlias()));
                if (projection.getProperty(escape) != null) {
                    throw new CannotSaveException("Cannot Save. Duplicate Columns.");
                }
                projection.add(escape, cols[i].newCopy(true), flags);
            }
            QueryUtil.addHiddenColumns((BQuery)copy);
            HxOptionsManager optionsManager = new HxOptionsManager(op);
            BQueryTableOptions options = (BQueryTableOptions)optionsManager.load(BQueryTableOptions.TYPE);
            boolean defaultProjection = QueryUtil.isDefaultProjection((BQuery)copy);
            if (defaultProjection && PrefilteringUtil.isDefaultPrefiltering((BQuery)copy)) {
                options.removePrefiltering(copy);
                PrefilteringUtil.removePrefiltering((BQuery)result);
                options.removeProjection(copy);
                if (result.get("projection") != null) {
                    result.remove("projection");
                }
                return;
            }
            if (BHxQueryTableConfig.getSaveToOptions(op) && op.getUser().getPermissions().isSuperUser() && optionsManager.getMountedOptions(BQueryTableOptions.TYPE) == null) {
                if (!this.dlg.isSubmit(op)) {
                    this.dlg.open(op);
                    return;
                }
                if (op.getFormValue("yes") != null) {
                    BHxQueryTableConfig.setSaveToOptions(false, op);
                }
            }
            BProjectionColumn[] newColumns = (BProjectionColumn[])projection.getChildren(BProjectionColumn.class);
            if (BHxQueryTableConfig.getSaveToOptions(op)) {
                options.setPrefiltering(copy, prefiltering);
                if (!defaultProjection) {
                    if (newColumns.length > 0) {
                        options.setProjection(copy, projection, (Context)op);
                    } else {
                        options.removeProjection(copy);
                    }
                }
            } else {
                options.removePrefiltering(result);
                PrefilteringUtil.setPrefiltering((BQuery)result, (boolean)prefiltering);
                if (!defaultProjection) {
                    options.removeProjection(result);
                    result.select((BProjection)projection.newCopy(true));
                    QueryUtil.reorderColumns((BQuery)result);
                }
            }
            new HxOptionsManager(op).save((BOptions)options);
            this.refresh(op);
        }
    }

    public static class Delete
    extends SmartCommand {
        public Delete(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public String getName(HxOp op) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BQuery workingQuery = (BQuery)op.getRequest().getSession().getAttribute("working");
            String[] propNames = Delete.getSelectionList((HxOp)op);
            boolean columnsSelected = false;
            for (int i = 0; i < propNames.length; ++i) {
                String functionName;
                BProjCol column = (BProjCol)workingQuery.getProjection().get(propNames[i]);
                BExpression expression = column.getColumnExpression();
                if (expression.getType().is(BFunction.TYPE) && (functionName = ((BFunction)expression).getFunctionName()).equals("entsec:ConsolidatedColumnsProvider.getStationName")) {
                    out.w((Object)"alert('Deleting the \\'stationName\\' column is not permitted');");
                    continue;
                }
                columnsSelected = true;
                workingQuery.getProjection().remove(propNames[i]);
                out.w((Object)"var elem = $('").w((Object)propNames[i]).w((Object)"');");
                out.w((Object)"smartTable.remove(elem);");
                out.w((Object)"smartTable.setForm('").w((Object)op.scope("")).w((Object)"');");
                out.w((Object)"elem.parentNode.removeChild(elem);");
            }
            if (columnsSelected) {
                SaveCommand.setModified((HxOp)op);
                BHxQueryTableConfig.setSaveToOptions(true, op);
            }
        }
    }

    public static class MoveDown
    extends SmartCommand {
        public MoveDown(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "moveDown";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            SaveCommand.setModified((HxOp)op);
            HtmlWriter out = op.getHtmlWriter();
            BQuery working = (BQuery)op.getRequest().getSession().getAttribute("working");
            BProjection projection = working.getProjection();
            String propName = MoveDown.getSelectionList((HxOp)op)[0];
            Array props = new Array((Object[])projection.getDynamicPropertiesArray());
            for (int i = 0; i < props.size() - 1; ++i) {
                Property p = (Property)props.get(i);
                if (!p.getName().equals(propName)) continue;
                for (int j = i + 1; j < props.size(); ++j) {
                    Property otherProp = (Property)props.get(j);
                    if (!(projection.get(otherProp) instanceof BProjectionColumn) || Flags.isHidden((BComplex)projection, (Slot)otherProp)) continue;
                    props.swap(i, j);
                    out.w((Object)"var elem = $('").w((Object)propName).w((Object)"');");
                    out.w((Object)"var otherElem = $('").w((Object)otherProp.getName()).w((Object)"');");
                    out.w((Object)"var parent = elem.parentNode;");
                    out.w((Object)"parent.insertBefore(otherElem, elem);");
                    projection.reorder((Property[])props.trim());
                    BHxQueryTableConfig.setSaveToOptions(true, op);
                    return;
                }
            }
        }
    }

    public static class MoveUp
    extends SmartCommand {
        public MoveUp(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "moveUp";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            SaveCommand.setModified((HxOp)op);
            HtmlWriter out = op.getHtmlWriter();
            BQuery working = (BQuery)op.getRequest().getSession().getAttribute("working");
            BProjection projection = working.getProjection();
            String propName = MoveUp.getSelectionList((HxOp)op)[0];
            Array props = new Array((Object[])projection.getDynamicPropertiesArray());
            for (int i = 1; i < props.size(); ++i) {
                Property p = (Property)props.get(i);
                if (!p.getName().equals(propName)) continue;
                for (int j = i - 1; j >= 0; --j) {
                    Property otherProp = (Property)props.get(j);
                    if (!(projection.get(otherProp) instanceof BProjectionColumn) || Flags.isHidden((BComplex)projection, (Slot)otherProp)) continue;
                    props.swap(i, j);
                    out.w((Object)"var elem = $('").w((Object)propName).w((Object)"');");
                    out.w((Object)"var otherElem = $('").w((Object)otherProp.getName()).w((Object)"');");
                    out.w((Object)"var parent = elem.parentNode;");
                    out.w((Object)"parent.insertBefore(elem, otherElem);");
                    projection.reorder((Property[])props.trim());
                    BHxQueryTableConfig.setSaveToOptions(true, op);
                    return;
                }
            }
        }
    }

    public static class TableCommand
    extends SmartCommand {
        public TableCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "table";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean isTableCommand(HxOp op) {
            return true;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BOrd ord = op.getOrdWithoutViewQuery();
            this.redirect(op, op.toUri(ord));
        }
    }
}

