/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platMstp;

import com.tridium.platMstp.EmstpCommandEnum;
import com.tridium.platMstp.EmstpCommandPrefixEnum;
import com.tridium.platMstp.MstpFrame;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class EmstpFrame {
    BufferedInputStream bufferedInputStream;
    EmstpCommandPrefixEnum prefix;
    EmstpCommandEnum command;
    int payloadLength;
    int statusByte;
    MstpFrame mstpFrame;
    byte[] payload;
    private boolean bufferAvailable;
    private boolean moreMessagesToSend;
    private static final int PROTOCOL_EMSTP = 1;
    private static final int COMMAND_PREFIX_MASK = 192;
    private static final int COMMAND_MASK = 63;
    private static final int STATUS_BYTE_MASK = 127;
    private static final int BUFFER_AVAIL_BIT_MASK = 128;
    private static final int BUFFER_AVAIL = 128;
    private static final int APP_TX_MESSAGES_WAITING = 1;
    private static final int APP_TX_NO_MESSAGES_WAITING = 0;
    private static final int APP_TX_DATA_EXPECTING_REPLY = 1;
    private static final int APP_TX_DATA_NOT_EXPECTING_REPLY = 0;

    public EmstpFrame(BufferedInputStream inputStream) {
        this.bufferedInputStream = inputStream;
        this.prefix = EmstpCommandPrefixEnum.NAK;
        this.command = EmstpCommandEnum.MSTP_COMMAND_UNKNOWN;
    }

    public EmstpFrame(EmstpCommandPrefixEnum prefix, EmstpCommandEnum command, MstpFrame mstpFrame) {
        this.prefix = prefix;
        this.command = command;
        this.mstpFrame = mstpFrame;
        this.payloadLength = mstpFrame.getData().length + 3;
        this.moreMessagesToSend = false;
    }

    public EmstpFrame(EmstpCommandPrefixEnum prefix, EmstpCommandEnum command, byte[] payload) {
        this.prefix = prefix;
        this.command = command;
        this.payload = (byte[])payload.clone();
        this.payloadLength = this.payload.length;
    }

    int getPayloadLength() {
        return this.payloadLength;
    }

    public void setMoreMessagesToSend(boolean more) {
        this.moreMessagesToSend = more;
    }

    public ByteArrayOutputStream encodeToTransmit() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (this.mstpFrame != null) {
            outputStream.write(1);
            outputStream.write(this.prefix.getPrefix() | this.command.getCommand());
            outputStream.write(this.payloadLength >> 8 & 0xFF);
            outputStream.write(this.payloadLength & 0xFF);
            outputStream.write(this.moreMessagesToSend ? 1 : 0);
            outputStream.write(this.mstpFrame.getAddr());
            outputStream.write(this.mstpFrame.getDataExpectingReply() ? 1 : 0);
            outputStream.write(this.mstpFrame.getData());
        } else if (this.payload != null) {
            outputStream.write(1);
            outputStream.write(this.prefix.getPrefix() | this.command.getCommand());
            outputStream.write(this.payloadLength >> 8 & 0xFF);
            outputStream.write(this.payloadLength & 0xFF);
            outputStream.write(this.payload);
        }
        return outputStream;
    }

    public void readResponse() throws IOException {
        this.reset();
        try {
            int inputByte = this.bufferedInputStream.read();
            if (inputByte != 1) {
                this.command = EmstpCommandEnum.MSTP_COMMAND_UNKNOWN;
                return;
            }
            inputByte = this.bufferedInputStream.read();
            this.prefix = EmstpCommandPrefixEnum.getEnum(inputByte & 0xC0);
            this.command = EmstpCommandEnum.getEnum(inputByte & 0x3F);
            int lenhigh = this.bufferedInputStream.read();
            int lenlow = this.bufferedInputStream.read();
            if (lenhigh < 0 || lenlow < 0) {
                this.command = EmstpCommandEnum.MSTP_COMMAND_UNKNOWN;
                return;
            }
            this.payloadLength = (lenhigh << 8) + lenlow;
            if (this.payloadLength < 1) {
                this.command = EmstpCommandEnum.MSTP_COMMAND_UNKNOWN;
                return;
            }
            this.statusByte = this.bufferedInputStream.read();
            if (this.statusByte == -1) {
                this.command = EmstpCommandEnum.MSTP_COMMAND_UNKNOWN;
                return;
            }
            this.bufferAvailable = (this.statusByte & 0x80) == 128;
            this.statusByte &= 0x7F;
            if (this.payloadLength > 1) {
                ByteArrayOutputStream payloadStream = new ByteArrayOutputStream(this.payloadLength - 1);
                for (int i = 1; i < this.payloadLength; ++i) {
                    inputByte = this.bufferedInputStream.read();
                    if (inputByte == -1) {
                        this.command = EmstpCommandEnum.MSTP_COMMAND_UNKNOWN;
                        return;
                    }
                    payloadStream.write(inputByte);
                }
                this.payload = payloadStream.toByteArray();
            } else {
                this.payload = null;
            }
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            this.command = EmstpCommandEnum.MSTP_COMMAND_UNKNOWN;
        }
    }

    public void flushInputStream() throws IOException {
        if (this.bufferedInputStream != null) {
            while (this.bufferedInputStream.available() > 0) {
                this.bufferedInputStream.read();
            }
        }
    }

    public EmstpCommandEnum getCommand() {
        return this.command;
    }

    public int getMstpAddress() {
        if (this.mstpFrame != null) {
            return this.mstpFrame.getAddr();
        }
        return -1;
    }

    public boolean isBufferAvailable() {
        return this.bufferAvailable;
    }

    public int getStatusByte() {
        return this.statusByte;
    }

    public byte[] getPayload() {
        return (byte[])this.payload.clone();
    }

    private void reset() {
        this.prefix = EmstpCommandPrefixEnum.NAK;
        this.command = EmstpCommandEnum.MSTP_COMMAND_UNKNOWN;
        this.payloadLength = 0;
        this.statusByte = 0;
        this.mstpFrame = null;
        this.payload = null;
    }
}

