/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.alarms.BCloudAlarmExt;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.ICloudSystemCommand;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.sys.BString;
import javax.baja.sys.Context;

public final class AlarmAckCommand
implements ICloudSystemCommand {
    private String commandName;
    private BCloudDevice device;
    private static final Logger log = Logger.getLogger("ncloud.command");

    public AlarmAckCommand(BCloudCommandsDeviceExt bCloudCommandsDeviceExt) {
        this.setCommandName("AlarmAckCommand");
        this.register(bCloudCommandsDeviceExt);
        this.device = (BCloudDevice)bCloudCommandsDeviceExt.getDevice();
    }

    @Override
    public void setCommandName(String cmdName) {
        this.commandName = cmdName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void runCommand(JSONObject commandProperties, Map<String, Object> responseProperties, Context cx) {
        String messageId = (String)responseProperties.get(this.device.getConstant("CORRELATIONID"));
        log.fine(() -> String.format("%s executing %s", this.commandName, messageId));
        BCloudAlarmExt alarmExt = this.device.getAlarms();
        String commandID = JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMANDID"));
        responseProperties.put(this.device.getConstant("COMMANDID"), commandID);
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMAND_PAYLOAD")));
        String alarmId = JSONUtil.getString((JSONObject)payload, (String)this.device.getConstant("ALARMID"));
        BString appId = BString.make((String)JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("CALLINGID")));
        BString appName = BString.make((String)JSONUtil.getString((JSONObject)payload, (String)this.device.getConstant("ALARMACKNAME")));
        BCloudAlarmExt.AckHelper result = alarmExt.acknowledgeAlarm(alarmId, appId, appName, messageId, cx);
        responseProperties.put("AlarmId", alarmId);
        responseProperties.put("IsSuccessful", result.getStatus());
        responseProperties.put("Message", result.getMessage());
        responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
        responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
        log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
    }
}

