/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.cloud.client.BICloudConnector;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.cmds.BCloudCommandQueue;
import com.tridium.nc.cmds.BCloudCommandStatus;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.ICloudCommand;
import com.tridium.nc.cmds.MessageCallbackHandler;
import com.tridium.nc.devices.CloudDecodeMsg;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.sentience.events.EventData;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ExecutorUtil;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="commandTimeout", type="BRelTime", defaultValue="BRelTime.makeMinutes(1)"), @NiagaraProperty(name="defaultCommandQueue", type="BCloudCommandQueue", defaultValue="new BCloudCommandQueue()"), @NiagaraProperty(name="SentienceCommandQueue", type="BCloudCommandQueue", defaultValue="new BCloudCommandQueue()", flags=5)})
public class BCloudCommandExecutor
extends BComponent {
    public static final Property commandTimeout = BCloudCommandExecutor.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)1), null);
    public static final Property defaultCommandQueue = BCloudCommandExecutor.newProperty((int)0, (BValue)new BCloudCommandQueue(), null);
    public static final Property SentienceCommandQueue = BCloudCommandExecutor.newProperty((int)5, (BValue)new BCloudCommandQueue(), null);
    public static final Type TYPE = Sys.loadType(BCloudCommandExecutor.class);
    private static final Logger log = Logger.getLogger("ncloud.command");
    private ExecutorService executor;
    private ExecutorService manager;
    private BCloudCommandQueue[] orderedQueues;
    private BCloudCommandsDeviceExt parentExt;

    public BRelTime getCommandTimeout() {
        return (BRelTime)this.get(commandTimeout);
    }

    public void setCommandTimeout(BRelTime v) {
        this.set(commandTimeout, (BValue)v, null);
    }

    public BCloudCommandQueue getDefaultCommandQueue() {
        return (BCloudCommandQueue)this.get(defaultCommandQueue);
    }

    public void setDefaultCommandQueue(BCloudCommandQueue v) {
        this.set(defaultCommandQueue, (BValue)v, null);
    }

    public BCloudCommandQueue getSentienceCommandQueue() {
        return (BCloudCommandQueue)this.get(SentienceCommandQueue);
    }

    public void setSentienceCommandQueue(BCloudCommandQueue v) {
        this.set(SentienceCommandQueue, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.getSentienceCommandQueue().setPriority(0);
        this.updatePriorityQueues();
        this.parentExt = (BCloudCommandsDeviceExt)this.getParent();
        this.manager = ExecutorUtil.newSingleThreadBackgroundExecutor((String)"nCloudDriver.commandManager", (long)1L, (TimeUnit)TimeUnit.MINUTES);
        this.executor = ExecutorUtil.newSingleThreadBackgroundExecutor((String)"nCloudDriver.commandExecutor", (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.manager.shutdown();
        this.executor.shutdown();
    }

    public void changed(Property prop, Context context) {
        this.handleChange(prop);
    }

    public void added(Property prop, Context context) {
        this.handleChange(prop);
    }

    public void removed(Property prop, BValue oldValue, Context context) {
        this.handleChange(prop);
    }

    private void handleChange(Property prop) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.isDynamic() && prop.getType() == BCloudCommandQueue.TYPE) {
            this.updatePriorityQueues();
        }
    }

    public void enqueue(MessageCallbackHandler handler) {
        Map<String, Object> response;
        ICloudCommand msg = (ICloudCommand)((Object)handler.getMessage());
        int priority = msg.getPriority();
        BCloudCommandQueue targetQueue = null;
        for (int lcv = this.orderedQueues.length - 1; lcv >= 0; --lcv) {
            if (this.orderedQueues[lcv].getPriority() > priority) continue;
            targetQueue = this.orderedQueues[lcv];
            break;
        }
        if (targetQueue == null && this.orderedQueues.length > 0) {
            targetQueue = this.orderedQueues[0];
        }
        BCloudDevice cloudDevice = (BCloudDevice)this.parentExt.getDevice();
        CloudEncodeMsg enqueueResp = handler.getCallback().getResponse();
        BICloudConnector connector = cloudDevice.resolveConnector();
        HashMap<String, Object> responseProps = new HashMap<String, Object>();
        responseProps.put(cloudDevice.getConstant("CORRELATIONID"), handler.getMessageId());
        boolean suppress = false;
        boolean invokeManager = false;
        if (!handler.getCallback().enabled()) {
            response = handler.getCallback().getResponseParams(handler.getMessageId(), (CloudDecodeMsg)handler.getMessage(), cloudDevice.getNumericConstant("CMD_ERR_CODE_FORBIDDEN"), cloudDevice.getConstant("ERR_ACCESS_NOT_ALLOWED"));
            log.info(() -> String.format("Incoming request not enqueued because the %s command is disabled %s", handler.getMessage().getCommand(), handler.getMessageId()));
        } else if (targetQueue == null || !targetQueue.enqueue(handler)) {
            response = handler.getCallback().getResponseParams(handler.getMessageId(), (CloudDecodeMsg)handler.getMessage(), cloudDevice.getNumericConstant("CMD_ERR_CODE_UNAVAILABLE"), cloudDevice.getConstant("ERR_UNAVAILABLE"));
            String queueName = targetQueue != null ? targetQueue.getName() : "null";
            log.warning(() -> String.format("Unable to enqueue command %s at priority %d %s to %s", handler.getMessage().getCommand(), priority, handler.getMessageId(), queueName));
        } else {
            log.finer(String.format("CommandExecutor enqueued command %s at priority %d", handler.getMessageId(), targetQueue.getPriority()));
            invokeManager = true;
            response = handler.getCallback().getResponseParams(handler.getMessageId(), (CloudDecodeMsg)handler.getMessage(), cloudDevice.getNumericConstant("CMD_ERR_CODE_OK"), "");
            suppress = msg.getSuppressStatusResponse();
        }
        if (!suppress) {
            log.finer(() -> String.format("CommandExecutor sending enqueued response at %d %s", BAbsTime.now().getMillis(), handler.getMessageId()));
            connector.sendMessage(enqueueResp.encode(response), enqueueResp.getProperties(responseProps)).whenComplete((resp, err) -> {
                if (err != null) {
                    log.warning(() -> "failed to send command enqueued message " + handler.getMessageId());
                } else {
                    log.fine(() -> String.format("Command enqueued message sent successfully at %d %s", BAbsTime.now().getMillis(), handler.getMessageId()));
                }
            });
        }
        if (invokeManager) {
            log.finer(String.format("CommandExecutor enqueue notifying manager %s", handler.getMessageId()));
            this.manager.submit(this::executeCommand);
        }
        log.finer(String.format("CommandExecutor enqueue exiting %s", handler.getMessageId()));
    }

    private void executeCommand() {
        MessageCallbackHandler commandHandler = null;
        BCloudCommandQueue commandQueue = null;
        for (BCloudCommandQueue queue : this.orderedQueues) {
            commandHandler = queue.getNextToExecute();
            if (commandHandler == null) continue;
            commandQueue = queue;
            break;
        }
        if (commandHandler == null) {
            log.info("executeCommand was invoked but no pending commands were found.");
            return;
        }
        log.finer(String.format("CommandExecutor executing command %s at priority %d", commandHandler.getMessageId(), commandQueue.getPriority()));
        Future<?> future = this.executor.submit(commandHandler::execute);
        commandHandler.setStatus(BCloudCommandStatus.Executing);
        BCloudDevice cloudDevice = (BCloudDevice)this.parentExt.getDevice();
        ICloudCommand cmd = (ICloudCommand)((Object)commandHandler.getMessage());
        HashMap<String, Object> response = new HashMap<String, List<EventData>>();
        HashMap<String, Object> responseProps = new HashMap<String, Object>();
        CloudEncodeMsg resultMsg = cmd.getSuppressStatusResponse() ? commandHandler.getCallback().getResponse() : cloudDevice.getFactory().createNewEventRequestMsg();
        boolean suppress = false;
        try {
            log.finer("CommandExecutor waiting for command to finish " + commandHandler.getMessageId());
            future.get(this.getCommandTimeout().getMillis(), TimeUnit.MILLISECONDS);
            log.finer("CommandExecutor command finished " + commandHandler.getMessageId());
            suppress = cmd.getSuppressStatusResponse();
            if (!suppress) {
                response.put(cloudDevice.getConstant("EVENTS"), CloudUtilities.buildEvent(cloudDevice, commandHandler.getMessageId(), cloudDevice.getNumericConstant("CMD_RESP_CODE_DONE"), cloudDevice.getConstant("RESP_DONE")));
            }
        }
        catch (TimeoutException e) {
            log.info("Cloud command timeout occurred. " + commandHandler.getMessageId());
            future.cancel(true);
            if (cmd.getSuppressStatusResponse()) {
                response = commandHandler.getCallback().getResponseParams(commandHandler.getMessageId(), (CloudDecodeMsg)commandHandler.getMessage(), cloudDevice.getNumericConstant("CMD_ERR_CODE_TIMEOUT"), cloudDevice.getConstant("ERR_TIMEOUT"));
            } else {
                response.put(cloudDevice.getConstant("EVENTS"), CloudUtilities.buildEvent(cloudDevice, commandHandler.getMessageId(), cloudDevice.getNumericConstant("CMD_ERR_CODE_TIMEOUT"), cloudDevice.getConstant("ERR_TIMEOUT")));
            }
        }
        catch (InterruptedException e) {
            log.warning("Cloud command control thread interrupted while command was executing. " + commandHandler.getMessageId());
            future.cancel(true);
            if (cmd.getSuppressStatusResponse()) {
                response = commandHandler.getCallback().getResponseParams(commandHandler.getMessageId(), (CloudDecodeMsg)commandHandler.getMessage(), cloudDevice.getNumericConstant("CMD_ERR_CODE_UNAVAILABLE"), cloudDevice.getConstant("ERR_UNAVAILABLE"));
            } else {
                response.put(cloudDevice.getConstant("EVENTS"), CloudUtilities.buildEvent(cloudDevice, commandHandler.getMessageId(), cloudDevice.getNumericConstant("CMD_ERR_CODE_UNAVAILABLE"), cloudDevice.getConstant("ERR_UNAVAILABLE")));
            }
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            log.log(Level.WARNING, String.format("Cloud command %s threw an exception: %s", commandHandler.getMessageId(), e), log.isLoggable(Level.FINE) ? e : null);
            if (cmd.getSuppressStatusResponse()) {
                response = commandHandler.getCallback().getResponseParams(commandHandler.getMessageId(), (CloudDecodeMsg)commandHandler.getMessage(), cloudDevice.getNumericConstant("CMD_ERR_CODE_FAILURE"), cloudDevice.getConstant("ERR_BAD_REQUEST"));
                HashMap<String, Throwable> responseParams = new HashMap<String, Throwable>();
                responseParams.put("exception", e.getCause());
                response.put(cloudDevice.getConstant("RESPONSE_PARAMETERS"), responseParams);
            }
            response.put(cloudDevice.getConstant("EVENTS"), CloudUtilities.buildEvent(cloudDevice, commandHandler.getMessageId(), cloudDevice.getNumericConstant("CMD_ERR_CODE_FAILURE"), cloudDevice.getConstant("ERR_BAD_REQUEST")));
        }
        commandHandler.setStatus(BCloudCommandStatus.Done);
        if (!suppress) {
            BCloudCommandQueue finalCommandQueue = commandQueue;
            MessageCallbackHandler finalCommandHandler = commandHandler;
            BICloudConnector connector = cloudDevice.resolveConnector();
            connector.sendMessage(resultMsg.encode(response), resultMsg.getProperties(responseProps)).whenComplete((resp, err) -> {
                if (err != null) {
                    log.warning(() -> "failed to send command completion message. " + finalCommandHandler.getMessageId());
                } else {
                    log.fine(() -> String.format("Command completion message sent successfully at %d %s", BAbsTime.now().getMillis(), finalCommandHandler.getMessageId()));
                }
                if (!finalCommandQueue.dequeue(finalCommandHandler)) {
                    log.info(() -> "Unable to find command handler in expected queue. " + finalCommandHandler.getMessageId());
                }
            });
        } else {
            commandQueue.dequeue(commandHandler);
            log.finer("CommandExecutor command dequeued " + commandHandler.getMessageId());
        }
        log.finer(String.format("CommandExecutor executeCommand exiting %s", commandHandler.getMessageId()));
    }

    void updatePriorityQueues() {
        this.orderedQueues = (BCloudCommandQueue[])this.getChildren(BCloudCommandQueue.class);
        Arrays.sort(this.orderedQueues, Comparator.comparingInt(BCloudCommandQueue::getPriority));
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Cloud Command Executor");
        out.prop((Object)"executor", (Object)this.executor);
        out.prop((Object)"manager", (Object)this.manager);
        out.prop((Object)"orderedQueues", this.orderedQueues.length);
        for (int i = 0; i < this.orderedQueues.length; ++i) {
            out.prop((Object)i, (Object)this.orderedQueues[i].getName());
        }
        out.prop((Object)"parentExt", (Object)this.parentExt);
        out.endProps();
        super.spy(out);
    }
}

