/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.nc.cmds.BCloudCommandExecutor;
import com.tridium.nc.cmds.BCloudCommandStatus;
import com.tridium.nc.cmds.MessageCallbackHandler;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="priority", type="int", defaultValue="LOWEST_PRIORITY", facets={@Facet(name="BFacets.MIN", value="HIGHEST_PRIORITY"), @Facet(name="BFacets.MAX", value="LOWEST_PRIORITY")}), @NiagaraProperty(name="maxSize", type="int", defaultValue="20", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="1024")})})
public class BCloudCommandQueue
extends BComponent {
    private static final int HIGHEST_PRIORITY = 0;
    private static final int LOWEST_PRIORITY = 255;
    public static final Property priority = BCloudCommandQueue.newProperty((int)0, (int)255, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)255)));
    public static final Property maxSize = BCloudCommandQueue.newProperty((int)0, (int)20, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)1024)));
    public static final Type TYPE = Sys.loadType(BCloudCommandQueue.class);
    private MessageCallbackHandler lastMsg;
    private String lastNextToExecute = "";
    private final ArrayList<MessageCallbackHandler> queue = new ArrayList();
    private static final Logger log = Logger.getLogger("ncloud.command");

    public int getPriority() {
        return this.getInt(priority);
    }

    public void setPriority(int v) {
        this.setInt(priority, v, null);
    }

    public int getMaxSize() {
        return this.getInt(maxSize);
    }

    public void setMaxSize(int v) {
        this.setInt(maxSize, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.queue.ensureCapacity(this.getMaxSize());
    }

    public void changed(Property prop, Context context) {
        BCloudCommandExecutor executor;
        if (!this.isRunning()) {
            return;
        }
        if (maxSize.equals(prop)) {
            this.queue.ensureCapacity(this.getMaxSize());
        } else if (priority.equals(prop) && (executor = (BCloudCommandExecutor)this.getParent()) != null) {
            executor.updatePriorityQueues();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BCloudCommandExecutor;
    }

    public boolean enqueue(MessageCallbackHandler handler) {
        log.finer(() -> String.format("enqueue command on %s, for message: %s, current queue size: %s", this.getName(), handler.getMessageId(), this.queue.size()));
        if (this.queue.size() < this.getMaxSize()) {
            this.queue.add(handler);
            return true;
        }
        return false;
    }

    public MessageCallbackHandler dequeue() {
        log.finer(() -> String.format("dequeue() on %s, current queue size: %s", this.getName(), this.queue.size()));
        if (this.queue.size() == 0) {
            return null;
        }
        this.lastMsg = this.queue.get(0);
        return this.queue.remove(0);
    }

    boolean dequeue(MessageCallbackHandler handler) {
        log.finer(() -> String.format("dequeue(message:%s) on %s, current queue size: %s", handler.getMessageId(), this.getName(), this.queue.size()));
        return this.queue.remove(handler);
    }

    MessageCallbackHandler getNextToExecute() {
        for (MessageCallbackHandler mch : this.queue) {
            if (mch.getStatus() != BCloudCommandStatus.Enqueued) continue;
            this.lastNextToExecute = this.toString(mch);
            return mch;
        }
        return null;
    }

    public static int getHighestPriority() {
        return 0;
    }

    public static int getLowestPriority() {
        return 255;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Cloud Command Queue");
        out.prop((Object)"queue size", this.queue.size());
        out.prop((Object)"lastMsg", (Object)this.toString(this.lastMsg));
        out.prop((Object)"lastNext", (Object)this.lastNextToExecute);
        out.endProps();
        super.spy(out);
    }

    public String toString(MessageCallbackHandler h) {
        if (h == null) {
            return "null";
        }
        return "MessageCallbackHandler: msgId=" + h.getMessageId() + " msg:" + h.getMessage().getCommand() + " cb:" + h.getCallback() + " user:" + h.getUser() + " status:" + (Object)((Object)h.getStatus());
    }
}

